﻿#change log 20190422
#change the input variable names for new SANSoffline platform

#change log 20190510
#add output files of .dat for plotting



from mantid.simpleapi import *
import sys
import time
import xml.etree.ElementTree as ET
import math

#prepath=str(prepath)
#prepath_read='/cvmfs/daas.csns.ihep.ac.cn/softwares/centos-7.2.1511/SANSoffline'




global prepath_read

#prepath=os.environ['HOME']+'/SANSoffline'
'''
prepath=os.environ['HOME']+'/Documents/SANSoffline_data'
prepath_read=os.environ['HOME']+'/Documents/SANSoffline'
'''
# for Cloud

prepath=os.environ['HOME']+'/instrument_data'
prepath_read='/cvmfs/daas.csns.ihep.ac.cn/softwares/centos-7.2.1511/SANSoffline'

prepath_configure=os.environ['HOME']+'/SANSoffline'

monSUM=True
global prepath_save
prepath_save=os.environ['HOME']+'/SANSoffline/reducedFiles'



def readXml(file):
    tree = ET.parse(file)
    root = tree.getroot()
    configure={}
    
    
    
    _tmp = root.findall('SampleFileName')[0].text
    configure['SampleFileName']=_tmp
    _tmp = root.findall('EmptyCellFileName')[0].text
    configure['EmptyCellFileName']=_tmp
    _tmp = root.findall('SolventFileName')[0].text
    configure['SolventFileName']=_tmp
    _tmp = root.findall('Calibration_File')[0].text
    configure['Calibration_File']=_tmp
    _tmp = root.findall('Mask_File')[0].text
    configure['Mask_File']=_tmp
    _tmp = root.findall('BeamCenter_X')[0].text
    configure['BeamCenter_X']=_tmp
    _tmp = root.findall('BeamCenter_Y')[0].text
    configure['BeamCenter_Y']=_tmp
    
    
    _tmp = root.findall('EmptyTransRun')[0].text
    configure['EmptyTransRun']=_tmp
    _tmp = root.findall('SampleTransRun')[0].text
    configure['SampleTransRun']=_tmp
    _tmp = root.findall('EmptyCellTransRun')[0].text
    configure['EmptyCellTransRun']=_tmp
    _tmp = root.findall('SolventTransRun')[0].text
    configure['SolventTransRun']=_tmp
    _tmp = root.findall('TransFittingMethod')[0].text
    configure['TransFittingMethod']=_tmp
    _tmp = root.findall('Smooth_Ns')[0].text
    configure['Smooth_Ns']=_tmp
    _tmp = root.findall('Trans_Wavelength_Min')[0].text
    configure['Trans_Wavelength_Min']=_tmp
    _tmp = root.findall('Trans_Wavelength_Step')[0].text
    configure['Trans_Wavelength_Step']=_tmp
    _tmp = root.findall('Trans_Wavelength_Max')[0].text
    configure['Trans_Wavelength_Max']=_tmp
    
    
    _tmp = root.findall('EmptyDirectRun')[0].text
    configure['EmptyDirectRun']=_tmp
    _tmp = root.findall('SampleScattRun')[0].text
    configure['SampleScattRun']=_tmp
    _tmp = root.findall('EmptyCellScattRun')[0].text
    configure['EmptyCellScattRun']=_tmp
    _tmp = root.findall('SolventScattRun')[0].text
    configure['SolventScattRun']=_tmp
    _tmp = root.findall('Thickness')[0].text
    configure['Thickness']=_tmp
    _tmp = root.findall('Diameter')[0].text
    configure['Diameter']=_tmp
    _tmp = root.findall('SolventVolumeFraction')[0].text
    configure['SolventVolumeFraction']=_tmp
    _tmp = root.findall('Scatt_Wavelength_Min')[0].text
    configure['Scatt_Wavelength_Min']=_tmp
    _tmp = root.findall('Scatt_Wavelength_Step')[0].text
    configure['Scatt_Wavelength_Step']=_tmp
    _tmp = root.findall('Scatt_Wavelength_Max')[0].text
    configure['Scatt_Wavelength_Max']=_tmp
    _tmp = root.findall('Q_Min')[0].text
    configure['Q_Min']=_tmp
    _tmp = root.findall('Q_Step')[0].text
    configure['Q_Step']=_tmp
    _tmp = root.findall('Q_Max')[0].text
    configure['Q_Max']=_tmp
    
    '''
    _tmp = root.findall('Batch_TransFittingMethods')[0].text
    configure['Batch_TransFittingMethods']=_tmp
    _tmp = root.findall('Batch_Smooth_Ns')[0].text
    configure['Batch_Smooth_Ns']=_tmp
    _tmp = root.findall('Batch_Wavelength_Min')[0].text
    configure['Batch_Wavelength_Min']=_tmp
    _tmp = root.findall('Batch_Wavelength_Step')[0].text
    configure['Batch_Wavelength_Step']=_tmp
    _tmp = root.findall('Batch_Wavelength_Max')[0].text
    configure['Batch_Wavelength_Max']=_tmp
    _tmp = root.findall('Batch_Q_Min')[0].text
    configure['Batch_Q_Min']=_tmp
    _tmp = root.findall('Batch_Q_Step')[0].text
    configure['Batch_Q_Step']=_tmp
    _tmp = root.findall('Batch_Q_Max')[0].text
    configure['Batch_Q_Max']=_tmp
    
    _tmp = root.findall('Batch_EmptyTransRun')[0].text
    configure['Batch_EmptyTransRun']=_tmp
    _tmp = root.findall('Batch_EmptyCellFileName')[0].text
    configure['Batch_EmptyCellFileName']=_tmp
    _tmp = root.findall('Batch_SolventFileName')[0].text
    configure['Batch_SolventFileName']=_tmp
    _tmp = root.findall('Batch_EmptyCellTransRun')[0].text
    configure['Batch_EmptyCellTransRun']=_tmp
    _tmp = root.findall('Batch_SolventTransRun')[0].text
    configure['Batch_SolventTransRun']=_tmp
    
    _tmp = root.findall('Batch_EmptyDirectRun')[0].text
    configure['Batch_EmptyDirectRun']=_tmp
    _tmp = root.findall('Batch_EmptyCellScattRun')[0].text
    configure['Batch_EmptyCellScattRun']=_tmp
    _tmp = root.findall('Batch_SolventScattRun')[0].text
    configure['Batch_SolventScattRun']=_tmp
    
    _tmp = root.findall('Batch_Thickness')[0].text
    configure['Batch_Thickness']=_tmp
    _tmp = root.findall('Batch_Diameter')[0].text
    configure['Batch_Diameter']=_tmp
    _tmp = root.findall('Batch_SolventVolumeFraction')[0].text
    configure['Batch_SolventVolumeFraction']=_tmp
    
    _tmp = root.findall('Batch_SampleFileName')[0].text
    configure['Batch_SampleFileName']=_tmp
    _tmp = root.findall('Batch_SampleTransRun')[0].text
    configure['Batch_SampleTransRun']=_tmp
    _tmp = root.findall('Batch_SampleScattRun')[0].text
    configure['Batch_SampleScattRun']=_tmp
    '''
    return configure

import os

def my_finds(fileFolder,prepath):
    #matchs=[]
    
    for currentFolder in os.listdir(prepath):
        addRootFolder=os.path.join(prepath, currentFolder)
        if os.path.isdir(addRootFolder+'/'+fileFolder):
            matchs=currentFolder
            break    
    
    return str(matchs)

def mergeWS(prepath, wsList,output):
    #wsList=[wsList]
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        realProposal=my_finds(name,prepath)
        LoadNexus(Filename=prepath+'/'+realProposal+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
        
        #LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
'''
def mergeWS(prepath, wsList,output):
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
        #name=str(ix).zfill(7)
        #LoadNexus(Filename=name+'/'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
'''

def getMask(xPids, yPids):
    index=[]
    xnum=xPids[1]-xPids[0]+1
    ynum=yPids[1]-yPids[0]+1
    sta=yPids[0]*125+xPids[0]
    for i in range(xnum):
        for j in range(ynum):
            index.append(sta+j*125+i)
    return index



def findCmaskWS(wsname,Xcenter,Ycenter):
    x=Xcenter
    y=Ycenter
    MoveInstrumentComponent(Workspace=wsname, ComponentName='Bank01', X=x, Y=y, RelativePosition=False)
    index=getMask([0,18],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    index=getMask([105,124],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
    MaskDetectorsInShape(Workspace=wsname, ShapeXML=xml_inner)
    index=getMask([60,63],[0,57])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)

def calResolution(M2sample,wavelength, Q):
    L1=11.90-7.45
    #L1, source to sample distance, unit: m 
    L2=4.0
    #L2, sample to detector distance, unit: m 
    d1=1.9/100.0
    #d1,source aperture diameter, unit: m 
    d2=0.6/100.0
    #d2, sample aperture diameter, unit: m 
    d3=1.6/100.0
    #d3, detector res, unit: m   
    detector_min=0.048
    #detector minimum position
    detector_max=0.7
    #detector maximum position
    delta_lamda=0.0057
    #variance of lamda
    
    #wavelength=mtd['wavelength'].readX(0)
    efficiency=[]
    for efficiency_index in range(len(wavelength)):
        efficiency.append(4.7613/1000000.0+0.00054333*wavelength[efficiency_index])
    #M2 efficiency

    Intensity=M2sample
    Intensity_eff=[]
    for Intensity_index in range(len(Intensity)):
        Intensity_eff.append(Intensity[Intensity_index]/efficiency[Intensity_index])
    #Intensity=Intensity/efficiency
    
    sigmaQ=[]
    for Q_value in Q:
        total_intensity=0
        lamda_value_index=0
        sigmaQ_sum=0
        for lamda_value in wavelength:
            Ldet=L2*Q_value*lamda_value/6.28
            
            if detector_min < Ldet < detector_max:
                total_intensity=total_intensity+Intensity_eff[lamda_value_index]
                sigmaQ_sum=sigmaQ_sum+Intensity_eff[lamda_value_index]*math.sqrt((delta_lamda)**2.0+0.25*((L2/L1)**2.0)*((d1/2.0/Ldet)**2.0)+0.25*((1+L2/L1)**2.0)*((d2/2.0/Ldet)**2.0)+1.0/12.0*((d3/Ldet)**2.0))*Q_value
            lamda_value_index=lamda_value_index+1
                      
        sigmaQ.append(sigmaQ_sum/total_intensity)
            
        
        
    return sigmaQ


def outputIq(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, emptyTransNo, transRunNo, qName, wName, m2Sample,fileName,thickness,radius):

    '''
    emptyNo=int(emptyNo)
    runNo=int(runNo)
    emptyTransNo=int(emptyTransNo)
    transRunNo=int(transRunNo)
    '''
    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    #f_fp=prepath+'/SANS_'+str(runNo)+'_'+str(fileName)+'.dat'     
    f_fp=prepath+'/SANS_'+str(runNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample radius '+str(radius)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))
        
        
        

def outputTrans(prepath, transRunNo, emptyRunNo, trans_unfitted, trans_fitted,fileName):

    
    '''
    emptyRunNo=int(emptyRunNo)
    transRunNo=int(transRunNo)
    '''
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    trans_sam_fitted=mtd[trans_fitted].readY(0)
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_fitted].readX(0)
     
    f_fp=prepath+'/SANS_Trans_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    #ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted | Trans_fitted \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i],trans_sam_fitted[i]))
        
        
#def outputTransAll(prepath, transRunNo, emptyRunNo, trans_unfitted,fileName,thickness,diameter):
def outputTransAll(prepath, transRunNo, emptyRunNo, trans_unfitted,fileName):

    
    '''
    emptyRunNo=int(emptyRunNo)
    transRunNo=int(transRunNo)
    '''
    
    
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_unfitted].readX(0)
     
    f_fp=prepath+'/SANS_Trans_All_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted  \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i]))
        
 


def outputIqSolution(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, cellSolventNo, emptyCellNo, emptyTransNo, transRunNo, transCellSolventNo, transEmptyCellNo, qName, wName, m2Sample, volumefraction,fileName,thickness,radius):

    '''
    emptyNo=int(emptyNo)
    runNo=int(runNo)
    emptyTransNo=int(emptyTransNo)
    transRunNo=int(transRunNo)
    cellSolventNo=int(cellSolventNo)
    emptyCellNo=int(emptyCellNo)
    transCellSolventNo=int(transCellSolventNo)
    transEmptyCellNo=int(transEmptyCellNo)
    '''
    
    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    cellSolventNo=map(int,cellSolventNo)
    cellSolventNo=str(cellSolventNo)
    cellSolventNo=cellSolventNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transCellSolventNo=map(int,transCellSolventNo)
    transCellSolventNo=str(transCellSolventNo)
    transCellSolventNo=transCellSolventNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    
    vf=mtd[volumefraction].readY(0)
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_'+str(runNo)+'_pure_solute'+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#SolutionRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#SolventRun '+str(cellSolventNo)+' and Trans '+str(transCellSolventNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample radius '+str(radius)+' mm and sample thickness '+str(thickness)+' mm\n')
    ff.write('#solvent volume fraction at solution: '+str(vf)+ '\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))       


def outputIqEmptyCellDeduction(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo,  emptyCellNo, emptyTransNo, transRunNo, transEmptyCellNo, qName, wName, m2Sample,fileName,thickness,radius):

    '''
    emptyNo=int(emptyNo)
    runNo=int(runNo)
    emptyTransNo=int(emptyTransNo)
    transRunNo=int(transRunNo)
    emptyCellNo=int(emptyCellNo)
    transEmptyCellNo=int(transEmptyCellNo)
    '''
    
    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_'+str(runNo)+'_pure_sample.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#SampleRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample radius '+str(radius)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))    
        


def ScatterData(prepath, prepath_read, detRun, wave_rebin, wave_rebin_all, output, beamcenter_x, beamcenter_y,mask_file):
    mergeWS(prepath,detRun,'sample')
    LoadInstrument(Workspace='sample', Filename=prepath_read+'/paramData/detector.xml', RewriteSpectraMap=True)
    
    #use loading mask file method to mask main detector
    
    
    mask=LoadMask(Instrument=prepath_read+'/paramData/detector.xml', InputFile=prepath_read+'/paramData/'+mask_file)
    MaskDetectors(Workspace='sample', MaskedWorkspace=mask)
    
    
    #findCmaskWS('sample', beamcenter_x, beamcenter_y)
    
    
    ConvertUnits(InputWorkspace="sample", OutputWorkspace="sample", Target="Wavelength", AlignBins=True)
    Rebin(InputWorkspace='sample',OutputWorkspace='sample',Params=wave_rebin)
    
    mergeWS(prepath, detRun,'monitor2')
    ConvertUnits(InputWorkspace='monitor2', OutputWorkspace='monitor2', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='monitor2',OutputWorkspace='monitor2',Params=wave_rebin_all)
    
    MonSUM=True
    
    if monSUM:
        name=mtd['monitor2']
        counts=sum(name.readY(0))*1.0
        CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
        Divide(LHSWorkspace='sample', RHSWorkspace='m2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
        DeleteWorkspace(Workspace='m2')
        
    else:
        Divide(LHSWorkspace='sample', RHSWorkspace='monitor2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
    
    DeleteWorkspace(Workspace='sample')
    DeleteWorkspace(Workspace='monitor2')
    
    #output Scattering Workspace: Det2D_output


def CalTrans(prepath, prepath_read, prepath_save, transam_run, trans_run, wave_rebin, fitting_method, Smooth_Ns, output):
    
    mergeWS(prepath, transam_run, 'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
    mergeWS(prepath, trans_run,'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')
    
    LoadInstrument(Workspace='monTran', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    LoadInstrument(Workspace='monTranSam', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    
    ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    
    Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    
    CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='Transmission', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    
    RenameWorkspace(InputWorkspace='Transmission'+'_unfitted',OutputWorkspace=output+'_raw')
    
    if (fitting_method=='Raw'):
        CloneWorkspace(InputWorkspace=output+'_raw',OutputWorkspace=output)
        print('Raw')
    
    elif (fitting_method=='Smooth'):
        SmoothData(InputWorkspace=output+'_raw', OutputWorkspace=output, NPoints=Smooth_Ns)
        print('Smooth')
    
    elif (fitting_method=='Linear'):
        CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace=output, IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        print('Linear')

    elif (fitting_method=='Logarithm'):
        CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace=output, IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        print('Log')
    else:
        pass
    
    '''
    SaveAscii(InputWorkspace='Trans_output', Filename=prepath+'/'+output+'.dat')
    SaveAscii(InputWorkspace='Trans_output_raw', Filename=prepath+'/'+'output_raw'+'.dat')
    #print 'save trans data!'   
    '''
    
    SaveAscii(InputWorkspace=output+'_raw' ,Filename=prepath_save+'/temporary/'+output+'_raw.dat')
    SaveAscii(InputWorkspace=output ,Filename=prepath_save+'/temporary/'+output+'.dat')
    
    DeleteWorkspace(Workspace='monTranSam')
    DeleteWorkspace(Workspace='monTran')
    DeleteWorkspace(Workspace='Transmission')
    
    #outputTrans Workspace: output, output_raw



def convertIQ1D(Q_rebin, Det2D_input, output):
    Q1D(DetBankWorkspace=Det2D_input, OutputWorkspace=output, OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    ReplaceSpecialValues(InputWorkspace=output, OutputWorkspace=output, NaNValue=0, InfinityValue=0)
    
    '''
    SaveAscii(InputWorkspace=output ,Filename=prepath+'/'+output+'.dat')
    '''



def getConfXML():
    conf=readXml(prepath_configure+'/configure.xml')
    
    if conf['SampleFileName'] is None:
        FileName_Sample=[]
    else:
        FileName_Sample=str(conf['SampleFileName'])
    
    if conf['EmptyCellFileName'] is None:
        FileName_EmptyCell=[]
    else:
        FileName_EmptyCell=str(conf['EmptyCellFileName'])
    
    if conf['SolventFileName'] is None:
        FileName_Solvent=[]
    else:
        FileName_Solvent=str(conf['SolventFileName'])
    
    
    
    if conf['Calibration_File'] is None:
        cal_file=[]
    else:
        cal_file=str(conf['Calibration_File'])
        #cal_file=[str(s).strip("'") for s in conf['Calibration_File'].split(';') if not len(s)==0 ]
        
    if conf['Mask_File'] is None:
        mask_file=[]
    else:
        mask_file=str(conf['Mask_File'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
        
    if conf['BeamCenter_X'] is None:
        beamcenter_x=[]
    else:
        #mm->m
        beamcenter_x=float(conf['BeamCenter_X'])/1000
        
    if conf['BeamCenter_Y'] is None:
        beamcenter_y=[]
    else:
        beamcenter_y=float(conf['BeamCenter_Y'])/1000
    
    
    
    if conf['EmptyTransRun'] is None:
        EmptyTrans_Run=[]
        EmptyTransNum=0
    else:
        #EmptyTrans_Run=[str(conf['EmptyTransRun'])]
        EmptyTrans_Run=[str(s).strip("'") for s in conf['EmptyTransRun'].split(',')]
        EmptyTransNum=len(EmptyTrans_Run)
        
    if conf['SampleTransRun'] is None:
        SampleTrans_Run=[]
        SampleTransNum=0
    else:
        #SampleTrans_Run=str(conf['SampleTransRun'])
        SampleTrans_Run=[str(s).strip("'") for s in conf['SampleTransRun'].split(',')]
        SampleTransNum=len(SampleTrans_Run)

    if conf['EmptyCellTransRun'] is None:
        EmptyCellTrans_Run=[]
        EmptyCellTransNum=0
    else:
        #EmptyCellTrans_Run=str(conf['EmptyCellTransRun'])
        EmptyCellTrans_Run=[str(s).strip("'") for s in conf['EmptyCellTransRun'].split(',')]
        EmptyCellTransNum=len(EmptyCellTrans_Run)

    if conf['SolventTransRun'] is None:
        SolventTrans_Run=[]
        SolventTransNum=0
    else:
        #SolventTrans_Run=str(conf['SolventTransRun'])
        SolventTrans_Run=[str(s).strip("'") for s in conf['SolventTransRun'].split(',')]
        SolventTransNum=len(SolventTrans_Run)
    
    
    if conf['TransFittingMethod'] is None:
        Trans_fitting_method=[]
    else:
        Trans_fitting_method=str(conf['TransFittingMethod'])
        
    #trans_fitting_method=conf['TransFittingMethod']
    
    if conf['Smooth_Ns'] is None:
        Smooth_Ns=[]
    else:
        Smooth_Ns=int(conf['Smooth_Ns'])
    
    
    if conf['Trans_Wavelength_Min'] is not None:
        w1=float(conf['Trans_Wavelength_Min'])
    else:
        w1=1.4
    if conf['Trans_Wavelength_Step'] is not None:
        dw=float(conf['Trans_Wavelength_Step'])
    else:
        dw=0.01
    if conf['Trans_Wavelength_Max'] is not None:
        w2=float(conf['Trans_Wavelength_Max'])
    else:
        w2=8.0
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)


    return FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum


def getConfXML2():
    conf=readXml(prepath_configure+'/configure.xml')
    
    
    if conf['EmptyDirectRun'] is None:
        EmptyDirect_Run=[]
        EmptyDirectNum=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        EmptyDirect_Run=[str(s).strip("'") for s in conf['EmptyDirectRun'].split(',')]
        EmptyDirectNum=len(EmptyDirect_Run)
    
    
    if conf['SampleScattRun'] is None:
        SampleScatt_Run=[]
        SampleScattNum=0
    else:
        #SampleScatt_Run=str(conf['SampleScattRun'])
        SampleScatt_Run=[str(s).strip("'") for s in conf['SampleScattRun'].split(',')]
        SampleScattNum=len(SampleScatt_Run)
    
    
    if conf['EmptyCellScattRun'] is None:
        EmptyCellScatt_Run=[]
        EmptyCellScattNum=0
    else:
        #EmptyCellScatt_Run=str(conf['EmptyCellScattRun'])
        EmptyCellScatt_Run=[str(s).strip("'") for s in conf['EmptyCellScattRun'].split(',')]
        EmptyCellScattNum=len(EmptyCellScatt_Run)
    
    
    if conf['SolventScattRun'] is None:
        SolventScatt_Run=[]
        SolventScattNum=0
    else:
        #SolventScatt_Run=str(conf['SolventScattRun'])
        SolventScatt_Run=[str(s).strip("'") for s in conf['SolventScattRun'].split(',')]
        SolventScattNum=len(SolventScatt_Run)
    
    
    # Thickness unit (mm)    
    if conf['Thickness'] is not None:
        Thickness=float(conf['Thickness'])
    else:
        Thickness=1.0 ## or print error?
        
    # Diameter unit (mm)    
    if conf['Diameter'] is not None:
        Diameter=float(conf['Diameter'])
    else:
        Diameter=6.8
        
    # Solvent Volume Fraction  
    if conf['SolventVolumeFraction'] is not None:
        Solvent_VF=float(conf['SolventVolumeFraction'])
    else:
        Solvent_VF=0
    
    # Volume unit (cm^3)    
    Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(Thickness/10.0)
    #CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
    
    
    if conf['Scatt_Wavelength_Min'] is not None:
        w1=float(conf['Scatt_Wavelength_Min'])
    else:
        w1=1.4
    if conf['Scatt_Wavelength_Step'] is not None:
        dw=float(conf['Scatt_Wavelength_Step'])
    else:
        dw=1
    if conf['Scatt_Wavelength_Max'] is not None:
        w2=float(conf['Scatt_Wavelength_Max'])
    else:
        w2=8.0
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
     
    
    if conf['Q_Min'] is not None:
        Q1=float(conf['Q_Min'])
    else:
        Q1=0.01
    if conf['Q_Step'] is not None:
        dQ=float(conf['Q_Step'])
    else:
        dQ=-0.08
    if conf['Q_Max'] is not None:
        Q2=float(conf['Q_Max'])
    else:
        Q2=0.8
    Q_rebin=str(Q1)+','+str(dQ)+','+str(Q2)
    
    
    return  EmptyDirect_Run,EmptyDirectNum,SampleScatt_Run,SampleScattNum,EmptyCellScatt_Run,EmptyCellScattNum,SolventScatt_Run,SolventScattNum,Solvent_VF,Volume,Thickness,Diameter,w1, dw, w2,Q_rebin 
    

    #, ﻿cal_file, 
def TransCalculation():
    
    FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum=getConfXML();
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
    wave_rebin_all='1,'+str(dw)+',8.5'
    
    if EmptyTransNum>0:
        if SampleTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Sample')
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_Sample_unfitted')
            outputTrans(prepath_save, SampleTrans_Run, EmptyTrans_Run, 'Trans_Sample', 'Trans_Sample_unfitted', FileName_Sample)
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_Sample_All')
            outputTransAll(prepath_save, SampleTrans_Run, EmptyTrans_Run, 'Trans_Sample_All', FileName_Sample)
        else:
            pass
            
            
        if EmptyCellTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_EmptyCell')
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_EmptyCell_unfitted')
            outputTrans(prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, 'Trans_EmptyCell', 'Trans_EmptyCell_unfitted', FileName_EmptyCell)
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_EmptyCell_All')
            outputTransAll(prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, 'Trans_EmptyCell_All', FileName_EmptyCell)
        else:
            pass
            
            
        if SolventTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Solvent')
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_Solvent_unfitted')
            outputTrans(prepath_save, SolventTrans_Run, EmptyTrans_Run, 'Trans_Solvent', 'Trans_Solvent_unfitted', FileName_Solvent)
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_Solvent_All')
            outputTransAll(prepath_save, SolventTrans_Run, EmptyTrans_Run, 'Trans_Solvent_All', FileName_Solvent)
        else:
            pass
            
    return True



def IQReduction():
    
    FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum=getConfXML();
    
    EmptyDirect_Run,EmptyDirectNum,SampleScatt_Run,SampleScattNum,EmptyCellScatt_Run,EmptyCellScattNum,SolventScatt_Run,SolventScattNum,Solvent_VF,Volume,Thickness,Diameter,w1, dw, w2,Q_rebin=getConfXML2();
    
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
    wave_rebin_all='1,'+str(dw)+',8.5'
    
    CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
    
    #the factor of wave_rebin and dlambda at calibration file
    #in the future should be considered at calibration file
    factor=0.005/0.01  
    CreateSingleValuedWorkspace(OutputWorkspace='factor', DataValue=factor)
    
    CreateSingleValuedWorkspace(OutputWorkspace='Solvent_VF', DataValue=Solvent_VF)
    
    
    #obtain the spectrum of the beam from Monitor2
    mergeWS(prepath, EmptyTrans_Run, 'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='Spectrum')    
    LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
    


    if EmptyTransNum>0:
        if SampleTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Sample')
        else:
            pass
            
        if EmptyCellTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_EmptyCell')
        else:
            pass
            
        if SolventTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Solvent')
        else:
            pass
    
    
    ###
    #if len(cal_file)>0:
    LoadAscii(Filename=prepath_read+'/paramData/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
    ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
    Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
    #else:
        #pass
        
        
    #bg
    if EmptyDirectNum>0:
        ScatterData(prepath, prepath_read, EmptyDirect_Run, wave_rebin, wave_rebin_all, 'empty_tmp', beamcenter_x, beamcenter_y, mask_file)
        Divide(LHSWorkspace='empty_tmp', RHSWorkspace='cal', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
        convertIQ1D(Q_rebin,'empty_tmp','IQ_empty')
        Divide(LHSWorkspace='IQ_empty', RHSWorkspace='volume', OutputWorkspace='IQ_empty_v', AllowDifferentNumberSpectra=True)
        Multiply(LHSWorkspace='IQ_empty_v', RHSWorkspace='factor', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
        
        SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyBeam.dat')
        
    else:
        pass
        
        
        
    #sample
    
    if (SampleScattNum>0):
    
        ScatterData(prepath, prepath_read, SampleScatt_Run, wave_rebin, wave_rebin_all, 'sam_tmp', beamcenter_x, beamcenter_y, mask_file)
        Divide(LHSWorkspace='sam_tmp', RHSWorkspace='cal', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    
        if (SampleTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='Trans_Sample',OutputWorkspace='sam_tmp',ThetaDependent=True)
        else:
            pass
        
        convertIQ1D(Q_rebin,'sam_tmp','IQ_sam')
        Divide(LHSWorkspace='IQ_sam', RHSWorkspace='volume', OutputWorkspace='IQ_sam_v', AllowDifferentNumberSpectra=True)
        Multiply(LHSWorkspace='IQ_sam_v', RHSWorkspace='factor', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_raw.dat')
        
        if EmptyDirectNum>0:
            Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_sam_normalized')
            
            SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyBeam_deduction.dat')
            
            
        else:
            pass
            
        outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyTrans_Run, SampleTrans_Run, 'IQ_sam_normalized', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter)

    
    
    
    if (EmptyCellScattNum>0):
        ScatterData(prepath, prepath_read, EmptyCellScatt_Run, wave_rebin, wave_rebin_all, 'emptycell_tmp', beamcenter_x, beamcenter_y, mask_file)
        Divide(LHSWorkspace='emptycell_tmp', RHSWorkspace='cal', OutputWorkspace='emptycell_tmp', AllowDifferentNumberSpectra=True)
        
        if (EmptyCellTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='emptycell_tmp',TransmissionWorkspace='Trans_EmptyCell',OutputWorkspace='emptycell_tmp',ThetaDependent=True)
        else:
            pass
        convertIQ1D(Q_rebin,'emptycell_tmp','IQ_emptycell')
        Divide(LHSWorkspace='IQ_emptycell', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_v', AllowDifferentNumberSpectra=True)
        Multiply(LHSWorkspace='IQ_emptycell_v', RHSWorkspace='factor', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_raw.dat')
        
        if (EmptyDirectNum>0):
            Minus(LHSWorkspace='IQ_emptycell_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_emptycell_normalized')
            SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_EmptyBeam_deduction.dat')
            
        else:
            pass
            
        Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_sam_normalized_emptycell_deduction')
        SaveAscii(InputWorkspace='IQ_sam_normalized_emptycell_deduction',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyCell_EmptyBeam_deduction.dat')
        
        outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, EmptyCellScatt_Run, EmptyTrans_Run, EmptyCellTrans_Run, 'IQ_empty_normalized', 'Trans_EmptyCell', 'Spectrum', FileName_EmptyCell, Thickness, Diameter)
        outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, 'IQ_sam_normalized_emptycell_deduction', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter)
    
    
    if (SolventScattNum>0):
        ScatterData(prepath, prepath_read, SolventScatt_Run, wave_rebin, wave_rebin_all, 'solvent_tmp', beamcenter_x, beamcenter_y, mask_file)
        Divide(LHSWorkspace='solvent_tmp', RHSWorkspace='cal', OutputWorkspace='solvent_tmp', AllowDifferentNumberSpectra=True)
        
        if (SolventTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='solvent_tmp',TransmissionWorkspace='Trans_Solvent',OutputWorkspace='solvent_tmp',ThetaDependent=True)
        else:
            pass
        convertIQ1D(Q_rebin,'solvent_tmp','IQ_solvent')
        Divide(LHSWorkspace='IQ_solvent', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_v', AllowDifferentNumberSpectra=True)
        Multiply(LHSWorkspace='IQ_solvent_v', RHSWorkspace='factor', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
        
        SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_raw.dat')
        
        if EmptyDirectNum>0:
            Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_solvent_normalized')
            
            SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_EmptyBeam_deduction.dat')
            
        else:
            pass
        
        
        Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_solvent_normalized_emptycell_deduction')
        Multiply(LHSWorkspace='IQ_solvent_normalized_emptycell_deduction', RHSWorkspace='Solvent_VF', OutputWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF', AllowDifferentNumberSpectra=True)
        Minus(LHSWorkspace='IQ_sam_normalized_emptycell_deduction', RHSWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF',OutputWorkspace='IQ_solute_reduced')
        
        SaveAscii(InputWorkspace='IQ_solute_reduced',Filename=prepath_save+'/temporary/'+'IQ_Solute_pure.dat')
        
        outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SolventTrans_Run, EmptyCellTrans_Run, 'IQ_solvent_normalized_emptycell_deduction', 'Trans_Solvent', 'Spectrum', FileName_Solvent, Thickness, Diameter)
        outputIqSolution(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, SolventTrans_Run, EmptyCellTrans_Run,  'IQ_solute_reduced', 'Trans_Sample', 'Spectrum', 'Solvent_VF', FileName_Sample, Thickness, Diameter)
        
    return True

