# reduction without sensitivity and efficiency
from mantid.simpleapi import *

def mergeWS(prepath, wsList,output):
    for name in wsList:
        LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=name)

    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=wsList[i], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=wsList[i+1])
            DeleteWorkspace(Workspace=wsList[i])
        else:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
            DeleteWorkspace(Workspace=wsList[i+1])
            break

#sample scattering exp
sample_run = ['RUN0000365']
#sample transimission exp
transam_run = ['RUN0000367']
#direct for M3/M2
trans_run=['RUN0000355','RUN0000343']
#background
empty_run=['RUN0000307']

volume=0.20106
wave_rebin='2.5,0.001,8.2'
q_rebin='0.01,0.002,0.22'
mlist=''
for i in range(59):
    start=60+(i)*125
    end=64+(i)*125
    mlist=mlist+str(start)+'-'+str(end)+','
mlist=mlist+'7435-7439'

prepath=sys.path[0]

#calculate sample transmission
mergeWS(prepath, transam_run, 'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
mergeWS(prepath, trans_run,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')
ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='trans_sam', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
#Rebin(InputWorkspace='trans_sam', OutputWorkspace="trans_sam", Params=wave_rebin)
DeleteWorkspace(Workspace='monTranSam')
DeleteWorkspace(Workspace='monTran')


#theory 
#==========================================
LoadRKH(Filename=prepath+'/paramData/bates_poly_theory2.dat', OutputWorkspace='theory', FirstColumnValue='MomentumTransfer')
ConvertToHistogram(InputWorkspace='theory', OutputWorkspace='theory')
Rebin(InputWorkspace='theory', OutputWorkspace='theory', Params=q_rebin)
# sample and empty
#========================================
#LoadNexus(Filename="/home/dur/work/nexusData/SANS/"+sample_run[0]+"/sample.nxs", OutputWorkspace='sam')
#LoadNexus(Filename="/home/dur/work/nexusData/SANS/"+empty_run[0]+"/sample.nxs", OutputWorkspace='empty')
outer=0.360
inner=0.056
xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
xml_outer='<infinite-cylinder id="beam_area"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(outer)+'" /></infinite-cylinder><algebra val="#beam_area"/>'

#sample
mergeWS(prepath, sample_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='sam_tmp')
MaskDetectorsInShape(Workspace='sam_tmp', ShapeXML=xml_inner)
MaskDetectorsInShape(Workspace='sam_tmp', ShapeXML=xml_outer)
MaskDetectors(Workspace='sam_tmp',WorkspaceIndexList=mlist)
ConvertUnits(InputWorkspace="sam_tmp", OutputWorkspace="sam_tmp", Target="Wavelength", AlignBins=True)
Rebin(InputWorkspace='sam_tmp',OutputWorkspace='sam_tmp',Params=wave_rebin)

mergeWS(prepath, sample_run,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='sam_m2')
CropWorkspace(InputWorkspace="sam_m2", OutputWorkspace="sam_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='sam_m2', OutputWorkspace='sam_m2', Target='Wavelength', AlignBins=True)
Rebin(InputWorkspace='sam_m2',OutputWorkspace='sam_m2',Params=wave_rebin)
Divide(LHSWorkspace='sam_tmp', RHSWorkspace='sam_m2', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='sam_tmp',ThetaDependent=True)

#empty
mergeWS(prepath, empty_run, 'sample')
CloneWorkspace(InputWorkspace='sample',OutputWorkspace='empty_tmp')
MaskDetectorsInShape(Workspace='empty_tmp', ShapeXML=xml_inner)
MaskDetectorsInShape(Workspace='empty_tmp', ShapeXML=xml_outer)
MaskDetectors(Workspace='empty_tmp',WorkspaceIndexList=mlist)
ConvertUnits(InputWorkspace="empty_tmp", OutputWorkspace="empty_tmp", Target="Wavelength", AlignBins=True)
Rebin(InputWorkspace='empty_tmp',OutputWorkspace='empty_tmp',Params=wave_rebin)
mergeWS(prepath, empty_run,'monitors')
RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='mon_empty')
CropWorkspace(InputWorkspace="mon_empty", OutputWorkspace="empty_m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
ConvertUnits(InputWorkspace='empty_m2', OutputWorkspace='empty_m2', Target='Wavelength', AlignBins=True)
RebinToWorkspace(WorkspaceToRebin='empty_m2',WorkspaceToMatch='empty_tmp',OutputWorkspace='empty_m2')
Divide(LHSWorkspace='empty_tmp', RHSWorkspace='empty_m2', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)

cvalue=[]
lvalue=[]

for i in range(285):
    lamda=2.51 + i * 0.02
    lamda_min=lamda - 0.01
    lamda_max=lamda + 0.01
    CropWorkspace(InputWorkspace='sam_tmp',OutputWorkspace='sam_tmp_1',Xmin=lamda_min,Xmax=lamda_max)
    CropWorkspace(InputWorkspace='empty_tmp',OutputWorkspace='bg_tmp_1',Xmin=lamda_min,Xmax=lamda_max)
    
    Q1D(DetBankWorkspace='sam_tmp_1', OutputWorkspace='IQ', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    ReplaceSpecialValues(InputWorkspace='IQ', OutputWorkspace='IQ', NaNValue=0, InfinityValue=0)
    Q1D(DetBankWorkspace='bg_tmp_1', OutputWorkspace='bg_IQ', OutputBinning=q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    ReplaceSpecialValues(InputWorkspace='bg_IQ', OutputWorkspace='bg_IQ', NaNValue=0, InfinityValue=0)
    Minus(LHSWorkspace='IQ', RHSWorkspace='bg_IQ',OutputWorkspace='IQ')

    Divide(LHSWorkspace='IQ', RHSWorkspace='theory', OutputWorkspace='norm')
    ReplaceSpecialValues(InputWorkspace='norm', OutputWorkspace='norm', NaNValue=0, InfinityValue=0)

    name=mtd['norm']
    value=name.readY(0)
    sumvalue=0
    num=0
    for iy in value:
        if iy > 0:
            sumvalue=sumvalue+iy
            num=num+1
        else:
            continue
    cvalue.append(sumvalue/num/volume)
    lvalue.append(lamda)

from scipy.optimize import least_squares
from scipy import exp,log

def fexp(p, values):
    a, b, c = p
    x = values
    return(a * exp(-x/b) + c)

def ferr(p,x,y):
    err=[]
    for i in range(len(x)):
        err.append(y[i]-fexp(p,x[i]))
    #return y-fexp(p,x)
    return err

def fitData(x,y):
    _b0=(x[0]-x[1])/(log(y[1])-log(y[0]))
    _a0=y[0]/exp(-x[0]/_b0)
    p0=[_a0, _b0, 0.]
    p1 = least_squares(ferr, p0, args=(x, y))
    p1=p1.x
    print "xxxx", p0 , p1
    xtmp=[]
    ytmp=[]
    for i in range(900):
        xtmp.append(1+0.01*i)
        ytmp.append(fexp(p1,xtmp[i]))

    return xtmp, ytmp


x,y=fitData(lvalue, cvalue)

f0=open(prepath+'/paramData/calibration.dat','w')


_s="SANS calibration file"
f0.write("%s\n" % (_s))
f0.write("\n")
f0.write("%d    0    0    0    1    %d    0\n" % (len(x), len(x)))
_s="        0        0        0        0"
f0.write("%s\n" % (_s))
_s="2 (F12.5,2E16.6)"
f0.write("%s\n" % (_s))

for i in range(len(x)):
    f0.write("%f %f\n" % (x[i], y[i]))
f0.close()

