from mantid.simpleapi import *
import sys
import time
import xml.etree.ElementTree as ET


def mergeWS(wsList,output,bm):
    
    if bm:
        for name in wsList:
            fpath='/home/dur/work/dp_SANS/RUN'+str(name).zfill(7)+'/sample.nxs'
            LoadNexus(Filename=fpath,OutputWorkspace=str(name))
            Rebin(InputWorkspace=name, OutputWorkspace=name, Params='10,8,39990')
    else:
        for name in wsList:
            fpath='/home/dur/work/dp_SANS/RUN'+str(name).zfill(7)+'/monitors.nxs'
            LoadNexus(Filename=fpath,OutputWorkspace=str(name))
            
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=wsList[i], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=wsList[i+1])
            DeleteWorkspace(Workspace=wsList[i])
        else:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
            DeleteWorkspace(Workspace=wsList[i+1])
            break

def ScatterData(detRun,xml_inner,xml_outer,wave_rebin,sensWS,output,monSUM, mlist):
    mergeWS(detRun, 'tmp',True)
    MaskDetectorsInShape(Workspace='tmp', ShapeXML=xml_inner)
    MaskDetectorsInShape(Workspace='tmp', ShapeXML=xml_outer)
    MaskDetectors(Workspace='tmp',WorkspaceIndexList=mlist)
    ConvertUnits(InputWorkspace="tmp", OutputWorkspace="tmp", Target="Wavelength", AlignBins=True)
    Rebin(InputWorkspace='tmp',OutputWorkspace='tmp',Params=wave_rebin)
    mergeWS(detRun,'monitors',False)
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='m2')
    CropWorkspace(InputWorkspace="m2", OutputWorkspace="m2",StartWorkspaceIndex=0, EndWorkspaceIndex=0)
    ConvertUnits(InputWorkspace='m2', OutputWorkspace='m2', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='m2',OutputWorkspace='m2',Params=wave_rebin)
    if monSUM:
        name=mtd['m2']
        value=sum(name.readY(0))
        CreateSingleValuedWorkspace(OutputWorkspace='m2', DataValue=value)
    else:
        Divide(LHSWorkspace="m2", RHSWorkspace=sensWS, OutputWorkspace="m2", AllowDifferentNumberSpectra=True)
    Divide(LHSWorkspace="tmp", RHSWorkspace="m2", OutputWorkspace=output, AllowDifferentNumberSpectra=True)
    DeleteWorkspace(Workspace='tmp')
    DeleteWorkspace(Workspace='m2')
                

def CalTrans(transam_run, trans_run, output, prepath, wave_rebin):
    mergeWS(transam_run, 'monitors',False)
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
    mergeWS(trans_run,'monitors',False)
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')
    ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace=output, IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    #Rebin(InputWorkspace='trans_sam', OutputWorkspace="trans_sam", Params=wave_rebin)
    #SaveAscii(InputWorkspace='trans_sam_unfitted' ,Filename=sys.path[0]+'/'+output+'.dat')
    #SaveAscii(InputWorkspace='trans_sam_unfitted' ,Filename=prepath+'/'+output+'.dat')
    DeleteWorkspace(Workspace='monTranSam')
    DeleteWorkspace(Workspace='monTran')

def convertQ(gravityCorr, solidAngleCorr, calWS, q_rebin, input1, output, prepath):
    if gravityCorr and not solidAngleCorr:
        Q1D(DetBankWorkspace=input1, OutputWorkspace=output, OutputBinning=q_rebin,WavelengthAdj=calWS,AccountForGravity=True, SolidAngleWeighting=False)
    if not gravityCorr and solidAngleCorr:
        Q1D(DetBankWorkspace=input1, OutputWorkspace=output, OutputBinning=q_rebin,WavelengthAdj=calWS,AccountForGravity=False, SolidAngleWeighting=True)
    if not gravityCorr and not solidAngleCorr:
        Q1D(DetBankWorkspace=input1, OutputWorkspace=output, OutputBinning=q_rebin,WavelengthAdj=calWS,AccountForGravity=False, SolidAngleWeighting=False)
    if gravityCorr and solidAngleCorr:
        Q1D(DetBankWorkspace=input1, OutputWorkspace=output, OutputBinning=q_rebin,WavelengthAdj=calWS,AccountForGravity=True, SolidAngleWeighting=True)
    #SaveAscii(InputWorkspace=output ,Filename=sys.path[0]+'/bg_raw.dat')
    #SaveAscii(InputWorkspace=output ,Filename=prepath+'/'+output+'.dat')

#use PS
monSUM=False

#print conf['cell_transmission']

sam_run=['320','323']
cell_run=[]
sol_run=['329','331']
transam_run=['324','325']
trancell_run=[]
transol_run=['326','327']
trans_run=['305','309']
empty_run=['307']
cal_file=['/home/dur/SANSoffline/paramData/calibration.dat']
sens_file=['/home/dur/SANSoffline/paramData/sens.dat']
flood_file=[]

q_rebin='0.002,0.0004,0.1'
wave_rebin='2.5,0.001,8.2'

inner=0.056
outer=0.36

mlist=''
for i in range(59):
    start=60+(i)*125
    end=64+(i)*125
    mlist=mlist+str(start)+'-'+str(end)+','
mlist=mlist+'7435-7439'
xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
xml_outer='<infinite-cylinder id="beam_area"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(outer)+'" /></infinite-cylinder><algebra val="#beam_area"/>'
gravityCorr=True
solidAngleCorr=True
prepath='/home/dur/SANSoffline'

be=time.time()
#calculate sample transmission
if len(transam_run)>0 and len(trans_run)>0:
    CalTrans(transam_run, trans_run, 'trans_sam', prepath, wave_rebin)
else:
    pass
if len(trancell_run)>0 and len(trans_run)>0:
    CalTrans(trancell_run, trans_run, 'trans_cell', prepath, wave_rebin)
else:
    pass
if len(transol_run)>0 and len(trans_run)>0:
    CalTrans(transol_run, trans_run, 'trans_sol',prepath, wave_rebin)
else:
    pass

if len(cal_file)>0:
    LoadRKH(Filename=cal_file[0], OutputWorkspace='cal', FirstColumnValue='Wavelength')
    ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
    #SmoothData(InputWorkspace='cal', OutputWorkspace='cal', NPoints=31)
    Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
else:
    pass

if len(flood_file)>0:
    LoadRKH(Filename=flood_file[0], OutputWorkspace='flood', FirstColumnValue='SpectrumNumber')
else:
    pass

if len(sens_file)>0:
    LoadRKH(Filename=sens_file[0], OutputWorkspace='sensitivity',FirstColumnValue='Wavelength')
    ConvertToHistogram(InputWorkspace='sensitivity', OutputWorkspace='sensitivity')
    Rebin(InputWorkspace='sensitivity', OutputWorkspace="sens_rebin", Params=wave_rebin)
else:
    pass

#bg
if len(empty_run)>0:
    ScatterData(empty_run,xml_inner,xml_outer,wave_rebin,'sens_rebin','empty_tmp', monSUM, mlist)
    convertQ(gravityCorr, solidAngleCorr, 'cal', q_rebin, 'empty_tmp', 'bg_raw', prepath)
else:
    pass

#sample
if len(sam_run)>0:
    ScatterData(sam_run,xml_inner,xml_outer,wave_rebin,'sens_rebin','sam_tmp', monSUM, mlist)
    if len(transam_run)>0:
        ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='trans_sam',OutputWorkspace='sam_tmp',ThetaDependent=True)
    else:
        pass
    convertQ(gravityCorr, solidAngleCorr, 'cal', q_rebin, 'sam_tmp', 'sam_raw', prepath)
    Minus(LHSWorkspace='sam_raw', RHSWorkspace='bg_raw',OutputWorkspace='sam_bg')
    SaveAscii(InputWorkspace='sam_bg' ,Filename=prepath+'sam_bg.dat')
else:
    pass

#cell
if len(cell_run)>0:
    ScatterData(cell_run,xml_inner,xml_outer,wave_rebin,'sens_rebin','cell_tmp', monSUM, mlist)
    if len(trancell_run)>0:
        ApplyTransmissionCorrection(InputWorkspace='cell_tmp',TransmissionWorkspace='trans_cell',OutputWorkspace='cell_tmp',ThetaDependent=True)
    else:
        pass
    convertQ(gravityCorr, solidAngleCorr, 'cal', q_rebin, 'cell_tmp', 'cell_raw',prepath)
    Minus(LHSWorkspace='cell_raw', RHSWorkspace='bg_raw',OutputWorkspace='cell_bg')
    SaveAscii(InputWorkspace='cell_bg' ,Filename=prepath+'cell_bg.dat')
else:
    pass

#solution
if len(sol_run)>0:
    ScatterData(sol_run,xml_inner,xml_outer,wave_rebin,'sens_rebin','sol_tmp', monSUM, mlist)
    if len(transol_run)>0:
        ApplyTransmissionCorrection(InputWorkspace='sol_tmp',TransmissionWorkspace='trans_sol',OutputWorkspace='sol_tmp',ThetaDependent=True)
    else:
        pass
    convertQ(gravityCorr, solidAngleCorr, 'cal', q_rebin, 'sol_tmp', 'sol_raw',prepath)
    Minus(LHSWorkspace='sol_raw', RHSWorkspace='bg_raw',OutputWorkspace='sol_bg')
    SaveAscii(InputWorkspace='sol_bg' ,Filename=prepath+'sol_bg.dat')
else:
    pass
'''
#sample - cell
if len(cell_run)== 0:
    #Divide(LHSWorkspace="sam_bg", RHSWorkspace='volume', OutputWorkspace="sam_bg", AllowDifferentNumberSpectra=True)
    SaveAscii(InputWorkspace='sam_bg', Filename=prepath+'/sam_IQ.dat')
else:
    Minus(LHSWorkspace='sam_bg', RHSWorkspace='cell_bg',OutputWorkspace='sam_cell')
    SaveAscii(InputWorkspace='sam_cell', Filename=prepath+'/sam_cell.dat')

if len(sol_run)>0 and len(cell_run)>0:
    Minus(LHSWorkspace='sol_bg', RHSWorkspace='cell_bg',OutputWorkspace='sol_cell')
    SaveAscii(InputWorkspace='sol_cell', Filename=prepath+'/sol_cell.dat')
    Minus(LHSWorkspace='sam_cell', RHSWorkspace='sol_cell',OutputWorkspace='sam_IQ')
    #Divide(LHSWorkspace="sam_IQ", RHSWorkspace='volume', OutputWorkspace="sam_IQ", AllowDifferentNumberSpectra=True)
    SaveAscii(InputWorkspace='sam_IQ', Filename=prepath+'/sam_IQ.dat')
elif len(sol_run)==0 and len(cell_run)>0:
    #Divide(LHSWorkspace="sam_cell", RHSWorkspace='volume', OutputWorkspace="sam_cell", AllowDifferentNumberSpectra=True)
    SaveAscii(InputWorkspace='sam_cell', Filename=prepath+'/sam_IQ.dat')
'''
print time.time()-be,' seconds'

