﻿#change log 20191122
#change the Trans calculation from monitors to monitor2+monitor3

#change log 20191217
#add the function to change IQ with a scaling factor

#change log 20191218
#add the mask file and cal file name output in the IQ reduced files
#add Batch in IQ2D

#change log 20191219
#the 2D_raw data will be deleted after the reduction to release the storage

#change log 20191220
#add the function to select save path for reduced data

#change log 20191222
#change the function to choose save path
#debug the IQ2D function for wrong Sample_No

from mantid.simpleapi import *
import sys
import time
import xml.etree.ElementTree as ET
import math

#prepath=str(prepath)
#prepath_read='/cvmfs/daas.csns.ihep.ac.cn/softwares/centos-7.2.1511/SANSoffline'

#define the path to load and save files

global prepath_read

prepath=os.environ['HOME']+'/instrument_data'

prepath_configure=os.environ['HOME']+'/SANSoffline'

#for Cloud
#prepath_read='/cvmfs/daas.csns.ihep.ac.cn/softwares/centos-7.2.1511/SANSoffline'

#for local
prepath_read=os.environ['HOME']+'/Documents/SANSoffline_data'

monSUM=True
global prepath_save
#prepath_save=os.environ['HOME']+'/SANSoffline/reducedFiles'

# the function to load configure.xml
def readXml(file):
    tree = ET.parse(file)
    root = tree.getroot()
    configure={}
    
    #the sign if sample had emptycell 
    _tmp = root.findall('if_empty')[0].text
    configure['if_empty']=_tmp
    
    #the sign if sample had solvent
    _tmp = root.findall('if_solvent')[0].text
    configure['if_solvent']=_tmp
    
    #the name of output files, may be used in the future
    _tmp = root.findall('SampleFileName')[0].text
    configure['SampleFileName']=_tmp
    _tmp = root.findall('EmptyCellFileName')[0].text
    configure['EmptyCellFileName']=_tmp
    _tmp = root.findall('SolventFileName')[0].text
    configure['SolventFileName']=_tmp
    
    #the name and path of calibration file 
    _tmp = root.findall('Calibration_File')[0].text
    configure['Calibration_File']=_tmp
    
    #the name and path of mask file 
    _tmp = root.findall('Mask_File')[0].text
    configure['Mask_File']=_tmp
    
    #the path to save reduced files
    _tmp = root.findall('Save_Path')[0].text
    configure['Save_Path']=_tmp
    
    #the center position on the detector of X and Y
    _tmp = root.findall('BeamCenter_X')[0].text
    configure['BeamCenter_X']=_tmp
    _tmp = root.findall('BeamCenter_Y')[0].text
    configure['BeamCenter_Y']=_tmp
    
    #the RunNo of Transmission exp.
    _tmp = root.findall('EmptyTransRun')[0].text
    configure['EmptyTransRun']=_tmp
    _tmp = root.findall('SampleTransRun')[0].text
    configure['SampleTransRun']=_tmp
    _tmp = root.findall('EmptyCellTransRun')[0].text
    configure['EmptyCellTransRun']=_tmp
    _tmp = root.findall('SolventTransRun')[0].text
    configure['SolventTransRun']=_tmp
    
    #the transmission fitting method 
    _tmp = root.findall('TransFittingMethod')[0].text
    configure['TransFittingMethod']=_tmp
    #the number of points to average over if transmission fitting method is smooth
    _tmp = root.findall('Smooth_Ns')[0].text
    configure['Smooth_Ns']=_tmp
    #the wavelength range for transmission reduction 
    _tmp = root.findall('Trans_Wavelength_Min')[0].text
    configure['Trans_Wavelength_Min']=_tmp
    _tmp = root.findall('Trans_Wavelength_Step')[0].text
    configure['Trans_Wavelength_Step']=_tmp
    _tmp = root.findall('Trans_Wavelength_Max')[0].text
    configure['Trans_Wavelength_Max']=_tmp
    
    #the RunNo of Scattering exp.
    _tmp = root.findall('EmptyDirectRun')[0].text
    configure['EmptyDirectRun']=_tmp
    _tmp = root.findall('SampleScattRun')[0].text
    configure['SampleScattRun']=_tmp
    _tmp = root.findall('EmptyCellScattRun')[0].text
    configure['EmptyCellScattRun']=_tmp
    _tmp = root.findall('SolventScattRun')[0].text
    configure['SolventScattRun']=_tmp
    
    #the sample thickness
    _tmp = root.findall('Thickness')[0].text
    configure['Thickness']=_tmp
    #the sample collimator diameter
    _tmp = root.findall('Diameter')[0].text
    configure['Diameter']=_tmp
    #the scaling factor of IQ
    _tmp = root.findall('ScalingFactor')[0].text
    configure['ScalingFactor']=_tmp
    #if the sample is solution, the volume fraction of solute
    _tmp = root.findall('SolventVolumeFraction')[0].text
    configure['SolventVolumeFraction']=_tmp
    #the wavelength range for scattering reduction
    _tmp = root.findall('Scatt_Wavelength_Min')[0].text
    configure['Scatt_Wavelength_Min']=_tmp
    _tmp = root.findall('Scatt_Wavelength_Step')[0].text
    configure['Scatt_Wavelength_Step']=_tmp
    _tmp = root.findall('Scatt_Wavelength_Max')[0].text
    configure['Scatt_Wavelength_Max']=_tmp
    #the Q range for scattering reduction
    _tmp = root.findall('Q_Min')[0].text
    configure['Q_Min']=_tmp
    _tmp = root.findall('Q_Step')[0].text
    configure['Q_Step']=_tmp
    _tmp = root.findall('Q_Max')[0].text
    configure['Q_Max']=_tmp
    
    #the wavelength range for IQChecking module
    _tmp = root.findall('IQ_Check_Wavelength_Min_1')[0].text
    configure['IQ_Check_Wavelength_Min_1']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_1')[0].text
    configure['IQ_Check_Wavelength_Step_1']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_1')[0].text
    configure['IQ_Check_Wavelength_Max_1']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_2')[0].text
    configure['IQ_Check_Wavelength_Min_2']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_2')[0].text
    configure['IQ_Check_Wavelength_Step_2']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_2')[0].text
    configure['IQ_Check_Wavelength_Max_2']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_3')[0].text
    configure['IQ_Check_Wavelength_Min_3']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_3')[0].text
    configure['IQ_Check_Wavelength_Step_3']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_3')[0].text
    configure['IQ_Check_Wavelength_Max_3']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_4')[0].text
    configure['IQ_Check_Wavelength_Min_4']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_4')[0].text
    configure['IQ_Check_Wavelength_Step_4']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_4')[0].text
    configure['IQ_Check_Wavelength_Max_4']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_5')[0].text
    configure['IQ_Check_Wavelength_Min_5']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_5')[0].text
    configure['IQ_Check_Wavelength_Step_5']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_5')[0].text
    configure['IQ_Check_Wavelength_Max_5']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_6')[0].text
    configure['IQ_Check_Wavelength_Min_6']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_6')[0].text
    configure['IQ_Check_Wavelength_Step_6']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_6')[0].text
    configure['IQ_Check_Wavelength_Max_6']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Min_7')[0].text
    configure['IQ_Check_Wavelength_Min_7']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Step_7')[0].text
    configure['IQ_Check_Wavelength_Step_7']=_tmp
    _tmp = root.findall('IQ_Check_Wavelength_Max_7')[0].text
    configure['IQ_Check_Wavelength_Max_7']=_tmp
    #the position range of detector, which is used to define Q range
    _tmp = root.findall('IQ_Check_Detector_Min')[0].text
    configure['IQ_Check_Detector_Min']=_tmp
    _tmp = root.findall('IQ_Check_Detector_Max')[0].text
    configure['IQ_Check_Detector_Max']=_tmp
    
    #the number of samples in batch module
    _tmp = root.findall('IQ_Batch_Number_Of_Samples')[0].text
    configure['IQ_Batch_Number_Of_Samples']=_tmp
    
    #int No_Batch which will be used in the following iteration
    No_Batch=int(configure['IQ_Batch_Number_Of_Samples'])
    
    #the iteration for different samples' info 
    for i in range(1,No_Batch+1):
        
        #tranmission RunNo.
        _tmp = root.findall('IQ_Batch_EmptyTrans_'+str(i))[0].text
        configure['IQ_Batch_EmptyTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_SampleTrans_'+str(i))[0].text
        configure['IQ_Batch_SampleTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_EmptycellTrans_'+str(i))[0].text
        configure['IQ_Batch_EmptycellTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_SolventTrans_'+str(i))[0].text
        configure['IQ_Batch_SolventTrans_'+str(i)]=_tmp
        
        #transmission fitting method
        _tmp = root.findall('IQ_Batch_TransFit_'+str(i))[0].text
        configure['IQ_Batch_TransFit_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_Ns_'+str(i))[0].text
        configure['IQ_Batch_Ns_'+str(i)]=_tmp
        
        #wavelength range
        _tmp = root.findall('IQ_Batch_WavMin_'+str(i))[0].text
        configure['IQ_Batch_WavMin_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_WavStep_'+str(i))[0].text
        configure['IQ_Batch_WavStep_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_WavMax_'+str(i))[0].text
        configure['IQ_Batch_WavMax_'+str(i)]=_tmp
        
        #scattering RunNo.
        _tmp = root.findall('IQ_Batch_EmptyScatt_'+str(i))[0].text
        configure['IQ_Batch_EmptyScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_SampleScatt_'+str(i))[0].text
        configure['IQ_Batch_SampleScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_EmptycellScatt_'+str(i))[0].text
        configure['IQ_Batch_EmptycellScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_SolventScatt_'+str(i))[0].text
        configure['IQ_Batch_SolventScatt_'+str(i)]=_tmp
        
        #sample property
        _tmp = root.findall('IQ_Batch_Thickness_'+str(i))[0].text
        configure['IQ_Batch_Thickness_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_SolventVF_'+str(i))[0].text
        configure['IQ_Batch_SolventVF_'+str(i)]=_tmp
        
        #Q range
        _tmp = root.findall('IQ_Batch_QMin_'+str(i))[0].text
        configure['IQ_Batch_QMin_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_QStep_'+str(i))[0].text
        configure['IQ_Batch_QStep_'+str(i)]=_tmp
        _tmp = root.findall('IQ_Batch_QMax_'+str(i))[0].text
        configure['IQ_Batch_QMax_'+str(i)]=_tmp
        
        #Scaling Factor of IQ
        _tmp = root.findall('IQ_Batch_ScalingFactor_'+str(i))[0].text
        configure['IQ_Batch_ScalingFactor_'+str(i)]=_tmp
        
    
    #the number of samples in batch module
    _tmp = root.findall('IQ2D_Number_Of_Samples')[0].text
    configure['IQ2D_Number_Of_Samples']=_tmp
    
    #int No_IQ2D which will be used in the following iteration
    No_IQ2D=int(configure['IQ2D_Number_Of_Samples'])
    
    #the iteration for different samples' info 
    for i in range(1,No_IQ2D+1):
    	
        #IQ2D transmission RunNo.
        _tmp = root.findall('IQ2D_EmptyTrans_'+str(i))[0].text
        configure['IQ2D_EmptyTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_SampleTrans_'+str(i))[0].text
        configure['IQ2D_SampleTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_EmptycellTrans_'+str(i))[0].text
        configure['IQ2D_EmptycellTrans_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_SolventTrans_'+str(i))[0].text
        configure['IQ2D_SolventTrans_'+str(i)]=_tmp
    
        #IQ2D transmission fitting method
        _tmp = root.findall('IQ2D_TransFittingMethod_'+str(i))[0].text
        configure['IQ2D_TransFittingMethod_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_Smooth_Ns_'+str(i))[0].text
        configure['IQ2D_Smooth_Ns_'+str(i)]=_tmp
    
        #IQ2D wavelength range
        _tmp = root.findall('IQ2D_Wavelength_Min_'+str(i))[0].text
        configure['IQ2D_Wavelength_Min_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_Wavelength_Step_'+str(i))[0].text
        configure['IQ2D_Wavelength_Step_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_Wavelength_Max_'+str(i))[0].text
        configure['IQ2D_Wavelength_Max_'+str(i)]=_tmp
    
        #IQ2D scattering RunNo.
        _tmp = root.findall('IQ2D_EmptyScatt_'+str(i))[0].text
        configure['IQ2D_EmptyScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_SampleScatt_'+str(i))[0].text
        configure['IQ2D_SampleScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_EmptycellScatt_'+str(i))[0].text
        configure['IQ2D_EmptycellScatt_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_SolventScatt_'+str(i))[0].text
        configure['IQ2D_SolventScatt_'+str(i)]=_tmp
    
        #IQ2D sample property
        _tmp = root.findall('IQ2D_Thickness_'+str(i))[0].text
        configure['IQ2D_Thickness_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_SolventVolumeFraction_'+str(i))[0].text
        configure['IQ2D_SolventVolumeFraction_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_ScalingFactor_'+str(i))[0].text
        configure['IQ2D_ScalingFactor_'+str(i)]=_tmp
    
        #IQ2D Q range
        _tmp = root.findall('IQ2D_QxyMax_'+str(i))[0].text
        configure['IQ2D_QxyMax_'+str(i)]=_tmp
        _tmp = root.findall('IQ2D_DeltaQ_'+str(i))[0].text
        configure['IQ2D_DeltaQ_'+str(i)]=_tmp
    
    
    return configure


import os

#to find the RunNo subfolder in the main folder
def my_finds(fileFolder,prepath):
    #matchs=[]
    
    for currentFolder in os.listdir(prepath):
        addRootFolder=os.path.join(prepath, currentFolder)
        if os.path.isdir(addRootFolder+'/'+fileFolder):
            matchs=currentFolder
            break    
    
    return str(matchs)

#load the Nexus file into internal storage and merge different Nexus files to one variable
def mergeWS(prepath, wsList,output):
    #wsList=[wsList]
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        realProposal=my_finds(name,prepath)
        LoadNexus(Filename=prepath+'/'+realProposal+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
        #LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
'''
def mergeWS(prepath, wsList,output):
    for ix in wsList:
        name='RUN'+str(ix).zfill(7)
        LoadNexus(Filename=prepath+'/'+name+'/'+output+'.nxs',OutputWorkspace=str(ix))
        #name=str(ix).zfill(7)
        #LoadNexus(Filename=name+'/'+output+'.nxs',OutputWorkspace=str(ix))
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=str(wsList[i]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=str(wsList[i+1]))
            DeleteWorkspace(Workspace=str(wsList[i]))
        else:
            Plus(LHSWorkspace=str(wsList[i]),RHSWorkspace=str(wsList[i+1]), OutputWorkspace=output)
            DeleteWorkspace(Workspace=str(wsList[i]))
            DeleteWorkspace(Workspace=str(wsList[i+1]))
            break
'''

# the function used in findCmaskWS
def getMask(xPids, yPids):
    index=[]
    xnum=xPids[1]-xPids[0]+1
    ynum=yPids[1]-yPids[0]+1
    sta=yPids[0]*125+xPids[0]
    for i in range(xnum):
        for j in range(ynum):
            index.append(sta+j*125+i)
    return index

# the function to set the Mask pixels in the detector, which can also be used for saving Mask file
# is not used in the reduction.py, since we use loading mask file instead
def findCmaskWS(wsname,Xcenter,Ycenter):
    x=Xcenter
    y=Ycenter
    MoveInstrumentComponent(Workspace=wsname, ComponentName='Bank01', X=x, Y=y, RelativePosition=False)
    index=getMask([0,18],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    index=getMask([105,124],[0,119])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)
    inner=0.048
    xml_inner='<infinite-cylinder id="beam_stop"><centre x="0" y="0" z="0.0" /><axis x="0" y="0" z="1" /><radius val= "'+str(inner)+'" /></infinite-cylinder><algebra val="beam_stop"/>'
    MaskDetectorsInShape(Workspace=wsname, ShapeXML=xml_inner)
    index=getMask([60,63],[0,57])
    MaskDetectors(Workspace=wsname, WorkspaceIndexList=index)

# to calculate the Qresolution for each Q value
def calResolution(M2sample,wavelength, Q):
    L1=11.90-7.45
    #L1, source to sample distance, unit: m 
    L2=4.0
    #L2, sample to detector distance, unit: m 
    #d1=1.9/100.0
    d1=1.4/100.0
    #d1,source aperture diameter, unit: m 
    #d2=0.6/100.0
    d2=0.6/100.0
    #d2, sample aperture diameter, unit: m 
    d3=1.6/100.0
    #d3, detector res, unit: m   
    #detector_min=0.048
    detector_min=0.024
    #detector minimum position
    detector_max=0.7
    #detector maximum position
    delta_lamda=0.0057
    #variance of lamda
    
    #wavelength=mtd['wavelength'].readX(0)
    efficiency=[]
    for efficiency_index in range(len(wavelength)):
        efficiency.append(4.7613/1000000.0+0.00054333*wavelength[efficiency_index])
    #M2 efficiency

    Intensity=M2sample
    Intensity_eff=[]
    for Intensity_index in range(len(Intensity)):
        Intensity_eff.append(Intensity[Intensity_index]/efficiency[Intensity_index])
    #Intensity=Intensity/efficiency
    
    sigmaQ=[]
    for Q_value in Q:
        total_intensity=0
        lamda_value_index=0
        sigmaQ_sum=0
        for lamda_value in wavelength:
            Ldet=L2*Q_value*lamda_value/6.28
            
            if detector_min < Ldet < detector_max:
                total_intensity=total_intensity+Intensity_eff[lamda_value_index]
                sigmaQ_sum=sigmaQ_sum+Intensity_eff[lamda_value_index]*math.sqrt((delta_lamda)**2.0+0.25*((L2/L1)**2.0)*((d1/2.0/Ldet)**2.0)+0.25*((1+L2/L1)**2.0)*((d2/2.0/Ldet)**2.0)+1.0/12.0*((d3/Ldet)**2.0))*Q_value
            lamda_value_index=lamda_value_index+1
                      
        sigmaQ.append(sigmaQ_sum/total_intensity)
            
        
        
    return sigmaQ


# output the transmission file
def outputTrans(prepath, transRunNo, emptyRunNo, trans_unfitted, trans_fitted,fileName, wave_rebin, Trans_fitting_method, Smooth_Ns):
    
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    trans_sam_fitted=mtd[trans_fitted].readY(0)
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_fitted].readX(0)
     
    f_fp=prepath+'/SANS_Trans_RunNo_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    #ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted | Trans_fitted \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i],trans_sam_fitted[i]))
        
        

#output the raw transmission file for the total wavelength range
def outputTransAll(prepath, transRunNo, emptyRunNo, trans_unfitted,fileName,wave_rebin_all):

    
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_unfitted].readX(0)
     
    f_fp=prepath+'/SANS_TransAll_RunNo_'+str(transRunNo)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin_all is '+str(wave_rebin_all)+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted  \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i]))
        

# output the IQ file for simple sample (only sample and emptybeam are considered)
def outputIq(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, emptyTransNo, transRunNo, qName, wName, m2Sample,fileName,thickness,diameter,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    #f_fp=prepath+'/SANS_'+str(runNo)+'_'+str(fileName)+'.dat'     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubEmpty.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))

#output IQ file for pure solute (sample, emptycell, solvent and emptybeam are considered)
def outputIqSolution(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, cellSolventNo, emptyCellNo, emptyTransNo, transRunNo, transCellSolventNo, transEmptyCellNo, qName, wName, m2Sample, volumefraction,fileName,thickness,diameter,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    cellSolventNo=map(int,cellSolventNo)
    cellSolventNo=str(cellSolventNo)
    cellSolventNo=cellSolventNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transCellSolventNo=map(int,transCellSolventNo)
    transCellSolventNo=str(transCellSolventNo)
    transCellSolventNo=transCellSolventNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    
    vf=mtd[volumefraction].readY(0)
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubSolvent'+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    ff.write('#SolutionRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#SolventRun '+str(cellSolventNo)+' and Trans '+str(transCellSolventNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    ff.write('#solvent volume fraction at solution: '+str(vf)+ '\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))       


#output IQ file for sample with emptycell (sample, emptycell and emptybeam are considered)
def outputIqEmptyCellDeduction(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo,  emptyCellNo, emptyTransNo, transRunNo, transEmptyCellNo, qName, wName, m2Sample,fileName,thickness,diameter,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubEmptycell.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    ff.write('#SampleRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))    
        

##specific for Batch mode, add an index in the output file for batch page

#output transmission file in batch mode
def outputTransBatch(prepath, transRunNo, emptyRunNo, trans_unfitted, trans_fitted,fileName,Batch_Sample_No,wave_rebin,Trans_fitting_method, Smooth_Ns):

    
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    trans_sam_fitted=mtd[trans_fitted].readY(0)
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_fitted].readX(0)
     
    f_fp=prepath+'/SANS_Trans_RunNo_'+str(transRunNo)+'_Batch'+str(Batch_Sample_No)+'.dat'     
    ff=open(f_fp, "w") 
    
    #ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted | Trans_fitted \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i],trans_sam_fitted[i]))
        
#output Raw transmission file of all wavelength range in batch mode
def outputTransAllBatch(prepath, transRunNo, emptyRunNo, trans_unfitted,fileName,Batch_Sample_No,wave_rebin_all):

    
    emptyRunNo=map(int,emptyRunNo)
    emptyRunNo=str(emptyRunNo)
    emptyRunNo=emptyRunNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    trans_sam_unfitted=mtd[trans_unfitted].readY(0)
    lambda_all= mtd[trans_unfitted].readX(0)
     
    f_fp=prepath+'/SANS_TransAll_RunNo_'+str(transRunNo)+'_Batch'+str(Batch_Sample_No)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Trans '+str(transRunNo)+' and Empty '+str(emptyRunNo)+' from SANS@CSNS\n')
    ff.write('#Wavelength_rebin_all is '+str(wave_rebin_all)+'\n')
    
    #The thickness and diameter of the sample are not shown in the Trans file, 
    #since the calculation of transmission won't consider them.
    #ff.write('#Sample diameter '+str(diameter)+' cm and sample thickness '+str(thickness)+' cm\n')
    
    #ff.write('%d',% (runNo))
    ff.write('lambda (AA) | Trans_unfitted  \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(lambda_all)-1):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f  \n' % (lambda_all[i],trans_sam_unfitted[i]))
        
# output IQ for simple sample (sample and emptybeam are considered) in batch mode
def outputIqBatch(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, emptyTransNo, transRunNo, qName, wName, m2Sample,fileName,thickness,diameter,Batch_Sample_No,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    #f_fp=prepath+'/SANS_'+str(runNo)+'_'+str(fileName)+'.dat'     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubEmpty_Batch'+str(Batch_Sample_No)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    ff.write('#Run '+str(runNo)+' and Trans '+str(transRunNo)+' from SANS@CSNS\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))

# output IQ for solute sample (sample, emptycell, solvent and emptybeam are considered) in batch mode
def outputIqSolutionBatch(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo, cellSolventNo, emptyCellNo, emptyTransNo, transRunNo, transCellSolventNo, transEmptyCellNo, qName, wName, m2Sample, volumefraction,fileName,thickness,diameter,Batch_Sample_No,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    cellSolventNo=map(int,cellSolventNo)
    cellSolventNo=str(cellSolventNo)
    cellSolventNo=cellSolventNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transCellSolventNo=map(int,transCellSolventNo)
    transCellSolventNo=str(transCellSolventNo)
    transCellSolventNo=transCellSolventNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    
    vf=mtd[volumefraction].readY(0)
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubSolvent'+'_Batch'+str(Batch_Sample_No)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    ff.write('#SolutionRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#SolventRun '+str(cellSolventNo)+' and Trans '+str(transCellSolventNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    ff.write('#solvent volume fraction at solution: '+str(vf)+ '\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))       

# output IQ file for sample in emptycell (sample, emptycell and emptybeam are considered) in batch mode
def outputIqEmptyCellDeductionBatch(prepath, Q_rebin, Wavelength_rebin, emptyNo, runNo,  emptyCellNo, emptyTransNo, transRunNo, transEmptyCellNo, qName, wName, m2Sample,fileName,thickness,diameter,Batch_Sample_No,  Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):

    
    emptyNo=map(int,emptyNo)
    emptyNo=str(emptyNo)
    emptyNo=emptyNo.replace('[','').replace(']','')
    
    runNo=map(int,runNo)
    runNo=str(runNo)
    runNo=runNo.replace('[','').replace(']','')
    
    emptyTransNo=map(int,emptyTransNo)
    emptyTransNo=str(emptyTransNo)
    emptyTransNo=emptyTransNo.replace('[','').replace(']','')
    
    transRunNo=map(int,transRunNo)
    transRunNo=str(transRunNo)
    transRunNo=transRunNo.replace('[','').replace(']','')
    
    emptyCellNo=map(int,emptyCellNo)
    emptyCellNo=str(emptyCellNo)
    emptyCellNo=emptyCellNo.replace('[','').replace(']','')
    
    transEmptyCellNo=map(int,transEmptyCellNo)
    transEmptyCellNo=str(transEmptyCellNo)
    transEmptyCellNo=transEmptyCellNo.replace('[','').replace(']','')
    
    Q=mtd[qName].readX(0)
    Q_shift=[]
    for Q_shift_index in range(len(Q)-1):
        Q_shift.append((Q[Q_shift_index]+Q[Q_shift_index+1])/2.0)
        
    iQ=mtd[qName].readY(0)
    
    sIQ=mtd[qName].readE(0)
     
    wavelength=mtd[wName].readX(0)
    wavelength_shift=[]
    for wavelength_shift_index in range(len(wavelength)-1):
        wavelength_shift.append((wavelength[wavelength_shift_index]+wavelength[wavelength_shift_index+1])/2.0)
    #change wavelength from bin to point
    
    M2sample=mtd[m2Sample].readY(0)
     
    sQ=calResolution(M2sample,wavelength_shift,Q)
     
    f_fp=prepath+'/SANS_IQ_RunNo_'+str(runNo)+'_Final_SubEmptycell'+'_Batch'+str(Batch_Sample_No)+'.dat'     
    ff=open(f_fp, "w") 
    
    ff.write('#Mask file is '+str(mask_file)+' \n')
    ff.write('#Calibration file is '+str(cal_file)+' \n')
    ff.write('#SampleRun '+str(runNo)+' and Trans '+str(transRunNo)+ '\n')
    ff.write('#EmptyCellRun '+str(emptyCellNo)+' and Trans '+str(transEmptyCellNo)+ '\n')
    ff.write('#EmptyRun '+str(emptyNo)+' and Trans '+str(emptyTransNo)+ '\n')
    ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
    
    
    ff.write('#Q_rebin is '+str(Q_rebin)+'\n')
    ff.write('#Wavelength_rebin is '+str(Wavelength_rebin)+'\n')
    ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
    if (Trans_fitting_method == 'Smooth'):
        ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
    
    ff.write('#Scaling Factor is '+str(ScalingFactor)+'\n')
    
    #ff.write('%d',% (runNo))
    ff.write('Q (1/A) | IQ (1/cm) | std. dev. I(Q) (1/cm) | sigmaQ (1/A) \n')
    #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
     
    for i in range(len(Q_shift)):
        #strtmp='%.6f %.6f %.6f %.6f' % (Q[i],iQ[i],sIQ[i],sQ[i])
        ff.write('%.6f %.6f %.6f %.6f \n' % (Q_shift[i],iQ[i],sIQ[i],sQ[i]))    
        
# output IQ2D of emptybeam
def outputIq2DEmpty(prepath, QxyMax, DeltaQ, wave_rebin, IQ2D_emptyScatt, IQ2D_emptyTrans, thickness, diameter,IQ2D_Sample_No, IQ2D_empty, ScalingFactor,cal_file,mask_file):
    
    IQ2D_emptyScatt=map(int,IQ2D_emptyScatt)
    IQ2D_emptyScatt=str(IQ2D_emptyScatt)
    IQ2D_emptyScatt=IQ2D_emptyScatt.replace('[','').replace(']','')
    
    IQ2D_emptyTrans=map(int,IQ2D_emptyTrans)
    IQ2D_emptyTrans=str(IQ2D_emptyTrans)
    IQ2D_emptyTrans=IQ2D_emptyTrans.replace('[','').replace(']','')
    
    SaveNISTDAT(InputWorkspace=IQ2D_empty, Filename=prepath+'/SANS_IQ2D_'+'Empty_RunNo_'+str(IQ2D_emptyScatt)+'_Batch_'+str(IQ2D_Sample_No)+'.dat')
    
    f_fp=prepath+'/SANS_IQ2D_'+'Empty_RunNo_'+str(IQ2D_emptyScatt)+'_Batch_'+str(IQ2D_Sample_No)+'.dat'
    
    with open(f_fp,"r+") as ff:
        old = ff.read()
        ff.seek(0)
        ff.write('#Mask file is '+str(mask_file)+' \n')
        ff.write('#Calibration file is '+str(cal_file)+' \n')
        ff.write('#EmptyRun '+str(IQ2D_emptyScatt)+' and Trans '+str(IQ2D_emptyTrans)+ '\n')
        
        ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
        ff.write('#QxyMax is '+str(QxyMax)+ ' and DeltaQ is ' +str(DeltaQ)+ '\n')
        ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
        ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
        
        ff.write(old)


# output IQ2D of sample (sample and emptybeam are considered)
def outputIq2DSample(prepath, QxyMax, DeltaQ, wave_rebin, IQ2D_emptyScatt, IQ2D_emptyTrans, IQ2D_sampleScatt, IQ2D_sampleTrans, thickness, diameter, IQ2D_Sample_No,IQ2D_sample, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):
    
    IQ2D_emptyScatt=map(int,IQ2D_emptyScatt)
    IQ2D_emptyScatt=str(IQ2D_emptyScatt)
    IQ2D_emptyScatt=IQ2D_emptyScatt.replace('[','').replace(']','')
    
    IQ2D_emptyTrans=map(int,IQ2D_emptyTrans)
    IQ2D_emptyTrans=str(IQ2D_emptyTrans)
    IQ2D_emptyTrans=IQ2D_emptyTrans.replace('[','').replace(']','')
    
    IQ2D_sampleScatt=map(int,IQ2D_sampleScatt)
    IQ2D_sampleScatt=str(IQ2D_sampleScatt)
    IQ2D_sampleScatt=IQ2D_sampleScatt.replace('[','').replace(']','')
    
    IQ2D_sampleTrans=map(int,IQ2D_sampleTrans)
    IQ2D_sampleTrans=str(IQ2D_sampleTrans)
    IQ2D_sampleTrans=IQ2D_sampleTrans.replace('[','').replace(']','')
    
    SaveNISTDAT(InputWorkspace=IQ2D_sample, Filename=prepath+'/SANS_IQ2D_'+'RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubEmpty_Batch_'+str(IQ2D_Sample_No)+'.dat')
    
    f_fp=prepath+'/SANS_IQ2D_'+'RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubEmpty_Batch_'+str(IQ2D_Sample_No)+'.dat'
    
    with open(f_fp,"r+") as ff:
        old = ff.read()
        ff.seek(0)
        
        ff.write('#Mask file is '+str(mask_file)+' \n')
        ff.write('#Calibration file is '+str(cal_file)+' \n')
        ff.write('#EmptyRun '+str(IQ2D_emptyScatt)+' and Trans '+str(IQ2D_emptyTrans)+ '\n')
        ff.write('#SampleRun '+str(IQ2D_sampleScatt)+' and Trans '+str(IQ2D_sampleTrans)+ '\n')
        
        ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
        ff.write('#QxyMax is '+str(QxyMax)+ ' and DeltaQ is ' +str(DeltaQ)+ '\n')
        ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
        ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
        if (Trans_fitting_method == 'Smooth'):
            ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
        ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
        
        ff.write(old)



# output IQ2D of sample with emptycell (sample, emptycell and emptybeam are considered)
def outputIq2DEmptycellDeduction(prepath, QxyMax, DeltaQ, wave_rebin, IQ2D_emptyScatt, IQ2D_emptyTrans, IQ2D_sampleScatt, IQ2D_sampleTrans, IQ2D_emptycellScatt, IQ2D_emptycellTrans, thickness, diameter,IQ2D_Sample_No, IQ_sam2D_normalized_emptycell_deduction, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):
    
    IQ2D_emptyScatt=map(int,IQ2D_emptyScatt)
    IQ2D_emptyScatt=str(IQ2D_emptyScatt)
    IQ2D_emptyScatt=IQ2D_emptyScatt.replace('[','').replace(']','')
    
    IQ2D_emptyTrans=map(int,IQ2D_emptyTrans)
    IQ2D_emptyTrans=str(IQ2D_emptyTrans)
    IQ2D_emptyTrans=IQ2D_emptyTrans.replace('[','').replace(']','')
    
    IQ2D_sampleScatt=map(int,IQ2D_sampleScatt)
    IQ2D_sampleScatt=str(IQ2D_sampleScatt)
    IQ2D_sampleScatt=IQ2D_sampleScatt.replace('[','').replace(']','')
    
    IQ2D_sampleTrans=map(int,IQ2D_sampleTrans)
    IQ2D_sampleTrans=str(IQ2D_sampleTrans)
    IQ2D_sampleTrans=IQ2D_sampleTrans.replace('[','').replace(']','')
    
    IQ2D_emptycellScatt=map(int,IQ2D_emptycellScatt)
    IQ2D_emptycellScatt=str(IQ2D_emptycellScatt)
    IQ2D_emptycellScatt=IQ2D_emptycellScatt.replace('[','').replace(']','')
    
    IQ2D_emptycellTrans=map(int,IQ2D_emptycellTrans)
    IQ2D_emptycellTrans=str(IQ2D_emptycellTrans)
    IQ2D_emptycellTrans=IQ2D_emptycellTrans.replace('[','').replace(']','')
    
    SaveNISTDAT(InputWorkspace=IQ_sam2D_normalized_emptycell_deduction, Filename=prepath+'/SANS_IQ2D_RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubEmptycell_Batch_'+str(IQ2D_Sample_No)+'.dat')
    
    f_fp=prepath+'/SANS_IQ2D_RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubEmptycell_Batch_'+str(IQ2D_Sample_No)+'.dat'
    
    with open(f_fp,"r+") as ff:
        old = ff.read()
        ff.seek(0)
        
        ff.write('#Mask file is '+str(mask_file)+' \n')
        ff.write('#Calibration file is '+str(cal_file)+' \n')
        ff.write('#EmptyRun '+str(IQ2D_emptyScatt)+' and Trans '+str(IQ2D_emptyTrans)+ '\n')
        ff.write('#SampleRun '+str(IQ2D_sampleScatt)+' and Trans '+str(IQ2D_sampleTrans)+ '\n')
        ff.write('#EmptycellRun '+str(IQ2D_emptycellScatt)+' and Trans '+str(IQ2D_emptycellTrans)+ '\n')
        
        ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
        ff.write('#QxyMax is '+str(QxyMax)+ ' and DeltaQ is ' +str(DeltaQ)+ '\n')
        ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
        ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
        if (Trans_fitting_method == 'Smooth'):
            ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
        ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
        
        ff.write(old)



# output IQ2D of solute sample (sample, emptycell, solvent and emptybeam are considered)
def outputIq2DSolution(prepath, QxyMax, DeltaQ, wave_rebin, IQ2D_emptyScatt, IQ2D_emptyTrans, IQ2D_sampleScatt, IQ2D_sampleTrans, IQ2D_emptycellScatt, IQ2D_emptycellTrans, IQ2D_solventScatt, IQ2D_solventTrans, thickness, diameter,IQ2D_Sample_No, Solvent_Volume_Fraction, IQ2D_solute_reduced, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file):
    
    IQ2D_emptyScatt=map(int,IQ2D_emptyScatt)
    IQ2D_emptyScatt=str(IQ2D_emptyScatt)
    IQ2D_emptyScatt=IQ2D_emptyScatt.replace('[','').replace(']','')
    
    IQ2D_emptyTrans=map(int,IQ2D_emptyTrans)
    IQ2D_emptyTrans=str(IQ2D_emptyTrans)
    IQ2D_emptyTrans=IQ2D_emptyTrans.replace('[','').replace(']','')
    
    IQ2D_sampleScatt=map(int,IQ2D_sampleScatt)
    IQ2D_sampleScatt=str(IQ2D_sampleScatt)
    IQ2D_sampleScatt=IQ2D_sampleScatt.replace('[','').replace(']','')
    
    IQ2D_sampleTrans=map(int,IQ2D_sampleTrans)
    IQ2D_sampleTrans=str(IQ2D_sampleTrans)
    IQ2D_sampleTrans=IQ2D_sampleTrans.replace('[','').replace(']','')
    
    IQ2D_emptycellScatt=map(int,IQ2D_emptycellScatt)
    IQ2D_emptycellScatt=str(IQ2D_emptycellScatt)
    IQ2D_emptycellScatt=IQ2D_emptycellScatt.replace('[','').replace(']','')
    
    IQ2D_emptycellTrans=map(int,IQ2D_emptycellTrans)
    IQ2D_emptycellTrans=str(IQ2D_emptycellTrans)
    IQ2D_emptycellTrans=IQ2D_emptycellTrans.replace('[','').replace(']','')
    
    IQ2D_solventScatt=map(int,IQ2D_solventScatt)
    IQ2D_solventScatt=str(IQ2D_solventScatt)
    IQ2D_solventScatt=IQ2D_solventScatt.replace('[','').replace(']','')
    
    IQ2D_solventTrans=map(int,IQ2D_solventTrans)
    IQ2D_solventTrans=str(IQ2D_solventTrans)
    IQ2D_solventTrans=IQ2D_solventTrans.replace('[','').replace(']','')
    
    SaveNISTDAT(InputWorkspace=IQ2D_solute_reduced, Filename=prepath+'/SANS_IQ2D_RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubSolvent_Batch_'+str(IQ2D_Sample_No)+'.dat')
    
    f_fp=prepath+'/SANS_IQ2D_RunNo_'+str(IQ2D_sampleScatt)+'_Final_SubSolvent_Batch_'+str(IQ2D_Sample_No)+'.dat'
    
    with open(f_fp,"r+") as ff:
        old = ff.read()
        ff.seek(0)
        
        ff.write('#Mask file is '+str(mask_file)+' \n')
        ff.write('#Calibration file is '+str(cal_file)+' \n')
        ff.write('#EmptyRun '+str(IQ2D_emptyScatt)+' and Trans '+str(IQ2D_emptyTrans)+ '\n')
        ff.write('#SampleRun '+str(IQ2D_sampleScatt)+' and Trans '+str(IQ2D_sampleTrans)+ '\n')
        ff.write('#EmptycellRun '+str(IQ2D_emptycellScatt)+' and Trans '+str(IQ2D_emptycellTrans)+ '\n')
        ff.write('#SolventRun '+str(IQ2D_solventScatt)+' and Trans '+str(IQ2D_solventTrans)+ '\n')
        
        ff.write('#Sample diameter '+str(diameter)+' mm and sample thickness '+str(thickness)+' mm\n')
        ff.write('#Solvent volume fraction at solution: '+str(Solvent_Volume_Fraction)+ '\n')
        ff.write('#QxyMax is '+str(QxyMax)+ ' and DeltaQ is ' +str(DeltaQ)+ '\n')
        ff.write('#Wavelength_rebin is '+str(wave_rebin)+'\n')
        ff.write('#Trans fitting method is '+Trans_fitting_method+'\n')
        if (Trans_fitting_method == 'Smooth'):
            ff.write('#The number of points for Trans fitting to average over is '+str(Smooth_Ns)+'\n')
        ff.write('#Scaling factor is '+str(ScalingFactor)+'\n')
        
        ff.write(old)

# write the log file for batch mode and IQ2D mode, including the information of RunNo and thickness
def WriteReducedFilesInfo(prepath,Time,BatchType,Sample_No,Batch_EmptyTrans_Num,Batch_EmptyTrans,Batch_SampleTrans_Num,Batch_SampleTrans,Batch_EmptycellTrans_Num,Batch_EmptycellTrans,Batch_SolventTrans_Num,Batch_SolventTrans,Batch_EmptyScatt_Num,Batch_EmptyScatt,Batch_SampleScatt_Num,Batch_SampleScatt,Batch_EmptycellScatt_Num,Batch_EmptycellScatt,Batch_SolventScatt_Num,Batch_SolventScatt,Batch_Thickness):
    
    Batch_EmptyTrans=map(int,Batch_EmptyTrans)
    Batch_EmptyTrans=str(Batch_EmptyTrans)
    Batch_EmptyTrans=Batch_EmptyTrans.replace('[','').replace(']','')
    
    Batch_SampleTrans=map(int,Batch_SampleTrans)
    Batch_SampleTrans=str(Batch_SampleTrans)
    Batch_SampleTrans=Batch_SampleTrans.replace('[','').replace(']','')
    
    if(Batch_EmptycellTrans_Num>0):
        Batch_EmptycellTrans=map(int,Batch_EmptycellTrans)
        Batch_EmptycellTrans=str(Batch_EmptycellTrans)
        Batch_EmptycellTrans=Batch_EmptycellTrans.replace('[','').replace(']','')
    else:
        Batch_EmptycellTrans=[]
    
    if(Batch_SolventTrans_Num>0):
        Batch_SolventTrans=map(int,Batch_SolventTrans)
        Batch_SolventTrans=str(Batch_SolventTrans)
        Batch_SolventTrans=Batch_SolventTrans.replace('[','').replace(']','')
    else:
        Batch_SolventTrans=[]
    
    Batch_EmptyScatt=map(int,Batch_EmptyScatt)
    Batch_EmptyScatt=str(Batch_EmptyScatt)
    Batch_EmptyScatt=Batch_EmptyScatt.replace('[','').replace(']','')
    
    Batch_SampleScatt=map(int,Batch_SampleScatt)
    Batch_SampleScatt=str(Batch_SampleScatt)
    Batch_SampleScatt=Batch_SampleScatt.replace('[','').replace(']','')
    
    if(Batch_EmptycellScatt_Num>0):
        Batch_EmptycellScatt=map(int,Batch_EmptycellScatt)
        Batch_EmptycellScatt=str(Batch_EmptycellScatt)
        Batch_EmptycellScatt=Batch_EmptycellScatt.replace('[','').replace(']','')
    else:
        Batch_EmptycellScatt=[]
        
    if(Batch_SolventScatt_Num>0):
        Batch_SolventScatt=map(int,Batch_SolventScatt)
        Batch_SolventScatt=str(Batch_SolventScatt)
        Batch_SolventScatt=Batch_SolventScatt.replace('[','').replace(']','')
    else:
        Batch_SolventScatt=[]
        
    f_fp=prepath+'/'+str(BatchType)+'_LogInfo_'+str(Time)+'.dat'
    
    with open(f_fp,"a+") as ff:
        if(Sample_No==1):
            ff.write('BatchNo'.center(18,' ')+'|'+'EmptyTransNo'.center(18,' ')+'|'+'SampleTransNo'.center(18,' ')+'|'+'EmptycellTransNo'.center(18,' ')+'|'+'SolventTransNo'.center(18,' ')+'|'+'EmptyScattNo'.center(18,' ')+'|'+'SampleScattNo'.center(18,' ')+'|'+'EmptycellScattNo'.center(18,' ')+'|'+'SolventScattNo'.center(18,' ')+'|'+'Thickness(mm)'.center(18,' ')+'\n')
        #ff.write('%s', "RUN000001 from SANS@CSNS 2018----")
        ff.write(str(Sample_No).center(18,' ')+'|'+str(Batch_EmptyTrans).center(18,' ')+'|'+str(Batch_SampleTrans).center(18,' ')+'|'+str(Batch_EmptycellTrans).center(18,' ')+'|'+str(Batch_SolventTrans).center(18,' ')+'|'+str(Batch_EmptyScatt).center(18,' ')+'|'+str(Batch_SampleScatt).center(18,' ')+'|'+str(Batch_EmptycellScatt).center(18,' ')+'|'+str(Batch_SolventScatt).center(18,' ')+'|'+str(Batch_Thickness).center(18,' ')+'\n')  


# for IQChecking module, which improves the efficiency of the reduction processing
# read nexus file and load it to the variable, thus the iteration for different wavelength range won't need to load nexus file again
def ReadDataFromFile(prepath, prepath_read, detRun, wave_rebin_all, output, beamcenter_x, beamcenter_y, mask_file):
  
  
    mergeWS(prepath,detRun,'sample')
    LoadInstrument(Workspace='sample', Filename=prepath_read+'/paramData/detector.xml', RewriteSpectraMap=True)
    MoveInstrumentComponent(Workspace='sample', ComponentName='Bank01', X=beamcenter_x, Y=beamcenter_y, RelativePosition=False)
    
    #use loading mask file method to mask main detector
    
    
    mask=LoadMask(Instrument=prepath_read+'/paramData/detector.xml', InputFile=prepath_read+'/paramData/'+mask_file)
    MaskDetectors(Workspace='sample', MaskedWorkspace=mask)
    
    
    #findCmaskWS('sample', beamcenter_x, beamcenter_y)
    
    
    ConvertUnits(InputWorkspace="sample", OutputWorkspace="sample", Target="Wavelength", AlignBins=True)
    Rebin(InputWorkspace='sample',OutputWorkspace='sample',Params=wave_rebin_all)
    
    mergeWS(prepath, detRun,'monitor2')
    ConvertUnits(InputWorkspace='monitor2', OutputWorkspace='monitor2', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='monitor2',OutputWorkspace='monitor2',Params=wave_rebin_all)
    
    MonSUM=True
    
    if monSUM:
        name=mtd['monitor2']
        counts=sum(name.readY(0))*1.0
        CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
        Divide(LHSWorkspace='sample', RHSWorkspace='m2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
        DeleteWorkspace(Workspace='m2')
        
    else:
        Divide(LHSWorkspace='sample', RHSWorkspace='monitor2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
    
    DeleteWorkspace(Workspace='sample')
    DeleteWorkspace(Workspace='monitor2')
    
    #output Scattering Workspace: Det2D_output
    
    
# read nexus file and convert it to the detectorPixel-TOF matrix
def ScatterData(prepath, prepath_read, detRun, wave_rebin, wave_rebin_all, output, beamcenter_x, beamcenter_y,mask_file):
    mergeWS(prepath,detRun,'sample')
    LoadInstrument(Workspace='sample', Filename=prepath_read+'/paramData/detector.xml', RewriteSpectraMap=True)
    
    MoveInstrumentComponent(Workspace='sample', ComponentName='Bank01', X=beamcenter_x, Y=beamcenter_y, RelativePosition=False)
    #use loading mask file method to mask main detector
    
    mask=LoadMask(Instrument=prepath_read+'/paramData/detector.xml', InputFile=prepath_read+'/paramData/'+mask_file)
    MaskDetectors(Workspace='sample', MaskedWorkspace=mask)
    
    #findCmaskWS('sample', beamcenter_x, beamcenter_y)
    
    ConvertUnits(InputWorkspace="sample", OutputWorkspace="sample", Target="Wavelength", AlignBins=True)
    Rebin(InputWorkspace='sample',OutputWorkspace='sample',Params=wave_rebin)
    
    mergeWS(prepath, detRun,'monitor2')
    ConvertUnits(InputWorkspace='monitor2', OutputWorkspace='monitor2', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='monitor2',OutputWorkspace='monitor2',Params=wave_rebin_all)
    
    MonSUM=True
    
    if monSUM:
        name=mtd['monitor2']
        counts=sum(name.readY(0))*1.0
        CreateSingleValuedWorkspace(OutputWorkspace='m2',DataValue=counts)
        Divide(LHSWorkspace='sample', RHSWorkspace='m2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
        DeleteWorkspace(Workspace='m2')
        
    else:
        Divide(LHSWorkspace='sample', RHSWorkspace='monitor2', OutputWorkspace=output, AllowDifferentNumberSpectra=True)
    
    DeleteWorkspace(Workspace='sample')
    DeleteWorkspace(Workspace='monitor2')
    
    #output Scattering Workspace: Det2D_output

# load and calculate(fit) the transmission of the sample (sample trans and emptybeam trans will be loaded) 
def CalTrans(prepath, prepath_read, prepath_save, transam_run, trans_run, wave_rebin, fitting_method, Smooth_Ns, output):
    
    #transam_run
    mergeWS(prepath, transam_run, 'monitor2')
    wname=mtd['monitor2']
    tmp=wname.readX(0)
    x=[]
    for i in range(len(tmp)-1):
        xvalue=(tmp[i+1]-tmp[i])/2.0+tmp[i]
        x.append(xvalue)
    tmp=wname.readY(0)
    y=[]
    for iy in tmp:
        y.append(iy)
    mergeWS(prepath, transam_run, 'monitor3')
    wname=mtd['monitor3']
    tmp=wname.readY(0)
    for iy in tmp:
        y.append(iy)
    CreateWorkspace(DataX=x,DataY=y,NSpec=2,UnitX='TOF',OutputWorkspace='monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
    ConvertToHistogram(InputWorkspace='monTranSam',OutputWorkspace='monTranSam')

    #tran_run
    mergeWS(prepath, trans_run, 'monitor2')
    wname=mtd['monitor2']
    tmp=wname.readX(0)
    x=[]
    for i in range(len(tmp)-1):
        xvalue=(tmp[i+1]-tmp[i])/2.0+tmp[i]
        x.append(xvalue)
    tmp=wname.readY(0)
    y=[]
    for iy in tmp:
        y.append(iy)
    mergeWS(prepath, trans_run, 'monitor3')
    wname=mtd['monitor3']
    tmp=wname.readY(0)
    for iy in tmp:
        y.append(iy)
    CreateWorkspace(DataX=x,DataY=y,NSpec=2,UnitX='TOF',OutputWorkspace='monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')
    ConvertToHistogram(InputWorkspace='monTran',OutputWorkspace='monTran')
    
    '''
    mergeWS(prepath, transam_run, 'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTranSam')
    mergeWS(prepath, trans_run,'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='monTran')
    '''
    
    LoadInstrument(Workspace='monTran', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    LoadInstrument(Workspace='monTranSam', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    
    ConvertUnits(InputWorkspace='monTranSam', OutputWorkspace='monTranSam', Target='Wavelength', AlignBins=True)
    ConvertUnits(InputWorkspace='monTran', OutputWorkspace='monTran', Target='Wavelength', AlignBins=True)
    
    Rebin(InputWorkspace='monTranSam', OutputWorkspace="monTranSam", Params=wave_rebin)
    Rebin(InputWorkspace='monTran', OutputWorkspace="monTran", Params=wave_rebin)
    
    CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace='Transmission', IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
    
    RenameWorkspace(InputWorkspace='Transmission'+'_unfitted',OutputWorkspace=output+'_raw')
    
    if (fitting_method=='Raw'):
        CloneWorkspace(InputWorkspace=output+'_raw',OutputWorkspace=output)
        print('Raw')
    
    elif (fitting_method=='Smooth'):
        SmoothData(InputWorkspace=output+'_raw', OutputWorkspace=output, NPoints=Smooth_Ns)
        print('Smooth')
    
    elif (fitting_method=='Linear'):
        CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace=output, IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Linear', OutputUnfittedData=True)
        print('Linear')

    elif (fitting_method=='Logarithm'):
        CalculateTransmission(SampleRunWorkspace='monTranSam', DirectRunWorkspace='monTran', OutputWorkspace=output, IncidentBeamMonitor=1, TransmissionMonitor=2, RebinParams=wave_rebin, FitMethod='Log', OutputUnfittedData=True)
        print('Log')
    else:
        pass
    
    '''
    SaveAscii(InputWorkspace='Trans_output', Filename=prepath+'/'+output+'.dat')
    SaveAscii(InputWorkspace='Trans_output_raw', Filename=prepath+'/'+'output_raw'+'.dat')
    #print 'save trans data!'   
    '''
    
    SaveAscii(InputWorkspace=output+'_raw' ,Filename=prepath_save+'/temporary/'+output+'_raw.dat')
    SaveAscii(InputWorkspace=output ,Filename=prepath_save+'/temporary/'+output+'.dat')
    
    DeleteWorkspace(Workspace='monTranSam')
    DeleteWorkspace(Workspace='monTran')
    DeleteWorkspace(Workspace='Transmission')
    
    #outputTrans Workspace: output, output_raw


# convert IQ from detector_Pixel - TOF matrix to IQ1D
def convertIQ1D(Q_rebin, Det2D_input, output):
    Q1D(DetBankWorkspace=Det2D_input, OutputWorkspace=output, OutputBinning=Q_rebin, AccountForGravity=False, SolidAngleWeighting=True)
    ReplaceSpecialValues(InputWorkspace=output, OutputWorkspace=output, NaNValue=0, InfinityValue=0)
    
    '''
    SaveAscii(InputWorkspace=output ,Filename=prepath+'/'+output+'.dat')
    '''

# convert IQ from detector_Pixel - TOF matrix to IQ2D
def convertIQxy(QxyMax, DeltaQ, Det2D_input, output):
    Qxy(InputWorkspace=Det2D_input, OutputWorkspace=output,MaxQxy=QxyMax,DeltaQ=DeltaQ)
    ReplaceSpecialValues(InputWorkspace=output, OutputWorkspace=output, NaNValue=0, InfinityValue=0)
    
    '''
    SaveAscii(InputWorkspace=output ,Filename=prepath+'/'+output+'.dat')
    '''
    

# transfer part of the parameters from xml file to variable in the internal memory for transmission
def getConfXML():
    conf=readXml(prepath_configure+'/configure.xml')
    
    if conf['SampleFileName'] is None:
        FileName_Sample=[]
    else:
        FileName_Sample=str(conf['SampleFileName'])
    
    if conf['EmptyCellFileName'] is None:
        FileName_EmptyCell=[]
    else:
        FileName_EmptyCell=str(conf['EmptyCellFileName'])
    
    if conf['SolventFileName'] is None:
        FileName_Solvent=[]
    else:
        FileName_Solvent=str(conf['SolventFileName'])
    
    
    
    if conf['Calibration_File'] is None:
        cal_file=[]
    else:
        cal_file=str(conf['Calibration_File'])
        #cal_file=[str(s).strip("'") for s in conf['Calibration_File'].split(';') if not len(s)==0 ]
        
    if conf['Mask_File'] is None:
        mask_file=[]
    else:
        mask_file=str(conf['Mask_File'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
        
    if conf['Save_Path'] is None:
        save_path=[]
    else:
        save_path=str(conf['Save_Path'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
        
    if conf['BeamCenter_X'] is None:
        beamcenter_x=[]
    else:
        #mm->m
        beamcenter_x=float(conf['BeamCenter_X'])/1000
        
    if conf['BeamCenter_Y'] is None:
        beamcenter_y=[]
    else:
        beamcenter_y=float(conf['BeamCenter_Y'])/1000
    
    
    
    if conf['EmptyTransRun'] is None:
        EmptyTrans_Run=[]
        EmptyTransNum=0
    else:
        #EmptyTrans_Run=[str(conf['EmptyTransRun'])]
        EmptyTrans_Run=[str(s).strip("'") for s in conf['EmptyTransRun'].split(',')]
        EmptyTransNum=len(EmptyTrans_Run)
        
    if conf['SampleTransRun'] is None:
        SampleTrans_Run=[]
        SampleTransNum=0
    else:
        #SampleTrans_Run=str(conf['SampleTransRun'])
        SampleTrans_Run=[str(s).strip("'") for s in conf['SampleTransRun'].split(',')]
        SampleTransNum=len(SampleTrans_Run)

    if conf['EmptyCellTransRun'] is None or conf['if_empty'] is "False":
        EmptyCellTrans_Run=[]
        EmptyCellTransNum=0
    else:
        #EmptyCellTrans_Run=str(conf['EmptyCellTransRun'])
        EmptyCellTrans_Run=[str(s).strip("'") for s in conf['EmptyCellTransRun'].split(',')]
        EmptyCellTransNum=len(EmptyCellTrans_Run)

    if conf['SolventTransRun'] is None or conf['if_solvent'] is "False":
        SolventTrans_Run=[]
        SolventTransNum=0
    else:
        #SolventTrans_Run=str(conf['SolventTransRun'])
        SolventTrans_Run=[str(s).strip("'") for s in conf['SolventTransRun'].split(',')]
        SolventTransNum=len(SolventTrans_Run)
    
    
    if conf['TransFittingMethod'] is None:
        Trans_fitting_method=[]
    else:
        Trans_fitting_method=str(conf['TransFittingMethod'])
        
    #trans_fitting_method=conf['TransFittingMethod']
    
    if conf['Smooth_Ns'] is None:
        Smooth_Ns=[]
    else:
        Smooth_Ns=int(conf['Smooth_Ns'])
    
    
    if conf['Trans_Wavelength_Min'] is not None:
        w1=float(conf['Trans_Wavelength_Min'])
    else:
        w1=1.4
    if conf['Trans_Wavelength_Step'] is not None:
        dw=float(conf['Trans_Wavelength_Step'])
    else:
        dw=0.01
    if conf['Trans_Wavelength_Max'] is not None:
        w2=float(conf['Trans_Wavelength_Max'])
    else:
        w2=8.0
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)

    return FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, save_path, beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum

# transfer part of the parameters from xml file to variable in the internal memory for scattering
def getConfXML2():
    conf=readXml(prepath_configure+'/configure.xml')
    
    
    if conf['EmptyDirectRun'] is None:
        EmptyDirect_Run=[]
        EmptyDirectNum=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        EmptyDirect_Run=[str(s).strip("'") for s in conf['EmptyDirectRun'].split(',')]
        EmptyDirectNum=len(EmptyDirect_Run)
    
    
    if conf['SampleScattRun'] is None:
        SampleScatt_Run=[]
        SampleScattNum=0
    else:
        #SampleScatt_Run=str(conf['SampleScattRun'])
        SampleScatt_Run=[str(s).strip("'") for s in conf['SampleScattRun'].split(',')]
        SampleScattNum=len(SampleScatt_Run)
    
    
    if conf['EmptyCellScattRun'] is None or conf['if_empty'] is "False":
        EmptyCellScatt_Run=[]
        EmptyCellScattNum=0
    else:
        #EmptyCellScatt_Run=str(conf['EmptyCellScattRun'])
        EmptyCellScatt_Run=[str(s).strip("'") for s in conf['EmptyCellScattRun'].split(',')]
        EmptyCellScattNum=len(EmptyCellScatt_Run)
    
    
    if conf['SolventScattRun'] is None or conf['if_solvent'] is "False":
        SolventScatt_Run=[]
        SolventScattNum=0
    else:
        #SolventScatt_Run=str(conf['SolventScattRun'])
        SolventScatt_Run=[str(s).strip("'") for s in conf['SolventScattRun'].split(',')]
        SolventScattNum=len(SolventScatt_Run)
    
    
    # Thickness unit (mm)    
    if conf['Thickness'] is not None:
        Thickness=float(conf['Thickness'])
    else:
        Thickness=1.0 ## or print error?
        
    # Diameter unit (mm)    
    if conf['Diameter'] is not None:
        Diameter=float(conf['Diameter'])
    else:
        Diameter=6.8
    
    # Scaling Factor for IQ  
    if conf['ScalingFactor'] is not None:
        ScalingFactor=float(conf['ScalingFactor'])
    else:
        ScalingFactor=1.0
    
    # Solvent Volume Fraction  
    if (conf['SolventVolumeFraction'] is not None) and (str(conf['if_solvent']) == "True"):
        Solvent_VF=float(conf['SolventVolumeFraction'])
    else:
        Solvent_VF=0
    
    # Volume unit (cm^3)    
    Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(Thickness/10.0)
    #CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
    
    
    if conf['Scatt_Wavelength_Min'] is not None:
        w1=float(conf['Scatt_Wavelength_Min'])
    else:
        w1=1.4
    if conf['Scatt_Wavelength_Step'] is not None:
        dw=float(conf['Scatt_Wavelength_Step'])
    else:
        dw=1
    if conf['Scatt_Wavelength_Max'] is not None:
        w2=float(conf['Scatt_Wavelength_Max'])
    else:
        w2=8.0
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
     
    
    if conf['Q_Min'] is not None:
        Q1=float(conf['Q_Min'])
    else:
        Q1=0.01
    if conf['Q_Step'] is not None:
        dQ=float(conf['Q_Step'])
    else:
        dQ=-0.08
    if conf['Q_Max'] is not None:
        Q2=float(conf['Q_Max'])
    else:
        Q2=0.8
    Q_rebin=str(Q1)+','+str(dQ)+','+str(Q2)
    
    
    return  EmptyDirect_Run,EmptyDirectNum,SampleScatt_Run,SampleScattNum,EmptyCellScatt_Run,EmptyCellScattNum,SolventScatt_Run,SolventScattNum,Solvent_VF,ScalingFactor,Volume,Thickness,Diameter,w1, dw, w2,Q_rebin 

# transfer part of the parameters from xml file to variable in the internal memory for IQ Checking
def getConfXML3():
    conf=readXml(prepath_configure+'/configure.xml')
    
    if conf['IQ_Check_Wavelength_Min_1'] is not None:
        IQ_Check_w_min_1=float(conf['IQ_Check_Wavelength_Min_1'])
    else:
        IQ_Check_w_min_1=1.4
    if conf['IQ_Check_Wavelength_Step_1'] is not None:
        IQ_Check_w_step_1=float(conf['IQ_Check_Wavelength_Step_1'])
    else:
        IQ_Check_w_step_1=0.01
    if conf['IQ_Check_Wavelength_Max_1'] is not None:
        IQ_Check_w_max_1=float(conf['IQ_Check_Wavelength_Max_1'])
    else:
        IQ_Check_w_max_1=2.5
        
        
    if conf['IQ_Check_Wavelength_Min_2'] is not None:
        IQ_Check_w_min_2=float(conf['IQ_Check_Wavelength_Min_2'])
    else:
        IQ_Check_w_min_2=2.5
    if conf['IQ_Check_Wavelength_Step_2'] is not None:
        IQ_Check_w_step_2=float(conf['IQ_Check_Wavelength_Step_2'])
    else:
        IQ_Check_w_step_2=0.01
    if conf['IQ_Check_Wavelength_Max_2'] is not None:
        IQ_Check_w_max_2=float(conf['IQ_Check_Wavelength_Max_2'])
    else:
        IQ_Check_w_max_2=3.5
        
        
    if conf['IQ_Check_Wavelength_Min_3'] is not None:
        IQ_Check_w_min_3=float(conf['IQ_Check_Wavelength_Min_3'])
    else:
        IQ_Check_w_min_3=3.5
    if conf['IQ_Check_Wavelength_Step_3'] is not None:
        IQ_Check_w_step_3=float(conf['IQ_Check_Wavelength_Step_3'])
    else:
        IQ_Check_w_step_3=0.01
    if conf['IQ_Check_Wavelength_Max_3'] is not None:
        IQ_Check_w_max_3=float(conf['IQ_Check_Wavelength_Max_3'])
    else:
        IQ_Check_w_max_3=4.5
        
    if conf['IQ_Check_Wavelength_Min_4'] is not None:
        IQ_Check_w_min_4=float(conf['IQ_Check_Wavelength_Min_4'])
    else:
        IQ_Check_w_min_4=4.5
    if conf['IQ_Check_Wavelength_Step_4'] is not None:
        IQ_Check_w_step_4=float(conf['IQ_Check_Wavelength_Step_4'])
    else:
        IQ_Check_w_step_4=0.01
    if conf['IQ_Check_Wavelength_Max_4'] is not None:
        IQ_Check_w_max_4=float(conf['IQ_Check_Wavelength_Max_4'])
    else:
        IQ_Check_w_max_4=5.5
        
    if conf['IQ_Check_Wavelength_Min_5'] is not None:
        IQ_Check_w_min_5=float(conf['IQ_Check_Wavelength_Min_5'])
    else:
        IQ_Check_w_min_5=5.5
    if conf['IQ_Check_Wavelength_Step_5'] is not None:
        IQ_Check_w_step_5=float(conf['IQ_Check_Wavelength_Step_5'])
    else:
        IQ_Check_w_step_5=0.01
    if conf['IQ_Check_Wavelength_Max_5'] is not None:
        IQ_Check_w_max_5=float(conf['IQ_Check_Wavelength_Max_5'])
    else:
        IQ_Check_w_max_5=6.5
        
    if conf['IQ_Check_Wavelength_Min_6'] is not None:
        IQ_Check_w_min_6=float(conf['IQ_Check_Wavelength_Min_6'])
    else:
        IQ_Check_w_min_6=6.5
    if conf['IQ_Check_Wavelength_Step_6'] is not None:
        IQ_Check_w_step_6=float(conf['IQ_Check_Wavelength_Step_6'])
    else:
        IQ_Check_w_step_6=0.01
    if conf['IQ_Check_Wavelength_Max_6'] is not None:
        IQ_Check_w_max_6=float(conf['IQ_Check_Wavelength_Max_6'])
    else:
        IQ_Check_w_max_6=7.5
        
    if conf['IQ_Check_Wavelength_Min_7'] is not None:
        IQ_Check_w_min_7=float(conf['IQ_Check_Wavelength_Min_7'])
    else:
        IQ_Check_w_min_7=7.5
    if conf['IQ_Check_Wavelength_Step_7'] is not None:
        IQ_Check_w_step_7=float(conf['IQ_Check_Wavelength_Step_7'])
    else:
        IQ_Check_w_step_7=0.01
    if conf['IQ_Check_Wavelength_Max_7'] is not None:
        IQ_Check_w_max_7=float(conf['IQ_Check_Wavelength_Max_7'])
    else:
        IQ_Check_w_max_7=8.5
        
        
    if conf['IQ_Check_Detector_Min'] is not None:
        IQ_Check_det_min=float(conf['IQ_Check_Detector_Min'])
    else:
        IQ_Check_det_min=4.8
    
    if conf['IQ_Check_Detector_Max'] is not None:
        IQ_Check_det_max=float(conf['IQ_Check_Detector_Max'])
    else:
        IQ_Check_det_max=60
    
    return IQ_Check_w_min_1,IQ_Check_w_step_1,IQ_Check_w_max_1,IQ_Check_w_min_2,IQ_Check_w_step_2,IQ_Check_w_max_2,IQ_Check_w_min_3,IQ_Check_w_step_3,IQ_Check_w_max_3,IQ_Check_w_min_4,IQ_Check_w_step_4,IQ_Check_w_max_4,IQ_Check_w_min_5,IQ_Check_w_step_5,IQ_Check_w_max_5,IQ_Check_w_min_6,IQ_Check_w_step_6,IQ_Check_w_max_6,IQ_Check_w_min_7,IQ_Check_w_step_7,IQ_Check_w_max_7,IQ_Check_det_min,IQ_Check_det_max

# transfer part of the parameters from xml file to variable in the internal memory for batch, specific for number of sample in batch module
def getConfXML_BatchNo():
    conf=readXml(prepath_configure+'/configure.xml')
    
    #int Batch_No
    
    if conf['IQ_Batch_Number_Of_Samples'] is not None:
        Batch_No=int(conf['IQ_Batch_Number_Of_Samples'])
    else:
        Batch_No=0
    
    return Batch_No

# transfer part of the parameters from xml file to variable in the internal memory for batch, specfic for each sampleNo  
def getConfXML4(Sample_No):
    
    conf=readXml(prepath_configure+'/configure.xml')
    
    if conf['IQ_Batch_EmptyTrans_'+str(Sample_No)] is None:
        Batch_EmptyTrans=[]
        Batch_EmptyTrans_Num=0
    else:
        Batch_EmptyTrans=[str(s).strip("'") for s in conf['IQ_Batch_EmptyTrans_'+str(Sample_No)].split(',')]
        Batch_EmptyTrans_Num=len(Batch_EmptyTrans)
    
    if conf['IQ_Batch_SampleTrans_'+str(Sample_No)] is None:
        Batch_SampleTrans=[]
        Batch_SampleTrans_Num=0
    else:
        Batch_SampleTrans=[str(s).strip("'") for s in conf['IQ_Batch_SampleTrans_'+str(Sample_No)].split(',')]
        Batch_SampleTrans_Num=len(Batch_SampleTrans)

    if conf['IQ_Batch_EmptycellTrans_'+str(Sample_No)] is None:
        Batch_EmptycellTrans=[]
        Batch_EmptycellTrans_Num=0
    else:
        Batch_EmptycellTrans=[str(s).strip("'") for s in conf['IQ_Batch_EmptycellTrans_'+str(Sample_No)].split(',')]
        Batch_EmptycellTrans_Num=len(Batch_EmptycellTrans)

    if conf['IQ_Batch_SolventTrans_'+str(Sample_No)] is None:
        Batch_SolventTrans=[]
        Batch_SolventTrans_Num=0
    else:
        Batch_SolventTrans=[str(s).strip("'") for s in conf['IQ_Batch_SolventTrans_'+str(Sample_No)].split(',')]
        Batch_SolventTrans_Num=len(Batch_SolventTrans)
    
    
    if conf['IQ_Batch_TransFit_'+str(Sample_No)] is None:
        Batch_TransFit=[]
    else:
        Batch_TransFit=str(conf['IQ_Batch_TransFit_'+str(Sample_No)])
        
    if conf['IQ_Batch_Ns_'+str(Sample_No)] is None:
        Batch_Ns=[]
    else:
        Batch_Ns=int(conf['IQ_Batch_Ns_'+str(Sample_No)])
    
    if conf['IQ_Batch_WavMin_'+str(Sample_No)] is None:
        Batch_WavMin=[]
    else:
        Batch_WavMin=float(conf['IQ_Batch_WavMin_'+str(Sample_No)])
    
    if conf['IQ_Batch_WavStep_'+str(Sample_No)] is None:
        Batch_WavStep=[]
    else:
        Batch_WavStep=float(conf['IQ_Batch_WavStep_'+str(Sample_No)])
    
    if conf['IQ_Batch_WavMax_'+str(Sample_No)] is None:
        Batch_WavMax=[]
    else:
        Batch_WavMax=float(conf['IQ_Batch_WavMax_'+str(Sample_No)])
    
    if conf['IQ_Batch_EmptyScatt_'+str(Sample_No)] is None:
        Batch_EmptyScatt=[]
        Batch_EmptyScatt_Num=0
    else:
        Batch_EmptyScatt=[str(s).strip("'") for s in conf['IQ_Batch_EmptyScatt_'+str(Sample_No)].split(',')]
        Batch_EmptyScatt_Num=len(Batch_EmptyScatt)
    
    if conf['IQ_Batch_SampleScatt_'+str(Sample_No)] is None:
        Batch_SampleScatt=[]
        Batch_SampleScatt_Num=0
    else:
        Batch_SampleScatt=[str(s).strip("'") for s in conf['IQ_Batch_SampleScatt_'+str(Sample_No)].split(',')]
        Batch_SampleScatt_Num=len(Batch_SampleScatt)

    if conf['IQ_Batch_EmptycellScatt_'+str(Sample_No)] is None:
        Batch_EmptycellScatt=[]
        Batch_EmptycellScatt_Num=0
    else:
        Batch_EmptycellScatt=[str(s).strip("'") for s in conf['IQ_Batch_EmptycellScatt_'+str(Sample_No)].split(',')]
        Batch_EmptycellScatt_Num=len(Batch_EmptycellScatt)

    if conf['IQ_Batch_SolventScatt_'+str(Sample_No)] is None:
        Batch_SolventScatt=[]
        Batch_SolventScatt_Num=0
    else:
        Batch_SolventScatt=[str(s).strip("'") for s in conf['IQ_Batch_SolventScatt_'+str(Sample_No)].split(',')]
        Batch_SolventScatt_Num=len(Batch_SolventScatt)

    if conf['IQ_Batch_Thickness_'+str(Sample_No)] is None:
        Batch_Thickness=[]
    else:
        Batch_Thickness=float(conf['IQ_Batch_Thickness_'+str(Sample_No)])

    if conf['IQ_Batch_ScalingFactor_'+str(Sample_No)] is None:
        Batch_ScalingFactor=[]
    else:
        Batch_ScalingFactor=float(conf['IQ_Batch_ScalingFactor_'+str(Sample_No)])
        
    if conf['IQ_Batch_SolventVF_'+str(Sample_No)] is None:
        Batch_SolventVF=0
    else:
        Batch_SolventVF=float(conf['IQ_Batch_SolventVF_'+str(Sample_No)])

    if conf['IQ_Batch_QMin_'+str(Sample_No)] is None:
        Batch_QMin=[]
    else:
        Batch_QMin=float(conf['IQ_Batch_QMin_'+str(Sample_No)])

    if conf['IQ_Batch_QStep_'+str(Sample_No)] is None:
        Batch_QStep=[]
    else:
        Batch_QStep=float(conf['IQ_Batch_QStep_'+str(Sample_No)])

    if conf['IQ_Batch_QMax_'+str(Sample_No)] is None:
        Batch_QMax=[]
    else:
        Batch_QMax=float(conf['IQ_Batch_QMax_'+str(Sample_No)])
        
        
    if conf['SampleFileName'] is None:
        FileName_Sample=[]
    else:
        FileName_Sample=str(conf['SampleFileName'])
    
    if conf['EmptyCellFileName'] is None:
        FileName_EmptyCell=[]
    else:
        FileName_EmptyCell=str(conf['EmptyCellFileName'])
    
    if conf['SolventFileName'] is None:
        FileName_Solvent=[]
    else:
        FileName_Solvent=str(conf['SolventFileName'])
        
        
    # Diameter unit (mm)    
    if conf['Diameter'] is not None:
        Diameter=float(conf['Diameter'])
    else:
        Diameter=6.8
    
    if conf['Calibration_File'] is None:
        cal_file=[]
    else:
        cal_file=str(conf['Calibration_File'])
        #cal_file=[str(s).strip("'") for s in conf['Calibration_File'].split(';') if not len(s)==0 ]
        
    if conf['Mask_File'] is None:
        mask_file=[]
    else:
        mask_file=str(conf['Mask_File'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
        
    if conf['Save_Path'] is None:
        save_path=[]
    else:
        save_path=str(conf['Save_Path'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
    
    if conf['BeamCenter_X'] is None:
        beamcenter_x=[]
    else:
        #mm->m
        beamcenter_x=float(conf['BeamCenter_X'])/1000
        
    if conf['BeamCenter_Y'] is None:
        beamcenter_y=[]
    else:
        beamcenter_y=float(conf['BeamCenter_Y'])/1000
    
    return Batch_EmptyTrans,Batch_EmptyTrans_Num,Batch_SampleTrans,Batch_SampleTrans_Num,Batch_EmptycellTrans,Batch_EmptycellTrans_Num,Batch_SolventTrans,Batch_SolventTrans_Num,Batch_TransFit,Batch_Ns,Batch_WavMin,Batch_WavStep,Batch_WavMax,Batch_EmptyScatt,Batch_EmptyScatt_Num,Batch_SampleScatt,Batch_SampleScatt_Num,Batch_EmptycellScatt,Batch_EmptycellScatt_Num,Batch_SolventScatt,Batch_SolventScatt_Num,Batch_Thickness,Batch_ScalingFactor,Batch_SolventVF,Batch_QMin,Batch_QStep,Batch_QMax, FileName_Sample, FileName_EmptyCell, FileName_Solvent,Diameter ,cal_file, mask_file,save_path, beamcenter_x,beamcenter_y

# transfer part of the parameters from xml file to variable in the internal memory for batch, specific for number of sample in IQ2D module
def getConfXML_IQ2DNo():
    conf=readXml(prepath_configure+'/configure.xml')
    
    #int IQ2D_No
    
    if conf['IQ2D_Number_Of_Samples'] is not None:
        IQ2D_No=int(conf['IQ2D_Number_Of_Samples'])
    else:
        IQ2D_No=0
    
    return IQ2D_No
# transfer part of the parameters from xml file to variable in the internal memory for IQ2D
def getConfXML5(Sample_No):
    
    conf=readXml(prepath_configure+'/configure.xml')
    
    if conf['IQ2D_EmptyTrans_'+str(Sample_No)] is None:
        IQ2D_EmptyTrans_Run=[]
        IQ2D_EmptyTrans_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_EmptyTrans_Run=[str(s).strip("'") for s in conf['IQ2D_EmptyTrans_'+str(Sample_No)].split(',')]
        IQ2D_EmptyTrans_Num=len(IQ2D_EmptyTrans_Run)
        
    
    if conf['IQ2D_SampleTrans_'+str(Sample_No)] is None:
        IQ2D_SampleTrans_Run=[]
        IQ2D_SampleTrans_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_SampleTrans_Run=[str(s).strip("'") for s in conf['IQ2D_SampleTrans_'+str(Sample_No)].split(',')]
        IQ2D_SampleTrans_Num=len(IQ2D_SampleTrans_Run)
        
    
    if conf['IQ2D_EmptycellTrans_'+str(Sample_No)] is None:
        IQ2D_EmptycellTrans_Run=[]
        IQ2D_EmptycellTrans_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_EmptycellTrans_Run=[str(s).strip("'") for s in conf['IQ2D_EmptycellTrans_'+str(Sample_No)].split(',')]
        IQ2D_EmptycellTrans_Num=len(IQ2D_EmptycellTrans_Run)
    
    
    if conf['IQ2D_SolventTrans_'+str(Sample_No)] is None:
        IQ2D_SolventTrans_Run=[]
        IQ2D_SolventTrans_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_SolventTrans_Run=[str(s).strip("'") for s in conf['IQ2D_SolventTrans_'+str(Sample_No)].split(',')]
        IQ2D_SolventTrans_Num=len(IQ2D_SolventTrans_Run)
    
    
    if conf['IQ2D_TransFittingMethod_'+str(Sample_No)] is None:
        IQ2D_TransFitting_Method=[]
    else:
        IQ2D_TransFitting_Method=str(conf['IQ2D_TransFittingMethod_'+str(Sample_No)])
        
    #trans_fitting_method=conf['TransFittingMethod']
    
    if conf['IQ2D_Smooth_Ns_'+str(Sample_No)] is None:
        IQ2D_Smooth_Ns=[]
    else:
        IQ2D_Smooth_Ns=int(conf['IQ2D_Smooth_Ns_'+str(Sample_No)])
    
    if conf['IQ2D_Wavelength_Min_'+str(Sample_No)] is None:
        IQ2D_Wavelength_Min=[]
    else:
        IQ2D_Wavelength_Min=float(conf['IQ2D_Wavelength_Min_'+str(Sample_No)])
    
    if conf['IQ2D_Wavelength_Step_'+str(Sample_No)] is None:
        IQ2D_Wavelength_Step=[]
    else:
        IQ2D_Wavelength_Step=float(conf['IQ2D_Wavelength_Step_'+str(Sample_No)])
    
    if conf['IQ2D_Wavelength_Max_'+str(Sample_No)] is None:
        IQ2D_Wavelength_Max=[]
    else:
        IQ2D_Wavelength_Max=float(conf['IQ2D_Wavelength_Max_'+str(Sample_No)])
    
    
    if conf['IQ2D_EmptyScatt_'+str(Sample_No)] is None:
        IQ2D_EmptyScatt_Run=[]
        IQ2D_EmptyScatt_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_EmptyScatt_Run=[str(s).strip("'") for s in conf['IQ2D_EmptyScatt_'+str(Sample_No)].split(',')]
        IQ2D_EmptyScatt_Num=len(IQ2D_EmptyScatt_Run)
        
    
    if conf['IQ2D_SampleScatt_'+str(Sample_No)] is None:
        IQ2D_SampleScatt_Run=[]
        IQ2D_SampleScatt_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_SampleScatt_Run=[str(s).strip("'") for s in conf['IQ2D_SampleScatt_'+str(Sample_No)].split(',')]
        IQ2D_SampleScatt_Num=len(IQ2D_SampleScatt_Run)
        
    
    if conf['IQ2D_EmptycellScatt_'+str(Sample_No)] is None:
        IQ2D_EmptycellScatt_Run=[]
        IQ2D_EmptycellScatt_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_EmptycellScatt_Run=[str(s).strip("'") for s in conf['IQ2D_EmptycellScatt_'+str(Sample_No)].split(',')]
        IQ2D_EmptycellScatt_Num=len(IQ2D_EmptycellScatt_Run)
    
    
    if conf['IQ2D_SolventScatt_'+str(Sample_No)] is None:
        IQ2D_SolventScatt_Run=[]
        IQ2D_SolventScatt_Num=0
    else:
        #EmptyDirect_Run=str(conf['EmptyDirectRun'])
        IQ2D_SolventScatt_Run=[str(s).strip("'") for s in conf['IQ2D_SolventScatt_'+str(Sample_No)].split(',')]
        IQ2D_SolventScatt_Num=len(IQ2D_SolventScatt_Run)
    
    
    if conf['IQ2D_Thickness_'+str(Sample_No)] is None:
        IQ2D_Thickness=[]
    else:
        IQ2D_Thickness=float(conf['IQ2D_Thickness_'+str(Sample_No)])
    
    if conf['IQ2D_SolventVolumeFraction_'+str(Sample_No)] is None:
        IQ2D_SolventVolumeFraction=0
    else:
        IQ2D_SolventVolumeFraction=float(conf['IQ2D_SolventVolumeFraction_'+str(Sample_No)])
    
    if conf['IQ2D_QxyMax_'+str(Sample_No)] is None:
        IQ2D_QxyMax=[]
    else:
        IQ2D_QxyMax=float(conf['IQ2D_QxyMax_'+str(Sample_No)])
    
    if conf['IQ2D_DeltaQ_'+str(Sample_No)] is None:
        IQ2D_DeltaQ=[]
    else:
        IQ2D_DeltaQ=float(conf['IQ2D_DeltaQ_'+str(Sample_No)])
    
    if conf['IQ2D_ScalingFactor_'+str(Sample_No)] is None:
        IQ2D_ScalingFactor=[]
    else:
        IQ2D_ScalingFactor=float(conf['IQ2D_ScalingFactor_'+str(Sample_No)])
    
    # Diameter unit (mm)    
    if conf['Diameter'] is not None:
        Diameter=float(conf['Diameter'])
    else:
        Diameter=6.8
    
    if conf['Calibration_File'] is None:
        cal_file=[]
    else:
        cal_file=str(conf['Calibration_File'])
        #cal_file=[str(s).strip("'") for s in conf['Calibration_File'].split(';') if not len(s)==0 ]
        
    if conf['Mask_File'] is None:
        mask_file=[]
    else:
        mask_file=str(conf['Mask_File'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
        
    if conf['Save_Path'] is None:
        save_path=[]
    else:
        save_path=str(conf['Save_Path'])
        #mask_file=[str(s).strip("'") for s in conf['Mask_File'].split(';') if not len(s)==0 ]
    
    if conf['BeamCenter_X'] is None:
        beamcenter_x=[]
    else:
        #mm->m
        beamcenter_x=float(conf['BeamCenter_X'])/1000
        
    if conf['BeamCenter_Y'] is None:
        beamcenter_y=[]
    else:
        beamcenter_y=float(conf['BeamCenter_Y'])/1000
    
    return IQ2D_EmptyTrans_Run,IQ2D_EmptyTrans_Num,IQ2D_SampleTrans_Run,IQ2D_SampleTrans_Num,IQ2D_EmptycellTrans_Run,IQ2D_EmptycellTrans_Num,IQ2D_SolventTrans_Run,IQ2D_SolventTrans_Num,IQ2D_TransFitting_Method,IQ2D_Smooth_Ns,IQ2D_Wavelength_Min,IQ2D_Wavelength_Step,IQ2D_Wavelength_Max,IQ2D_EmptyScatt_Run,IQ2D_EmptyScatt_Num,IQ2D_SampleScatt_Run,IQ2D_SampleScatt_Num,IQ2D_EmptycellScatt_Run,IQ2D_EmptycellScatt_Num,IQ2D_SolventScatt_Run,IQ2D_SolventScatt_Num,IQ2D_Thickness,IQ2D_ScalingFactor,IQ2D_SolventVolumeFraction,IQ2D_QxyMax,IQ2D_DeltaQ,Diameter,cal_file,mask_file,save_path,beamcenter_x,beamcenter_y

def getInfoFromCalFile(cal_file):
    with open(cal_file, "rb") as f:
        Numberline=0
        for line in f:
            if (Numberline == 3):
                Diameter=line[17:21]
                Diameter=float(Diameter)
            #if (line[2:21] is "Wavelength_rebin_all"):
            if (Numberline == 4):
                wave_rebin_all=line[52:]
                wave_rebin_all=wave_rebin_all.rstrip('\n')
                wave_rebin_all=wave_rebin_all.split(',')
                wave_rebin_all_min=wave_rebin_all[0]
                wave_rebin_all_max=wave_rebin_all[2]
            #if (line[2:8] is "Xcenter"):
            if (Numberline == 12):
                Xcenter=line[12:]
                Xcenter=Xcenter.rstrip(' mm \n')
                Xcenter=float(Xcenter)/1000
            #if (line[2:8] is "Ycenter"):
            if (Numberline == 13):
                Ycenter=line[12:]
                Ycenter=Ycenter.rstrip(' mm \n')
                Ycenter=float(Ycenter)/1000
            Numberline+=1
        
    return Diameter,wave_rebin_all_min, wave_rebin_all_max, Xcenter, Ycenter
    

# the module to calculate transmission in the main.py
def TransCalculation():
    
    # load parameters from configure.xml
    FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, prepath_save, beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum=getConfXML();
    Diameter,wave_rebin_all_min, wave_rebin_all_max, beamcenter_x, beamcenter_y=getInfoFromCalFile(prepath_read+'/paramData/'+cal_file)
    
    wave_rebin_all=wave_rebin_all_min+','+str(dw)+','+wave_rebin_all_max
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
    
    
    if EmptyTransNum>0:
        if SampleTransNum>0:
            #calculate the transmission for sample
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Sample')
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_Sample_unfitted')
            #output transmission file for sample
            outputTrans(prepath_save, SampleTrans_Run, EmptyTrans_Run, 'Trans_Sample', 'Trans_Sample_unfitted', FileName_Sample, wave_rebin, Trans_fitting_method, Smooth_Ns)
            
            #calculate transmission for sample of all wavelength range
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_Sample_All')
            #output transmission file for sample of all wavelength range
            outputTransAll(prepath_save, SampleTrans_Run, EmptyTrans_Run, 'Trans_Sample_All', FileName_Sample, wave_rebin_all)
        else:
            pass
            
        #if emptycell module existed, calculate the transmission for emptycell    
        if EmptyCellTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_EmptyCell')
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_EmptyCell_unfitted')
            outputTrans(prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, 'Trans_EmptyCell', 'Trans_EmptyCell_unfitted', FileName_EmptyCell, wave_rebin, Trans_fitting_method, Smooth_Ns)
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_EmptyCell_All')
            outputTransAll(prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, 'Trans_EmptyCell_All', FileName_EmptyCell, wave_rebin_all)
        else:
            pass
            
            
        #if solvent module existed, calculate the transmission for solvent
        if SolventTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Solvent')
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, 'Raw', Smooth_Ns, 'Trans_Solvent_unfitted')
            outputTrans(prepath_save, SolventTrans_Run, EmptyTrans_Run, 'Trans_Solvent', 'Trans_Solvent_unfitted', FileName_Solvent, wave_rebin, Trans_fitting_method, Smooth_Ns)
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin_all, 'Raw', Smooth_Ns, 'Trans_Solvent_All')
            outputTransAll(prepath_save, SolventTrans_Run, EmptyTrans_Run, 'Trans_Solvent_All', FileName_Solvent, wave_rebin_all)
        else:
            pass
            
    return True

#the module for IQ reduction in the main.py
def IQReduction():
    
    #load parameters from configure.xml
    FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, prepath_save,beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum=getConfXML();
    
    EmptyDirect_Run,EmptyDirectNum,SampleScatt_Run,SampleScattNum,EmptyCellScatt_Run,EmptyCellScattNum,SolventScatt_Run,SolventScattNum,Solvent_VF,ScalingFactor, Volume,Thickness,Diameter,w1, dw, w2,Q_rebin=getConfXML2();
    Diameter,wave_rebin_all_min, wave_rebin_all_max, beamcenter_x, beamcenter_y=getInfoFromCalFile(prepath_read+'/paramData/'+cal_file)
    
    wave_rebin_all=wave_rebin_all_min+','+str(dw)+','+wave_rebin_all_max
    wave_rebin=str(w1)+','+str(dw)+','+str(w2)
    #wave_rebin_all='1,'+str(dw)+',8.5'
    
    
    Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(Thickness/10.0)
    CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
    
    #the factor of wave_rebin and dlambda at calibration file
    #in the future should be considered at calibration file
    #factor=0.005/0.01  
    #CreateSingleValuedWorkspace(OutputWorkspace='factor', DataValue=factor)
    
    CreateSingleValuedWorkspace(OutputWorkspace='Solvent_VF', DataValue=Solvent_VF)
    
    #Scaling Factor for each sample to adjust the absolute intensity
    CreateSingleValuedWorkspace(OutputWorkspace='ScalingFactor', DataValue=ScalingFactor)
    
    #obtain the spectrum of the beam from Monitor2, using for Qresolution averaging in the wavelength range
    '''
    mergeWS(prepath, EmptyTrans_Run, 'monitors')
    RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='Spectrum')    
    LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
    '''
    
    mergeWS(prepath, EmptyTrans_Run, 'monitor2')
    RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Spectrum')    
    LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
    ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
    Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
    


    #calculate transmission for sample
    if EmptyTransNum>0:
        if SampleTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Sample')
        else:
            pass
            
        if EmptyCellTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_EmptyCell')
        else:
            pass
            
        if SolventTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Solvent')
        else:
            pass
    
    
    #load calibration file
    
    #if len(cal_file)>0:
    LoadAscii(Filename=prepath_read+'/paramData/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
    ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
    Divide(LHSWorkspace='cal', RHSWorkspace='ScalingFactor', OutputWorkspace='cal', AllowDifferentNumberSpectra=True)
    Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
    #else:
        #pass
        
        
    #IQ background(emptybeam) calculation 
    if EmptyDirectNum>0:
        ScatterData(prepath, prepath_read, EmptyDirect_Run, wave_rebin, wave_rebin_all, 'empty_raw', beamcenter_x, beamcenter_y, mask_file)
        Divide(LHSWorkspace='empty_raw', RHSWorkspace='cal', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
        convertIQ1D(Q_rebin,'empty_tmp','IQ_empty')
        Divide(LHSWorkspace='IQ_empty', RHSWorkspace='volume', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
        #Multiply(LHSWorkspace='IQ_empty_v', RHSWorkspace='factor', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
        
        SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyBeam_Scale.dat')
        SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(EmptyDirect_Run)+'_Scale.dat')
        
        convertIQ1D(Q_rebin,'empty_raw','IQ_empty_raw')
        Divide(LHSWorkspace='IQ_empty_raw', RHSWorkspace='volume', OutputWorkspace='IQ_empty_raw', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_empty_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(EmptyDirect_Run)+'_Raw.dat')
        
    else:
        pass
        
        
        
    #IQ sample calculation
    
    if (SampleScattNum>0):
    
        #converting the scattering data to pixel-TOF matrix considering mask, beamcenter and wavelength range
        ScatterData(prepath, prepath_read, SampleScatt_Run, wave_rebin, wave_rebin_all, 'sam_raw', beamcenter_x, beamcenter_y, mask_file)
        
        #normalize the scattering data after considering transmission of the sample
        if (SampleTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='sam_raw',TransmissionWorkspace='Trans_Sample',OutputWorkspace='sam_raw',ThetaDependent=True)
        else:
            pass
            
        #normalize the scattering data after considering calibration file
        Divide(LHSWorkspace='sam_raw', RHSWorkspace='cal', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    
        #convert the pixel-TOF matrix to IQ1D curve
        convertIQ1D(Q_rebin,'sam_tmp','IQ_sam')
        
        #normalize IQ after considering the volume of the sample
        Divide(LHSWorkspace='IQ_sam', RHSWorkspace='volume', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
        #normalize IQ after considering the factor in calibration file. the value will be considered in the calibration file itself in the future package, and this sentence will be deleted
        #Multiply(LHSWorkspace='IQ_sam_v', RHSWorkspace='factor', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
        
        #save IQ for canvas plotting
        SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_Scale.dat')
        #save IQ to a backup folder
        SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(SampleScatt_Run)+'_Scale.dat')
        
        #save raw IQ without calibration and transmission normalization
        convertIQ1D(Q_rebin,'sam_raw','IQ_sam_raw')
        Divide(LHSWorkspace='IQ_sam_raw', RHSWorkspace='volume', OutputWorkspace='IQ_sam_raw', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_sam_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(SampleScatt_Run)+'_Raw.dat')
        
        #if emptybeam scattering is measured, it will be deducted
        if EmptyDirectNum>0:
            Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_sam_normalized')
            
            SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyBeam_deduction.dat')
            
        else:
            pass
            
        #output the IQ file of sample with all information in header
        outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyTrans_Run, SampleTrans_Run, 'IQ_sam_normalized', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file)

    
    # if emptycell module is existed, do the IQ reduction for emptycell
    if (EmptyCellScattNum>0):
        
        #converting the scattering data to pixel-TOF matrix considering mask, beamcenter and wavelength range
        ScatterData(prepath, prepath_read, EmptyCellScatt_Run, wave_rebin, wave_rebin_all, 'emptycell_raw', beamcenter_x, beamcenter_y, mask_file)
        
        #normalize the scattering data after considering transmission of the emptycell
        if (EmptyCellTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='emptycell_raw',TransmissionWorkspace='Trans_EmptyCell',OutputWorkspace='emptycell_raw',ThetaDependent=True)
        else:
            pass
        
        #normalize the scattering data after considering calibration file
        Divide(LHSWorkspace='emptycell_raw', RHSWorkspace='cal', OutputWorkspace='emptycell_tmp', AllowDifferentNumberSpectra=True)
        
        #convert the pixel-TOF matrix to IQ1D curve
        convertIQ1D(Q_rebin,'emptycell_tmp','IQ_emptycell')
        #normalize IQ after considering the volume of the sample
        Divide(LHSWorkspace='IQ_emptycell', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
        
        #normalize IQ after considering the factor in calibration file. the value will be considered in the calibration file itself in the future package, and this sentence will be deleted
        #Multiply(LHSWorkspace='IQ_emptycell_v', RHSWorkspace='factor', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
        #save IQ for canvas plotting
        SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_Scale.dat')
        #save IQ to a backup folder
        SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(EmptyCellScatt_Run)+'_Scale.dat')
        
        #save raw IQ without calibration and transmission normalization
        convertIQ1D(Q_rebin,'emptycell_raw','IQ_emptycell_raw')
        Divide(LHSWorkspace='IQ_emptycell_raw', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_raw', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_emptycell_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(EmptyCellScatt_Run)+'_Raw.dat')
        
        #if emptybeam scattering is measured, it will be deducted
        if (EmptyDirectNum>0):
            Minus(LHSWorkspace='IQ_emptycell_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_emptycell_normalized')
            SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_EmptyBeam_deduction.dat')
            
        else:
            pass
            
        #IQ deduction of emptycell for sample
        Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_sam_normalized_emptycell_deduction')
        SaveAscii(InputWorkspace='IQ_sam_normalized_emptycell_deduction',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyCell_EmptyBeam_deduction.dat')
        
        #output the IQ file of emptycell with all information in header
        outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, EmptyCellScatt_Run, EmptyTrans_Run, EmptyCellTrans_Run, 'IQ_emptycell_normalized', 'Trans_EmptyCell', 'Spectrum', FileName_EmptyCell, Thickness, Diameter, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file)
        #output the IQ file of sample after deduction of emptycell with all information in header
        outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, 'IQ_sam_normalized_emptycell_deduction', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file)
    
    # if solvent module is existed, do the IQ reduction for solvent
    if (SolventScattNum>0):
        
        #converting the scattering data to pixel-TOF matrix considering mask, beamcenter and wavelength range
        ScatterData(prepath, prepath_read, SolventScatt_Run, wave_rebin, wave_rebin_all, 'solvent_raw', beamcenter_x, beamcenter_y, mask_file)
        
        #normalize the scattering data after considering transmission of the solvent
        if (SolventTransNum>0):
            ApplyTransmissionCorrection(InputWorkspace='solvent_raw',TransmissionWorkspace='Trans_Solvent',OutputWorkspace='solvent_raw',ThetaDependent=True)
        else:
            pass
        
        #normalize the scattering data after considering calibration file
        Divide(LHSWorkspace='solvent_raw', RHSWorkspace='cal', OutputWorkspace='solvent_tmp', AllowDifferentNumberSpectra=True)
        
        #convert the pixel-TOF matrix to IQ1D curve
        convertIQ1D(Q_rebin,'solvent_tmp','IQ_solvent')
        #normalize IQ after considering the volume of the sample
        Divide(LHSWorkspace='IQ_solvent', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
        #normalize IQ after considering the factor in calibration file. the value will be considered in the calibration file itself in the future package, and this sentence will be deleted
        #Multiply(LHSWorkspace='IQ_solvent_v', RHSWorkspace='factor', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
        #save IQ for canvas plotting
        SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_Scale.dat')
        #save IQ to a backup folder
        SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(SolventScatt_Run)+'_Scale.dat')
        
        #save raw IQ without calibration and transmission normalization
        convertIQ1D(Q_rebin,'solvent_raw','IQ_solvent_raw')
        Divide(LHSWorkspace='IQ_solvent_raw', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_raw', AllowDifferentNumberSpectra=True)
        SaveAscii(InputWorkspace='IQ_solvent_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(SolventScatt_Run)+'_Raw.dat')
        
        #if emptybeam scattering is measured, it will be deducted
        if EmptyDirectNum>0:
            Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_solvent_normalized')
            
            SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_EmptyBeam_deduction.dat')
            
        else:
            pass
        
        #IQ deduction of emptycell for solvent
        Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_solvent_normalized_emptycell_deduction')
        
        #IQ deduction of solvent after considering its volume fraction for solution, approaching IQ for pure solute
        Multiply(LHSWorkspace='IQ_solvent_normalized_emptycell_deduction', RHSWorkspace='Solvent_VF', OutputWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF', AllowDifferentNumberSpectra=True)
        Minus(LHSWorkspace='IQ_sam_normalized_emptycell_deduction', RHSWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF',OutputWorkspace='IQ_solute_reduced')
        
        #save IQ for canvas plotting
        SaveAscii(InputWorkspace='IQ_solute_reduced',Filename=prepath_save+'/temporary/'+'IQ_Solute_pure.dat')
        
        #output the IQ file of solvent deducting emptycell with all information in header
        outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SolventTrans_Run, EmptyCellTrans_Run, 'IQ_solvent_normalized_emptycell_deduction', 'Trans_Solvent', 'Spectrum', FileName_Solvent, Thickness, Diameter, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file)
        #output the IQ file of pure solute with all information in header
        outputIqSolution(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, SolventTrans_Run, EmptyCellTrans_Run,  'IQ_solute_reduced', 'Trans_Sample', 'Spectrum', 'Solvent_VF', FileName_Sample, Thickness, Diameter, Trans_fitting_method, Smooth_Ns, ScalingFactor,cal_file,mask_file)
    
    if (EmptyDirectNum>0):
        DeleteWorkspace(Workspace='empty_raw')
        DeleteWorkspace(Workspace='empty_tmp')
        DeleteWorkspace(Workspace='IQ_empty')
        DeleteWorkspace(Workspace='IQ_empty_normalized')
        DeleteWorkspace(Workspace='IQ_empty_raw')
        
    if (SampleScattNum>0):
        DeleteWorkspace(Workspace='sam_raw')
        DeleteWorkspace(Workspace='sam_tmp')
        DeleteWorkspace(Workspace='IQ_sam')
        DeleteWorkspace(Workspace='IQ_sam_normalized')
        DeleteWorkspace(Workspace='IQ_sam_raw')
        
    if (EmptyCellScattNum>0):
        DeleteWorkspace(Workspace='emptycell_raw')
        DeleteWorkspace(Workspace='emptycell_tmp')
        DeleteWorkspace(Workspace='IQ_emptycell')
        DeleteWorkspace(Workspace='IQ_emptycell_normalized')
        DeleteWorkspace(Workspace='IQ_emptycell_raw')
        DeleteWorkspace(Workspace='IQ_sam_normalized_emptycell_deduction')
        
    if (SolventScattNum>0):
        DeleteWorkspace(Workspace='solvent_raw')
        DeleteWorkspace(Workspace='solvent_tmp')
        DeleteWorkspace(Workspace='IQ_solvent')
        DeleteWorkspace(Workspace='IQ_solvent_normalized')
        DeleteWorkspace(Workspace='IQ_solvent_raw')
        DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction')
        DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction_SolventVF')
        DeleteWorkspace(Workspace='IQ_solute_reduced')
        
    return True


#IQ Checking module at main.py, which is used to show if IQ of different wavelength range fits well
def IQChecking():
    
    #load parameters from configure.xml
    IQ_Check_w_min_1,IQ_Check_w_step_1,IQ_Check_w_max_1,IQ_Check_w_min_2,IQ_Check_w_step_2,IQ_Check_w_max_2,IQ_Check_w_min_3,IQ_Check_w_step_3,IQ_Check_w_max_3,IQ_Check_w_min_4,IQ_Check_w_step_4,IQ_Check_w_max_4,IQ_Check_w_min_5,IQ_Check_w_step_5,IQ_Check_w_max_5,IQ_Check_w_min_6,IQ_Check_w_step_6,IQ_Check_w_max_6,IQ_Check_w_min_7,IQ_Check_w_step_7,IQ_Check_w_max_7,IQ_Check_det_min,IQ_Check_det_max = getConfXML3();
    
    FileName_Sample, FileName_EmptyCell, FileName_Solvent, cal_file, mask_file, prepath_save,beamcenter_x, beamcenter_y, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, SolventTrans_Run, Trans_fitting_method, Smooth_Ns, w1, dw, w2, EmptyTransNum, SampleTransNum, EmptyCellTransNum, SolventTransNum=getConfXML();
    
    EmptyDirect_Run,EmptyDirectNum,SampleScatt_Run,SampleScattNum,EmptyCellScatt_Run,EmptyCellScattNum,SolventScatt_Run,SolventScattNum,Solvent_VF,ScalingFactor, Volume,Thickness,Diameter,w1, dw, w2,Q_rebin=getConfXML2();
    
    Diameter,wave_rebin_all_min, wave_rebin_all_max, beamcenter_x, beamcenter_y=getInfoFromCalFile(prepath_read+'/paramData/'+cal_file)
    
    wave_rebin_all=wave_rebin_all_min+','+str(dw)+','+wave_rebin_all_max
    
    IQ_Check_w_min_List=[IQ_Check_w_min_1,IQ_Check_w_min_2,IQ_Check_w_min_3,IQ_Check_w_min_4,IQ_Check_w_min_5,IQ_Check_w_min_6,IQ_Check_w_min_7]
    IQ_Check_w_step_List=[IQ_Check_w_step_1,IQ_Check_w_step_2,IQ_Check_w_step_3,IQ_Check_w_step_4,IQ_Check_w_step_5,IQ_Check_w_step_6,IQ_Check_w_step_7]
    IQ_Check_w_max_List=[IQ_Check_w_max_1,IQ_Check_w_max_2,IQ_Check_w_max_3,IQ_Check_w_max_4,IQ_Check_w_max_5,IQ_Check_w_max_6,IQ_Check_w_max_7]
    
    Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(Thickness/10.0)
    CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
    
    #the factor of wave_rebin and dlambda at calibration file
    #in the future should be considered at calibration file
    #factor=0.005/0.01  
    #CreateSingleValuedWorkspace(OutputWorkspace='factor', DataValue=factor)
    
    CreateSingleValuedWorkspace(OutputWorkspace='Solvent_VF', DataValue=Solvent_VF)
    
    CreateSingleValuedWorkspace(OutputWorkspace='ScalingFactor', DataValue=ScalingFactor)
    
    #wave_rebin_all='1,0.01,8.5'
    
    #specific for IQ Checking module, which is used to obtain pixel-TOF matrix of all wavelength range before the iteration
    #it's better than calculating the pixel-TOF matrix in the iteration by each wavelength range
    if EmptyDirectNum>0:
        ReadDataFromFile(prepath, prepath_read, EmptyDirect_Run, wave_rebin_all, 'empty_raw', beamcenter_x, beamcenter_y, mask_file)
    
    if (SampleScattNum>0):
        ReadDataFromFile(prepath, prepath_read, SampleScatt_Run, wave_rebin_all, 'sam_raw', beamcenter_x, beamcenter_y, mask_file)
    
    if (EmptyCellScattNum>0):
        ReadDataFromFile(prepath, prepath_read, EmptyCellScatt_Run, wave_rebin_all, 'emptycell_raw', beamcenter_x, beamcenter_y, mask_file)
    
    if (SolventScattNum>0):
        ReadDataFromFile(prepath, prepath_read, SolventScatt_Run, wave_rebin_all, 'solvent_raw', beamcenter_x, beamcenter_y, mask_file)
    
    
    
    #calculate the IQ of different wavelength range as an iteration
    for IQ_Check_Range_N in range(0,7,1):
        
        #obtain wavelength range for each iteration
        w_min=IQ_Check_w_min_List[IQ_Check_Range_N]
        w_max=IQ_Check_w_max_List[IQ_Check_Range_N]
        w_step=IQ_Check_w_step_List[IQ_Check_Range_N]
        
        wave_rebin=str(w_min)+','+str(w_step)+','+str(w_max)
        
        '''
        rebin_ratio=w_step/0.01
        CreateSingleValuedWorkspace(OutputWorkspace='rebin_ratio', DataValue=rebin_ratio)
        '''
        
        #L2 is the distance between detector and sample
        #calculate the Q range from the wavelength range and position range of the detector
        L2=4
        Q_min=6.28/w_max*IQ_Check_det_min/100/L2
        Q_max=6.28/w_min*IQ_Check_det_max/100/L2
        Q_rebin=str(Q_min)+','+str(-0.08)+','+str(Q_max)

        
        #obtain the spectrum of the beam from Monitor2, which will be used for Q resolution averaging
        '''
        mergeWS(prepath, EmptyTrans_Run, 'monitors')
        RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='Spectrum')    
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
        '''
        
        mergeWS(prepath, EmptyTrans_Run, 'monitor2')
        RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Spectrum')    
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
    
        
        #calculate transmission 
        if EmptyTransNum>0:
            if SampleTransNum>0:
                CalTrans(prepath, prepath_read, prepath_save, SampleTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Sample_Check')
                
            else:
                pass
            
        if EmptyCellTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, EmptyCellTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_EmptyCell_Check')
            
        else:
            pass
            
        if SolventTransNum>0:
            CalTrans(prepath, prepath_read, prepath_save, SolventTrans_Run, EmptyTrans_Run, wave_rebin, Trans_fitting_method, Smooth_Ns, 'Trans_Solvent_Check')
            
        else:
            pass
            
        #load calibration file
        #if len(cal_file)>0:
        LoadAscii(Filename=prepath_read+'/paramData/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
        ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
        Divide(LHSWorkspace='cal', RHSWorkspace='ScalingFactor', OutputWorkspace='cal', AllowDifferentNumberSpectra=True)
        Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
        
        #calculate IQ of emptybeam
        if EmptyDirectNum>0:
            #ScatterData(prepath, prepath_read, EmptyDirect_Run, wave_rebin, wave_rebin_all, 'empty_raw', beamcenter_x, beamcenter_y, mask_file)
            
            Rebin(InputWorkspace='empty_raw', OutputWorkspace='empty_raw_'+str(IQ_Check_Range_N), Params=wave_rebin)
            
            #Divide(LHSWorkspace='empty_raw_'+str(IQ_Check_Range_N), RHSWorkspace='rebin_ratio', OutputWorkspace='empty_raw_'+str(IQ_Check_Range_N), AllowDifferentNumberSpectra=True)
            
            Divide(LHSWorkspace='empty_raw_'+str(IQ_Check_Range_N), RHSWorkspace='cal', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
            convertIQ1D(Q_rebin,'empty_tmp','IQ_empty')
            Divide(LHSWorkspace='IQ_empty', RHSWorkspace='volume', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_empty_v', RHSWorkspace='factor', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
        
            #SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyBeam_Scale.dat')
        
        else:
            pass
            
        #calculate IQ of sample
        if (SampleScattNum>0):
    
            #ScatterData(prepath, prepath_read, SampleScatt_Run, wave_rebin, wave_rebin_all, 'sam_raw', beamcenter_x, beamcenter_y, mask_file)
            
            Rebin(InputWorkspace='sam_raw', OutputWorkspace='sam_raw_'+str(IQ_Check_Range_N), Params=wave_rebin)
            
            #Divide(LHSWorkspace='sam_raw_'+str(IQ_Check_Range_N), RHSWorkspace='rebin_ratio', OutputWorkspace='sam_raw_'+str(IQ_Check_Range_N), AllowDifferentNumberSpectra=True)
            
            Divide(LHSWorkspace='sam_raw_'+str(IQ_Check_Range_N), RHSWorkspace='cal', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    
            if (SampleTransNum>0):
                ApplyTransmissionCorrection(InputWorkspace='sam_tmp',TransmissionWorkspace='Trans_Sample_Check',OutputWorkspace='sam_tmp',ThetaDependent=True)
            else:
                pass
        
            convertIQ1D(Q_rebin,'sam_tmp','IQ_sam')
            Divide(LHSWorkspace='IQ_sam', RHSWorkspace='volume', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_sam_v', RHSWorkspace='factor', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam.dat')
        
            if EmptyDirectNum>0:
                Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_sam_normalized')
            
                SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_Check_'+str(IQ_Check_Range_N+1)+'.dat')
            
            
            else:
                pass
            
            #outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyTrans_Run, SampleTrans_Run, 'IQ_sam_normalized', 'Trans_Sample', 'Spectrum', FileName_Sample+'_'+str(IQ_Check_Range_N), Thickness, Diameter)
            
        
        #calculate IQ of EmptyCell
        if (EmptyCellScattNum>0):
            #ScatterData(prepath, prepath_read, EmptyCellScatt_Run, wave_rebin, wave_rebin_all, 'emptycell_raw', beamcenter_x, beamcenter_y, mask_file)
            Rebin(InputWorkspace='emptycell_raw', OutputWorkspace='emptycell_raw_'+str(IQ_Check_Range_N), Params=wave_rebin)
            
            #Divide(LHSWorkspace='emptycell_raw_'+str(IQ_Check_Range_N), RHSWorkspace='rebin_ratio', OutputWorkspace='emptycell_raw_'+str(IQ_Check_Range_N), AllowDifferentNumberSpectra=True)
            
            Divide(LHSWorkspace='emptycell_raw_'+str(IQ_Check_Range_N), RHSWorkspace='cal', OutputWorkspace='emptycell_tmp', AllowDifferentNumberSpectra=True)
        
            if (EmptyCellTransNum>0):
                ApplyTransmissionCorrection(InputWorkspace='emptycell_tmp',TransmissionWorkspace='Trans_EmptyCell_Check',OutputWorkspace='emptycell_tmp',ThetaDependent=True)
            else:
                pass
            convertIQ1D(Q_rebin,'emptycell_tmp','IQ_emptycell')
            Divide(LHSWorkspace='IQ_emptycell', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_emptycell_v', RHSWorkspace='factor', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
            #SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_Scale.dat')
        
            if (EmptyDirectNum>0):
                Minus(LHSWorkspace='IQ_emptycell_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_emptycell_normalized')
                #SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_EmptyBeam_deduction.dat')
            
            else:
                pass
            
            Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_sam_normalized_emptycell_deduction')
            SaveAscii(InputWorkspace='IQ_sam_normalized_emptycell_deduction',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyCell_deduction_Check_'+str(IQ_Check_Range_N+1)+'.dat')
        
            #outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, EmptyCellScatt_Run, EmptyTrans_Run, EmptyCellTrans_Run, 'IQ_empty_normalized', 'Trans_EmptyCell', 'Spectrum', FileName_EmptyCell+'_'+str(IQ_Check_Range_N), Thickness, Diameter)
            #outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, EmptyCellTrans_Run, 'IQ_sam_normalized_emptycell_deduction', 'Trans_Sample', 'Spectrum', FileName_Sample+'_'+str(IQ_Check_Range_N), Thickness, Diameter)
            
        #calculate IQ of Solvent
        if (SolventScattNum>0):
        
            #ScatterData(prepath, prepath_read, SolventScatt_Run, wave_rebin, wave_rebin_all, 'solvent_raw', beamcenter_x, beamcenter_y, mask_file)
            
            Rebin(InputWorkspace='solvent_raw', OutputWorkspace='solvent_raw_'+str(IQ_Check_Range_N), Params=wave_rebin)
            
            #Divide(LHSWorkspace='solvent_raw_'+str(IQ_Check_Range_N), RHSWorkspace='rebin_ratio', OutputWorkspace='solvent_raw_'+str(IQ_Check_Range_N), AllowDifferentNumberSpectra=True)
            
            Divide(LHSWorkspace='solvent_raw_'+str(IQ_Check_Range_N), RHSWorkspace='cal', OutputWorkspace='solvent_tmp', AllowDifferentNumberSpectra=True)
        
            if (SolventTransNum>0):
                ApplyTransmissionCorrection(InputWorkspace='solvent_tmp',TransmissionWorkspace='Trans_Solvent_Check',OutputWorkspace='solvent_tmp',ThetaDependent=True)
            else:
                pass
            convertIQ1D(Q_rebin,'solvent_tmp','IQ_solvent')
            Divide(LHSWorkspace='IQ_solvent', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_solvent_v', RHSWorkspace='factor', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
        
            #SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_Scale.dat')
        
            if EmptyDirectNum>0:
                Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_solvent_normalized')
            
                #SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_EmptyBeam_deduction.dat')
            
            else:
                pass
        
        
            Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_solvent_normalized_emptycell_deduction')
            Multiply(LHSWorkspace='IQ_solvent_normalized_emptycell_deduction', RHSWorkspace='Solvent_VF', OutputWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF', AllowDifferentNumberSpectra=True)
            Minus(LHSWorkspace='IQ_sam_normalized_emptycell_deduction', RHSWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF',OutputWorkspace='IQ_solute_reduced')
        
            SaveAscii(InputWorkspace='IQ_solute_reduced',Filename=prepath_save+'/temporary/'+'IQ_Solute_pure_Check_'+str(IQ_Check_Range_N+1)+'.dat')
        
            #outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SolventTrans_Run, EmptyCellTrans_Run, 'IQ_solvent_normalized_emptycell_deduction', 'Trans_Solvent', 'Spectrum', FileName_Solvent+'_'+str(IQ_Check_Range_N), Thickness, Diameter)
            #outputIqSolution(prepath_save, Q_rebin, wave_rebin, EmptyDirect_Run, SampleScatt_Run, SolventScatt_Run, EmptyCellScatt_Run, EmptyTrans_Run, SampleTrans_Run, SolventTrans_Run, EmptyCellTrans_Run,  'IQ_solute_reduced', 'Trans_Sample', 'Spectrum', 'Solvent_VF', FileName_Sample+'_'+str(IQ_Check_Range_N), Thickness, Diameter)
            
        if (EmptyDirectNum>0):
            DeleteWorkspace(Workspace='empty_raw_'+str(IQ_Check_Range_N))
            DeleteWorkspace(Workspace='empty_tmp')
            DeleteWorkspace(Workspace='IQ_empty')
            DeleteWorkspace(Workspace='IQ_empty_normalized')
        
        if (SampleScattNum>0):
            DeleteWorkspace(Workspace='sam_raw_'+str(IQ_Check_Range_N))
            DeleteWorkspace(Workspace='sam_tmp')
            DeleteWorkspace(Workspace='IQ_sam')
            DeleteWorkspace(Workspace='IQ_sam_normalized')
        
        if (EmptyCellScattNum>0):
            DeleteWorkspace(Workspace='emptycell_raw_'+str(IQ_Check_Range_N))
            DeleteWorkspace(Workspace='emptycell_tmp')
            DeleteWorkspace(Workspace='IQ_emptycell')
            DeleteWorkspace(Workspace='IQ_emptycell_normalized')
            DeleteWorkspace(Workspace='IQ_sam_normalized_emptycell_deduction')
    	
        if (SolventScattNum>0):
            DeleteWorkspace(Workspace='solvent_raw_'+str(IQ_Check_Range_N))
            DeleteWorkspace(Workspace='solvent_tmp')
            DeleteWorkspace(Workspace='IQ_solvent')
            DeleteWorkspace(Workspace='IQ_solvent_normalized')
            DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction')
            DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction_SolventVF')
            DeleteWorkspace(Workspace='IQ_solute_reduced')
        
    if (EmptyDirectNum>0):
        DeleteWorkspace(Workspace='empty_raw')
    if (SampleScattNum>0):
        DeleteWorkspace(Workspace='sam_raw')
    if (EmptyCellScattNum>0):
        DeleteWorkspace(Workspace='emptycell_raw')
    if (SolventScattNum>0):
        DeleteWorkspace(Workspace='solvent_raw')
        
#Batch module in main.py, which is used to reduce different samples simultaneously
def IQBatch():
    
    #obtain number of samples from configure.xml
    Batch_No = getConfXML_BatchNo()
    
    #The local time to name the log file
    Time=time.strftime('%Y%m%d_%H%M',time.localtime(time.time()))
    
    #iteration of different sample No.
    for Sample_No in range(1,Batch_No+1,1):
        
        #obtain sample information at specfic sample No. from configure.xml
        Batch_EmptyTrans,Batch_EmptyTrans_Num,Batch_SampleTrans,Batch_SampleTrans_Num,Batch_EmptycellTrans,Batch_EmptycellTrans_Num,Batch_SolventTrans,Batch_SolventTrans_Num,Batch_TransFit,Batch_Ns,Batch_WavMin,Batch_WavStep,Batch_WavMax,Batch_EmptyScatt,Batch_EmptyScatt_Num,Batch_SampleScatt,Batch_SampleScatt_Num,Batch_EmptycellScatt,Batch_EmptycellScatt_Num,Batch_SolventScatt,Batch_SolventScatt_Num,Batch_Thickness,Batch_ScalingFactor,Batch_SolventVF,Batch_QMin,Batch_QStep,Batch_QMax ,FileName_Sample, FileName_EmptyCell, FileName_Solvent,Diameter ,cal_file, mask_file,prepath_save,beamcenter_x,beamcenter_y = getConfXML4(Sample_No)
        #FileName_Sample, FileName_EmptyCell, FileName_Solvent, X, X, X, X, X, X,X ,X , X, X, X, X,X ,X ,X,X,X=getConfXML()
        #X, X, X, X,X , X, X,X ,X ,X ,X , Diameter , X, X,X ,X =getConfXML2()
        #cal_file, mask_file
        Diameter,wave_rebin_all_min, wave_rebin_all_max, beamcenter_x, beamcenter_y=getInfoFromCalFile(prepath_read+'/paramData/'+cal_file)
        
        wave_rebin_all=wave_rebin_all_min+','+str(Batch_WavMin)+','+wave_rebin_all_max
        
        wave_rebin=str(Batch_WavMin)+','+str(Batch_WavStep)+','+str(Batch_WavMax)
        #wave_rebin_all='1,'+str(Batch_WavStep)+',8.5'
        Q_rebin=str(Batch_QMin)+','+str(Batch_QStep)+','+str(Batch_QMax)
        
        # Volume unit (cm^3) 
        Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(Batch_Thickness/10.0)
        
        CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
        
        CreateSingleValuedWorkspace(OutputWorkspace='Batch_ScalingFactor', DataValue=Batch_ScalingFactor)
        
        #factor=0.005/0.01
        #CreateSingleValuedWorkspace(OutputWorkspace='factor', DataValue=factor)
        
        CreateSingleValuedWorkspace(OutputWorkspace='Batch_SolventVF', DataValue=Batch_SolventVF)
        
        #obtain the spectrum of the beam from Monitor2, which will be used to average different wavelength for Q resolution
        '''
        mergeWS(prepath, Batch_EmptyTrans, 'monitors')
        RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='Spectrum')
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
        '''
        
        mergeWS(prepath, Batch_EmptyTrans, 'monitor2')
        RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Spectrum')
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
    
    
        #calculate the transmission before IQ reduction
        if Batch_EmptyTrans_Num>0:
            if Batch_SampleTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, Batch_SampleTrans, Batch_EmptyTrans, wave_rebin, Batch_TransFit, Batch_Ns, 'Trans_Sample_'+str(Sample_No))
                CalTrans(prepath, prepath_read, prepath_save, Batch_SampleTrans, Batch_EmptyTrans, wave_rebin, 'Raw', Batch_Ns, 'Trans_Sample_unfitted'+str(Sample_No))
                
                #change the output trans raw name to make it same format with scattering output
                SaveAscii(InputWorkspace='Trans_Sample_'+str(Sample_No)+'_raw' ,Filename=prepath_save+'/temporary/'+'Trans_Sample_raw_'+str(Sample_No)+'.dat')
                outputTransBatch(prepath_save, Batch_SampleTrans, Batch_EmptyTrans, 'Trans_Sample_'+str(Sample_No), 'Trans_Sample_unfitted'+str(Sample_No), FileName_Sample,Sample_No, wave_rebin,Batch_TransFit,Batch_Ns)
            else:
                pass
            
            if Batch_EmptycellTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, Batch_EmptycellTrans, Batch_EmptyTrans, wave_rebin, Batch_TransFit, Batch_Ns, 'Trans_EmptyCell_'+str(Sample_No))
                CalTrans(prepath, prepath_read, prepath_save, Batch_EmptycellTrans, Batch_EmptyTrans, wave_rebin, 'Raw', Batch_Ns, 'Trans_EmptyCell_unfitted'+str(Sample_No))
                
                SaveAscii(InputWorkspace='Trans_EmptyCell_'+str(Sample_No)+'_raw' ,Filename=prepath_save+'/temporary/'+'Trans_EmptyCell_raw_'+str(Sample_No)+'.dat')
                outputTransBatch(prepath_save, Batch_EmptycellTrans, Batch_EmptyTrans, 'Trans_EmptyCell_'+str(Sample_No), 'Trans_EmptyCell_unfitted'+str(Sample_No), FileName_Sample,Sample_No, wave_rebin,Batch_TransFit,Batch_Ns)
                
            else:
                pass
            
            if Batch_SolventTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, Batch_SolventTrans, Batch_EmptyTrans, wave_rebin, Batch_TransFit, Batch_Ns, 'Trans_Solvent_'+str(Sample_No))
                CalTrans(prepath, prepath_read, prepath_save, Batch_SolventTrans, Batch_EmptyTrans, wave_rebin, 'Raw', Batch_Ns, 'Trans_Solvent_unfitted'+str(Sample_No))
                
                SaveAscii(InputWorkspace='Trans_Solvent_'+str(Sample_No)+'_raw' ,Filename=prepath_save+'/temporary/'+'Trans_Solvent_raw_'+str(Sample_No)+'.dat')
                outputTransBatch(prepath_save, Batch_SolventTrans, Batch_EmptyTrans, 'Trans_Solvent_'+str(Sample_No), 'Trans_Solvent_unfitted'+str(Sample_No), FileName_Sample,Sample_No, wave_rebin,Batch_TransFit,Batch_Ns)
            else:
                pass
        
        
        #load the calibration file
        #if len(cal_file)>0:
        LoadAscii(Filename=prepath_read+'/paramData/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
        ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
        Divide(LHSWorkspace='cal', RHSWorkspace='Batch_ScalingFactor', OutputWorkspace='cal', AllowDifferentNumberSpectra=True)
        Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
        #else:
            #pass
            
        
        #IQ background reduction
        if Batch_EmptyScatt_Num>0:
            ScatterData(prepath, prepath_read, Batch_EmptyScatt, wave_rebin, wave_rebin_all, 'empty_raw', beamcenter_x, beamcenter_y, mask_file)
            Divide(LHSWorkspace='empty_raw', RHSWorkspace='cal', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
            convertIQ1D(Q_rebin,'empty_tmp','IQ_empty')
            Divide(LHSWorkspace='IQ_empty', RHSWorkspace='volume', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_empty_v', RHSWorkspace='factor', OutputWorkspace='IQ_empty_normalized', AllowDifferentNumberSpectra=True)
        
            SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyBeam_Scale_'+str(Sample_No)+'.dat')
            SaveAscii(InputWorkspace='IQ_empty_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_EmptyScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            
            convertIQ1D(Q_rebin,'empty_raw','IQ_empty_raw')
            Divide(LHSWorkspace='IQ_empty_raw', RHSWorkspace='volume', OutputWorkspace='IQ_empty_raw', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_empty_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_EmptyScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
        
        
        
        else:
            pass
        
        
        #IQ sample reduction
        if (Batch_SampleScatt_Num>0):
    
            ScatterData(prepath, prepath_read, Batch_SampleScatt, wave_rebin, wave_rebin_all, 'sam_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (Batch_SampleTrans_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='sam_raw',TransmissionWorkspace='Trans_Sample_'+str(Sample_No),OutputWorkspace='sam_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='sam_raw', RHSWorkspace='cal', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
    
        
            convertIQ1D(Q_rebin,'sam_tmp','IQ_sam')
            Divide(LHSWorkspace='IQ_sam', RHSWorkspace='volume', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_sam_v', RHSWorkspace='factor', OutputWorkspace='IQ_sam_normalized', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_Scale_'+str(Sample_No)+'.dat')
            SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_SampleScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            
            convertIQ1D(Q_rebin,'sam_raw','IQ_sam_raw')
            Divide(LHSWorkspace='IQ_sam_raw', RHSWorkspace='volume', OutputWorkspace='IQ_sam_raw', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_sam_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_SampleScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
        
            if (Batch_EmptyScatt_Num>0):
                Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_sam_normalized')
            
                SaveAscii(InputWorkspace='IQ_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyBeam_deduction_'+str(Sample_No)+'.dat')
                
            
            else:
                pass
            
            outputIqBatch(prepath_save, Q_rebin, wave_rebin, Batch_EmptyScatt, Batch_SampleScatt, Batch_EmptyTrans, Batch_SampleTrans, 'IQ_sam_normalized', 'Trans_Sample_'+str(Sample_No), 'Spectrum', FileName_Sample, Batch_Thickness, Diameter,Sample_No,Batch_TransFit,Batch_Ns, Batch_ScalingFactor,cal_file,mask_file)
            

    
    
    
        #IQ emptycell reduction
        if (Batch_EmptycellScatt_Num>0):
            ScatterData(prepath, prepath_read, Batch_EmptycellScatt, wave_rebin, wave_rebin_all, 'emptycell_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (Batch_EmptycellTrans_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='emptycell_raw',TransmissionWorkspace='Trans_EmptyCell_'+str(Sample_No),OutputWorkspace='emptycell_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='emptycell_raw', RHSWorkspace='cal', OutputWorkspace='emptycell_tmp', AllowDifferentNumberSpectra=True)
        
            convertIQ1D(Q_rebin,'emptycell_tmp','IQ_emptycell')
            Divide(LHSWorkspace='IQ_emptycell', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_emptycell_v', RHSWorkspace='factor', OutputWorkspace='IQ_emptycell_normalized', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_Scale_'+str(Sample_No)+'.dat')
            SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_EmptycellScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
        
            convertIQ1D(Q_rebin,'emptycell_raw','IQ_emptycell_raw')
            Divide(LHSWorkspace='IQ_emptycell_raw', RHSWorkspace='volume', OutputWorkspace='IQ_emptycell_raw', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_emptycell_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_EmptycellScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
        
            if (Batch_EmptyScatt_Num>0):
                Minus(LHSWorkspace='IQ_emptycell_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_emptycell_normalized')
                SaveAscii(InputWorkspace='IQ_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_EmptyBeam_deduction_'+str(Sample_No)+'.dat')
            
            else:
                pass
            
            Minus(LHSWorkspace='IQ_sam_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_sam_normalized_emptycell_deduction')
            SaveAscii(InputWorkspace='IQ_sam_normalized_emptycell_deduction',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyCell_EmptyBeam_deduction_'+str(Sample_No)+'.dat')
        
            outputIqBatch(prepath_save, Q_rebin, wave_rebin, Batch_EmptyScatt, Batch_EmptycellScatt, Batch_EmptyTrans, Batch_EmptycellTrans, 'IQ_emptycell_normalized', 'Trans_EmptyCell_'+str(Sample_No), 'Spectrum', FileName_EmptyCell, Batch_Thickness, Diameter,Sample_No,Batch_TransFit,Batch_Ns,Batch_ScalingFactor,cal_file,mask_file)
            outputIqEmptyCellDeductionBatch(prepath_save, Q_rebin, wave_rebin, Batch_EmptyScatt, Batch_SampleScatt, Batch_EmptycellScatt, Batch_EmptyTrans, Batch_SampleTrans, Batch_EmptycellTrans, 'IQ_sam_normalized_emptycell_deduction', 'Trans_Sample_'+str(Sample_No), 'Spectrum', FileName_Sample, Batch_Thickness, Diameter,Sample_No,Batch_TransFit,Batch_Ns,Batch_ScalingFactor,cal_file,mask_file)
    
    
        #IQ solvent reduction
        if (Batch_SolventScatt_Num>0):
            ScatterData(prepath, prepath_read, Batch_SolventScatt, wave_rebin, wave_rebin_all, 'solvent_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (Batch_SolventTrans_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='solvent_raw',TransmissionWorkspace='Trans_Solvent_'+str(Sample_No),OutputWorkspace='solvent_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='solvent_raw', RHSWorkspace='cal', OutputWorkspace='solvent_tmp', AllowDifferentNumberSpectra=True)
        
            convertIQ1D(Q_rebin,'solvent_tmp','IQ_solvent')
            Divide(LHSWorkspace='IQ_solvent', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ_solvent_v', RHSWorkspace='factor', OutputWorkspace='IQ_solvent_normalized', AllowDifferentNumberSpectra=True)
        
            SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_Scale_'+str(Sample_No)+'.dat')
            SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_SolventScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
        
            convertIQ1D(Q_rebin,'solvent_raw','IQ_solvent_raw')
            Divide(LHSWorkspace='IQ_solvent_raw', RHSWorkspace='volume', OutputWorkspace='IQ_solvent_raw', AllowDifferentNumberSpectra=True)
            SaveAscii(InputWorkspace='IQ_solvent_raw',Filename=prepath_save+'/backup/'+'SANS_IQ_RunNo_'+str(Batch_SolventScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
        
            if Batch_EmptyScatt_Num>0:
                Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_empty_normalized',OutputWorkspace='IQ_solvent_normalized')
            
                SaveAscii(InputWorkspace='IQ_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_EmptyBeam_deduction_'+str(Sample_No)+'.dat')
            
            else:
                pass
        
        
            Minus(LHSWorkspace='IQ_solvent_normalized', RHSWorkspace='IQ_emptycell_normalized',OutputWorkspace='IQ_solvent_normalized_emptycell_deduction')
            Multiply(LHSWorkspace='IQ_solvent_normalized_emptycell_deduction', RHSWorkspace='Batch_SolventVF', OutputWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF', AllowDifferentNumberSpectra=True)
            Minus(LHSWorkspace='IQ_sam_normalized_emptycell_deduction', RHSWorkspace='IQ_solvent_normalized_emptycell_deduction_SolventVF',OutputWorkspace='IQ_solute_reduced')
        
            SaveAscii(InputWorkspace='IQ_solute_reduced',Filename=prepath_save+'/temporary/'+'IQ_Solute_pure_'+str(Sample_No)+'.dat')
        
            outputIqEmptyCellDeductionBatch(prepath_save, Q_rebin, wave_rebin, Batch_EmptyScatt, Batch_SolventScatt, Batch_EmptycellScatt, Batch_EmptyTrans, Batch_SolventTrans, Batch_EmptycellTrans, 'IQ_solvent_normalized_emptycell_deduction', 'Trans_Solvent_'+str(Sample_No), 'Spectrum', FileName_Solvent, Batch_Thickness, Diameter,Sample_No,Batch_TransFit,Batch_Ns,Batch_ScalingFactor,cal_file,mask_file)
            outputIqSolutionBatch(prepath_save, Q_rebin, wave_rebin, Batch_EmptyScatt, Batch_SampleScatt, Batch_SolventScatt, Batch_EmptycellScatt, Batch_EmptyTrans, Batch_SampleTrans, Batch_SolventTrans, Batch_EmptycellTrans,  'IQ_solute_reduced', 'Trans_Sample_'+str(Sample_No), 'Spectrum', 'Batch_SolventVF', FileName_Sample, Batch_Thickness, Diameter,Sample_No,Batch_TransFit,Batch_Ns,Batch_ScalingFactor,cal_file,mask_file)
        
        if (Batch_EmptyScatt_Num>0):
            DeleteWorkspace(Workspace='empty_raw')
            DeleteWorkspace(Workspace='empty_tmp')
            DeleteWorkspace(Workspace='IQ_empty')
            DeleteWorkspace(Workspace='IQ_empty_normalized')
            DeleteWorkspace(Workspace='IQ_empty_raw')
            
        if (Batch_SampleScatt_Num>0):
            DeleteWorkspace(Workspace='sam_raw')
            DeleteWorkspace(Workspace='sam_tmp')
            DeleteWorkspace(Workspace='IQ_sam')
            DeleteWorkspace(Workspace='IQ_sam_normalized')
            DeleteWorkspace(Workspace='IQ_sam_raw')
        
        if (Batch_EmptycellScatt_Num>0):
            DeleteWorkspace(Workspace='emptycell_raw')
            DeleteWorkspace(Workspace='emptycell_tmp')
            DeleteWorkspace(Workspace='IQ_emptycell')
            DeleteWorkspace(Workspace='IQ_emptycell_normalized')
            DeleteWorkspace(Workspace='IQ_emptycell_raw')
            DeleteWorkspace(Workspace='IQ_sam_normalized_emptycell_deduction')
        
        if (Batch_SolventScatt_Num>0):
            DeleteWorkspace(Workspace='solvent_raw')
            DeleteWorkspace(Workspace='solvent_tmp')
            DeleteWorkspace(Workspace='IQ_solvent')
            DeleteWorkspace(Workspace='IQ_solvent_normalized')
            DeleteWorkspace(Workspace='IQ_solvent_raw')
            DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction')
            DeleteWorkspace(Workspace='IQ_solvent_normalized_emptycell_deduction_SolventVF')
            DeleteWorkspace(Workspace='IQ_solute_reduced')
        
        WriteReducedFilesInfo(prepath_save,Time,'IQBatch',Sample_No,Batch_EmptyTrans_Num,Batch_EmptyTrans,Batch_SampleTrans_Num,Batch_SampleTrans,Batch_EmptycellTrans_Num,Batch_EmptycellTrans,Batch_SolventTrans_Num,Batch_SolventTrans,Batch_EmptyScatt_Num,Batch_EmptyScatt,Batch_SampleScatt_Num,Batch_SampleScatt,Batch_EmptycellScatt_Num,Batch_EmptycellScatt,Batch_SolventScatt_Num,Batch_SolventScatt,Batch_Thickness)
    
    
    return True

#IQ2D module in main.py 
def IQ2D():
    
    #obtain number of samples from configure.xml
    IQ2D_No = getConfXML_IQ2DNo()
    
    #The local time to name the log file
    Time=time.strftime('%Y%m%d_%H%M',time.localtime(time.time()))
    
    #iteration of different sample No.
    for Sample_No in range(1,IQ2D_No+1,1):
        
        IQ2D_EmptyTrans,IQ2D_EmptyTrans_Num,IQ2D_SampleTrans,IQ2D_SampleTrans_Num,IQ2D_EmptycellTrans,IQ2D_EmptycellTrans_Num,IQ2D_SolventTrans,IQ2D_SolventTrans_Num,IQ2D_TransFitting_Method,IQ2D_Smooth_Ns,IQ2D_Wavelength_Min,IQ2D_Wavelength_Step,IQ2D_Wavelength_Max,IQ2D_EmptyScatt,IQ2D_EmptyScatt_Num,IQ2D_SampleScatt,IQ2D_SampleScatt_Num,IQ2D_EmptycellScatt,IQ2D_EmptycellScatt_Num,IQ2D_SolventScatt,IQ2D_SolventScatt_Num,IQ2D_Thickness,IQ2D_ScalingFactor,IQ2D_SolventVolumeFraction,IQ2D_QxyMax,IQ2D_DeltaQ,Diameter,cal_file,mask_file,prepath_save,beamcenter_x,beamcenter_y=getConfXML5(Sample_No)
        
        Diameter,wave_rebin_all_min, wave_rebin_all_max, beamcenter_x, beamcenter_y=getInfoFromCalFile(prepath_read+'/paramData/'+cal_file)
        
        wave_rebin_all=wave_rebin_all_min+','+str(IQ2D_Wavelength_Step)+','+wave_rebin_all_max
        
        wave_rebin=str(IQ2D_Wavelength_Min)+','+str(IQ2D_Wavelength_Step)+','+str(IQ2D_Wavelength_Max)
        #wave_rebin_all='1,'+str(IQ2D_Wavelength_Step)+',8.5'
        QxyMax = IQ2D_QxyMax
        DeltaQ = IQ2D_DeltaQ
        
        # Volume unit (cm^3) 
        Volume=3.14*(Diameter/2.0/10.0)*(Diameter/2.0/10.0)*(IQ2D_Thickness/10.0)
        
        CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=Volume)
        
        CreateSingleValuedWorkspace(OutputWorkspace='IQ2D_ScalingFactor', DataValue=IQ2D_ScalingFactor)
        
        #the factor of wave_rebin and dlambda at calibration file
        #in the future should be considered at calibration file
        #factor=0.005/0.01  
        #CreateSingleValuedWorkspace(OutputWorkspace='factor', DataValue=factor)
        
        CreateSingleValuedWorkspace(OutputWorkspace='Solvent_VF', DataValue=IQ2D_SolventVolumeFraction)
        
        #obtain the spectrum of the beam from Monitor2
        '''
        mergeWS(prepath, IQ2D_EmptyTrans, 'monitors')
        RenameWorkspace(InputWorkspace='monitors',OutputWorkspace='Spectrum')    
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
        '''
        
        mergeWS(prepath, IQ2D_EmptyTrans, 'monitor2')
        RenameWorkspace(InputWorkspace='monitor2',OutputWorkspace='Spectrum')    
        LoadInstrument(Workspace='Spectrum', Filename=prepath_read+'/paramData/monitors_201901.xml', RewriteSpectraMap=True)
        ConvertUnits(InputWorkspace='Spectrum', OutputWorkspace='Spectrum', Target='Wavelength', AlignBins=True)
        Rebin(InputWorkspace='Spectrum', OutputWorkspace="Spectrum", Params=wave_rebin)
        
        if IQ2D_EmptyTrans_Num>0:
            if IQ2D_SampleTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, IQ2D_SampleTrans, IQ2D_EmptyTrans, wave_rebin, IQ2D_TransFitting_Method, IQ2D_Smooth_Ns, 'Trans_Sample_'+str(Sample_No))
            else:
                pass
                
            if IQ2D_EmptycellTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, IQ2D_EmptycellTrans, IQ2D_EmptyTrans, wave_rebin, IQ2D_TransFitting_Method, IQ2D_Smooth_Ns, 'Trans_EmptyCell_'+str(Sample_No))
            else:
                pass
                
            if IQ2D_SolventTrans_Num>0:
                CalTrans(prepath, prepath_read, prepath_save, IQ2D_SolventTrans, IQ2D_EmptyTrans, wave_rebin, IQ2D_TransFitting_Method, IQ2D_Smooth_Ns, 'Trans_Solvent_'+str(Sample_No))
            else:
                pass
        
        LoadAscii(Filename=prepath_read+'/paramData/'+cal_file, OutputWorkspace='cal', Separator='Automatic', Unit='Wavelength')
        ConvertToHistogram(InputWorkspace='cal', OutputWorkspace='cal')
        Divide(LHSWorkspace='cal', RHSWorkspace='IQ2D_ScalingFactor', OutputWorkspace='cal', AllowDifferentNumberSpectra=True)
        Rebin(InputWorkspace='cal', OutputWorkspace='cal', Params=wave_rebin)
        
        #bg
        if IQ2D_EmptyScatt_Num>0:
            ScatterData(prepath, prepath_read, IQ2D_EmptyScatt, wave_rebin, wave_rebin_all, 'empty_raw', beamcenter_x, beamcenter_y, mask_file)
            Divide(LHSWorkspace='empty_raw', RHSWorkspace='cal', OutputWorkspace='empty_tmp', AllowDifferentNumberSpectra=True)
            convertIQxy(QxyMax, DeltaQ, 'empty_tmp', 'IQ2D_empty')
            Divide(LHSWorkspace='IQ2D_empty', RHSWorkspace='volume', OutputWorkspace='IQ2D_empty_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ2D_empty_v', RHSWorkspace='factor', OutputWorkspace='IQ2D_empty_normalized', AllowDifferentNumberSpectra=True)
            
            outputIq2DEmpty(prepath_save, QxyMax, DeltaQ, wave_rebin, IQ2D_EmptyScatt, IQ2D_EmptyTrans, IQ2D_Thickness, Diameter, Sample_No, 'IQ2D_empty_normalized',IQ2D_ScalingFactor,cal_file,mask_file)
            SaveNISTDAT(InputWorkspace='IQ2D_empty_normalized', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_EmptyScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            
            convertIQxy(QxyMax, DeltaQ, 'empty_raw', 'IQ2D_empty_raw')
            Divide(LHSWorkspace='IQ2D_empty_raw', RHSWorkspace='volume', OutputWorkspace='IQ2D_empty_raw', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_empty_raw', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_EmptyScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
            
            #SaveAscii(InputWorkspace='IQ2D_empty_v_normalized',Filename=prepath_save+'/temporary/'+'IQ2D_EmptyBeam.dat')
            
        else:
            pass
        
        #sample
    
        if (IQ2D_SampleScatt_Num>0):
        
            ScatterData(prepath, prepath_read, IQ2D_SampleScatt, wave_rebin, wave_rebin_all, 'sam_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (IQ2D_SampleTrans_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='sam_raw',TransmissionWorkspace='Trans_Sample_'+str(Sample_No),OutputWorkspace='sam_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='sam_raw', RHSWorkspace='cal', OutputWorkspace='sam_tmp', AllowDifferentNumberSpectra=True)
        
            
            convertIQxy(QxyMax, DeltaQ, 'sam_tmp', 'IQ2D_sam')
            Divide(LHSWorkspace='IQ2D_sam', RHSWorkspace='volume', OutputWorkspace='IQ2D_sam_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ2D_sam_v', RHSWorkspace='factor', OutputWorkspace='IQ2D_sam_normalized', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_sam_normalized', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_SampleScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            
            convertIQxy(QxyMax, DeltaQ, 'sam_raw', 'IQ2D_sam_raw')
            Divide(LHSWorkspace='IQ2D_sam_raw', RHSWorkspace='volume', OutputWorkspace='IQ2D_sam_raw', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_sam_raw', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_SampleScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
            
            #SaveAscii(InputWorkspace='IQ2D_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_Scale.dat')
            
            if IQ2D_EmptyScatt_Num>0:
                Minus(LHSWorkspace='IQ2D_sam_normalized', RHSWorkspace='IQ2D_empty_normalized',OutputWorkspace='IQ2D_sam_normalized')
                
                #SaveAscii(InputWorkspace='IQ2D_sam_normalized',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyBeam_deduction.dat')
                
                
            else:
                pass
                
            
            outputIq2DSample(prepath_save, QxyMax, DeltaQ, wave_rebin, IQ2D_EmptyScatt, IQ2D_EmptyTrans, IQ2D_SampleScatt, IQ2D_SampleTrans, IQ2D_Thickness, Diameter, Sample_No, 'IQ2D_sam_normalized',IQ2D_TransFitting_Method,IQ2D_Smooth_Ns, IQ2D_ScalingFactor,cal_file,mask_file)
            
            #outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect, SampleScatt, EmptyTrans, SampleTrans, 'IQ_sam_normalized', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter)
    
        
        
        
        if (IQ2D_EmptycellScatt_Num>0):
            ScatterData(prepath, prepath_read, IQ2D_EmptycellScatt, wave_rebin, wave_rebin_all, 'emptycell_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (IQ2D_EmptycellTrans_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='emptycell_raw',TransmissionWorkspace='Trans_EmptyCell_'+str(Sample_No),OutputWorkspace='emptycell_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='emptycell_raw', RHSWorkspace='cal', OutputWorkspace='emptycell_tmp', AllowDifferentNumberSpectra=True)
            
            convertIQxy(QxyMax, DeltaQ, 'emptycell_tmp', 'IQ2D_emptycell')
            Divide(LHSWorkspace='IQ2D_emptycell', RHSWorkspace='volume', OutputWorkspace='IQ2D_emptycell_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ2D_emptycell_v', RHSWorkspace='factor', OutputWorkspace='IQ2D_emptycell_normalized', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_emptycell_normalized', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_EmptycellScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            #SaveAscii(InputWorkspace='IQ2D_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_Scale.dat')
            
            convertIQxy(QxyMax, DeltaQ, 'emptycell_raw', 'IQ2D_emptycell_raw')
            Divide(LHSWorkspace='IQ2D_emptycell_raw', RHSWorkspace='volume', OutputWorkspace='IQ2D_emptycell_raw', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_emptycell_raw', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_EmptycellScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
            
            if (IQ2D_EmptyScatt_Num>0):
                Minus(LHSWorkspace='IQ2D_emptycell_normalized', RHSWorkspace='IQ2D_empty_normalized',OutputWorkspace='IQ2D_emptycell_normalized')
                #SaveAscii(InputWorkspace='IQ2D_emptycell_normalized',Filename=prepath_save+'/temporary/'+'IQ_EmptyCell_EmptyBeam_deduction.dat')
                
            else:
                pass
                
            Minus(LHSWorkspace='IQ2D_sam_normalized', RHSWorkspace='IQ2D_emptycell_normalized',OutputWorkspace='IQ2D_sam_normalized_emptycell_deduction')
            
            outputIq2DEmptycellDeduction(prepath_save, QxyMax, DeltaQ, wave_rebin, IQ2D_EmptyScatt, IQ2D_EmptyTrans, IQ2D_SampleScatt, IQ2D_SampleTrans, IQ2D_EmptycellScatt, IQ2D_EmptycellTrans, IQ2D_Thickness, Diameter, Sample_No, 'IQ2D_sam_normalized_emptycell_deduction',IQ2D_TransFitting_Method,IQ2D_Smooth_Ns,IQ2D_ScalingFactor,cal_file,mask_file)
            
            
            #SaveAscii(InputWorkspace='IQ2D_sam_normalized_emptycell_deduction',Filename=prepath_save+'/temporary/'+'IQ_Sam_EmptyCell_EmptyBeam_deduction.dat')
            
            #outputIq(prepath_save, Q_rebin, wave_rebin, EmptyDirect, EmptyCellScatt, EmptyTrans, EmptyCellTrans, 'IQ_emptycell_normalized', 'Trans_EmptyCell', 'Spectrum', FileName_EmptyCell, Thickness, Diameter)
            #outputIqEmptyCellDeduction(prepath_save, Q_rebin, wave_rebin, EmptyDirect, SampleScatt, EmptyCellScatt, EmptyTrans, SampleTrans, EmptyCellTrans, 'IQ_sam_normalized_emptycell_deduction', 'Trans_Sample', 'Spectrum', FileName_Sample, Thickness, Diameter)
        
        
        if (IQ2D_SolventScatt_Num>0):
            ScatterData(prepath, prepath_read, IQ2D_SolventScatt, wave_rebin, wave_rebin_all, 'solvent_raw', beamcenter_x, beamcenter_y, mask_file)
            
            if (IQ2D_SolventScatt_Num>0):
                ApplyTransmissionCorrection(InputWorkspace='solvent_raw',TransmissionWorkspace='Trans_Solvent_'+str(Sample_No),OutputWorkspace='solvent_raw',ThetaDependent=True)
            else:
                pass
            
            Divide(LHSWorkspace='solvent_raw', RHSWorkspace='cal', OutputWorkspace='solvent_tmp', AllowDifferentNumberSpectra=True)
            
            
            convertIQxy(QxyMax, DeltaQ, 'solvent_tmp', 'IQ2D_solvent')
            Divide(LHSWorkspace='IQ2D_solvent', RHSWorkspace='volume', OutputWorkspace='IQ2D_solvent_normalized', AllowDifferentNumberSpectra=True)
            #Multiply(LHSWorkspace='IQ2D_solvent_v', RHSWorkspace='factor', OutputWorkspace='IQ2D_solvent_normalized', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_solvent_normalized', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_SolventScatt)+'_Batch_'+str(Sample_No)+'_Scale.dat')
            
            convertIQxy(QxyMax, DeltaQ, 'solvent_raw', 'IQ2D_solvent_raw')
            Divide(LHSWorkspace='IQ2D_solvent_raw', RHSWorkspace='volume', OutputWorkspace='IQ2D_solvent_raw', AllowDifferentNumberSpectra=True)
            SaveNISTDAT(InputWorkspace='IQ2D_solvent_raw', Filename=prepath_save+'/backup/'+'SANS_IQ2D_RunNo_'+str(IQ2D_SolventScatt)+'_Batch_'+str(Sample_No)+'_Raw.dat')
            
            #SaveAscii(InputWorkspace='IQ2D_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_Scale.dat')
            
            if (IQ2D_EmptyScatt_Num>0):
                Minus(LHSWorkspace='IQ2D_solvent_normalized', RHSWorkspace='IQ2D_empty_normalized',OutputWorkspace='IQ2D_solvent_normalized')
                
                #SaveAscii(InputWorkspace='IQ2D_solvent_normalized',Filename=prepath_save+'/temporary/'+'IQ_Solvent_EmptyBeam_deduction.dat')
                
            else:
                pass
            
            
            Minus(LHSWorkspace='IQ2D_solvent_normalized', RHSWorkspace='IQ2D_emptycell_normalized',OutputWorkspace='IQ2D_solvent_normalized_emptycell_deduction')
            Multiply(LHSWorkspace='IQ2D_solvent_normalized_emptycell_deduction', RHSWorkspace='Solvent_VF', OutputWorkspace='IQ2D_solvent_normalized_emptycell_deduction_SolventVF', AllowDifferentNumberSpectra=True)
            Minus(LHSWorkspace='IQ2D_sam_normalized_emptycell_deduction', RHSWorkspace='IQ2D_solvent_normalized_emptycell_deduction_SolventVF',OutputWorkspace='IQ2D_solute_reduced')
            
            outputIq2DSolution(prepath_save, QxyMax, DeltaQ, wave_rebin, IQ2D_EmptyScatt, IQ2D_EmptyTrans, IQ2D_SampleScatt, IQ2D_SampleTrans, IQ2D_EmptycellScatt, IQ2D_EmptycellTrans, IQ2D_SolventScatt, IQ2D_SolventTrans, IQ2D_Thickness, Diameter, Sample_No, IQ2D_SolventVolumeFraction, 'IQ2D_solute_reduced',IQ2D_TransFitting_Method,IQ2D_Smooth_Ns,IQ2D_ScalingFactor,cal_file,mask_file)
            
            #SaveAscii(InputWorkspace='IQ_solute_reduced',Filename=prepath_save+'/temporary/'+'IQ_Solute_pure.dat')
        
        if (IQ2D_EmptyScatt_Num>0):
            DeleteWorkspace(Workspace='empty_raw')
            DeleteWorkspace(Workspace='empty_tmp')
            DeleteWorkspace(Workspace='IQ2D_empty')
            DeleteWorkspace(Workspace='IQ2D_empty_normalized')
            DeleteWorkspace(Workspace='IQ2D_empty_raw')
        
        if (IQ2D_SampleScatt_Num>0):
            DeleteWorkspace(Workspace='sam_raw')
            DeleteWorkspace(Workspace='sam_tmp')
            DeleteWorkspace(Workspace='IQ2D_sam')
            DeleteWorkspace(Workspace='IQ2D_sam_normalized')
            DeleteWorkspace(Workspace='IQ2D_sam_raw')
        
        if (IQ2D_EmptycellScatt_Num>0):
            DeleteWorkspace(Workspace='emptycell_raw')
            DeleteWorkspace(Workspace='emptycell_tmp')
            DeleteWorkspace(Workspace='IQ2D_emptycell')
            DeleteWorkspace(Workspace='IQ2D_emptycell_normalized')
            DeleteWorkspace(Workspace='IQ2D_emptycell_raw')
            DeleteWorkspace(Workspace='IQ2D_sam_normalized_emptycell_deduction')
    	
        if (IQ2D_SolventScatt_Num>0):
            DeleteWorkspace(Workspace='solvent_raw')
            DeleteWorkspace(Workspace='solvent_tmp')
            DeleteWorkspace(Workspace='IQ2D_solvent')
            DeleteWorkspace(Workspace='IQ2D_solvent_normalized')
            DeleteWorkspace(Workspace='IQ2D_solvent_raw')
            DeleteWorkspace(Workspace='IQ2D_solvent_normalized_emptycell_deduction')
            DeleteWorkspace(Workspace='IQ2D_solvent_normalized_emptycell_deduction_SolventVF')
            DeleteWorkspace(Workspace='IQ2D_solute_reduced')

        WriteReducedFilesInfo(prepath_save,Time,'IQ2D',Sample_No,IQ2D_EmptyTrans_Num,IQ2D_EmptyTrans,IQ2D_SampleTrans_Num,IQ2D_SampleTrans,IQ2D_EmptycellTrans_Num,IQ2D_EmptycellTrans,IQ2D_SolventTrans_Num,IQ2D_SolventTrans,IQ2D_EmptyScatt_Num,IQ2D_EmptyScatt,IQ2D_SampleScatt_Num,IQ2D_SampleScatt,IQ2D_EmptycellScatt_Num,IQ2D_EmptycellScatt,IQ2D_SolventScatt_Num,IQ2D_SolventScatt,IQ2D_Thickness)
    





