#include "parseXML.h"
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
using namespace std;

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        destNode=tree;
        return true;
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        if(0==strcmp(nodeName,pNode->Value()))
        {
            destNode=pNode;
            return true;
        }else
            getNode(pNode, destNode,nodeName);
    }
    return false;    
}

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName, const char* attrName, const char* attrValue)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        for(attr=tree->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue)))
            {
                destNode=tree;
                return true;
            }
        }
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement())
    {
        if(0==strcmp(nodeName,pNode->Value()))
        {
            for(attr=pNode->FirstAttribute();attr!=NULL; attr=attr->Next())
            {
                if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
                    destNode=pNode;
                    return true;
                }
            }
        }else
            getNode(pNode,destNode,nodeName,attrName,attrValue);
    }    
        return false;
}
CSNSgeometry ParseXML::getGeometry(TiXmlElement *node)
{
    CSNSgeometry data;
    vector<string> tmp;
    TiXmlElement *search, *group, *son;
    TiXmlText *text;
    const char* str;
    getNode(node, search, "NXgeometry");
    if(getNode(search, group, "NXorientation"))
    {
        if(getNode(group, son, "value"))
        {
            text=son->FirstChild()->ToText();
            str=text->Value();
            
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=6; i++)
                data.ori[i]=atof(tmp[i].c_str());
            tmp.clear();
        }
    }else{
            for(int i =0; i!=6; i++)
                data.ori[i]=0.0;
    }
    if(getNode(search, group, "NXshape"))
    {
        if(getNode(group, son, "size"))
        {
            text=son->FirstChild()->ToText();
            str=text->Value();
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=3; i++)
            data.size[i]=atof(tmp[i].c_str());
            tmp.clear();
        }else{
            for(int i =0; i!=3; i++)
                data.size[i]=0.0;
            }
        if(getNode(group, son, "shape"))
        {
            text=son->FirstChild()->ToText();
            data.shape=text->Value();    
        }else{
            data.shape="no value";
            }
    }else{
            for(int i =0; i!=3; i++)
                data.size[i]=0.0;
            data.shape="no value";
    } 
    if(getNode(search, group, "NXtranslation"))
    {
        if(getNode(group, son, "distances"))
        {
            text=son->FirstChild()->ToText();
            str=text->Value();
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=3; i++)
                data.distances[i]=atof(tmp[i].c_str());
            tmp.clear();
        }
    }else{
             for(int i =0; i!=3; i++)
                    data.distances[i]=0.0;
    }
    return data;
}

map<string, string> ParseXML::getPublic()
{
    std::map<string, string> data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    const char* str;
    const char* str2;
    node=root->FirstChildElement();
    for(search=node->FirstChildElement();search!=NULL; search=search->NextSiblingElement()){
        TiXmlNode *tmp=search->FirstChild();
        if(tmp->Type()==TiXmlNode::TINYXML_TEXT){
            text=search->FirstChild()->ToText();
            str=search->Value();
            str2=text->Value();
            data.insert(make_pair(str, str2));
        }else
            continue;
    }
    return data;
}

CSNSsam ParseXML::getSample()
{
    CSNSsam data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root,search, "NXsample");
//    cout<<"name: "<<search->Value()<<endl;
    if(getNode(search, node, "chemical_formula"))
    {
        text=node->FirstChild()->ToText();
        data.chemical_formula=text->Value();
    }
    if(getNode(search,node, "name"))
    {
        text=node->FirstChild()->ToText();
        data.name=text->Value();
    //    cout<<text->Value()<<endl;
    }

    if(getNode(search,node, "situation"))
    {
        text=node->FirstChild()->ToText();
        data.situation=text->Value();
      //  cout<<text->Value()<<endl;
    }
    if(getNode(search,node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=text->Value();
        //cout<<text->Value()<<endl;
    }
    if(getNode(search, node, "density"))
    {
        text=node->FirstChild()->ToText();
        data.density=atof(text->Value());
    }
    if(getNode(search, node, "mass"))
    {
        text=node->FirstChild()->ToText();
        data.mass=atof(text->Value());
    }
    if(getNode(search, node, "distance"))
    {
        text=node->FirstChild()->ToText();
        data.distance=atof(text->Value());
    }
    //getDistance(search,data.distance);
    data.geometry=getGeometry(search); 
    return data;
}

vector<CSNSse> ParseXML::getSE()
{
    std::vector<CSNSse> data;
    CSNSse tmp;
    TiXmlElement *search, *search2, *node, *group;
    TiXmlText *text;
    TiXmlAttribute *attr;
    getNode(root, search, "NXcollection");
    for(node=search->FirstChildElement();node!=NULL;node=node->NextSiblingElement())
    {
        if(0==strcmp("NXenvironment",node->Value()))
        {
            attr=node->FirstAttribute();
            tmp.seName=attr->Value();
            if(getNode(node, group, "name"))
            {
                text=group->FirstChild()->ToText();
                tmp.name=text->Value();
            }else{
                tmp.name="No name";
            }
            if(getNode(node, group, "type"))
            {
                text=group->FirstChild()->ToText();
                tmp.type=text->Value();
            }else{
                tmp.type="No type";
            }
            if(getNode(node, group, "pressure"))
            {
                text=group->FirstChild()->ToText();
                tmp.pressure=atof(text->Value());
            }else{
                tmp.pressure=-100000.0;
            }
            if(getNode(node, group, "temperature"))
            {
                text=group->FirstChild()->ToText();
                tmp.temperature=atof(text->Value());
            }else{
                tmp.temperature=-100000.0;
            }
            if(getNode(node, group, "t2"))
            {
                text=group->FirstChild()->ToText();
                tmp.t2=atof(text->Value());
            }else{
                tmp.t2=-100000.0;
            }
            if(getNode(node, group, "magnetic_field"))
            {
                text=group->FirstChild()->ToText();
                tmp.magnetic_field=atof(text->Value());
            }else{
                tmp.magnetic_field=-100000.0;
            }
            if(getNode(node, group, "electric_field"))
            {
                text=group->FirstChild()->ToText();
                tmp.electric_field=atof(text->Value());
            }else{
                tmp.electric_field=-100000.0;
            }

            data.push_back(tmp);
        }        
    }
    //cout<<123<<endl;
    return data;
}

vector<CSNSdc> ParseXML::getDC()
{
    std::vector<CSNSdc> data;
    CSNSdc tmp;
    TiXmlElement *search, *node, *group;
    TiXmlText *text;
    TiXmlAttribute *attr;
    getNode(root, search, "NXdisk_chopper");
    for(search; search!=NULL; search=search->NextSiblingElement())
    {
        if(0==strcmp("NXdisk_chopper", search->Value()))
        {
            attr=search->FirstAttribute();
            tmp.dcName=attr->Value();
            if(getNode(search, group, "phase"))
            {
                text=group->FirstChild()->ToText();
                tmp.phase=atof(text->Value());
            }
            if(getNode(search, group, "slit_angle"))
            {
                text=group->FirstChild()->ToText();
                tmp.slitAngle=atof(text->Value());
            }
            if(getNode(search, group, "rotation_speed"))
            {
                text=group->FirstChild()->ToText();
                tmp.rotationSpeed=atof(text->Value());
            }
            if(getNode(search, node, "distance"))
            {
                text=node->FirstChild()->ToText();
                tmp.distance=atof(text->Value());
            }
            data.push_back(tmp);
        }
   }
    return data;
}

CSNSsource ParseXML::getSource()
{
    CSNSsource data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root,search,"NXsource"); 
    //cout<<"NXsource: "<<search->Value()<<endl;    
     
   if(getNode(search, node, "name"))
    {
        text=node->FirstChild()->ToText();
        data.name=text->Value();
    }
    if(getNode(search, node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=text->Value();
    }
    if(getNode(search, node, "probe"))
    {
        text=node->FirstChild()->ToText();
        data.probe=text->Value();
    }
    if(getNode(search, node, "frequency"))
    {
        text=node->FirstChild()->ToText();
        data.frequency=atof(text->Value());
    }
    if(getNode(search, node, "power"))
    {
        text=node->FirstChild()->ToText();
        data.power=atof(text->Value());
    }
    return data;
}
CSNSmoderator ParseXML::getModerator()
{
    CSNSmoderator data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root, search, "NXmoderator"); 

    if(getNode(search, node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=(text->Value());
    }
    if(getNode(search, node, "temperature"))
    {
        text=node->FirstChild()->ToText();
        data.temperature=atof(text->Value());
    }
    if(getNode(search, node, "distance"))
    {
        text=node->FirstChild()->ToText();
        data.distance=atof(text->Value());
    }
    return data;
}

vector<CSNSaperture> ParseXML::getAperture()
{
    vector<CSNSaperture> data;
    CSNSaperture tmp;
    TiXmlElement *search, *node;
    TiXmlAttribute *attr;
    getNode(root,search, "NXaperture");
    for(search; search!=NULL; search=search->NextSiblingElement())
    {
        if(0==strcmp("NXaperture",search->Value()))
        {
            attr=search->FirstAttribute();
            tmp.apertureName=attr->Value();
            tmp.geometry=getGeometry(search);    
            data.push_back(tmp);
        }
    }
    return data;
}

CSNSdet ParseXML::getDetector()
{
    CSNSdet data;
    TiXmlElement *search, *psearch;
    TiXmlText *text;
    const char* str;
    getNode(root,search, "NXdetector");
    getNode(search, psearch, "local_name");
    text=psearch->FirstChild()->ToText();
    data.name=text->Value();

    getNode(search, psearch, "distance");
    text=psearch->FirstChild()->ToText();
    str=text->Value();
    data.distance=atof(str);
    cout<<"distance is "<<data.distance<<endl;

    getNode(search, psearch, "rotate_angle");
    text=psearch->FirstChild()->ToText();
    str=text->Value();
    data.rotateAngle=atof(str);

    return data;
}

/*
CSNSbs ParseXML::getBS()
{
    CSNSbs data;
    TiXmlElement *search, *node;
    getNode(root, search, "NXbeam_stop");
    data.geometry=getGeometry(search);
    getDistance(search, data.distance);
    TiXmlText *text;
    getNode(search, node, "status");
    text=node->FirstChild()->ToText();
    data.status=text->Value();
    return data;
}
*/

vector<CSNSlogs> ParseXML::getLogs()
{
    vector<CSNSlogs> data;
    TiXmlElement *search, *node, *group;
    TiXmlText *text;
    const char* str2;
    getNode(root, search, "NXcollection");
    cout<<"search:"<<search->Value()<<endl;
    for(node=search->FirstChildElement(); node!=NULL; node=node->NextSiblingElement())
    {
        CSNSlogs tmp;
        tmp.name = node->Value();
        text=node->FirstChild()->ToText();
        str2=text->Value();
        boost::split(tmp.filePath,str2,boost::is_any_of(":"), boost::token_compress_on);
        data.push_back(tmp);
    }

    /*
    getNode(search, node, "proton_charge");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.proton_charge,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "disk_chopper_phase1");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.disk_chopper_phase1,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "sample_electric_field");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_electric,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search,node, "sample_magnetic_field");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_magnetic, str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search,node, "sample_pressure");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_pressure,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "sample_environment_temperature");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_temperature,str2,boost::is_any_of(":"), boost::token_compress_on);
*/
    return data;
}

map<string, float> ParseXML::getModuleInfo(const char* moduleName)
{
    map<string, float> data;
    TiXmlElement *search, *psearch;
    TiXmlNode *node;
    TiXmlAttribute *attr;
    getNode(root, search, "location", "name", moduleName);
    for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        data.insert(make_pair(attr->Name(),atof(attr->Value()))); 
    }
    node=search;
    node=node->Parent();
    psearch=node->ToElement();
    for(attr=psearch->FirstAttribute();attr!=NULL; attr=attr->Next())
    {
        if(0==strcmp("idstart",attr->Name())||
           0==strcmp("idstepbyrow",attr->Name()))
            data.insert(make_pair(attr->Name(),atof(attr->Value())));
                //cout<<"idstart:"<<data["idstart"]<<endl;
            
    }
    getNode(psearch, search, "rot");
    for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
        data.insert(make_pair(attr->Name(),atof(attr->Value())));

    getNode(root, search, "type", "name", "panel");
    for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
    {
        if(0==strcmp("xpixels",attr->Name())||
           0==strcmp("ypixels",attr->Name())||
           0==strcmp("xstart",attr->Name())||
           0==strcmp("ystart",attr->Name())||
           0==strcmp("xstep",attr->Name())||
           0==strcmp("ystep",attr->Name()))
            data.insert(make_pair(attr->Name(),atof(attr->Value())));
    }
    return data;
}

map<string, float> ParseXML::getMonitorInfo(const char* idName)
{
    map<string, float> data;
    TiXmlElement *search, *psearch;
    TiXmlNode *node;
    TiXmlAttribute *attr;
    getNode(root, search, "left-front-bottom-point");
    //cout<<search->Value()<<endl;
    for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        if(0==strcmp("x",attr->Name())){
            float x=-2*atof(attr->Value());
            data.insert(make_pair("xstep",x));
        }
        if(0==strcmp("y",attr->Name())){
            float y=-2*atof(attr->Value());
            data.insert(make_pair("ystep",y));
        }
    }
    //cout<<idName<<endl;
    //cout<<data["xstep"]<<endl;
    getNode(root, search, "idlist","idname",idName);
    psearch=search->FirstChildElement();
   // cout<<psearch->Value()<<endl;
    for(attr=psearch->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        if(0==strcmp("start",attr->Name()))
            data.insert(make_pair("idstart",atof(attr->Value())));
    }
    return data;

}

void ParseXML::getMonitorPos(float (*pos)[3], const char* monitorName)
{
    TiXmlElement *search,*son; 
    TiXmlAttribute *attr;
    getNode(root, search, "component", "name", monitorName);
    int i=0;
    for(son=search->FirstChildElement();son!=NULL;son=son->NextSiblingElement())
    {
        for(attr=son->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if(0==strcmp("x",attr->Name()))
                pos[i][0]=atof(attr->Value());
            if(0==strcmp("y",attr->Name()))
                pos[i][1]=atof(attr->Value());
            if(0==strcmp("z",attr->Name()))
                pos[i][2]=atof(attr->Value());
        }
        i++;
    }
}

