#include "parseXML.h"
#include "parseNXS.h"
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream>
#include "nexus/NeXusFile.hpp"
#include <vector>

using namespace std;

void ParseNXS::getEventData(string name, uint64_t& evtNum, int64_t* pid, float* tof, uint64_t* pulse)
{
    string path = "/home/dur/work/gen_nexus/rm/tmpData/event_"+name+".dat";
    std::ifstream eventfile(path.c_str());
    string eventbuff;
    uint64_t n = 0;
    if(eventfile.is_open()){
        while(getline(eventfile, eventbuff)){
        vector<string> substring;
        boost::split(substring, eventbuff, boost::is_any_of(";"), boost::token_compress_on);
        pid[n]=atoi(substring[0].c_str());
        tof[n]=atof(substring[1].c_str());
        pulse[n]=atoi(substring[2].c_str());
        n++;
    }
    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
    eventfile.close();
    }else{
        cout<<"can't open file!"<<endl;
    }
}

void ParseNXS::getHistData(string name, uint32_t* histData)
{
    string path = "/home/dur/work/gen_nexus/rm/tmpData/hist_"+name+".dat";
    std::ifstream histfile(path.c_str());
    string histbuff;
    uint64_t n = 0;
    vector<string> substring;
    if(histfile.is_open()){
        while(getline(histfile, histbuff)){
        boost::split(substring, histbuff, boost::is_any_of(";"), boost::token_compress_on);
        for (int i = 0; i<substring.size(); i++){
            histData[n]= atoi(substring[i].c_str());
            n++;
        }
    }
    cout<<substring.size()<<";"<<n<<endl;
    histfile.close();
    }else{
        cout<<"can't open file!"<<endl;
    }
}

void ParseNXS::writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType)
{
    status=NXmakegroup(fileID,groupName,groupType);
    status=NXopengroup(fileID,groupName,groupType);
}
void ParseNXS::writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
    int dim[1] = {dataValue.size()};
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
    status=NXopendata(fileID,p);
    status=NXputdata(fileID,dataValue.c_str());
    status=NXclosedata(fileID);
}
//write slab data
void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
     char* p = (char*)dataName.data();
   status=NXmakedata(fileID, p, NX_FLOAT32, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
     char* p = (char*)dataName.data();
   status=NXmakedata(fileID, p, NX_INT64, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
     char* p = (char*)dataName.data();
   status=NXmakedata(fileID, p, NX_INT32, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

//if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParseNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParseNXS::setPublic(ParseXML new_xml)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    map<string, string> publicFromSummary=new_xml.getPublic();
    writeCharData(status, fileID, "description", publicFromSummary["description"]);
    writeCharData(status, fileID, "beamline", publicFromSummary["beamline"]);
    writeCharData(status, fileID, "start_time_utc", publicFromSummary["start_time_utc"]);
    writeCharData(status, fileID, "end_time_utc", publicFromSummary["end_time_utc"]);
    writeCharData(status, fileID, "proposal_id", publicFromSummary["proposal_id"]);
    writeCharData(status, fileID, "instrument_name", publicFromSummary["instrument_name"]);
    writeCharData(status, fileID, "start_time_tai", publicFromSummary["start_time_tai"]);
    writeCharData(status, fileID, "end_time_tai", publicFromSummary["end_time_tai"]);
    writeCharData(status, fileID, "run_no", publicFromSummary["run_no"]);
    writeCharData(status, fileID, "measurement_type", publicFromSummary["measurement_type"]);
    writeCharData(status, fileID, "version", "1.0");
    writeCharData(status, fileID, "wavelength", publicFromSummary["wavelength"]);
    writeCharData(status, fileID, "proton_charge", publicFromSummary["proton_charge"]);
    writeCharData(status, fileID, "instrument_detector_file", "filename from detector group");
    writeCharData(status, fileID, "instrument_monitor_file", "filename from monitor group");
    std::string det_definition = "";
    std::string mon_definition = "";
    fstream fileidf;
    fileidf.open("./paramData/detector.xml", std::ios::in);
    std::stringstream tmp1;
    tmp1<<fileidf.rdbuf();
    det_definition = tmp1.str();
    fileidf.close();
    //fileidf.open("./paramData/monitor.xml", std::ios::in);
    //std::stringstream tmp2;
    //tmp2<<fileidf.rdbuf();
    //mon_definition = tmp2.str();
    //fileidf.close();
    writeCharData(status, fileID, "instrument_detector_definition", det_definition);
    //writeCharData(status, fileID, "instrument_monitor_definition", mon_definition); 
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish set pub"<<endl;
}

void ParseNXS::setPresentData(const int timeBin, const int timeStep)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    int dim[1]={1};
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "present_data","NXdata");
    writeCharData(status, fileID, "plot", "TOF,intensity:intensity_error");
    writeCharData(status, fileID, "title", "Events Distribution");
    writeCharData(status, fileID, "type", "line");
    float* ptof = new float [timeBin];
    for(int i=0; i<timeBin; i++)
        ptof[i] = float(i*timeStep);
    dim[0]= timeBin;
    writeNumData(status, fileID, "TOF", ptof, 1, dim, "microsecond");
    delete [] ptof;
    uint32_t* pcounts = new uint32_t [timeBin];
    for(int i=0; i<timeBin; i++)
        pcounts[i] = i*timeStep;
    writeNumData(status, fileID, "intensity", pcounts, 1, dim, "counts");
    delete [] pcounts;
    float* perr = new float [timeBin];
    for(int i=0; i<timeBin; i++)
        perr[i] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
    dim[0]=timeBin;
    writeNumData(status, fileID, "intensity_error", perr, 1, dim, "microsecond");
    delete [] perr;
    NXclosegroup(fileID); //close present_data
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish present data"<<endl;
}

void ParseNXS::setProcess()
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
 
    writeGroup(status, fileID, "process", "NXprocess");
    writeGroup(status, fileID, "process1", "NXnote");
    writeCharData(status, fileID, "date", "2017-12-13");
    writeCharData(status, fileID, "algorithm", "drone-1.3;nexus-1.0");
    writeCharData(status, fileID, "author", "csns");
    writeCharData(status, fileID, "description", "This is data reconstruction.");
    NXclosegroup(fileID); 
    NXclosegroup(fileID); //close process
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish process"<<endl;
}

void ParseNXS::setUser()
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");

    writeGroup(status, fileID, "user", "NXuser");
    writeCharData(status, fileID, "facility_user_id", "zhangs");
    writeCharData(status, fileID, "address", "Zhongziyuan Road No.1, Dongguan, Guangdong, China");
    writeCharData(status, fileID, "email", "zhangs@126.com");
    writeCharData(status, fileID, "affiliation", "CSNS");
    writeCharData(status, fileID, "name", "S Zhang");
    writeCharData(status, fileID, "role", "principal_investigator");
    NXclosegroup(fileID); //close user
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish user"<<endl;
}

void ParseNXS::setLogs(ParseXML new_xml)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "logs", "NXcollection");
    vector<CSNSlogs> m_log = new_xml.getLogs();
    vector<string>::iterator it;
    vector<CSNSlogs>::iterator it2;
    for(it2=m_log.begin(); it2!=m_log.end(); it2++)
    {
        writeGroup(status, fileID, (*it2).name.c_str(), "NXlog");
        for(it=(*it2).filePath.begin(); it!=(*it2).filePath.end(); it++)
        {
            cout<<(*it)<<endl;
        }
        NXclosegroup(fileID);
    } 
    NXclosegroup(fileID); //close logs
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish logs"<<endl; 
    /*
    writeGroup(status, fileID, "proton_charge", "NXlog");
    for(it=m_log.proton_charge.begin(); it!=m_log.proton_charge.end(); it++){
        string filename=(*it);
        cout<<filename<<endl;
    }
    NXclosegroup(fileID);
    writeGroup(status, fileID, "sample_environment", "NXcollection");
    writeGroup(status, fileID, "temperature", "NXlog");
    for(it=m_log.sample_temperature.begin(); it!=m_log.sample_temperature.end();it++){
        string filename=(*it);
        cout<<filename<<endl;
    } 
    NXclosegroup(fileID);
    writeGroup(status, fileID, "pressure", "NXlog");
    for(it=m_log.sample_pressure.begin(); it!=m_log.sample_pressure.end();it++){
        string filename=(*it);
        cout<<filename<<endl;
    }
    NXclosegroup(fileID);
    writeGroup(status, fileID, "magnetic_field", "NXlog");
    for(it=m_log.sample_magnetic.begin(); it!=m_log.sample_magnetic.end();it++){
        string filename=(*it);
        cout<<filename<<endl;
    }
    NXclosegroup(fileID);
    writeGroup(status, fileID, "electric_field", "NXlog");
    for(it=m_log.sample_electric.begin(); it!=m_log.sample_electric.end();it++){
        string filename=(*it);
        cout<<filename<<endl;
    }
    NXclosegroup(fileID);
    NXclosegroup(fileID); //close se

    NXclosegroup(fileID);//close logs
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    */
}

void ParseNXS::setInstrument(ParseXML new_xml)
{
    cout<<"start set instrument!"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    int dim[1]={1};
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "instrument", "NXinstrument");
    writeGroup(status, fileID, "sample", "NXsample");
    CSNSsam sampleFromSummary=new_xml.getSample();
    writeCharData(status, fileID, "chemical_formula", sampleFromSummary.chemical_formula);
    writeCharData(status, fileID, "name", sampleFromSummary.name);
    writeCharData(status, fileID, "situation", sampleFromSummary.situation);
    writeCharData(status, fileID, "type", sampleFromSummary.type);    
    writeNumData(status, fileID, "density", &sampleFromSummary.density, 1, dim, "g cm-3");
    writeNumData(status, fileID, "mass", &sampleFromSummary.mass, 1, dim, "g");
    writeNumData(status, fileID, "distance", &sampleFromSummary.distance, 1, dim, "m");
    writeGroup(status, fileID, "geometry", "NXgeometry");
    writeGroup(status, fileID, "shape", "NXshape");
    writeCharData(status, fileID, "shape", sampleFromSummary.geometry.shape);
    dim[0] = 3;
    writeNumData(status, fileID, "size", sampleFromSummary.geometry.size, 1, dim, "m");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "orientation", "NXorientation");
    dim[0] = 6;
    writeNumData(status, fileID, "value", sampleFromSummary.geometry.ori, 1, dim, "");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "translation", "NXtranslation");
    dim[0] = 3;
    writeNumData(status, fileID, "distances", sampleFromSummary.geometry.distances, 1, dim, "");
    NXclosegroup(fileID);
    NXclosegroup(fileID);
    NXclosegroup(fileID);
    cout<<"finish set sample"<<endl;

    /*
    writeGroup(status, fileID, "sample_environment", "NXcollection");
    vector<CSNSse> se=new_xml.getSE();
    cout<<444<<endl;
    vector<CSNSse>::iterator it_se;
    dim[0] = 1;
    for(it_se=se.begin();it_se!=se.end();it_se++)
    {
        const char* gName=(*it_se).seName.c_str();
        writeGroup(status, fileID, gName, "NXenvironment");
        writeCharData(status,fileID,"name",(*it_se).name);
        writeCharData(status,fileID,"type",(*it_se).type);
        writeGroup(status, fileID, "electric_field", "NXcollection");
        
        writeNumData(status, fileID, "electric_field", &((*it_se).electric_field), 1, dim, "N/C");
        NXclosegroup(fileID);
        writeGroup(status, fileID, "magnetic_field", "NXcollection");
        writeNumData(status, fileID, "magnetic_field", &((*it_se).magnetic_field), 1, dim, "T");
        NXclosegroup(fileID);
        writeGroup(status, fileID, "pressure", "NXcollection");
        writeNumData(status, fileID, "pressure", &((*it_se).pressure), 1, dim, "pa");
        NXclosegroup(fileID);
        writeGroup(status, fileID, "temperature", "NXcollection");
        writeNumData(status, fileID, "temperature", &((*it_se).temperature), 1, dim, "K");
        writeNumData(status, fileID, "t2", &(*it_se).t2, 1, dim, "K");
        NXclosegroup(fileID);
        //writeGroup(status, fileID, gName, "NXnote");
        NXclosegroup(fileID);
    }
    NXclosegroup(fileID);
    cout<<555<<endl;

    vector<CSNSdc> diskChopper=new_xml.getDC();
    vector<CSNSdc>::iterator it_dc;
    for(it_dc=diskChopper.begin();it_dc!=diskChopper.end();it_dc++)
    {
        const char* gName=((*it_dc).dcName).c_str();
        writeGroup(status, fileID, gName, "NXdisk_chopper");
        dim[0]=1;
        writeNumData(status, fileID, "phase", &(*it_dc).phase, 1, dim, "degree");
        writeNumData(status, fileID, "slit_angle", &(*it_dc).slitAngle, 1, dim, "degree");
        writeNumData(status, fileID, "rotation_speed", &(*it_dc).rotationSpeed, 1, dim, "Hz");
        writeNumData(status, fileID, "distance", &(*it_dc).distance, 1, dim, "m");
        NXclosegroup(fileID);
    }

    writeGroup(status, fileID, "source", "NXsource");
    CSNSsource sourceFromSummary=new_xml.getSource();
    writeCharData(status,fileID,"name",sourceFromSummary.name);
    writeCharData(status,fileID,"type",sourceFromSummary.type);
    writeCharData(status,fileID,"probe",sourceFromSummary.probe);
    dim[0]=1;
    writeNumData(status, fileID, "frequency", &sourceFromSummary.frequency, 1, dim, "Hz");
    writeNumData(status, fileID, "power", &sourceFromSummary.power, 1, dim, "W");
    NXclosegroup(fileID);

    writeGroup(status, fileID, "moderator", "NXmoderator");
    CSNSmoderator moderatorFromSummary=new_xml.getModerator();
    writeCharData(status, fileID, "type", moderatorFromSummary.type);
    dim[0]=1;
    writeNumData(status, fileID, "distance", &moderatorFromSummary.distance, 1, dim, "m");
    writeNumData(status, fileID, "temperature", &moderatorFromSummary.temperature, 1, dim, "K");
    NXclosegroup(fileID);

    vector<CSNSaperture> aperture=new_xml.getAperture();
    vector<CSNSaperture>::iterator it_ap;
    for(it_ap=aperture.begin();it_ap!=aperture.end();it_ap++)
    {
        const char* gName=(*it_ap).apertureName.c_str();
        writeGroup(status, fileID, gName, "NXaperture");
        writeGroup(status, fileID, "geometry", "NXgeometry");
        writeGroup(status, fileID, "orientation", "NXorientation");
        dim[0]=6;
        writeNumData(status, fileID, "value", (*it_ap).geometry.ori, 1, dim, "");
        NXclosegroup(fileID);
        writeGroup(status, fileID, "shape", "NXshape");
        dim[0]=3;
        writeNumData(status, fileID, "size", (*it_ap).geometry.size, 1, dim, "m");
        const std::string shape_shape = "nxelliptical";
        writeCharData(status, fileID, "shape", (*it_ap).geometry.shape);
        NXclosegroup(fileID);
        writeGroup(status, fileID, "translation", "NXtranslation");
        dim[0]=3;
        writeNumData(status, fileID, "distances", (*it_ap).geometry.distances, 1, dim, "m");
        NXclosegroup(fileID);
        NXclosegroup(fileID);
        NXclosegroup(fileID);
    }
    */
    NXclosegroup(fileID);//close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish instrument"<<endl;
}

void ParseNXS::setPid(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid)
{
    int dim2D[2]={ypid,xpid};
    int64_t pid=int64_t(m_info["idstart"]);
    int64_t *pixelId = new int64_t [xpid*ypid];
    cout<<"idstart= "<<pid<<endl;
    for (int i=0; i<xpid*ypid;i++){
            pixelId[i]=pid;
            pid++;
        }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid, xpid};
    writeSlabData(status, fileID, "pixel_id", pixelId, dim2D, slab_start, slab_size, "");
    delete [] pixelId;
}

void ParseNXS::setTof(NXstatus status, NXhandle fileID, const int timeBin, const uint32_t timeStep)
{
    int dim[1]={0};
    uint32_t* timeOfFlight = new uint32_t [timeBin];
    for(uint32_t i=0; i<timeBin; i++)
        timeOfFlight[i]=i*timeStep;
    dim[0]=timeBin;
    writeNumData(status, fileID, "time_of_flight", timeOfFlight, 1, dim, "");
    delete [] timeOfFlight;
}

void ParseNXS::setPidSize(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid)
{
    float * x_pixel_size=new float [xpid*ypid];
    float * y_pixel_size=new float [xpid*ypid];
    float z_pixel_size=0.0005;
    for(int i=0; i<xpid*ypid; i++){
            x_pixel_size[i] = float(m_info["xstep"]);
            y_pixel_size[i] = float(m_info["ystep"]);
    }
    cout<<1111<<endl;
    int dim[1]={1};
    int dim2D[2]={ypid, xpid};
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "x_pixel_size", x_pixel_size, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "y_pixel_size", y_pixel_size, dim2D, slab_start, slab_size, "");
    writeNumData(status, fileID, "z_pixel_size", &z_pixel_size, 1, dim, "");
    delete [] x_pixel_size;
    delete [] y_pixel_size;
}

void ParseNXS::setCoordinate_module(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid)
{
    int dim2D[2]={ypid, xpid};
    float *x=new float[xpid*ypid];
    float *y=new float[xpid*ypid];
    float *z=new float[xpid*ypid];
    int num=0;
    for (int i=0; i<xpid; i++){
        for (int j=0; j<ypid;j++){
            float tmpx=float(m_info["x"])+j*float(m_info["xstep"]);
            float tmpy=float(m_info["y"])+i*float(m_info["ystep"]);
            float tmpz=float(m_info["z"]);
            z[num]= -sin(float(m_info["val"])/180*M_PI)*(tmpx-float(m_info["x"]))+tmpz;
            x[num]= float(m_info["x"]) +cos(float(m_info["val"])/180*M_PI)*(tmpx-float(m_info["x"]));
            y[num]= tmpy;
        }
        num++;
    }
    float *ra_distance=new float [xpid*ypid];
    float *az_angle=new float [xpid*ypid];
    float *po_angle=new float [xpid*ypid];
    for (int i=0; i<xpid*ypid; i++){
            ra_distance[i]= sqrt(x[i]*x[i]+y[i]*y[i]+z[i]*z[i]);
            az_angle[i]= 180/M_PI*acos(z[i]/ra_distance[i]);
            po_angle[i]= 180/M_PI*atan(y[i]/x[i]);
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "radial_distance", ra_distance, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "polar_angle", po_angle, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "azimuthal_angle", az_angle, dim2D, slab_start, slab_size, "");
    delete [] x;
    delete [] y;
    delete [] z;
    delete [] ra_distance;
    delete [] az_angle;
    delete [] po_angle;
}

void ParseNXS::setDetector(ParseXML sum_xml,ParseXML idf_xml, const int xpid, const int ypid, const int timeBin, const int timeStep)
{
    cout<<"start set detctor"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    CSNSdet det_info;
    map<string, float> m_info;
    int dim[1]={0};

    int dim2D[2]={xpid*ypid, timeBin-1};
    uint64_t evtNum=0;
    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
    //for(int i=0; i<dSize; i++){
    cout<<987<<endl;
        writeGroup(status, fileID, "module1", "NXdetector");
        det_info=sum_xml.getDetector();
        writeCharData(status, fileID, "local_name", det_info.name);
    cout<<"local name"<<endl;
        dim[0]=1;
        writeNumData(status, fileID, "distance", &det_info.distance, 1, dim, "");
        writeNumData(status, fileID, "rotate_angle", &det_info.rotateAngle, 1, dim, "");
    cout<<"distance and rotate"<<endl;

        //cout<<"detName="<<detName[i]<<endl;
        //int64_t* pid=new int64_t [999999999];
        //float* tof=new float [999999999];
        //uint64_t* pulse=new uint64_t [999999999];        
        //getEventData(detName[i], evtNum, pid, tof, pulse);
        //dim[0]= evtNum;
        //writeNumData(status, fileID, "event_pixel_id", pid, 1, dim, "");
        //writeNumData(status, fileID, "event_time_of_flight", tof, 1, dim, "");
        //writeNumData(status, fileID, "event_pulse_time", pulse, 1, dim, "");
        //cout<<"finish set evt"<<endl;
        uint32_t* histData=new uint32_t [xpid*ypid*(timeBin-1)];
        getHistData("module1", histData);
        int slab_start[2]={0,0};
        int slab_size[2]={ypid*xpid,(timeBin-1)};
        writeSlabData(status, fileID, "histogram_data",histData, dim2D,slab_start, slab_size, "");
        cout<<"finish set hist"<<endl;
        m_info=idf_xml.getModuleInfo("module01");
        setPid(status, fileID, m_info, xpid, ypid);   
        setTof(status, fileID, timeBin, timeStep);   
        setPidSize(status, fileID, m_info, xpid, ypid);
        setCoordinate_module(status, fileID, m_info, xpid, ypid);
        //delete [] pid;
        //delete [] tof;
        //delete [] pulse;
        NXclosegroup(fileID);
   // }
    NXclosegroup(fileID); //close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID); 
    cout<<"finish detector"<<endl;
}

void ParseNXS::setEventData(string dName[], const int dSize)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "event_data", "NXcollection");
    NXclosegroup(fileID);
    for(int i = 0; i < dSize; i++){
        NXlink eventPixelIdLink;
        NXlink eventPulseTimeLink;
        NXlink eventTimeOfFlightLink;
        string path ="/csns/instrument/"+dName[i];
        string pathEventPixelId = path+"/event_pixel_id";
        string pathEventPulseTime = path+"/event_pulse_time";
        string pathEventTimeOfFlight = path+"/event_time_of_flight";
        string pathEventData="/csns/event_data";
        status=NXopenpath(fileID, pathEventPixelId.c_str());
        status=NXgetdataID(fileID, &eventPixelIdLink);
        status=NXopenpath(fileID, pathEventPulseTime.c_str());
        status=NXgetdataID(fileID, &eventPulseTimeLink);
        status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &eventTimeOfFlightLink);
        status=NXopenpath(fileID, pathEventData.c_str());

        writeGroup(status, fileID, dName[i].c_str(), "NXevent_data");
        status=NXmakelink(fileID, &eventPixelIdLink);
        status=NXmakelink(fileID, &eventPulseTimeLink);
        status=NXmakelink(fileID, &eventTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close event
    }

    NXclosegroup(fileID);//close csns
    NXclose(&fileID);
    cout<<" finish event_data"<<endl;
}
void ParseNXS::setHistData()
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "histogram_data", "NXcollection");
    NXclosegroup(fileID);
        string path ="/csns/instrument/module1";
        NXlink HistTimeOfFlightLink;
        NXlink HistValueLink;
        string pathValue = path+"/histogram_data";
        string pathTimeOfFlight = path+"/time_of_flight";
        string pathHistData="/csns/histogram_data";
        status=NXopenpath(fileID, pathValue.c_str());
        status=NXgetdataID(fileID, &HistValueLink);
        status=NXopenpath(fileID, pathTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &HistTimeOfFlightLink);
        status=NXopenpath(fileID, pathHistData.c_str());

        writeGroup(status, fileID, "module1", "NXdata");
        status=NXmakelink(fileID, &HistValueLink);
        status=NXmakelink(fileID, &HistTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close hist
    NXclosegroup(fileID);//clsoe csns
    NXclose(&fileID);

    cout<<" finish histogram_data"<<endl;
}

