#include<iostream>
#include<vector>
#include<tinyxml.h>
#include<boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <fstream>
#include "nexus/NeXusFile.hpp"
#include <map>
#include "parseXML.h"
#include "parseNXS.h"
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <typeinfo>
#include <dirent.h>


using namespace std;
int dim[1]={0};
const uint32_t TIME_BIN = 2501;
const uint32_t TIME_STEP = 16;
const int XPID=300;
const int YPID=4;
//const int XPID_M=32;
//const int YPID_M=32;

void SaveNexusFile(string nxsfilename, string sumfilename, string ddffilename)
{
    ParseXML sumXML(sumfilename);
    ParseXML ddfXML(ddffilename);
    //ParseXML mdfXML(mdffilename);
    ParseNXS m_nxs(nxsfilename);

    NXaccess mode(NXACC_CREATE5);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfilename.c_str(), mode, &fileID);
    status=NXmakegroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"csns","NXentry");
    /*
    //test
    cout<<"start test"<<endl;
    int array_dims[2]={5,4};
    int *r8_array = new int [20];
    int num=1;
//    int r8_array[20];
    for (int i = 0; i < 20; i++) {
        r8_array[i]=num;
        num++;
        cout<<r8_array[i]<<endl;
        }
    status=NXmakegroup(fileID,"test","NXdata");
    status=NXopengroup(fileID,"test","NXdata");

    status=NXmakedata(fileID, "data", NX_INT32, 2, array_dims);
    status=NXopendata(fileID, "data");
    int slab_start[2];
     slab_start[0]=0;
     slab_start[1]=0;
    int slab_size[2];
    slab_size[0]=4;
    slab_size[1]=4;
    status=NXputslab(fileID, &(r8_array[0]), slab_start, slab_size);
  //slab_start[0] = 0;
  //slab_start[1] = 0;
  //slab_size[0]=4;
  //slab_size[1]=4;
  //status=NXputslab(fileID, &(r8_array[0]), slab_start, slab_size);
    status=NXclosedata(fileID);
    NXclosegroup(fileID);
*/
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);

    m_nxs.setPublic(sumXML);
   // m_nxs.setPresentData(10000,4);
    //m_nxs.setUser();
    //m_nxs.setProcess();
    //m_nxs.setLogs(sumXML);

    m_nxs.setInstrument(sumXML);
    m_nxs.setDetector(sumXML, ddfXML, XPID, YPID, TIME_BIN, TIME_STEP);

    //m_nxs.setEventData(dName, dSize);
    m_nxs.setHistData();
}

int main(int argc, char *argv[])
{
    if(argc<=1)
    {
        printf("Usage:%s runNumber prepath\n", argv[0]);
        return 0;
    }
    string runno=argv[1];
    //string prepath= argv[2];
    string prepath = "/home/dur/work/gen_nexus/rm";

    //string filepath="/opt/CSNSDATA/TS1/BL02/Control/"+runno;
    string filepath="/home/dur/work/gen_nexus/rm/Control/"+runno;
    string sumfile="";
    DIR *dirp;
    struct dirent *dp;
    dirp=opendir(filepath.c_str());
    while((dp = readdir(dirp))!=NULL)
    {
    string name = dp->d_name;
    if(name.size()>6)
    {    int iPos = name.find_last_of(".");
         if(name.substr(iPos)==".xml")
        {
        sumfile=filepath+"/"+name;
        cout<<"sum file is: "<<sumfile<<endl;
        break;
        }else{continue;}
    }
    } 
    //string nxsfile=prepath+"/"+runno+"/detector.nxs";
    string nxsfile=prepath+"/rm_template.nxs";
    string ddffile=prepath+"/paramData/detector.xml";
    //const int dSize = 1;
    //string dName[dSize]={"module1"};
    SaveNexusFile(nxsfile, sumfile, ddffile);    
    cout<<"finish"<<endl;
    
    return 0;
}

