#ifndef IncPARSEXML
#define IncPARSEXML

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
using namespace std;

struct CSNSgeometry{
        float ori[6];
        string shape;
        float size[3];
        float distances[3];
};

struct CSNSse{
        string seName;
        string name;
        string type;
        float pressure;
        float temperature;
        float t2;
        float magnetic_field;
        float electric_field;
};

struct CSNSsam{
        string chemical_formula;
        string name;
        string type;
        string situation;
        float distance;
        float density;
        float mass;
        CSNSgeometry geometry;
};

struct CSNSsource{
        string name;
        string type;
        string probe;
        float frequency;
        float power;
};

struct CSNSmoderator{
        string type;
        float distance;
        float temperature;
};

struct CSNSbs{
        CSNSgeometry geometry;
        float distance[3];
        string status;
};

struct CSNSaperture{
        string apertureName;
        CSNSgeometry geometry;
};

struct CSNSdc{
        string dcName;
        float phase;
        float slitAngle;
        float distance;
        float rotationSpeed;
};

struct CSNSlogs{
        string name;
        vector<string> filePath;
};

struct CSNSdet{
        string name;
        float distance;
        float rotateAngle;
};


class ParseXML {
    public:

        ParseXML(string filename)
        {
            TiXmlDocument *doc=new TiXmlDocument(filename.c_str());
            doc->LoadFile();
            if (doc==NULL)
                cout<<"error: no such xml file!"<<endl;
            else
                root=doc->RootElement();       
                cout<<"doc: "<<doc<<" root: "<<root->Value()<<endl;
        }

       // ~ParseXML();
        //Config(string configFile, char** envp = 0);
        //~Config();
        map<string, string> getPublic();
        CSNSsam getSample();
        CSNSsource getSource();
        CSNSmoderator getModerator();
        vector<CSNSse> getSE();
        CSNSbs getBS();
        vector<CSNSaperture> getAperture();
        vector<CSNSdc> getDC();
        vector<CSNSlogs> getLogs();
        vector<string> getBankName();
        CSNSdet getDetector();
        map<string, float> getModuleInfo(const char* moduleName);
        void getMonitorPos(float (*pos)[3], const char* monitorName);
        map<string, float> getMonitorInfo(const char* idName);
        void setBankInfo(const char* bankName, float distance[], int64_t* pid, float* r, float* theta, float* phi);
    private:
        TiXmlElement *root;
        // private constructor for sub groups
        //Config(string name, string parentDebugInfo);
        //get node point by special name and attr 
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode, const char* nodeName);
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode,const char* nodeName, const char* attrName, const char* attrValue);
        //int getNodeNum(TiXmlElement *root, const char* nodeName, TiXmlElement * &destNode);

        CSNSgeometry getGeometry(TiXmlElement *node);
        void getDistance(TiXmlElement *node, float distance[]);
};

#endif
