#ifndef IncPARSENXS
#define IncPARSENXS

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
#include "nexus/NeXusFile.hpp"

using namespace std;
/*
struct evtMode{
    string name;
    uint64_t evtNum;
    int64_t* pid;
    float* tof;
    uint64_t* pulse;
};
struct histMode{
    string name;
    uint32_t **array ;
};
*/

class ParseNXS {
    public:
        ParseNXS(string filepath)
        { nxsfile = filepath;}
        void getEventData(string filename,uint64_t& evtNum, int64_t* pid, float* tof, uint64_t* pulse);  // now this is just for single module
        void getHistData(string filename, uint32_t* histData);  // now this is just for single monitor
        void setPublic(ParseXML new_xml); // from summary xml file
        void setUser(); //set default value
        void setProcess(); // set default value
        void setPresentData(const int timeBin, const int timeStep); // set random value
        //void setHistData(string dName[], const int dSize); //set link for all module or monitor
        void setHistData(); //set link for all module or monitor
        void setEventData(string dName[], const int dSize); //set link for all module or monitor
        void setLogs(ParseXML new_xml);//unfinished, no log file!
        //void setData(string name);
        void setInstrument(ParseXML new_xml);//include sample, SE, DC, source, moderator, apeture
        //void setDetector(ParseXML sum_xml, ParseXML idf_xml, const string detName[],const int dSize, const int xpid, const int ypid, const int timeBin, const int timeStep);
        void setDetector(ParseXML sum_xml, ParseXML idf_xml, const int xpid, const int ypid, const int timeBin, const int timeStep);
        void setPid(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid);
        void setTof(NXstatus status, NXhandle fileID, const int timeBin, const uint32_t timeStep);
        void setHist_module(NXstatus status, NXhandle fileID, uint64_t evtNum,const int64_t* pid, const float* tof, string detName, const int xpid, const int ypid, const int timeBin);
        void setPidSize(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid);
        void setCoordinate_module(NXstatus status, NXhandle fileID, map<string, float> m_info, const int xpid, const int ypid);

    private:
        string nxsfile;
        void writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType);
        void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text);
        void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        void writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text);
        

};

#endif
