#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2018.3.7
LILI YAN
'''
from multiprocessing import Pool
from conf.constants import *
import json
#from json import *
import atexit
import xml.etree.ElementTree as ET
from xml.dom import minidom
from canvas import *
import reduction
import subprocess
import math

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):
        _loadWidth=80
        _fileWidth=200

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)
        self.scrollArea2.setMinimumHeight(150)

        self.third = QtGui.QFrame(self)
        self.third.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea3 = QtGui.QScrollArea()
        self.scrollArea3.setWidgetResizable(True)
        self.scrollArea3.setWidget(self.third)
        self.scrollArea3.setMinimumHeight(150)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([600, 500])

        self.splitterH = QtGui.QSplitter(QtCore.Qt.Vertical, self)
        self.splitterH.addWidget(self.splitter)
        self.splitterH.addWidget(self.scrollArea3)
        self.splitterH.setSizes([500, 200])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)
        self.thirdGrid = QtGui.QGridLayout(self.third)

        self.settingText = QtGui.QLabel('Settings: ',self.first)

        #self.roiButton = QtGui.QPushButton('Find ROI')
        #self.roiButton.setMaximumHeight(30)
        #self.roiButton.setMaximumWidth(_fileWidth)
        #self.roiButton.clicked.connect(self.findROI)

        self.okButton = QtGui.QPushButton('Do Reduction')
        self.okButton.setMaximumHeight(30)
        self.okButton.setMaximumWidth(_fileWidth)
        self.okButton.clicked.connect(self.startReduction)

        self.defaultButton = QtGui.QPushButton('Default')
        self.defaultButton.setMaximumHeight(30)
        self.defaultButton.setMaximumWidth(_fileWidth)
        self.defaultButton.clicked.connect(self.setDefault)

        self.loadButton = QtGui.QPushButton('Load')
        self.loadButton.setMaximumHeight(30)
        self.loadButton.setMaximumWidth(_fileWidth)
        self.loadButton.clicked.connect(self.loadSetting)

        self.logo = QtGui.QLabel(self.first)
        self.logo.setPixmap(QtGui.QPixmap("img/csns.png").scaledToHeight(64))

        self.line1=QtGui.QFrame(self.first)
        self.line1.setGeometry(QtCore.QRect())
        self.line1.setFrameShape(QtGui.QFrame.HLine)
        self.line1.setFrameShadow(QtGui.QFrame.Sunken)

        self.line2=QtGui.QFrame(self.first)
        self.line2.setGeometry(QtCore.QRect())
        self.line2.setFrameShape(QtGui.QFrame.HLine)
        self.line2.setFrameShadow(QtGui.QFrame.Sunken)

        self.line3=QtGui.QFrame(self.first)
        self.line3.setGeometry(QtCore.QRect())
        self.line3.setFrameShape(QtGui.QFrame.HLine)
        self.line3.setFrameShadow(QtGui.QFrame.Sunken)

        self.sample = QtGui.QLabel('Sample Run:',self.first)
        self.sample.setMaximumHeight(30)
        self.sampleText = QtGui.QTextEdit('') 
        self.sampleText.setMaximumHeight(31)
        self.sampleLoad = QtGui.QPushButton('Load') 
        self.sampleLoad.setMaximumHeight(30)
        self.sampleLoad.setMaximumWidth(_loadWidth)
        self.sampleLoad.clicked.connect(self.sampleLoadFile)

        self.direct = QtGui.QLabel('Direct Run:',self.first)
        self.direct.setMaximumHeight(30)
        self.directText = QtGui.QTextEdit('') 
        self.directText.setMaximumHeight(31)
        self.directLoad = QtGui.QPushButton('Load') 
        self.directLoad.setMaximumHeight(30)
        self.directLoad.setMaximumWidth(_loadWidth)
        self.directLoad.clicked.connect(self.directLoadFile)

        self.l2 = QtGui.QLabel('Sample-to-Detector:',self.first)
        self.l2Text = QtGui.QTextEdit('2.09')
        self.l2Text.setMaximumHeight(31)

        self.angle = QtGui.QLabel('Detector Angle:',self.first)
        self.angleText = QtGui.QTextEdit('0.5')
        self.angleText.setMaximumHeight(31)

        self.pcSample = QtGui.QLabel('    Proton Current:',self.first)
        self.pcSampleText = QtGui.QTextEdit('')
        self.pcSampleText.setMaximumHeight(31)

        self.pcDir = QtGui.QLabel('    Proton Current:',self.first)
        self.pcDirText = QtGui.QTextEdit('')
        self.pcDirText.setMaximumHeight(31)
        
        self.roiMinLabel = QtGui.QLabel('Begin:',self.first)
        self.roiMaxLabel = QtGui.QLabel('End:',self.first)
        
        self.refROI = QtGui.QLabel('Reflection ROI:',self.first)
        self.refROIMinText = QtGui.QTextEdit('137') 
        self.refROIMinText.setMaximumHeight(31)
        self.refROIMaxText = QtGui.QTextEdit('154') 
        self.refROIMaxText.setMaximumHeight(31)
        
        self.refBgROI = QtGui.QLabel('Background ROI:',self.first)
        self.refBgROIMinText = QtGui.QTextEdit('73') 
        self.refBgROIMinText.setMaximumHeight(31)
        self.refBgROIMaxText = QtGui.QTextEdit('90') 
        self.refBgROIMaxText.setMaximumHeight(31)
        
        self.dirROI = QtGui.QLabel('Direct ROI:',self.first)
        self.dirROIMinText = QtGui.QTextEdit('137') 
        self.dirROIMinText.setMaximumHeight(31)
        self.dirROIMaxText = QtGui.QTextEdit('154') 
        self.dirROIMaxText.setMaximumHeight(31)
        
        self.dirBgROI = QtGui.QLabel('Background ROI:',self.first)
        self.dirBgROIMinText = QtGui.QTextEdit('73') 
        self.dirBgROIMinText.setMaximumHeight(31)
        self.dirBgROIMaxText = QtGui.QTextEdit('90') 
        self.dirBgROIMaxText.setMaximumHeight(31)
        
        self.minLabel = QtGui.QLabel('Min:',self.first)
        self.binLabel = QtGui.QLabel('Bin:',self.first)
        self.maxLabel = QtGui.QLabel('Max:',self.first)
        
        self.wavelength = QtGui.QLabel('Wavelength:',self.first)
        self.wavelengthMinText = QtGui.QTextEdit('1.8') 
        self.wavelengthMinText.setMaximumHeight(31)
        self.wavelengthMaxText = QtGui.QTextEdit('6.8') 
        self.wavelengthMaxText.setMaximumHeight(31)
        
        self.q = QtGui.QLabel('Q Range:',self.first)
        self.qMinText = QtGui.QTextEdit('0.001') 
        self.qMinText.setMaximumHeight(31)
        self.qBinText = QtGui.QTextEdit('0.0004') 
        self.qBinText.setMaximumHeight(31)
        self.qMaxText = QtGui.QTextEdit('0.15') 
        self.qMaxText.setMaximumHeight(31)

        self.qMerge = QtGui.QLabel('Merge Q Params:',self.first)
        self.qMergeMinText = QtGui.QTextEdit('0.001') 
        self.qMergeMinText.setMaximumHeight(31)
        self.qMergeBinText = QtGui.QTextEdit('0.0004') 
        self.qMergeBinText.setMaximumHeight(31)
        self.qMergeMaxText = QtGui.QTextEdit('0.15') 
        self.qMergeMaxText.setMaximumHeight(31)

        self.xmlFile = QtGui.QLabel('File Path:',self.first)
        self.xmlFile.setMaximumHeight(30)
        self.xmlFileText = QtGui.QTextEdit('') 
        self.xmlFileText.setMaximumHeight(31)
        self.xmlFileLoad = QtGui.QPushButton('Load') 
        self.xmlFileLoad.setMaximumHeight(30)
        self.xmlFileLoad.setMaximumWidth(_loadWidth)
        self.xmlFileLoad.clicked.connect(self.xmlFileLoadFile)
        
        self.tubeCombo = QtGui.QComboBox(self.second)
        self.tubeCombo.addItem('tube 1')
        self.tubeCombo.addItem('tube 2')
        self.tubeCombo.addItem('tube 3')
        self.tubeCombo.addItem('tube 4')
        self.tubeCombo.setMaximumWidth(150)
        self.tubeCombo.activated.connect(self.tubeComboChange)
        self.tubeCombo.setCurrentIndex(1)

        self.comboBox = QtGui.QComboBox(self.second)
        self.comboBox.addItem('sample_IQ')
        self.comboBox.addItem('direct_wavelength')
        self.comboBox.addItem('RQ')
        self.comboBox.addItem('ROI')
        self.comboBox.setMaximumWidth(150)
        self.comboBox.activated.connect(self.comboBoxChange)

        self.logcomboBox = QtGui.QComboBox(self.second)
        self.logcomboBox.addItem('linear')
        self.logcomboBox.addItem('log')
        self.logcomboBox.activated.connect(self.logcomboBoxChange)

        self.canvas = zoomCanvas(
            self,
            16,
            8,
            150,
            '',
            '',
            '',
            '',
            )
        self.canvas.setMinimumHeight(100)
        self.refPeakLabel = QtGui.QLabel('',self.second)
        self.refFwhmLabel = QtGui.QLabel('',self.second)
        self.dirPeakLabel = QtGui.QLabel('',self.second)
        self.dirFwhmLabel = QtGui.QLabel('',self.second)
        
        self.addButton = QtGui.QPushButton('Add and Find ROI')
        self.addButton.setMaximumHeight(30)
        self.addButton.clicked.connect(self.findROI)#addLine)
        self.addBlankButton = QtGui.QPushButton('+')
        self.addBlankButton.setMaximumHeight(30)
        self.addBlankButton.clicked.connect(self.addBlankLine)
        self.removeButton = QtGui.QPushButton('-')
        self.removeButton.setMaximumHeight(30)
        self.removeButton.clicked.connect(self.removeLine)

        self.tableData = TableData(self)
        self.tableData.setMinimumHeight(150)
        self.tableData.itemChanged.connect(self.itemChange)
        self.tableData.itemSelectionChanged.connect(self.itemChange)
        self.tableData.cellChanged.connect(self.checkChange)
        
        _nline = 0
        self.firstGrid.addWidget(self.logo, _nline, 0, 1, 4 , QtCore.Qt.AlignCenter)

        _nline+=1
        self.firstGrid.addWidget(self.settingText, _nline, 0, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.defaultButton, _nline, 1, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.loadButton, _nline, 2, 1,1 , QtCore.Qt.AlignLeft)
        #self.firstGrid.addWidget(self.roiButton, _nline, 3, 1,1 , QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.okButton, _nline, 4, 1,2 , QtCore.Qt.AlignCenter)
        
        _nline+=1
        self.firstGrid.addWidget(self.line1, _nline, 0, 1, 4)

        _nline+=1
        self.firstGrid.addWidget(self.sample, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.sampleText, _nline, 1, 1, 3)
        self.firstGrid.addWidget(self.sampleLoad, _nline, 4, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.pcSample, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.pcSampleText, _nline, 1, 1, 1)
        
        _nline += 1
        self.firstGrid.addWidget(self.direct, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.directText, _nline, 1, 1, 3)
        self.firstGrid.addWidget(self.directLoad, _nline, 4, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.pcDir, _nline, 0, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.pcDirText, _nline, 1, 1, 1)

        _nline+=1
        self.firstGrid.addWidget(self.line2, _nline, 0, 1,4)

        _nline += 1
        self.firstGrid.addWidget(self.roiMinLabel, _nline, 1, 1, 1, QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.roiMaxLabel, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.refROI, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.refROIMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.refROIMaxText, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.refBgROI, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.refBgROIMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.refBgROIMaxText, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.dirROI, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.dirROIMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.dirROIMaxText, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.dirBgROI, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.dirBgROIMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.dirBgROIMaxText, _nline, 2, 1, 1)
   
        _nline+=1
        self.firstGrid.addWidget(self.line3, _nline, 0, 1,4)
 
        _nline += 1
        self.firstGrid.addWidget(self.l2, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.l2Text, _nline, 1, 1, 1)
       
        _nline += 1
        self.firstGrid.addWidget(self.angle, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.angleText, _nline, 1, 1, 1)
         
        _nline += 1
        self.firstGrid.addWidget(self.minLabel, _nline, 1, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.binLabel, _nline, 2, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.maxLabel, _nline, 3, 1, 1, QtCore.Qt.AlignCenter)
        
        _nline += 1
        self.firstGrid.addWidget(self.wavelength, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMaxText, _nline, 3, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.q, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.qMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.qBinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.qMaxText, _nline, 3, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.qMerge, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.qMergeMinText, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.qMergeBinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.qMergeMaxText, _nline, 3, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.xmlFile, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.xmlFileText, _nline, 1, 1, 3)
        self.firstGrid.addWidget(self.xmlFileLoad, _nline, 4, 1, 1)
        _nline = 0
        self.secondGrid.addWidget(self.tubeCombo, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.comboBox, _nline, 1, 1, 1, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.logcomboBox, _nline, 2, 1, 1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.secondGrid.addWidget(self.canvas, _nline, 0, 1, 3, QtCore.Qt.AlignCenter)
        _nline += 1
        self.secondGrid.addWidget(self.refPeakLabel, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.dirPeakLabel, _nline, 1, 1, 1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.secondGrid.addWidget(self.refFwhmLabel, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)
        self.secondGrid.addWidget(self.dirFwhmLabel, _nline, 1, 1, 1, QtCore.Qt.AlignCenter)
        _nline = 0
        self.thirdGrid.addWidget(self.addButton, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)
        self.thirdGrid.addWidget(self.addBlankButton, _nline, 1, 1, 1, QtCore.Qt.AlignCenter)
        self.thirdGrid.addWidget(self.removeButton, _nline, 2, 1, 1, QtCore.Qt.AlignCenter)
        _nline += 1
        self.thirdGrid.addWidget(self.tableData, _nline, 0, 1,8)#, QtCore.Qt.AlignCenter)

        self.setCentralWidget(self.splitterH)
        self.loadConfigure()
        self.setConfigure()

        self.mainWidth = 0
        self.mainHeight = 0

        #self.comboBoxChange()
        self.canvas.ax.clear()
        self.canvas.draw()
 
    def checkChange(self): 
        index = self.comboBox.currentIndex()
        _row = int(self.tableData.rowCount())
        self.canvas.ax.clear()
        for i in range(_row):
            if self.tableData.item(i, 0).checkState() == QtCore.Qt.Checked:
                if index == 0:
                    _filename = './sam_raw_'+str(i)+'.dat'
                elif index == 1:
                    _filename = './dir_raw_'+str(i)+'.dat'
                elif index == 2:
                    _filename = './RQ_'+str(i)+'.dat'

                try:
                    _x, _y, _e = self.readData(_filename)
                except:
                    pass
                try:
                    self.updateCanvas(_x, _y, _e)
                except:
                    self.canvas.ax.clear()
        self.canvas.ax.relim()
        self.canvas.ax.autoscale_view()
        self.canvas.draw() 
    
    def itemChange(self):
        try:
            _item = 0
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.sampleText.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.pcSampleText.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            _range = _text.split('-')
            self.refROIMinText.setText(str(_range[0]))
            self.refROIMaxText.setText(str(_range[1]))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            _range = _text.split('-')
            self.refBgROIMinText.setText(str(_range[0]))
            self.refBgROIMaxText.setText(str(_range[1]))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.angleText.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.l2Text.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.directText.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            self.pcDirText.setText(str(_text))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            _range = _text.split('-')
            self.dirROIMinText.setText(str(_range[0]))
            self.dirROIMaxText.setText(str(_range[1]))
            _item += 1
            _text = self.tableData.item(self.tableData.currentRow(), _item).text()
            _range = _text.split('-')
            self.dirBgROIMinText.setText(str(_range[0]))
            self.dirBgROIMaxText.setText(str(_range[1]))
        except:
            pass

    def addBlankLine(self):
        _row = int(self.tableData.rowCount())
        self.tableData.insertRow(_row)
        #self.tableData.setCellWidget(_row, 0, QtGui.QCheckBox())
        _checkBox = QtGui.QTableWidgetItem()
        _checkBox.setCheckState(QtCore.Qt.Unchecked)
        self.tableData.setItem(_row, 0, _checkBox)
        #self.tableData.item(_row, 0).setCheckState(QtCore.Qt.Unchecked)

    def addLine(self):
        _data = None
        _result = self.checkValue()
        if _result:
            for _row in range(int(self.tableData.rowCount())):
                if _row == int(self.tableData.rowCount())-1:
                    self.tableData.insertRow(_row)
                    _checkBox = QtGui.QTableWidgetItem()
                    _checkBox.setCheckState(QtCore.Qt.Unchecked)
                    self.tableData.setItem(_row, 0, _checkBox)
                    #self.tableData.item(_row, 0).setCheckState(QtCore.Qt.Unchecked)
                
                _data = self.tableData.item(_row, 2)
                if _data is None:
                    _item = 0
                    _checkBox = QtGui.QTableWidgetItem()
                    _checkBox.setCheckState(QtCore.Qt.Unchecked)
                    self.tableData.setItem(_row, _item, _checkBox)
                    #self.tableData.item(_row, 0).setCheckState(QtCore.Qt.Unchecked)
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.sampleText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.pcSampleText.toPlainText())))
                    _item += 1
                    _roi = str(self.refROIMinText.toPlainText())+'-'+str(self.refROIMaxText.toPlainText())
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    _item += 1
                    _roi = str(self.refBgROIMinText.toPlainText())+'-'+str(self.refBgROIMaxText.toPlainText())
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.angleText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.l2Text.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.directText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.pcDirText.toPlainText())))
                    _item += 1
                    _roi = str(self.dirROIMinText.toPlainText())+'-'+str(self.dirROIMaxText.toPlainText())
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    _item += 1
                    _roi = str(self.dirBgROIMinText.toPlainText())+'-'+str(self.dirBgROIMaxText.toPlainText())
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    break
                else:
                    pass

    def removeLine(self):
        if int(self.tableData.rowCount()) != 1:
            rmRow = self.tableData.currentIndex().row()
            self.tableData.removeRow(rmRow)
        else:
            pass

    def setDefault(self):
        self.refROIMinText.setText('137')
        self.refROIMaxText.setText('154')
        self.refBgROIMinText.setText('73')
        self.refBgROIMaxText.setText('94')
        
        self.dirROIMinText.setText('137')
        self.dirROIMaxText.setText('154')
        self.dirBgROIMinText.setText('73')
        self.dirBgROIMaxText.setText('94')
        
        self.l2Text.setText('2.09')
        self.angleText.setText('0.0')
        self.wavelengthMinText.setText('1.8')
        self.wavelengthMaxText.setText('6.8')
        self.qMinText.setText('0.001')
        self.qBinText.setText('0.0004')
        self.qMaxText.setText('0.15')

    def loadSetting(self):
        fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load Setting', './configure.xml')
        configure = self.readXml(fileName[0])
        self.setSetting(configure)

    def getFilePath(self, _file):
        _path=""
        try:
            _path=os.path.dirname(_file)
        except:
            _path=""

        return _path

    def setSetting(self, configure):
        _merge = []
        _sample = []
        _pcSample = []
        _roiSample = []
        _roiBgSample = []
        _angle = []
        _l2 = []
        _direct = []
        _pcDirect = []
        _roiDirect = []
        _roiBgDirect = []
        _qRange = []
        _min = []
        _bin = []
        _max = []
        _overlaps = []
        
        _merge = [s.strip() for s in configure['Merge'][1:-1].split(',')]
        _sample = [s.strip() for s in configure['Sample'][1:-1].split(',')]
        _pcSample = [s.strip() for s in configure['sample_PC'][1:-1].split(',')]
        _min = [s.strip() for s in configure['refRoiStart'][1:-1].split(',')]
        _max = [s.strip() for s in configure['refRoiEnd'][1:-1].split(',')]
        for i in range(len(_min)):
            _roiSample.append(str(_min[i])+'-'+str(_max[i]))
        _min = [s.strip() for s in configure['refBgRoiStart'][1:-1].split(',')]
        _max = [s.strip() for s in configure['refBgRoiEnd'][1:-1].split(',')]
        for i in range(len(_min)):
            _roiBgSample.append(str(_min[i])+'-'+str(_max[i]))
        _angle = [s.strip() for s in configure['rotateAngle'][1:-1].split(',')]
        _l2 = [s.strip() for s in configure['L2'][1:-1].split(',')]
        _direct = [s.strip() for s in configure['Direct'][1:-1].split(',')]
        _pcDirect = [s.strip() for s in configure['direct_PC'][1:-1].split(',')]
        _min = [s.strip() for s in configure['dirRoiStart'][1:-1].split(',')]
        _max = [s.strip() for s in configure['dirRoiEnd'][1:-1].split(',')]
        for i in range(len(_min)):
            _roiDirect.append(str(_min[i])+'-'+str(_max[i]))
        _min = [s.strip() for s in configure['dirBgRoiStart'][1:-1].split(',')]
        _max = [s.strip() for s in configure['dirBgRoiEnd'][1:-1].split(',')]
        for i in range(len(_min)):
            _roiBgDirect.append(str(_min[i])+'-'+str(_max[i]))
        _min = [s.strip() for s in configure['qMin'][1:-1].split(',')]
        _bin = [s.strip() for s in configure['qBin'][1:-1].split(',')]
        _max = [s.strip() for s in configure['qMax'][1:-1].split(',')]
        for i in range(len(_min)):
            _qRange.append(str(_min[i])+'-'+str(_bin[i])+'-'+str(_max[i]))
        
        _overlaps = [s.strip() for s in configure['Overlaps'][1:-1].split(',')]
        
        self.wavelengthMinText.setText(configure['wMin'])
        self.wavelengthMaxText.setText(configure['wMax'])
        self.qMinText.setText(configure['qMin'])
        self.qBinText.setText(configure['qBin'])
        self.qMaxText.setText(configure['qMax'])
        self.qMergeMinText.setText(configure['qMergeMin'])
        self.qMergeBinText.setText(configure['qMergeBin'])
        self.qMergeMaxText.setText(configure['qMergeMax'])
        self.xmlFileText.setText(configure['filePath'])

        _tube = int(configure['tube'][-1])
        self.tubeCombo.setCurrentIndex(_tube)

        for _row in range(len(_sample)):
            if _row == int(self.tableData.rowCount())-1:
                self.tableData.insertRow(_row)
                _checkBox = QtGui.QTableWidgetItem()
                _checkBox.setCheckState(QtCore.Qt.Unchecked)
                self.tableData.setItem(_row, 0, _checkBox)

            _item = 0
            if int(_merge[_row]) == 1:
                self.tableData.item(_row, _item).setCheckState(QtCore.Qt.Checked)
            else:
                self.tableData.item(_row, _item).setCheckState(QtCore.Qt.Unchecked)
            _item += 1
            if _sample[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_sample[_row])))
            _item += 1
            if _pcSample[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_pcSample[_row])))
            _item += 1
            if _roiSample[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_roiSample[_row])))
            _item += 1
            if _roiBgSample[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_roiBgSample[_row])))
            _item += 1
            if _angle[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_angle[_row])))
            _item += 1
            if _l2[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_l2[_row])))
            _item += 1
            if _direct[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_direct[_row])))
            _item += 1
            if _pcDirect[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_pcDirect[_row])))
            _item += 1
            if _roiDirect[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_roiDirect[_row])))
            _item += 1
            if _roiBgDirect[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_roiBgDirect[_row])))
            _item += 1
            if _qRange[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_qRange[_row])))
            _item += 1
            if _overlaps[_row] == "''":
                pass
            else:
                self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(_overlaps[_row])))

    def sampleLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.sampleText.setText(fileName)
    
    def xmlFileLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.xmlFileText.setText(fileName)

    def directLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.directText.setText(fileName)

    def findROI(self):
        _data = None
        if self.sampleText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Sample Run can not be empty.", QtGui.QMessageBox.Yes)
        elif self.directText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Direct Run can not be empty.", QtGui.QMessageBox.Yes)
        else:
            self.canvas.ax.clear()
            self.canvas.draw()
            refRun = str(self.sampleText.toPlainText())
            dirRun = str(self.directText.toPlainText())
            tube = str(self.tubeComboChange())
            print refRun, dirRun
            self.addButton.setEnabled(False)
            roiJudge=reduction.FindROI(refRun, dirRun, tube)
            self.addButton.setEnabled(True)
            _filename1 = './ref_roi.dat'
            _filename2 = './dir_roi.dat'
            try:
                _x1, _y1, _e = self.readData(_filename1)
                _x2, _y2, _e = self.readData(_filename2)
            except:
                pass
            try:
                self.drawCanvas(_x1,_y1,_x2,_y2)
            except:
                self.canvas.ax.clear()

            try:
                _cy1, self.popt1 = self.curveFit(_x1, _y1)
                self.canvas.ax.plot(_x1, _cy1, 'r') 
            except:
                pass
            try:
                _cy2, self.popt2 = self.curveFit(_x2, _y2)
                self.canvas.ax.plot(_x2, _cy2, 'b') 
            except:
                pass
            try:
                self.refPeakLabel.setText('Reflection Peak:' + format(self.popt1[0], '.2f'))
                self.refFwhmLabel.setText('Reflection FWHM:' + format(abs(self.popt1[2]) * 2.3548, '.2f'))
                self.dirPeakLabel.setText('Direct Peak:' + format(self.popt2[0], '.2f'))
                self.dirFwhmLabel.setText('Direct FWHM:' + format(abs(self.popt2[2]) * 2.3548, '.2f'))
            
                if self.popt1[0]<150:
                    self.refBgRoiMin=self.popt1[0]+abs(self.popt1[2])
                    self.refBgRoiMax=self.popt1[0]+abs(self.popt1[2])*2
                else:
                    self.refBgRoiMin=self.popt1[0]-abs(self.popt1[2])*2
                    self.refBgRoiMax=self.popt1[0]-abs(self.popt1[2])
                self.refRoiMin=self.popt1[0]-abs(self.popt1[2])   
                self.refRoiMax=self.popt1[0]+abs(self.popt1[2]) 
     
                if self.popt2[0]<150:
                    self.dirBgRoiMin=self.popt2[0]+abs(self.popt2[2])
                    self.dirBgRoiMax=self.popt2[0]+abs(self.popt2[2])*2
                else:
                    self.dirBgRoiMin=self.popt2[0]-abs(self.popt2[2])*2
                    self.dirBgRoiMax=self.popt2[0]-abs(self.popt2[2])
                self.dirRoiMin=self.popt2[0]-abs(self.popt2[2])   
                self.dirRoiMax=self.popt2[0]+abs(self.popt2[2])  
            except:
                pass
 
            self.canvas.ax.relim()
            self.canvas.ax.autoscale_view()
            self.canvas.draw()

            self.comboBox.setCurrentIndex(3)

            for _row in range(int(self.tableData.rowCount())):
                self.tableData.setCurrentCell(int(self.tableData.rowCount()),1)
                if _row == int(self.tableData.rowCount())-1:
                    self.tableData.insertRow(_row)
                    _checkBox = QtGui.QTableWidgetItem()
                    _checkBox.setCheckState(QtCore.Qt.Unchecked)
                    self.tableData.setItem(_row, 0, _checkBox)
                    #self.tableData.item(_row, 0).setCheckState(QtCore.Qt.Unchecked)

                _data = self.tableData.item(_row, 2)
                if _data is None:
                    _item = 0
                    _checkBox = QtGui.QTableWidgetItem()
                    _checkBox.setCheckState(QtCore.Qt.Unchecked)
                    self.tableData.setItem(_row, _item, _checkBox)
                    #self.tableData.item(_row, 0).setCheckState(QtCore.Qt.Unchecked)
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.sampleText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.pcSampleText.toPlainText())))
                    _item += 1
                    try:
                        _roi = str(self.refROIMinText.toPlainText())+'-'+str(self.refROIMaxText.toPlainText())
                        self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    except:
                        pass
                    _item += 1
                    try:
                        _roi = str(self.refBgROIMinText.toPlainText())+'-'+str(self.refBgROIMaxText.toPlainText())
                        self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    except:
                        pass
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.angleText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.l2Text.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.directText.toPlainText())))
                    _item += 1
                    self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(str(self.pcDirText.toPlainText())))
                    _item += 1
                    try:
                        _roi = str(self.dirROIMinText.toPlainText())+'-'+str(self.dirROIMaxText.toPlainText())
                        self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    except:
                        pass
                    _item += 1
                    try:
                        _roi = str(self.dirBgROIMinText.toPlainText())+'-'+str(self.dirBgROIMaxText.toPlainText())
                        self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_roi))
                    except:
                        pass
                    _item += 1
                    try:
                        _qRange = str(self.qMinText.toPlainText())+'-'+str(self.qBinText.toPlainText())+'-'+str(self.qMaxText.toPlainText())
                        self.tableData.setItem(_row, _item, QtGui.QTableWidgetItem(_qRange))
                    except:
                        pass
                    break
                else:
                    pass

    def curveFit(self, x0, y0):
        from scipy.optimize import curve_fit

        def func(x, *params):
            y = np.zeros_like(x)
            for i in range(0, len(params), 3):
                ctr = params[i]
                amp = params[i + 1]
                wid = params[i + 2]
                y = y + amp * np.exp(-((x-ctr) / wid) ** 2 / 2.0)
            return y

        _max = max(y0)
        _center = x0.index(max(x0))
        guess = [_center, _max, 20]

        (popt, pcov) = curve_fit(func, x0, y0, p0=guess)
        fit = func(x0, *popt)
        return fit, popt

    def startReduction(self):
        configure = self.getSetting()
        self.writeXml(configure)
        self.comboBox.setCurrentIndex(-1)
        #_result = self.checkValue()
        #if _result:
	    #self.deleteData()
        #    self.comboBox.setCurrentIndex(0)
        self.canvas.ax.clear()
        self.canvas.draw()
        #reduction.Reduction()
        self.comboBox.setCurrentIndex(2)
        self.comboBoxChange()

    def deleteData(self):
        _tmp = "rm -rf "+os.getcwd()+"/*.dat"
        print _tmp
        try:
            subprocess.check_output(_tmp, shell=True)
        except:
            pass

    def checkValue(self):
        _result=False
        if self.sampleText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Sample Run can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.pcSampleText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Sample Proton can not be empty.", QtGui.QMessageBox.Yes)
        elif self.directText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Direct Run can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.pcDirText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Direct Proton can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.refROIMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Reflection ROI Min can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.refROIMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning"," Reflection ROI Max can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.refBgROIMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Background ROI Min  not be empty.", QtGui.QMessageBox.Yes)
        #elif self.refBgROIMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Background ROI Max can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.dirROIMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Reflection ROI Min can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.dirROIMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning"," Reflection ROI Max can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.dirBgROIMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Background ROI Min  not be empty.", QtGui.QMessageBox.Yes)
        #elif self.dirBgROIMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Background ROI Max can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.l2Text.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Sample-to-Detector can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.angleText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Detector Angle can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.wavelengthMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Wavelength Min can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.wavelengthMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Wavelength Max can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.qMinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Q Range Min can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.qBinText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Q Range Bin can not be empty.", QtGui.QMessageBox.Yes)
        #elif self.qMaxText.toPlainText() == '':
        #    msgBox = QtGui.QMessageBox.information(self,"Warning","Q Range Max can not be empty.", QtGui.QMessageBox.Yes)
        else:
            _result=True

        return _result

    def getSetting(self):    
        configure = {}
        _merge = []
        _sample = []
        _pcSample = []
        _roiSample = []
        _roiBgSample = []
        _angle = []
        _l2 = []
        _direct = []
        _pcDirect = []
        _roiDirect = []
        _roiBgDirect = []
        _qRange = []
        _overlaps = []
        #try:
        _rowCount = 0
        for _row in range(int(self.tableData.rowCount())):
            if (self.tableData.item(_row, 1)!=None) and \
                (self.tableData.item(_row, 2)!=None) and \
                (self.tableData.item(_row, 3)!=None) and \
                (self.tableData.item(_row, 4)!=None) and \
                (self.tableData.item(_row, 5)!=None) and \
                (self.tableData.item(_row, 6)!=None) and \
                (self.tableData.item(_row, 7)!=None) and \
                (self.tableData.item(_row, 8)!=None) and \
                (self.tableData.item(_row, 9)!=None) and \
                (self.tableData.item(_row, 10)!=None) and \
                (self.tableData.item(_row, 11)!=None):
                _rowCount += 1
            else:
                pass
        
        for _row in range(_rowCount):
            if (self.tableData.item(_row, 1)!=None) and \
                (self.tableData.item(_row, 2)!=None) and \
                (self.tableData.item(_row, 3)!=None) and \
                (self.tableData.item(_row, 4)!=None) and \
                (self.tableData.item(_row, 5)!=None) and \
                (self.tableData.item(_row, 6)!=None) and \
                (self.tableData.item(_row, 7)!=None) and \
                (self.tableData.item(_row, 8)!=None) and \
                (self.tableData.item(_row, 9)!=None) and \
                (self.tableData.item(_row, 10)!=None) and \
                (self.tableData.item(_row, 11)!=None):
            
                _item = 0
                if self.tableData.item(_row, _item).checkState() == QtCore.Qt.Checked:
                    _tmp = 1
                else:
                    _tmp = 0
                _merge.append(int(_tmp))
                
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _sample.append('')
                else:
                    _sample.append(int(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _pcSample.append('')
                else:
                    _pcSample.append(float(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _roiSample.append('')
                else:
                    _roiSample.append(_tmp.text())
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _roiBgSample.append('')
                else:
                    _roiBgSample.append(_tmp.text())
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _angle.append('')
                else:
                    _angle.append(float(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _l2.append('')
                else:
                    _l2.append(float(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _direct.append('')
                else:
                    _direct.append(int(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _pcDirect.append('')
                else:
                    _pcDirect.append(float(_tmp.text()))
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _roiDirect.append('')
                else:
                    _roiDirect.append(_tmp.text())
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _roiBgDirect.append('')
                else:
                    _roiBgDirect.append(_tmp.text())
            
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _qRange.append('')
                else:
                    _qRange.append(_tmp.text())
           
                _item += 1
                _tmp=self.tableData.item(_row, _item)
                if _tmp is None:
                    _overlaps.append('')
                else:
                    _overlaps.append(_tmp.text())
            else:
                pass        
   
        configure['Merge'] = str(_merge)
        configure['Sample'] = str(_sample)
        configure['sample_PC'] = str(_pcSample)
        _min = []
        _max = []
        for i in range(len(_roiSample)):
            _data = _roiSample[i].split('-')
            _min.append(float(_data[0]))
            _max.append(float(_data[1]))
        configure['refRoiStart'] = str(_min)
        configure['refRoiEnd'] = str(_max)
        _min = []
        _max = []
        for i in range(len(_roiBgSample)):
            _data = _roiBgSample[i].split('-')
            _min.append(float(_data[0]))
            _max.append(float(_data[1]))
        configure['refBgRoiStart'] = str(_min)
        configure['refBgRoiEnd'] = str(_max)
        configure['rotateAngle'] = str(_angle)
        configure['L2'] = str(_l2)
        configure['Direct'] = str(_direct)
        configure['direct_PC'] = str(_pcDirect)
        _min = []
        _max = []
        for i in range(len(_roiDirect)):
            _data = _roiDirect[i].split('-')
            _min.append(float(_data[0]))
            _max.append(float(_data[1]))
        configure['dirRoiStart'] = str(_min)
        configure['dirRoiEnd'] = str(_max)
        _min = []
        _max = []
        for i in range(len(_roiBgDirect)):
            _data = _roiBgDirect[i].split('-')
            _min.append(float(_data[0]))
            _max.append(float(_data[1]))
        configure['dirBgRoiStart'] = str(_min)
        configure['dirBgRoiEnd'] = str(_max)

        configure['wMin'] = str(self.wavelengthMinText.toPlainText())
        configure['wMax'] = str(self.wavelengthMaxText.toPlainText())
        #configure['qMin'] = str(self.qMinText.toPlainText())
        #configure['qBin'] = str(self.qBinText.toPlainText())
        #configure['qMax'] = str(self.qMaxText.toPlainText())
        configure['qMergeMin'] = str(self.qMergeMinText.toPlainText())
        configure['qMergeBin'] = str(self.qMergeBinText.toPlainText())
        configure['qMergeMax'] = str(self.qMergeMaxText.toPlainText())
        configure['filePath'] = str(self.xmlFileText.toPlainText())
        _min = []
        _bin = []
        _max = []
        for i in range(len(_qRange)):
            _data = _qRange[i].split('-')
            _min.append(float(_data[0]))
            _bin.append(float(_data[1]))
            _max.append(float(_data[2]))
        configure['qMin'] = str(_min)
        configure['qBin'] = str(_bin)
        configure['qMax'] = str(_max)
        configure['Overlaps'] = str(_overlaps)

        _tube = self.tubeComboChange()
        configure['tube'] = _tube
        #except:
        #    pass

        return configure

    def readXml(self, filename):
        tree = ET.parse(filename)
        root = tree.getroot()

        configure={}

        _tmp = root.findall('Merge')[0].text
        configure['Merge']=_tmp

        _tmp = root.findall('Sample')[0].text
        configure['Sample']=_tmp

        _tmp = root.findall('sample_PC')[0].text
        configure['sample_PC']=_tmp

        _tmp = root.findall('Direct')[0].text
        configure['Direct']=_tmp
        
        _tmp = root.findall('direct_PC')[0].text
        configure['direct_PC']=_tmp

        _tmp = root.findall('refRoiStart')[0].text
        configure['refRoiStart']=_tmp

        _tmp = root.findall('refRoiEnd')[0].text
        configure['refRoiEnd']=_tmp
        
        _tmp = root.findall('refBgRoiStart')[0].text
        configure['refBgRoiStart']=_tmp

        _tmp = root.findall('refBgRoiEnd')[0].text
        configure['refBgRoiEnd']=_tmp
        
        _tmp = root.findall('dirRoiStart')[0].text
        configure['dirRoiStart']=_tmp

        _tmp = root.findall('dirRoiEnd')[0].text
        configure['dirRoiEnd']=_tmp
        
        _tmp = root.findall('dirBgRoiStart')[0].text
        configure['dirBgRoiStart']=_tmp

        _tmp = root.findall('dirBgRoiEnd')[0].text
        configure['dirBgRoiEnd']=_tmp
        
        _tmp = root.findall('L2')[0].text
        configure['L2']=_tmp
        
        _tmp = root.findall('rotateAngle')[0].text
        configure['rotateAngle']=_tmp

        _tmp = root.findall('wMin')[0].text
        configure['wMin']=_tmp
        
        _tmp = root.findall('wMax')[0].text
        configure['wMax']=_tmp
        
        _tmp = root.findall('qMin')[0].text
        configure['qMin']=_tmp

        _tmp = root.findall('qBin')[0].text
        configure['qBin']=_tmp
        
        _tmp = root.findall('qMax')[0].text
        configure['qMax']=_tmp

        _tmp = root.findall('Overlaps')[0].text
        configure['Overlaps']=_tmp

        _tmp = root.findall('qMergeMin')[0].text
        configure['qMergeMin']=_tmp

        _tmp = root.findall('qMergeBin')[0].text
        configure['qMergeBin']=_tmp
        
        _tmp = root.findall('qMergeMax')[0].text
        configure['qMergeMax']=_tmp

        _tmp = root.findall('filePath')[0].text
        configure['filePath']=_tmp

        _tmp = root.findall('tube')[0].text
        configure['tube']=_tmp

        return configure

    def writeXml(self, configure):
        top = ET.Element('root')

        child = ET.SubElement(top, 'Merge')
        child.text=configure['Merge']
        child = ET.SubElement(top, 'Sample')
        child.text=configure['Sample']
        child = ET.SubElement(top, 'sample_PC')
        child.text=configure['sample_PC']
        child = ET.SubElement(top, 'refRoiStart')
        child.text=configure['refRoiStart']
        child = ET.SubElement(top, 'refRoiEnd')
        child.text=configure['refRoiEnd']
        child = ET.SubElement(top, 'refBgRoiStart')
        child.text=configure['refBgRoiStart']
        child = ET.SubElement(top, 'refBgRoiEnd')
        child.text=configure['refBgRoiEnd']
        child = ET.SubElement(top, 'rotateAngle')
        child.text=configure['rotateAngle']
        child = ET.SubElement(top, 'L2')
        child.text=configure['L2']
        child = ET.SubElement(top, 'Direct')
        child.text=configure['Direct']
        child = ET.SubElement(top, 'direct_PC')
        child.text=configure['direct_PC']
        child = ET.SubElement(top, 'dirRoiStart')
        child.text=configure['dirRoiStart']
        child = ET.SubElement(top, 'dirRoiEnd')
        child.text=configure['dirRoiEnd']
        child = ET.SubElement(top, 'dirBgRoiStart')
        child.text=configure['dirBgRoiStart']
        child = ET.SubElement(top, 'dirBgRoiEnd')
        child.text=configure['dirBgRoiEnd']
        child = ET.SubElement(top, 'wMin')
        child.text=configure['wMin']
        child = ET.SubElement(top, 'wMax')
        child.text=configure['wMax']
        child = ET.SubElement(top, 'qMin')
        child.text=configure['qMin']
        child = ET.SubElement(top, 'qBin')
        child.text=configure['qBin']
        child = ET.SubElement(top, 'qMax')
        child.text=configure['qMax']
        child = ET.SubElement(top, 'Overlaps')
        child.text=configure['Overlaps']
        child = ET.SubElement(top, 'qMergeMin')
        child.text=configure['qMergeMin']
        child = ET.SubElement(top, 'qMergeBin')
        child.text=configure['qMergeBin']
        child = ET.SubElement(top, 'qMergeMax')
        child.text=configure['qMergeMax']
        child = ET.SubElement(top, 'filePath')
        child.text=configure['filePath']
        child = ET.SubElement(top, 'tube')
        child.text=configure['tube']
 
        xmlstr = minidom.parseString(ET.tostring(top)).toprettyxml(indent="   ")
        with open("./configure.xml", "w") as f:
            f.write(xmlstr)
    
        _file = str(self.xmlFileText.toPlainText())+ '.xml'
        with open(_file, "w") as f:
            f.write(xmlstr)
    
    def logcomboBoxChange(self):
        if self.logcomboBox.currentIndex()==1:
            self.canvas.ax.set_yscale('log')
        else:
            self.canvas.ax.set_yscale('linear')

	self.canvas.draw()

    def tubeComboChange(self):
        index = self.tubeCombo.currentIndex()
        _str = 'tube' + str(index+1)
        return _str

    def comboBoxChange(self):
        index = self.comboBox.currentIndex()
        self.canvas.ax.clear()
        if index == 3:
            _filename1 = './ref_roi.dat'
            _filename2 = './dir_roi.dat'
            try:
                _x1, _y1, _e = self.readData(_filename1)
                _x2, _y2, _e = self.readData(_filename2)
            except:
                pass
            try:
                self.drawCanvas(_x1,_y1,_x2,_y2)
            except:
                self.canvas.ax.clear()

            try:
                _cy1, self.popt1 = self.curveFit(_x1, _y1)
                self.canvas.ax.plot(_x1, _cy1, 'r')
            except:
                pass
            try:
                _cy2, self.popt2 = self.curveFit(_x2, _y2)
                self.canvas.ax.plot(_x2, _cy2, 'b')
            except:
                pass
        else:
            _row = int(self.tableData.rowCount())
            for i in range(_row):
                if self.tableData.item(i, 0).checkState() == QtCore.Qt.Checked:
                    if index == 0:
                        _filename = './sam_raw_'+str(i)+'.dat'
                    elif index == 1:
                        _filename = './dir_raw_'+str(i)+'.dat' 
                    elif index == 2:
                        _filename = './RQ_'+str(i)+'.dat'

                    try:
                        _x, _y, _e = self.readData(_filename)
                    except:
                        pass
                    try:
                        self.updateCanvas(_x, _y, _e)
                    except:
                        self.canvas.ax.clear()
        self.canvas.ax.relim()
        self.canvas.ax.autoscale_view()
        self.canvas.draw()
       
        if index == 3:
            self.refPeakLabel.setText('Reflection Peak:' + format(self.popt1[0], '.2f'))
            self.refFwhmLabel.setText('Reflection FWHM:' + format(abs(self.popt1[2]) * 2.3548, '.2f'))
            self.dirPeakLabel.setText('Direct Peak:' + format(self.popt2[0], '.2f'))
            self.dirFwhmLabel.setText('Direct FWHM:' + format(abs(self.popt2[2]) * 2.3548, '.2f'))
        else:
            self.refPeakLabel.setText('')
            self.refFwhmLabel.setText('')
            self.dirPeakLabel.setText('')
            self.dirFwhmLabel.setText('') 

    def readData(self, filename):
        _x=[]
        _y=[]
        _e=[]
        f=open(filename, "rb")
        for line in f.readlines()[2:]:
            value=line.split(',')
            try:
                _x.append(float(value[0]))
                _y.append(float(value[1]))
                _e.append(float(value[2]))
            except:
                pass
        f.close()
        return _x, _y, _e

    def updateCanvas(
        self,
        x,
        y,
        e,
        ):
       
        if len(y) == 0 or len(x) \
            != len(y):
            pass
        else:
            #self.canvas.ax.clear()
            self.pix1 = \
                self.canvas.ax.errorbar(x, y, yerr=e)
	    if self.logcomboBox.currentIndex()==1:
	        self.canvas.ax.set_yscale('log')
	    else:
	        self.canvas.ax.set_yscale('linear')
        self.canvas.ax.add_patch(self.canvas.rect)
        self.canvas.draw()

    def drawCanvas(
        self,
        x1,
        y1,
        x2,
        y2,
        ):

        self.canvas.ax.clear()
        if len(y1) == 0 or len(x1) \
            != len(y1):
            pass
        else:
            self.canvas.ax.plot(x1, y1, '.')
        if len(y2) == 0 or len(x2) \
            != len(y2):
            pass
        else:
            self.canvas.ax.plot(x2, y2, '.')
        if self.logcomboBox.currentIndex()==1:
            self.canvas.ax.set_yscale('log')
        else:
            self.canvas.ax.set_yscale('linear')
        self.canvas.ax.add_patch(self.canvas.rect)
        self.canvas.draw()

    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        _confFile='./conf/configure.json'
        _mainWidth, _mainHeight=self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth=_mainWidth
            self.mainHeight=_mainHeight
        else:
            try:
                layoutParameter = json.loads(open(_confFile, "r").read())
                self.mainWidth=layoutParameter['mainWidth']
                self.mainHeight=layoutParameter['mainHeight']+215
            except:
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight

    def setConfigure(self):
        self.resize(self.mainWidth, self.mainHeight)

    def saveConfigure(self):
        _mainWidth=self.splitter.geometry().width()
        _mainHeight=self.splitter.geometry().height()

        _data = {"mainWidth": _mainWidth, "mainHeight": _mainHeight}
        
        _confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)

    def setNeonStatus(self, value):
	    self.userWidget.setNeonStatus(value)
 
    def getNeon(self):
	    self.neonStatus, self.writeServer, self.readServer=self.userWidget.getNeon()
	    return self.neonStatus, self.writeServer, self.readServer

class circleButton(QtGui.QToolButton):
    def __init__(self, parent=None):
        super(circleButton, self).__init__(parent)
        self.setStyleSheet('''border-image: url("img/button.png")''')

    def resizeEvent(self, event):
        self.setMask(QtGui.QRegion(self.rect(), QtGui.QRegion.Ellipse))
        QtGui.QToolButton.resizeEvent(self, event)

class TableData(QtGui.QTableWidget):#View):
    def __init__(self, parent):
        super(TableData, self).__init__(parent=None)
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, Widget):
        self.headerList = []
        self.headerList.append("merge")
        self.headerList.append("ref_run")
        self.headerList.append("ref_pc")
        self.headerList.append("ref_roi")
        self.headerList.append("ref_bg_roi")
        self.headerList.append("det_angle")
        self.headerList.append("L2")
        self.headerList.append("dir_run")
        self.headerList.append("dir_pc")
        self.headerList.append("dir_roi")
        self.headerList.append("dir_bg_roi")
        self.headerList.append("q_range")
        self.headerList.append("overlaps")

        self.setColumnCount(13)
        self.setRowCount(3)
        for _row in range(3):
            _checkBox = QtGui.QTableWidgetItem()
            _checkBox.setCheckState(QtCore.Qt.Unchecked)
            self.setItem(_row, 0, _checkBox)

        for i in range(len(self.headerList)):
            self.setHorizontalHeaderItem(i, QtGui.QTableWidgetItem(self.headerList[i]))

        #self.dataModel = QtGui.QStandardItemModel(3, 10)
        #self.dataModel.setHorizontalHeaderLabels(self.headerList)

        #self.setModel(self.dataModel)

    def setModelData(self,row,data1,data2,data3,data4,data5,data6,data7,data8,data9,data10):
        self.dataModel.setItem(row, 0, QStandardItem(data1))
        self.dataModel.setItem(row, 1, QStandardItem(data2))
        self.dataModel.setItem(row, 2, QStandardItem(data3))
        self.dataModel.setItem(row, 3, QStandardItem(data4))
        self.dataModel.setItem(row, 4, QStandardItem(data5))
        self.dataModel.setItem(row, 5, QStandardItem(data6))
        self.dataModel.setItem(row, 6, QStandardItem(data7))
        self.dataModel.setItem(row, 7, QStandardItem(data8))
        self.dataModel.setItem(0, 8, QStandardItem(data9))
        self.dataModel.setItem(0, 9, QStandardItem(data10))

def exit_handler(top):
    top.saveConfigure()

if __name__ == '__main__':
    
    myapp = QtGui.QApplication(sys.argv)
    
    mytop = mywindow(myapp)
    mytop.setWindowTitle('RM Data Reduction v0.3')
    mytop.show()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
