from mantid.simpleapi import *
import sys
import time
import xml.etree.ElementTree as ET


tubeList={}
tubeList['tube1']= 0
tubeList['tube2']= 300
tubeList['tube3']= 600
tubeList['tube4']= 900

def readXml(filename):
    tree = ET.parse(filename)
    root = tree.getroot()
    configure={}
    
    _tmp = root.findall('Merge')[0].text
    configure['Merge']=_tmp
    _tmp = root.findall('Sample')[0].text
    configure['Sample']=_tmp
    _tmp = root.findall('sample_PC')[0].text
    configure['sample_PC']=_tmp
    _tmp = root.findall('Direct')[0].text
    configure['Direct']=_tmp
    _tmp = root.findall('direct_PC')[0].text
    configure['direct_PC']=_tmp
    _tmp = root.findall('refRoiStart')[0].text
    configure['refRoiStart']=_tmp
    _tmp = root.findall('refRoiEnd')[0].text
    configure['refRoiEnd']=_tmp
    _tmp = root.findall('refBgRoiStart')[0].text
    configure['refBgRoiStart']=_tmp
    _tmp = root.findall('refBgRoiEnd')[0].text
    configure['refBgRoiEnd']=_tmp
    _tmp = root.findall('dirRoiStart')[0].text
    configure['dirRoiStart']=_tmp
    _tmp = root.findall('dirRoiEnd')[0].text
    configure['dirRoiEnd']=_tmp
    _tmp = root.findall('dirBgRoiStart')[0].text
    configure['dirBgRoiStart']=_tmp
    _tmp = root.findall('dirBgRoiEnd')[0].text
    configure['dirBgRoiEnd']=_tmp
    _tmp = root.findall('L2')[0].text
    configure['L2']=_tmp
    _tmp = root.findall('rotateAngle')[0].text
    configure['rotateAngle']=_tmp
    _tmp = root.findall('wmin')[0].text
    configure['wmin']=_tmp
    _tmp = root.findall('wmax')[0].text
    configure['wmax']=_tmp
    _tmp = root.findall('qmin')[0].text
    configure['qmin']=_tmp
    _tmp = root.findall('qbin')[0].text
    configure['qbin']=_tmp
    _tmp = root.findall('qmax')[0].text
    configure['qmax']=_tmp
    _tmp = root.findall('qmergemin')[0].text
    configure['qmergemin']=_tmp
    _tmp = root.findall('qmergebin')[0].text
    configure['qmergebin']=_tmp
    _tmp = root.findall('qmergemax')[0].text
    configure['qmergemax']=_tmp

    _tmp = root.findall('tube')[0].text
    configure['tube']=_tmp
    _tmp = root.findall('filePath')[0].text
    configure['filePath']=_tmp

    return configure


def FindROI(refRunNo, dirRunNo, tube):

    path=sys.path[0]
    startIndex=tubeList[tube]
    endIndex=tubeList[tube]+299

    ref_run='/home/dur/work/nexusData/MR/RUN'+str(refRunNo).zfill(7)+'/sample.nxs'
    dir_run='/home/dur/work/nexusData/MR/RUN'+str(dirRunNo).zfill(7)+'/sample.nxs'
    LoadNexus(Filename=ref_run, OutputWorkspace='ref')
    CropWorkspace(InputWorkspace='ref', OutputWorkspace='ref',StartWorkspaceIndex=startIndex,EndWorkspaceIndex=endIndex)
    name=mtd['ref']
    y=[]
    x=[]
    for i in range(name.getNumberHistograms()):
        y.append(sum(name.readY(i)))
        x.append(i)
    CreateWorkspace(DataX=x, DataY=y, NSpec=1, OutputWorkspace='ref',VerticalAxisUnit='SpectraNumber')
    SaveAscii(InputWorkspace= 'ref', Filename='./ref_roi.dat')
    DeleteWorkspace(Workspace='ref')

    LoadNexus(Filename=dir_run, OutputWorkspace='dir')
    CropWorkspace(InputWorkspace='dir', OutputWorkspace='dir',StartWorkspaceIndex=startIndex,EndWorkspaceIndex=endIndex)
    name=mtd['dir']
    y=[]
    x=[]
    for i in range(name.getNumberHistograms()):
        y.append(sum(name.readY(i)))
        x.append(i)
    CreateWorkspace(DataX=x, DataY=y, NSpec=1, OutputWorkspace='dir',VerticalAxisUnit='SpectraNumber')
    SaveAscii(InputWorkspace= 'dir', Filename='./dir_roi.dat')
    DeleteWorkspace(Workspace='dir')

    return True

def processWS(prepath, runPath, pc_value, L2, rotateAngle, roiPids, bgPids, wave_rebin, output, refJudge):
    LoadNexus(Filename=runPath, OutputWorkspace='tmp')
    #pc norm
    CreateSingleValuedWorkspace(OutputWorkspace='pc', DataValue=pc_value)
    Divide(LHSWorkspace='tmp',RHSWorkspace='pc',AllowDifferentNumberSpectra=True, OutputWorkspace='tmp')
    #===========ROI=================
    CropWorkspace(InputWorkspace='tmp', OutputWorkspace='roi_tmp', StartWorkspaceIndex=roiPids[0], EndWorkspaceIndex=roiPids[1])
    #pid norm
    pid_roi=roiPids[1]-roiPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
    Divide(LHSWorkspace='roi_tmp',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_tmp')
    SumSpectra(InputWorkspace='roi_tmp', OutputWorkspace='roi')
    #========baseline==================
    CropWorkspace(InputWorkspace='tmp', OutputWorkspace='base_tmp', StartWorkspaceIndex=bgPids[0], EndWorkspaceIndex=bgPids[1])
    #pid norm
    pid_bg=bgPids[1]-bgPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_bg)
    Divide(LHSWorkspace='base_tmp',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='base_tmp')
    SumSpectra(InputWorkspace='base_tmp', OutputWorkspace='base')
    #substract baseline
    if L2 == 2.09:
        xmlpath=prepath+'/paramData/onePid_2.xml'
    else:
	xmlpath=prepath+'/paramData/onePid_1.xml'
    LoadInstrument(Workspace='roi', Filename=xmlpath, RewriteSpectraMap=True)
    LoadInstrument(Workspace='base', Filename=xmlpath, RewriteSpectraMap=True)
    if refJudge:
        if rotateAngle != 0:
            RotateInstrumentComponent(Workspace="roi", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
            RotateInstrumentComponent(Workspace="base", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
        else:
            pass
    else:
        pass
    ConvertUnits(InputWorkspace='roi',Target="Wavelength",OutputWorkspace='roi', AlignBins=True)
    ConvertUnits(InputWorkspace='base',Target="Wavelength",OutputWorkspace='base', AlignBins=True)
    Rebin(InputWorkspace='roi', OutputWorkspace='roi',Params=wave_rebin)
    Rebin(InputWorkspace='base', OutputWorkspace='base',Params=wave_rebin)
    Minus(LHSWorkspace='roi',RHSWorkspace='base',AllowDifferentNumberSpectra=True, OutputWorkspace=output)

    if refJudge:
        ConvertUnits(InputWorkspace=output, Target='MomentumTransfer',OutputWorkspace='roi_q',AlignBins=True)
        SaveAscii(InputWorkspace= 'roi_q', Filename='./sam_raw.dat')

def Reduction():
    conf=readXml('./test.xml')
    mergeList=conf['Merge'][1:-1].split(',')
    ref_run=[int(s) for s in conf['Sample'][1:-1].split(',')]
    pc_ref=[int(float(s)) for s in conf['sample_PC'][1:-1].split(',')]
    dir_run=[int(s) for s in conf['Direct'][1:-1].split(',')]
    pc_dir=[int(float(s)) for s in conf['direct_PC'][1:-1].split(',')]
    #print pc_dir, type(pc_dir[0])
    rotateAngleList=[float(s) for s in conf['rotateAngle'][1:-1].split(',')]
    tube=conf['tube']
    L2List=[float(s) for s in conf['L2'][1:-1].split(',')]
    #outputpath=conf['filePath'][1:-1].split(',')
    outputpath=None

    refRoiStart=[int(float(s)) for s in conf['refRoiStart'][1:-1].split(',')]
    #print (refRoiStart[0])
    refRoiEnd=[int(float(s)) for s in conf['refRoiEnd'][1:-1].split(',')]
    refBgRoiStart=[int(float(s)) for s in conf['refBgRoiStart'][1:-1].split(',')]
    refBgRoiEnd=[int(float(s)) for s in conf['refBgRoiEnd'][1:-1].split(',')]
    dirRoiStart=[int(float(s)) for s in conf['refRoiStart'][1:-1].split(',')]
    dirRoiEnd=[int(float(s)) for s in conf['refRoiEnd'][1:-1].split(',')]
    dirBgRoiStart=[int(float(s)) for s in conf['refBgRoiStart'][1:-1].split(',')]
    dirBgRoiEnd=[int(float(s)) for s in conf['refBgRoiEnd'][1:-1].split(',')]
    w1=float(conf['wmin'])
    w2=float(conf['wmax'])
    wave_rebin=str(w1)+',0.001,'+str(w2)
    q1=conf['qmin'][1:-1].split(',')
    q2=conf['qbin'][1:-1].split(',')
    q3=conf['qmax'][1:-1].split(',')
    path=sys.path[0]

    for i in range(len(ref_run)):
        refRoiPids=[]
        refRoiPids.append(refRoiStart[i]+tubeList[tube])
        refRoiPids.append(refRoiEnd[i]+tubeList[tube])
        print refRoiPids
        refBgPids=[]
        refBgPids.append(refBgRoiStart[i]+tubeList[tube])
        refBgPids.append(refBgRoiEnd[i]+tubeList[tube])
        dirRoiPids=[]
        dirRoiPids.append(int(float(dirRoiStart[i]))+tubeList[tube])
        dirRoiPids.append(int(float(dirRoiEnd[i]))+tubeList[tube])
        dirBgPids=[]
        dirBgPids.append(int(float(dirBgRoiStart[i]))+tubeList[tube])
        dirBgPids.append(int(float(dirBgRoiEnd[i]))+tubeList[tube])
        q_rebin=str(q1[i])+','+str(q2[i])+','+str(q3[i])
        print q_rebin
        pc_value= int(float(pc_ref[i]))
        #sys.exit()
        '''
        runPath='/home/dur/work/nexusData/MR/RUN'+str(ref_run[i]).zfill(7)+'/sample.nxs'
        print runPath
        L2=float(L2List[i])
        rotateAngle=float(rotateAngleList[i])
        processWS(path, runPath, pc_value, L2, rotateAngle, refRoiPids, refBgPids, wave_rebin, 'ref', True)
        pc_value= int(float(pc_dir[i]))
        runPath='/home/dur/work/nexusData/MR/RUN'+str(dir_run[i]).zfill(7)+'/sample.nxs'
        processWS(path, runPath, pc_value, L2, rotateAngle, dirRoiPids, dirBgPids, wave_rebin, 'dir', False)
    
        Divide(LHSWorkspace='ref',RHSWorkspace='dir',AllowDifferentNumberSpectra=True, OutputWorkspace='nor')
        ConvertUnits(InputWorkspace='nor', Target='MomentumTransfer',OutputWorkspace='nor',AlignBins=True)
        Rebin(InputWorkspace='nor', OutputWorkspace='RQ_'+ref_run[i],Params=q_rebin)
        SaveAscii(InputWorkspace= 'RQ_'+ref_run[i], Filename='./RQ_'+ref_run[i]+'.dat')

        if outputpath is None:
            pass
        else:
            SaveAscii(InputWorkspace= 'RQ_'+ref_run[i], Filename=outputpath[i]+'.dat')
            SaveNexus(InputWorkspace= 'RQ_'+ref_run[i], Filename=outputpath[i]+'.nxs')
        '''
    #merge
    workspaces='RQ_'+str(ref_run[0])+','
    for i in range(len(ref_run)-1):
        workspaces=workspaces+'RQ_'+str(ref_run[i+1])+','
        #print workspaces
    workspaces=workspaces+'RQ_'+str(ref_run[-1])
    print workspaces
    #startOverlaps=
    #endOverlaps=
    #q_params=
    #Stitch1DMany(InputWorkspaces=workspaces, StartOverlaps=)

Reduction()
