from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
import matplotlib.pyplot as plt
import glob
import shutil
import re
import datetime
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler

class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                #filename='myMantid_'+name+'.log',
                filename=os.getcwd()+'/nxs.log',
                filemode='a')

        self.logger = logging.getLogger('BL02nxs')
        hdlr = RotatingFileHandler(os.getcwd()+'/nxs.log', maxBytes=100, backupCount=0)

    def getLog(self):
        return self.logger

def parseDaq(prepath,runno,logger):
    rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/"+runno+"/"
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmllist)== 0:
        logger.warning('no xml file in DAQ for '+runno)
        judge=False
    else:
        try:
            xmlfile=xmllist[0]
            root = ET.parse(xmlfile)
            judge=True
        except:
            logger.warning('error in parse xml for daq for '+runno)
            _cmd="cp "+xmlfile+" /home/mantid/workspace/BL02nexus/"+runno+'/'
            subprocess.check_call(_cmd, shell=True)
            judge=False

    if judge:
        subprocess.check_call("python binary_hist.py "+runno+" 1 "+prepath+" &", shell=True)
        while not os.path.exists(prepath+"/tmpData/module1.dat"):
            #print "no data"
            time.sleep(3)
        logger.debug("module1 exists!")
    else:
        pass
 
def getDaq(prepath, logger):
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep for i in xrange(m_tofbins+1)]
    value=[]
    name="module1"
    for item in root.findall('type/component'):
        if name== item.attrib['name']:
            m_moduleinfo = item.attrib
            idstart = int(m_moduleinfo['idstart'])
            idsize  = int(m_moduleinfo['pixels'])
            mpid = [idstart+i*1 for i in xrange(idsize)]
        f0=open(prepath+'/tmpData/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                value.append(iy)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        logger.debug("daq data match failed!")
        _cmd="rm -rf "+prepath+"/tmpData"
        subprocess.check_call(_cmd, shell=True)
        sys.exit()

def checkNewRun():
    prepath=sys.path[0]
    rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/Completed"
    daqList=os.listdir(rawpath)
    runList=os.listdir(prepath)
    newList=[]
    for name in daqList:
        if name[0]=='R' and name[3]=='0':
            if name in runList:
                pass
            elif name == 'RUN0':
                pass
            else:
                newList.append(name)
    return newList

# usage: python hist_nxs.py banknum 
def createNexus(runNo, logger):
    runno="RUN"+str(runNo).zfill(7)

    prepath=sys.path[0]+"/"+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)

    tmp=prepath+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    #print 'mkdir: ',tmp
    #rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/"+runno
    #xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    #if len(xmlfile)==0:
    #    print "no data in ",runno, " for DAQ"
    #else:
    parseDaq(prepath, runno, logger)
    spid, stof, svalue = getDaq(prepath, logger)
    LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
    LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/detector.xml', RewriteSpectraMap='True')
    SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/sample.nxs')
    logger.debug('finish save nexus for detector! ') 
    _cmd="rm -rf "+prepath+"/tmpData"
    subprocess.check_call(_cmd, shell=True)

    f=open("./database/"+runno, "w")
    f.close()
    try:
        f=open("complete", "w")
        f.close()
    except:
        pass

    _cmd = 'scp -r '+runno+' transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL02/'
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'scp complete  transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL02/'+runno
    subprocess.check_call(_cmd, shell=True)


#!/usr/bin/python
import sys
import time
import os
import threading

class main(threading.Thread):
    def __init__(self, logger):
        threading.Thread.__init__(self)
        self.logger=logger

    def getRunNoList(self):
        dir="/opt/CSNSDATA/TS1/BL02/Control/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))

        runNo.sort()
        return runNo


    def getDaqCompleteList(self):
        dir="/opt/CSNSDATA/TS1/BL02/DAQ/Completed/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        runStr=glob.glob(dir+'RUN*')

        for r in runStr:
            if r[-7:].isdigit():
                runNo.append(int(r[-7:]))
            else:
                pass

        '''
        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))
        '''

        runNo.sort()
        return runNo

    def getNexusRunList(self):
        dir=os.getcwd()+"/database/"
        pattern="^RUN[0-9]{7}"
        runNo=[]

        runStr=glob.glob(dir+'RUN*')

        for r in runStr:
            runNo.append(int(r[-7:]))

        runNo.sort()
        return runNo

    def process(self):
        ctrlRunList=self.getRunNoList()
        nexusRunList=self.getNexusRunList()
        completeRunList=self.getDaqCompleteList() 

        newList=[]
        for cRun in ctrlRunList:
            if cRun not in nexusRunList and cRun in completeRunList:
                newList.append(cRun)

        self.logger.debug("to be reconstructed: "+str(newList))
        for runNo in newList:
            _b=time.time()
            #print "begin:", runNo
            createNexus(runNo)
            self.logger.debug("end:"+str(runNo)+" "+str((time.time()-_b)/60.0)+'seconds!')

    def run(self):
        while True:
            #try:
            self.process()
            #except:
            #    pass
            time.sleep(300.0)

if __name__=="__main__":
    _log=myLog()
    logger=_log.getLog()

    threadDaemon = main(logger)
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()

