import sys
import time
import xml.etree.ElementTree as ET
import os

path='/root/Desktop/RMoffline'

tubeList={}
tubeList['tube1']= 0
tubeList['tube2']= 300
tubeList['tube3']= 600
tubeList['tube4']= 900

#xmlFile=path+'/Data/2018.3.23/Ni100_2018.3.23_DA4.0_3rd.xml'
#RQname='RQ_Raw_3rd'
xmlFile=path+'/configure.xml'
RQname='RQ_WNi'

def readXml(filename):
    tree = ET.parse(filename)
    root = tree.getroot()
    configure={}
    _tmp = root.findall('Sample')[0].text
    configure['Sample']=_tmp
    _tmp = root.findall('sample_PC')[0].text
    configure['sample_PC']=_tmp
    _tmp = root.findall('Direct')[0].text
    configure['Direct']=_tmp
    _tmp = root.findall('direct_PC')[0].text
    configure['direct_PC']=_tmp

    _tmp = root.findall('refRoiStart')[0].text
    configure['refRoiStart']=_tmp
    _tmp = root.findall('refRoiEnd')[0].text
    configure['refRoiEnd']=_tmp
    _tmp = root.findall('refBgRoiStart')[0].text
    configure['refBgRoiStart']=_tmp
    _tmp = root.findall('refBgRoiEnd')[0].text
    configure['refBgRoiEnd']=_tmp
    _tmp = root.findall('dirRoiStart')[0].text
    configure['dirRoiStart']=_tmp
    _tmp = root.findall('dirRoiEnd')[0].text
    configure['dirRoiEnd']=_tmp
    _tmp = root.findall('dirBgRoiStart')[0].text
    configure['dirBgRoiStart']=_tmp
    _tmp = root.findall('dirBgRoiEnd')[0].text
    configure['dirBgRoiEnd']=_tmp


    _tmp = root.findall('L2')[0].text
    configure['L2']=_tmp
    _tmp = root.findall('rotateAngle')[0].text
    configure['rotateAngle']=_tmp
    _tmp = root.findall('wmin')[0].text
    configure['wmin']=_tmp
    _tmp = root.findall('wmax')[0].text
    configure['wmax']=_tmp
    _tmp = root.findall('qmin')[0].text
    configure['qmin']=_tmp
    _tmp = root.findall('qbin')[0].text
    configure['qbin']=_tmp
    _tmp = root.findall('qmax')[0].text
    configure['qmax']=_tmp
    _tmp = root.findall('tube')[0].text
    configure['tube']=_tmp
    return configure


conf=readXml(xmlFile)
ref_run=conf['Sample']
pc_ref=float(conf['sample_PC'])
dir_run=conf['Direct']
pc_dir=float(conf['direct_PC'])
rotateAngle=float(conf['rotateAngle'])
tube=conf['tube']
startIndex=tubeList[tube]
endIndex=tubeList[tube]+299

refRoiPids=[]
refRoiPids.append(int(conf['refRoiStart'])+tubeList[tube])
refRoiPids.append(int(conf['refRoiEnd'])+tubeList[tube])
refBgPids=[]
refBgPids.append(int(conf['refBgRoiStart'])+tubeList[tube])
refBgPids.append(int(conf['refBgRoiEnd'])+tubeList[tube])
dirRoiPids=[]
dirRoiPids.append(int(conf['dirRoiStart'])+tubeList[tube])
dirRoiPids.append(int(conf['dirRoiEnd'])+tubeList[tube])
dirBgPids=[]
dirBgPids.append(int(conf['dirBgRoiStart'])+tubeList[tube])
dirBgPids.append(int(conf['dirBgRoiEnd'])+tubeList[tube])

w1=float(conf['wmin'])
w2=float(conf['wmax'])
wave_rebin=str(w1)+',0.001,'+str(w2)
q1=float(conf['qmin'])
q2=float(conf['qbin'])
q3=float(conf['qmax'])
q_rebin=str(q1)+','+str(q2)+','+str(q3)
L2=float(conf['L2'])

if L2 ==2.09:
    xmlpath=path+'/paramData/onePid_2.xml'
else:
    xmlpath=path+'/paramData/onePid_1.xml'
# finish configure   

LoadNexus(Filename=ref_run, OutputWorkspace='tmp')
CropWorkspace(InputWorkspace='tmp', OutputWorkspace='t2',StartWorkspaceIndex=startIndex,EndWorkspaceIndex=endIndex)
name=mtd['t2']
y=[]
x=[]
for i in range(name.getNumberHistograms()):
    y.append(sum(name.readY(i)))
    x.append(i)
CreateWorkspace(DataX=x, DataY=y, NSpec=1, OutputWorkspace='tube2',VerticalAxisUnit='SpectraNumber')


#pc norm
CreateSingleValuedWorkspace(OutputWorkspace='pc_ref', DataValue=pc_ref)
Divide(LHSWorkspace='tmp',RHSWorkspace='pc_ref',AllowDifferentNumberSpectra=True, OutputWorkspace='tmp')
#===========ROI=================
CropWorkspace(InputWorkspace='tmp', OutputWorkspace='roi_tmp', StartWorkspaceIndex=refRoiPids[0], EndWorkspaceIndex=refRoiPids[1])
#pid norm
pid_roi=refRoiPids[1]-refRoiPids[0]+1
CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
Divide(LHSWorkspace='roi_tmp',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_tmp')
SumSpectra(InputWorkspace='roi_tmp', OutputWorkspace='roi_ref')
#========baseline==================
CropWorkspace(InputWorkspace='tmp', OutputWorkspace='base_tmp', StartWorkspaceIndex=refBgPids[0], EndWorkspaceIndex=refBgPids[1])
#pid norm
pid_bg=refBgPids[1]-refBgPids[0]+1
CreateSingleValuedWorkspace(OutputWorkspace='pids2', DataValue=pid_bg)
Divide(LHSWorkspace='base_tmp',RHSWorkspace='pids2',AllowDifferentNumberSpectra=True, OutputWorkspace='base_tmp')
SumSpectra(InputWorkspace='base_tmp', OutputWorkspace='base_ref')
#substract baseline
LoadInstrument(Workspace='roi_ref', Filename=xmlpath, RewriteSpectraMap=True)
LoadInstrument(Workspace='base_ref', Filename=xmlpath, RewriteSpectraMap=True)
if rotateAngle != 0:
    RotateInstrumentComponent(Workspace="roi_ref", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
    RotateInstrumentComponent(Workspace="base_ref", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
else:
    pass
ConvertUnits(InputWorkspace='roi_ref',Target="Wavelength",OutputWorkspace='roi_ref', AlignBins=True)
ConvertUnits(InputWorkspace='base_ref',Target="Wavelength",OutputWorkspace='base_ref', AlignBins=True)
Rebin(InputWorkspace='roi_ref', OutputWorkspace='roi_ref',Params=wave_rebin)
Rebin(InputWorkspace='base_ref', OutputWorkspace='base_ref',Params=wave_rebin)
Minus(LHSWorkspace='roi_ref',RHSWorkspace='base_ref',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_ref')
ConvertUnits(InputWorkspace='roi_ref', Target='MomentumTransfer',OutputWorkspace='roi_ref_q',AlignBins=True)


#===============================
#dir beam
LoadNexus(Filename=dir_run, OutputWorkspace='dir')
#pc norm
CreateSingleValuedWorkspace(OutputWorkspace='pc_dir', DataValue=pc_dir)
Divide(LHSWorkspace='dir',RHSWorkspace='pc_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='dir')
#===========ROI=================
CropWorkspace(InputWorkspace='dir', OutputWorkspace='roi_dir', StartWorkspaceIndex=dirRoiPids[0], EndWorkspaceIndex=dirRoiPids[1])
#pid norm
pid_roi=dirRoiPids[1]-dirRoiPids[0]+1
CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
Divide(LHSWorkspace='roi_dir',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_dir')
SumSpectra(InputWorkspace='roi_dir', OutputWorkspace='roi_dir')
#========baseline==================
CropWorkspace(InputWorkspace='dir', OutputWorkspace='base_dir', StartWorkspaceIndex=dirBgPids[0], EndWorkspaceIndex=dirBgPids[1])
pid_roi=dirRoiPids[1]-dirRoiPids[0]+1
CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
Divide(LHSWorkspace='base_dir',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='base_dir')
SumSpectra(InputWorkspace='base_dir', OutputWorkspace='base_dir')
LoadInstrument(Workspace='roi_dir', Filename=xmlpath, RewriteSpectraMap=True)
LoadInstrument(Workspace='base_dir', Filename=xmlpath, RewriteSpectraMap=True)
ConvertUnits(InputWorkspace='roi_dir',Target="Wavelength",OutputWorkspace='roi_dir', AlignBins=True)
ConvertUnits(InputWorkspace='base_dir',Target="Wavelength",OutputWorkspace='base_dir', AlignBins=True)
Rebin(InputWorkspace='roi_dir', OutputWorkspace='roi_dir',Params=wave_rebin)
Rebin(InputWorkspace='base_dir', OutputWorkspace='base_dir',Params=wave_rebin)
Minus(LHSWorkspace='roi_dir',RHSWorkspace='base_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_dir')

Divide(LHSWorkspace='roi_ref',RHSWorkspace='roi_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='nor')
ConvertUnits(InputWorkspace='nor', Target='MomentumTransfer',OutputWorkspace='nor',AlignBins=True)
Rebin(InputWorkspace='nor', OutputWorkspace=RQname,Params=q_rebin)

