from mantid.simpleapi import *
import sys
import time
import xml.etree.ElementTree as ET

def readXml(filename):
    tree = ET.parse(filename)
    root = tree.getroot()
    configure={}
    _tmp = root.findall('Sample')[0].text
    configure['Sample']=_tmp
    _tmp = root.findall('sample_PC')[0].text
    configure['sample_PC']=_tmp
    _tmp = root.findall('Direct')[0].text
    configure['Direct']=_tmp
    _tmp = root.findall('direct_PC')[0].text
    configure['direct_PC']=_tmp
    _tmp = root.findall('roiStart')[0].text
    configure['roiStart']=_tmp
    _tmp = root.findall('roiEnd')[0].text
    configure['roiEnd']=_tmp
    _tmp = root.findall('bgRoiStart')[0].text
    configure['bgRoiStart']=_tmp
    _tmp = root.findall('bgRoiEnd')[0].text
    configure['bgRoiEnd']=_tmp
    _tmp = root.findall('L2')[0].text
    configure['L2']=_tmp
    _tmp = root.findall('rotateAngle')[0].text
    configure['rotateAngle']=_tmp
    _tmp = root.findall('wmin')[0].text
    configure['wmin']=_tmp
    _tmp = root.findall('wmax')[0].text
    configure['wmax']=_tmp
    _tmp = root.findall('qmin')[0].text
    configure['qmin']=_tmp
    _tmp = root.findall('qbin')[0].text
    configure['qbin']=_tmp
    _tmp = root.findall('qmax')[0].text
    configure['qmax']=_tmp

    return configure

def Reduction():
    conf=readXml('./configure.xml')
    ref_run=conf['Sample']
    pc_ref=float(conf['sample_PC'])
    dir_run=conf['Direct']
    pc_dir=float(conf['direct_PC'])
    rotateAngle=float(conf['rotateAngle'])
    r1=int(conf['roiStart'])
    r2=int(conf['roiEnd'])
    roiPids=[]
    roiPids.append(int(conf['roiStart']))
    roiPids.append(int(conf['roiEnd']))
    bgPids=[]
    bgPids.append(int(conf['bgRoiStart']))
    bgPids.append(int(conf['bgRoiEnd']))
    w1=float(conf['wmin'])
    w2=float(conf['wmax'])
    wave_rebin=str(w1)+',0.001,'+str(w2)
    q1=float(conf['qmin'])
    q2=float(conf['qbin'])
    q3=float(conf['qmax'])
    q_rebin=str(q1)+','+str(q2)+','+str(q3)
    
    path=sys.path[0]

    LoadNexus(Filename=ref_run, OutputWorkspace='tmp')
    #pc norm
    CreateSingleValuedWorkspace(OutputWorkspace='pc_ref', DataValue=pc_ref)
    Divide(LHSWorkspace='tmp',RHSWorkspace='pc_ref',AllowDifferentNumberSpectra=True, OutputWorkspace='tmp')
    #===========ROI=================
    CropWorkspace(InputWorkspace='tmp', OutputWorkspace='roi_tmp', StartWorkspaceIndex=roiPids[0], EndWorkspaceIndex=roiPids[1])
    #pid norm
    pid_roi=roiPids[1]-roiPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
    Divide(LHSWorkspace='roi_tmp',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_tmp')
    SumSpectra(InputWorkspace='roi_tmp', OutputWorkspace='roi_ref')
    #========baseline==================
    CropWorkspace(InputWorkspace='tmp', OutputWorkspace='base_tmp', StartWorkspaceIndex=bgPids[0], EndWorkspaceIndex=bgPids[1])
    #pid norm
    pid_bg=bgPids[1]-bgPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids2', DataValue=pid_bg)
    Divide(LHSWorkspace='base_tmp',RHSWorkspace='pids2',AllowDifferentNumberSpectra=True, OutputWorkspace='base_tmp')
    SumSpectra(InputWorkspace='base_tmp', OutputWorkspace='base_ref')
    #substract baseline
    LoadInstrument(Workspace='roi_ref', Filename=path+'/paramData/onePid.xml', RewriteSpectraMap=True)
    LoadInstrument(Workspace='base_ref', Filename=path+'/paramData/onePid.xml', RewriteSpectraMap=True)
    if rotateAngle != 0:
        RotateInstrumentComponent(Workspace="roi_ref", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
        RotateInstrumentComponent(Workspace="base_ref", ComponentName="Bank01", X=0, Y=1, Z=0, Angle=rotateAngle)
    else:
        pass
    ConvertUnits(InputWorkspace='roi_ref',Target="Wavelength",OutputWorkspace='roi_ref', AlignBins=True)
    ConvertUnits(InputWorkspace='base_ref',Target="Wavelength",OutputWorkspace='base_ref', AlignBins=True)
    Rebin(InputWorkspace='roi_ref', OutputWorkspace='roi_ref',Params=wave_rebin)
    Rebin(InputWorkspace='base_ref', OutputWorkspace='base_ref',Params=wave_rebin)
    Minus(LHSWorkspace='roi_ref',RHSWorkspace='base_ref',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_ref')
    ConvertUnits(InputWorkspace='roi_ref', Target='MomentumTransfer',OutputWorkspace='roi_ref_q',AlignBins=True)
    SaveAscii(InputWorkspace= 'roi_ref_q', Filename='./sam_raw.dat')


    LoadNexus(Filename=dir_run, OutputWorkspace='dir')
    #pc norm
    CreateSingleValuedWorkspace(OutputWorkspace='pc_dir', DataValue=pc_dir)
    Divide(LHSWorkspace='dir',RHSWorkspace='pc_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='dir')
    #===========ROI=================
    CropWorkspace(InputWorkspace='dir', OutputWorkspace='roi_dir', StartWorkspaceIndex=roiPids[0], EndWorkspaceIndex=roiPids[1])
    #pid norm
    pid_roi=roiPids[1]-roiPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
    Divide(LHSWorkspace='roi_dir',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_dir')
    SumSpectra(InputWorkspace='roi_dir', OutputWorkspace='roi_dir')
    #========baseline==================
    CropWorkspace(InputWorkspace='dir', OutputWorkspace='base_dir', StartWorkspaceIndex=bgPids[0], EndWorkspaceIndex=bgPids[1])
    pid_roi=roiPids[1]-roiPids[0]+1
    CreateSingleValuedWorkspace(OutputWorkspace='pids', DataValue=pid_roi)
    Divide(LHSWorkspace='base_dir',RHSWorkspace='pids',AllowDifferentNumberSpectra=True, OutputWorkspace='base_dir')
    SumSpectra(InputWorkspace='base_dir', OutputWorkspace='base_dir')
    LoadInstrument(Workspace='roi_dir', Filename='./paramData/onePid.xml', RewriteSpectraMap=True)
    LoadInstrument(Workspace='base_dir', Filename='./paramData/onePid.xml', RewriteSpectraMap=True)
    ConvertUnits(InputWorkspace='roi_dir',Target="Wavelength",OutputWorkspace='roi_dir', AlignBins=True)
    ConvertUnits(InputWorkspace='base_dir',Target="Wavelength",OutputWorkspace='base_dir', AlignBins=True)
    Rebin(InputWorkspace='roi_dir', OutputWorkspace='roi_dir',Params=wave_rebin)
    Rebin(InputWorkspace='base_dir', OutputWorkspace='base_dir',Params=wave_rebin)
    Minus(LHSWorkspace='roi_dir',RHSWorkspace='base_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='roi_dir')
    SaveAscii(InputWorkspace= 'roi_ref', Filename='./dir_raw.dat')

    Divide(LHSWorkspace='roi_ref',RHSWorkspace='roi_dir',AllowDifferentNumberSpectra=True, OutputWorkspace='nor')
    ConvertUnits(InputWorkspace='nor', Target='MomentumTransfer',OutputWorkspace='nor',AlignBins=True)
    Rebin(InputWorkspace='nor', OutputWorkspace='RQ',Params=q_rebin)
    SaveAscii(InputWorkspace='RQ', Filename='./RQ.dat')
