#from mantid.simpleapi import *
import time
import sys
import subprocess
import os
import glob
import shutil
import re
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler
import DAQParser

class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename=os.getcwd()+'/recNxs.log',
                filemode='a')

        self.logger = logging.getLogger('auto')
        hdlr = RotatingFileHandler(os.getcwd()+'/nxs.log', maxBytes=100, backupCount=0)

    def getLog(self):
        return self.logger


class recNexus():
    def __init__(self, logger, beamline,runno):
        self.logger = logger
        self.beamline=beamline
        self.runNo = 'RUN'+str(runno).zfill(7)
        self.moduleList=["module1"]

        self.ctrlPath = "/opt/CSNSDATA/TS1/"+self.beamline+"/Control/"
        self.daqDataPath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/"
        self.databasePath = os.getcwd()+"/database/"
        self.curPath = os.getcwd()


    def createRunFolder(self):
        if os.path.exists(self.curPath+"/"+self.runNo):
            pass
        else:
            os.mkdir(self.curPath+"/"+self.runNo)
        tmp=self.curPath+"/"+self.runNo+'/tmpData'
        if os.path.exists(tmp):
            _cmd="rm -rf "+tmp+'/*'
            subprocess.check_call(_cmd, shell=True)
        else:
            os.mkdir(tmp)

    def parserDaq(self,t0,t1):
        for name in self.moduleList:
            _cmd="python drone_He3_T0.py "+self.runNo+" "+self.curPath+" "+str(t0)+" "+str(t1)+" &"
            subprocess.check_call(_cmd, shell=True)

    def getStartEndTime(self):
        rawpath="/opt/CSNSDATA/TS1/BL02/Control/"+self.runNo
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        xmlfile=xmllist[0]
        root = ET.parse(xmlfile)
        ns=''
        nsmatch=re.match('\{.*\}', root.getroot().tag)
        if nsmatch:
            ns=nsmatch.group(0)
        for item in root.findall(ns+'NXentry'):
            tmp = item.findtext(ns+'start_time_utc')
            tmp=tmp.split()
            startTime=tmp[0]+"T"+tmp[1]
            tmp = item.findtext(ns+'end_time_utc')
            tmp=tmp.split()
            endTime=tmp[0]+"T"+tmp[1]
        return startTime, endTime


    def getT0(self,t1,t2):
        rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/"+self.runNo+"/"
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        xmlfile=xmllist[0]
        root = ET.parse(xmlfile)
        ns=''
        nsmatch=re.match('\{.*\}', root.getroot().tag)
        if nsmatch:
            ns=nsmatch.group(0)
        for item in root.findall(ns+'T0'):
            item = item.find(ns+'files')
            filename = item.findtext(ns+'file')
        filepath=rawpath+filename
        T0Start, T0End=DAQParser.parseT0(filepath, t1, t2)
        return T0Start, T0End


if __name__=="__main__":
    _log=myLog()
    logger= _log.getLog()

    tslice = recNexus(logger, "BL02", 10645)

    localStart, localEnd = tslice.getStartEndTime()
    print localStart, localEnd
    start=DAQParser.local2utc(localStart)
    localEnd="2020-06-19T10:43:34"
    end=DAQParser.local2utc(localEnd)
    utcStart=start
    utcEnd=end
    T0Start, T0End=tslice.getT0(utcStart, utcEnd)
    tslice.createRunFolder()
    tslice.parserDaq(0,T0End)
