#!/usr/bin/env python
# -*- coding:utf-8 -*-
# author: H.L. TIAN 2017
import DroNECore
import sys
import os
import glob
import re


if __name__ == "__main__":

    detType='He3'
    runnum = sys.argv[1] 
    modulenum = 2
    prepath = sys.argv[2] 
    m_modulename = 'module1'
    from xml.etree import ElementTree as ET
    root = ET.parse('drone_conf.xml')
    tof  = root.find('tofInformation')
    factor = 80  # 25ns to 1us
    m_tofstart= int(tof.attrib['tofstart'])*factor
    m_tofstep = int(tof.attrib['tofstep'])*factor
    m_tofbins = int(tof.attrib['tofbin'])
    
    threshold = root.find('threshold')
    value = int(threshold.attrib['value'])
    for item in root.findall('type'):
        if detType==item.attrib['name']:
            item2=item.find('component')
            m_moduleinfo = item2.attrib
    idstart = int(m_moduleinfo['idstart'])
    idsize  = int(m_moduleinfo['pixels'])
    print idstart,idsize

    #parse daq xml
    rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/"+runnum+"/"
    print rawpath
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    print xmllist
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    #print root.tag
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
        print ns

    #ns="{http://xmlns.csns.ihep.ac.cn/xml/ns/descriptor}"
    for item in root.findall(ns+'module'):
        #print item
        if item.attrib['id']== str(modulenum):
            #print "modulenum: ",num
            item = item.find(ns+'files')
            filename = item.findtext(ns+'file')
    print filename

    T0start=1
    T0end=351200000
    #import Sniper
    task = DroNECore.DroNE("task")
    task.asTop()
    task.setLogLevel(0)

    import DataSvc
    import CtrlSvc
    task.property("svcs").append("MRDataSvc/DataSvc")
    #task.property("svcs").append("SANSDataSvc/DataSvc")
    task.property("svcs").append("CtrlSvc")
    task.property("svcs").append("He3TRawDataInputSvcV02/DataInputSvc")
    task.property("svcs").append("FileInputSvc/DataProvideSvc")
    iDat = task.find("DataSvc")
    iSvc = task.find("DataInputSvc")
    iPvd = task.find("DataProvideSvc")

    #filelist=["./rawData/BL01_RUN167_MODULE01_FILE001_20180111101729.dat"]
    iPvd.property("InputFile").set(rawpath+filename)
    iSvc.property("BuffSize").set(10000)

    iSvc.show()
    iPvd.show()

    import Algorithms
    task.property("algs").append("MRHe3TRecAlg")
    task.property("algs").append("MRHe3TMapAlg")
    task.property("algs").append("RunningInfAlg")
    task.property("algs").append("SaveEvtAlg") 
    task.property("algs").append("SaveHistAlg")
    #task.property("algs").append("SaveMatrix2JSONAlg") 

    #calpath=prepath+"/calibration_factor.txt"
    iRec = task.find("MRHe3TRecAlg")
    iRec.property("threshold").set(value)
    iRec.property("bins").set(300)
    iRec.property('T0start').set(T0start)
    iRec.property('T0end').set(T0end)


    #iRec.property("param_a").set(100.0)
    #iRec.property("param_b").set(153.283)

    iMap = task.find("MRHe3TMapAlg")
    iMap.property("bins").set(300)
    iMap.show()
    
    iRun = task.find("RunningInfAlg")
    iRun.property("TofStart").set(m_tofstart)
    iRun.property("TofStep").set(m_tofstep)
    iRun.property("TofBins").set(m_tofbins)

    histname = prepath+'/'+runnum+'/tmpData/hist_module1.dat'
    print 'histname: ',histname
    iMatrix = task.find("SaveHistAlg")
    #iMatrix = task.find("SaveMatrix2JSONAlg")
    iMatrix.property("PIDStart").set(idstart)
    iMatrix.property("PIDSize").set(idsize)
    iMatrix.property("OutputFileName").set(histname)

    factor = 80
    evtname = prepath+'/'+runnum+'/tmpData/evt_module1.dat'
    iEvt = task.find("SaveEvtAlg")
    iEvt.property("Factor").set(factor)
    iEvt.property("OutputFileName").set(evtname)

    task.setEvtMax(-1)
    #task.initialize()
    task.run()

