#!/usr/bin/env python
# -*- coding:utf-8 -*-
# author: H.L. TIAN 2017
import DroNECore
import sys
import os
import glob
import re


if __name__ == "__main__":

    detType='MWPC'

    runnum = sys.argv[1]
    modulenum = 2
    prepath = sys.argv[2]
    m_modulename = 'module'+str(modulenum)


    T0start = 1
    T0end = 40240000


    from xml.etree import ElementTree as ET
    root = ET.parse('drone_conf.xml')
    tof  = root.find('tofInformation')
    factor = 40  # 25ns to 1us
    m_tofstart= int(tof.attrib['tofstart'])*factor
    m_tofstep = int(tof.attrib['tofstep'])*factor
    m_tofbins = int(tof.attrib['tofbin'])
    
    for item in root.findall('type'):
        if item.attrib['name']== detType:
            item2=item.find('component')
            m_moduleinfo = item2.attrib
    idstart = int(m_moduleinfo['idstart'])
    idsize  = int(m_moduleinfo['pixels'])

    #histname = prepath+'/tmpData/module2.dat'

    #parse daq xml
    rawpath="/opt/CSNSDATA/TS1/BL02/DAQ/"+runnum+"/"
    print rawpath
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    print xmllist
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    #print root.tag
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
        print ns

    #ns="{http://xmlns.csns.ihep.ac.cn/xml/ns/descriptor}"
    for item in root.findall(ns+'module'):
        #print item
        if item.attrib['id']== str(modulenum):
            #print "modulenum: ",num
            item = item.find(ns+'files')
            filename = item.findtext(ns+'file')
    print filename

    #import Sniper
    task = DroNECore.DroNE("task")
    task.asTop()
    task.setLogLevel(0)

    import DataSvc
    import CtrlSvc
    task.property("svcs").append("CtrlSvc")
    task.property("svcs").append("MRDataSvcV02/DataSvc")
    task.property("svcs").append("MWPCRawDataInputSvc/DataInputSvc")
    task.property("svcs").append("FileInputSvc/DataProvideSvc")

    iDat = task.find("DataSvc")
    iSvc = task.find("DataInputSvc")
    iPvd = task.find("DataProvideSvc")

    #filelist=["./rawData/BL01_RUN167_MODULE01_FILE001_20180111101729.dat"]
    iPvd.property("InputFile").set(rawpath+filename)
    iSvc.property("BuffSize").set(10000)

    iSvc.show()
    iPvd.show()

    import Algorithms
    task.property("algs").append("MRMWPCRecAlg")
    task.property("algs").append("MRMWPCMapAlg")

    task.property("algs").append("RunningDInfAlg")
    #task.property("algs").append("SaveEvtAlg") 
    task.property("algs").append("SaveHistAlg") 
    #task.property("algs").append("SaveMatrix2JSONAlg")
    iRec = task.find("MRMWPCRecAlg")
    iRec.property("QMin").set(10)
    iRec.property("QMax").set(25)
    iRec.property("xmin").set(0)
    iRec.property("ymin").set(0)
    iRec.property("xmax").set(500)
    iRec.property("ymax").set(500)

    #iRec.property("QMin").set(150) #this is for detector test
    #iRec.property("QMax").set(25)

    iRec.property("T0start").set(T0start)
    iRec.property("T0end").set(T0end)

    iMap = task.find("MRMWPCMapAlg")
    #iMap.property("bins").set(int(idsize/4))
    #iMap.property("ConfigFileName").set("configure.xml")
    iMap.show()

     
    iRun = task.find("RunningDInfAlg")
    iRun.property("TofStart").set(m_tofstart)
    iRun.property("TofStep").set(m_tofstep)
    iRun.property("TofBins").set(m_tofbins)
    
    histname = prepath+'/'+runnum+'/tmpData/hist_module1.dat'
    #iMatrix = task.find("SaveMatrix2JSONAlg")
    iMatrix = task.find("SaveHistAlg")
    iMatrix.property("PIDStart").set(idstart)
    iMatrix.property("PIDSize").set(idsize)
    iMatrix.property("OutputFileName").set(histname)


    task.setEvtMax(-1)
    #task.initialize()
    task.run()

