#from mantid.simpleapi import *
import time
import sys
import subprocess
import os
import glob
import shutil
import re
import threading
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler


class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                filename=os.getcwd()+'/recNxs.log',
                filemode='a')

        self.logger = logging.getLogger('auto')
        hdlr = RotatingFileHandler(os.getcwd()+'/nxs.log', maxBytes=100, backupCount=0)

    def getLog(self):
        return self.logger


class recNexus(threading.Thread):
    def __init__(self, logger, beamline):
        threading.Thread.__init__(self)
        self.logger = logger
        self.beamline = beamline
        if(self.beamline == "BL18"):
            self.moduleList=['module521', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643','module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343','module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443','module123', 'module131', 'module132', 'module133','module141','module142','module143','module221','module231', 'module232', 'module233','module241','module242','module243']
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/complete/"
        elif(self.beamline == "BL01"):
            self.moduleList=["module1","module2","module3","module4","module5","module6","module7","module8","module9","module10"]
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/Completed/"
        elif(self.beamline == "BL02"):
            self.moduleList=["module1"]
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/Completed/"

        else:
            self.moduleList=["module1"]
            self.daqCompletePath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/complete/"

        if(self.beamline=="BL02"):
            self.monCompletePath ="/opt/CSNSDATA/TS1/"+self.beamline+"/Monitor/complete/Monitor1/"
        else:
            self.monCompletePath ="/opt/CSNSDATA/TS1/"+self.beamline+"/Monitor/complete/Monitor2/"

        self.ctrlPath = "/opt/CSNSDATA/TS1/"+self.beamline+"/Control/"
        self.daqDataPath = "/opt/CSNSDATA/TS1/"+self.beamline+"/DAQ/"
        self.databasePath = os.getcwd()+"/database/"
        self.curPath = os.getcwd()


    def getFolderList(self, path):
        pattern="^RUN[0-9]{7}"
        runNo=[]
        for dirpath, dirnames, files in os.walk(path):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))
        runNo.sort()
        return runNo

    def getFileList(self, path):
        pattern="^RUN[0-9]{7}"
        runNo=[]
        runStr=glob.glob(path+'RUN*')
        for r in runStr:
            try:
                runNo.append(int(r[-7:]))
            except:
                pass
        runNo.sort()
        return runNo

    def createRunFolder(self):
        if os.path.exists(self.curPath+"/"+self.runNo):
            pass
        else:
            os.mkdir(self.curPath+"/"+self.runNo)
        tmp=self.curPath+"/"+self.runNo+'/tmpData'
        if os.path.exists(tmp):
            _cmd="rm -rf "+tmp+'/*'
            subprocess.check_call(_cmd, shell=True)
        else:
            os.mkdir(tmp)


    def getDetMode(self):
        rawpath = self.ctrlPath+self.runNo+"/"
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        if len(xmllist)== 0:
            logger.warning('no xml file in Control for '+self.runNo)
        else:
            xmlfile=xmllist[0]
            root = ET.parse(xmlfile) 
            ns = ''
            nsmatch=re.match('\{.*\}', root.getroot().tag)
            if nsmatch:
                ns=nsmatch.group(0)
                print ns
            mode = root.findtext(ns+"NXentry/"+ns+"NXinstrument/"+ns+"NXdetector/"+ns+"detector_mode")

            print mode
            return mode

    def parserDaq(self):
        rawpath=self.daqDataPath+self.runNo+"/"
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        if len(xmllist)== 0:
            logger.warning('no xml file in DAQ for '+self.runNo)
            judge=False
        else:
            try:
                xmlfile=xmllist[0]
                root = ET.parse(xmlfile)
                judge=True
            except:
                logger.warning('error in parse xml for daq for '+self.runNo)
                _cmd="cp "+xmlfile+" "+self.curPath+"/"+self.runNo+'/'
                subprocess.check_call(_cmd, shell=True)
                judge=False

        if judge:
            for name in self.moduleList:
                _cmd="python drone_"+self.detMode+".py "+self.runNo+" "+self.curPath+" &"
                subprocess.check_call(_cmd, shell=True)
            for name in self.moduleList:
                while not os.path.exists(self.curPath+"/"+self.runNo+"/tmpData/hist_"+name+'.dat'):
                    time.sleep(5)
                #logger.debug(name+" exists!")
        else:
            pass

    def checkData(self):
        import numpy
        fpath = self.curPath+"/"+self.runNo+"/tmpData/hist_module1.dat"
        a=numpy.loadtxt(fpath, delimiter=";")
        x=a.shape[0]
        y=a.shape[1]
        if self.detMode=="He3":
            if x==1200 and y==10000:
                return False
            else:
                return True
        else:
            if x==4600 and y==10000:
                return False
            else:
                return True

    def recAlg(self):
        _cmd="./gen_nexus.exe "+self.runNo
        pro = True
        while(pro):
            try:
                subprocess.check_call(_cmd, shell=True)
                pro = False
                while not os.path.exists(self.curPath+"/"+self.runNo+"/complete.dat"):
                    time.sleep(5)
            except:
                pro =True
                time.sleep(10)
                self.logger.warning("waiting for hist data!")




    def setNxsData(self):
        _cmd="rm -rf "+self.curPath+"/"+self.runNo+"/complete.dat"
        subprocess.check_call(_cmd, shell=True)
        _cmd="rm -rf "+self.curPath+"/"+self.runNo+"/tmpData"
        subprocess.check_call(_cmd, shell=True)

        #'''
        f=open(self.curPath+"/database/"+self.runNo, "w")
        f.close()
        try:
            f=open("complete", "w")
            f.close()
        except:
            pass
        transPath = "transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/"+self.beamline+"/"
        _cmd = 'scp -r '+self.runNo+' '+transPath
        subprocess.check_call(_cmd, shell=True)

        newServerPath = "zhanxz@10.1.252.40:/home/zhanxz/nxsData/"
        _cmd = 'scp -r '+self.runNo+' '+newServerPath
        subprocess.check_call(_cmd, shell=True)


        transPath = transPath+self.runNo
        _cmd = 'scp complete  '+transPath
        subprocess.check_call(_cmd, shell=True)
        _cmd = 'rm -rf '+self.runNo
        subprocess.check_call(_cmd, shell=True)
        #'''

    def process(self):
        ctrlRunList = self.getFolderList(self.ctrlPath)
        daqCompleteRunList = self.getFileList(self.daqCompletePath)
        monCompleteRunList = self.getFileList(self.monCompletePath)
        databaseList = self.getFileList(self.databasePath)

        newList =[] 
        for cRun in ctrlRunList:
            if cRun>9135 and cRun not in databaseList:
                if cRun in daqCompleteRunList:
                    #if cRun in monCompleteRunList:
                    newList.append(cRun)
                    #else:
                    #    self.logger.debug("missed by monitor: "+str(cRun))
                else:
                    self.logger.debug("missed by daq: "+str(cRun))
        self.logger.debug("to be reconstructed: "+str(newList))
        #print "newList: ",newList
        #sys.exit()
    
        #newList=[9906,9907,9908,9900,9901,9902,9903,9904,9905]
        for run in newList:
            self.runNo = "RUN"+str(run).zfill(7)
            self.createRunFolder()            
            self.detMode = self.getDetMode()
            if self.detMode !="He3" and self.detMode != "MWPC":
                self.detMode = "He3"
            self.logger.warning(self.detMode)
            self.parserDaq()
            judge = self.checkData()
            while(judge):
                time.sleep(10)
                judge = self.checkData()           
            self.recAlg()
            self.setNxsData()
        #sys.exit()

    def run(self):
        while True:
            self.process()
            time.sleep(600.0)


if __name__=="__main__":
    _log=myLog()
    logger= _log.getLog()


    threadDaemon = recNexus(logger, "BL02")
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()


