#!/usr/bin/env python
#-*- coding: UTF-8 -*-

import sys, os, struct, time, io, calendar, datetime, pytz
from collections import namedtuple


def local2utc(local):
    # Local datatime string to utc seconds.
    #local='2018-03-26T15:28:42'
    dateTimeString='%Y-%m-%dT%H:%M:%S'
    localTimeZone = pytz.timezone("Asia/Shanghai")
    localTime = datetime.datetime.strptime(local, dateTimeString)
    #print "Local seconds: ", time.mktime(localTime.timetuple())
    local_dt = localTimeZone.localize(localTime, is_dst=None)
    #print "Local seconds: ", time.mktime(local_dt.timetuple())
    utc_dt = local_dt.astimezone(pytz.utc)
    utcSecond = calendar.timegm(utc_dt.timetuple())
    #print "local time string: ",local,", local_dt: ",local_dt, ", utc_dt", utc_dt, ", UTC seconds: ", utcSecond
    return utcSecond


def parseT0(filename, utcStartSecond, utcEndSecond):

    DaqModule = namedtuple('DaqModule', 'headerTag, beamlineId, detectorTypeId, moduleId, runMode, frequencyMode, version, reserve1, t0Count, reserve2, reserve3, t_39_8, h0, t_7_0, packed, tailTag, status, byteCount')

    deltaSecond = 37
    #utcStart='2018-03-15T06:28:42'
    #utcEnd='2018-03-15T07:54:03'
    
    #utcStartSecond=local2utc(localStart)
    #utcEndSecond=local2utc(localEnd)

    #dateTimeString='%Y-%m-%dT%H:%M:%S'
    #utcStartSecond = calendar.timegm(time.strptime(utcStart, dateTimeString))
    taiStartSecond = utcStartSecond + deltaSecond
    #print taiStartSecond
    #utcEndSecond = calendar.timegm(time.strptime(utcEnd, dateTimeString))
    taiEndSecond = utcEndSecond + deltaSecond
    #print taiEndSecond

    chunksize=40
    #print filename
    with io.open(filename, 'rb') as f:
        # Find the header of the module
        headerFound = False
        readCount = 0
        while headerFound == False:
            chunk = f.read(1)
            readCount+=1
            # The end of the file
            if chunk == "":
                print "Error: no header found!"
                exit
            if chunk == '\xfa' or chunk == '\xFA':
                #print "Header found at byte: ", readCount
                headerFound = True
                f.seek(-1, os.SEEK_CUR)
        
        list2 = []
        #for i in range(8):
        chunk = f.read(chunksize)
        while chunk:
            try:
                module1 = DaqModule._make(struct.unpack('>BBBBBBBBLLLL3sBLB3sL',chunk))
                #print module1
                if module1.headerTag != 250 or module1.tailTag != 251:
                    print "Wrong module!"
                    continue

                taiSec = (module1.t_39_8 << 8) + module1.t_7_0
                utcSec = taiSec - deltaSecond
                #utcSec = time.localtime(utcSec)
                #print "TAI Seconds: ", taiSec
                #print "UTC Date time: ", time.strftime('%Y-%m-%d %H:%M:%S', time.gmtime(utcSec))
                #print "Local Date time: ", time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(utcSec))
                tag = (module1.packed >> 28)
                #print tag 
                # 8 ns
                subSeconds = (module1.packed & 0x0fffffff) * 8
                #print "Sub seconds:(ns) ", subSeconds

                if taiSec > taiEndSecond:
                    #True
                    break
                if taiSec == taiStartSecond:
                    list1 = []
                    list1.append(int(module1.t0Count))
                    list1.append(int(taiSec))
                    if len(list2) == 0:
                        list2.append(list1)
                    else:
                        list2[0] = list1
                if taiSec == taiEndSecond:
                    list1 = []
                    list1.append(int(module1.t0Count))
                    list1.append(int(taiSec))
                    list2.append(list1)
                    break
                if taiSec > taiStartSecond and taiSec < taiEndSecond:
                    list1 = []
                    list1.append(int(module1.t0Count))
                    list1.append(int(taiSec))
                    list2.append(list1)
                
            except Exception, ex:
                #print ex.message
                #pass
                print "The last module is incompleted, skipped."
                break
            chunk = f.read(chunksize)
            
        #print list2
        return list2[0][0],list2[-1][0]
