#!/usr/bin/env python

'''Calculate PDF of FCC nickel.  Save data to calculation.cgr.
'''

from diffpy.pdffit2 import PdfFit
from diffpy.structure.tests.testutils import datafile
from diffpy.structure import Structure
import matplotlib.pyplot as plt
import numpy as np

name='Si'
ciffile=name+'.cif'
strufile=name+'.stru'
grfile=name+'.gr'

stru_check = Structure()
stru_check.read(ciffile)
stru_check.write(strufile, 'discus')

# create new PDF calculator object
P = PdfFit()

# load structure file in PDFFIT or DISCUS format
P.read_struct(strufile)

radiation_type = 'N'  # x-rays
qmax = 50.0  # Q-cutoff used in PDF calculation in 1/A
qdamp = 0.01 # instrument Q-resolution factor, responsible for PDF decay
rmin = 0.01  # minimum r-value
rmax = 50.0  # maximum r-value
npts = 3000  # number of points in the r-grid

# allocate and configure PDF calculation
P.alloc(radiation_type, qmax, qdamp, rmin, rmax, npts)
P.calc()

P.save_pdf(1, grfile)
print (grfile)
grdata=np.loadtxt(grfile, delimiter=' ', unpack=True)

print (grdata[0])
plt.plot(grdata[0],grdata[1])
plt.show()
