#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include "napi.h"
#include <iostream>
#include <fstream>
#include <sstream>

using namespace std;

int main(int argc, char *argv[]){
    if(argc<=1)
    {
        printf("Usage:%s runNumber monitorName pixels prepath \n", argv[0]);
        printf("Example:%s 122 monitor1 1024 /home/mantid/workspace/offline_hist \n", argv[0]);
        return 0;
    }
    
    string runnum=argv[1];
    //runnum = "RUN"+runnum;
    string monitor=argv[2];
    string pixelsNum = argv[3];
    string prepath = argv[4];

    DIR *dirp;
    struct dirent *dp;
    monitor[0]=toupper(monitor[0]);
    string filepath="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/"+monitor+"/"+runnum;
    dirp=opendir(filepath.c_str());
    while((dp = readdir(dirp))!=NULL)
    {if(strlen(dp->d_name)<=3) continue;
        string target;
        target=filepath+"/"+dp->d_name;
        monitor[0]=tolower(monitor[0]);
        cout<<target<<endl;
        std::ifstream histfile(target.c_str(), ios::binary);
        const int pixels = atoi(pixelsNum.c_str());
        const int timeBin = 40000;
        uint32_t** buffer = new uint32_t* [pixels];
        if(histfile.is_open()){
            histfile.seekg(0, histfile.end);
            histfile.seekg(0, histfile.beg);
            for(int i = 0; i< pixels; i++){
                buffer[i] = new uint32_t [timeBin];
                histfile.read((char*)buffer[i],timeBin*sizeof(uint32_t));
            }
            histfile.close();
        // test neutron counts
        int a=0;
        for(int i=0; i<pixels; i++){
            for(int j=0; j<timeBin; j++){
                a+=buffer[i][j];
            }
        }
        cout<<"total neutron counts: "<<a<<endl;

        }else{
            cout<<"can't open file!"<<endl;
        }

        std::stringstream retVal;
        retVal << "[";
        for(uint32_t i = 0; i < uint32_t(pixels); i++){
            if(0<i)
                retVal << ",";
            retVal << "[";
            for(uint32_t j = 0; j < timeBin; j++){
                if(0<j)retVal << ",";
                retVal << buffer[i][j];
            }
            retVal << "]";
        }
        retVal << "]";
        std::ofstream m_ofstream;
        string m_outputfile=prepath+"/tmpData/"+monitor+".dat";
        m_ofstream.open(m_outputfile.c_str(),ios::out);
        m_ofstream<<retVal.str()<<endl;
        m_ofstream.close();

        for(int i=0; i<pixels; i++)
            delete [] buffer[i];
        delete [] buffer;
    }
    return 0;
}
