#!/usr/bin/env python
# -*- coding:utf-8 -*-
# author: H.L. TIAN 2017
# modified by DR 2017
#import Sniper
import os
import glob
import DroNECore
import CtrlSvc
import DataSvc
import sys
import re

if __name__ == "__main__":

    runnum = sys.argv[1]
    m_modulename = sys.argv[2]
    prepath = sys.argv[3]
    #print m_runnum
    # parse configure.xml
    from xml.etree import ElementTree as ET
    root1 = ET.parse('configure.xml')
    tof  = root1.find('tofInformation')
    factor = 40  # 25ns to 1us
    m_tofstart= int(tof.attrib['tofstart'])*factor
    m_tofstep = int(tof.attrib['tofstep'])*factor
    m_tofbins = int(tof.attrib['tofbin'])

    for item in root1.findall('type/component'):
        if m_modulename== item.attrib['name']:
            m_moduleinfo = item.attrib

    modulenum = m_moduleinfo['moduleNum']
    idstart = int(m_moduleinfo['idstart'])
    idsize  = int(m_moduleinfo['pixels'])

    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/"+runnum+"/"
    print rawpath
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    xmlfile=xmllist[0]
    root = ET.parse(xmlfile)
    ns=''
    nsmatch=re.match('\{.*\}', root.getroot().tag)
    if nsmatch:
        ns=nsmatch.group(0)
        print ns

    T0start=1
    T0end=351200000


    for item in root.findall(ns+'module'):
        if item.attrib['id']== modulenum:
            #print modulenum
            item = item.find(ns+'files')
            #filenum = int(item.attrib['total'])
            filename = item.findtext(ns+'file')
    print filename
    ## ===========================
    ## DroNE
    ## ===========================

    task = DroNECore.DroNE("task")
    #task = Sniper.Task("task")
    task.asTop()
    task.setLogLevel(3)
    

    ## ===========================
    task.property("svcs").append("CtrlSvc")
    task.property("svcs").append("GPPDDataSvc/DataSvc")
    task.property("svcs").append("RawDataInputSvc/DataInputSvc")
    task.property("svcs").append("FileInputSvc/DataProvideSvc")
    iDat = task.find("DataSvc")
    iSvc = task.find("DataInputSvc")
    iPvd = task.find("DataProvideSvc")

    #filelist = ["RUN119/BL18_RUN119_MODULE21_0000001_2017_11_2_19_31_27.dat"]
    #iPvd.property("InputFile").set(filelist) #"N_3Cdmaskslit.dat", 
    iPvd.property("InputFile").set(rawpath+filename) #"N_3Cdmaskslit.dat", 
    iSvc.property("BuffSize").set(5000)

    iSvc.show()
    iPvd.show()

    ## ===========================
    import Algorithms
    task.property("algs").append("GPPDSNDRecAlg")
    task.property("algs").append("GPPDSNDMapAlg")
    task.property("algs").append("RunningInfAlg")
    #task.property("algs").append("DumpAlg")
    task.property("algs").append("SaveMatrix2JSONAlg")

    iRec = task.find("GPPDSNDRecAlg")
    iRec.property('T0start').set(T0start)
    iRec.property('T0end').set(T0end)


    iMap = task.find("GPPDSNDMapAlg")
    iMap.property("ConfigFileName").set("configure.xml")

    iRun = task.find("RunningInfAlg")
    iRun.property("TofStart").set(m_tofstart)
    iRun.property("TofStep").set(m_tofstep)
    iRun.property("TofBins").set(m_tofbins)

    histname = prepath+'/tmpData/'+m_modulename+'.dat'
    #histpath="/home/gppd/workspace/reconstruction_data/histdata/"+m_runnum
    #histpath="/home/gppd/workspace/hist/data/"+m_runnum
    #print histpath
    #if os.path.exists(histpath):
    #    pass
    #else:
    #    os.mkdir(histpath)
    iMatrix = task.find("SaveMatrix2JSONAlg")
    iMatrix.property("PIDStart").set(idstart)
    iMatrix.property("PIDSize").set(5328)
    iMatrix.property("OutputFileName").set(histname)

    ## ===========================
    task.setEvtMax(-1)
    task.run()
