from mantid.simpleapi import *
import json
import time
import sys
import numpy
import subprocess
import os
#import matplotlib.pyplot as plt
import glob
import shutil
import re

def parseDaq(prepath,runno, modulenum, moduleList, T0start, T0end):
    for i in range(modulenum):
        subprocess.check_call("python binary_hist_T0.py "+runno+" "+moduleList[i]+" "+prepath+" "+str(T0start)+" "+str(T0end)+" &", shell=True)
    for i in range(modulenum):
        while not os.path.exists(prepath+"/tmpData/"+moduleList[i]+".dat"):
            print "no data"
            time.sleep(3)
        print moduleList[i]," exists!"
 
def parseMonitor(prepath, runno, monitor, pixels):
    _cmd="./main "+runno+" "+monitor+" "+str(pixels)+" "+prepath
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/tmpData/"+monitor+".dat"):
        print "no data"
        time.sleep(3)
    print "finish parse monitor binary data for ", monitor
    
def getDaq(prepath, moduleList, delay):
    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    m_tofstart= int(tof.attrib['tofstart'])
    m_tofstep = int(tof.attrib['tofstep'])
    m_tofbins = int(tof.attrib['tofbin'])
    tof = [m_tofstart+i*m_tofstep+delay for i in xrange(m_tofbins+1)]
    mpid=[]
    value=[]
    for name in moduleList:
        for item in root.findall('type/component'):
            if name== item.attrib['name']:
                m_moduleinfo = item.attrib
                idstart = int(m_moduleinfo['idstart'])
                idsize  = int(m_moduleinfo['pixels'])
                _tmp = [idstart+i*1 for i in xrange(idsize)]
                for num in _tmp:
                    mpid.append(num)
        f0=open(prepath+'/tmpData/'+name+'.dat',"r")
        _tmpv=json.load(f0)
        v=[]
        for ix in _tmpv:
            for iy in ix:
                v.append(iy)
        for num in v:
            value.append(num)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "daq data match failed!"
        #_cmd="rm -rf "+prepath+"/tmpData"
        #subprocess.check_call(_cmd, shell=True)
        sys.exit()

def getMonitor(prepath, monitor, pixels, delay):
    mpid=[1+i for i in xrange(pixels)]
    tof=[0+i+delay for i in xrange(40001)]
    f0=open(prepath+"/tmpData/"+monitor+".dat")
    _tmpv=json.load(f0)
    value=[]
    for ix in _tmpv:
        for iy in ix:
            value.append(iy)
    if len(mpid)*(len(tof)-1)==len(value):
        return mpid, tof ,value   
    else:
        print "monitor data match failed!"
        #_cmd="rm -rf "+prepath+"/tmpData"
        #subprocess.check_call(_cmd, shell=True)
        sys.exit()

def checkNewRun():
    prepath=sys.path[0]
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/complete"
    daqList=os.listdir(rawpath)
    runList=os.listdir(prepath)
    newList=[]
    for name in daqList:
        if name[0]=='R':
            if name in runList:
                pass
            else:
                newList.append(name)
    return newList

# usage: python hist_nxs.py banknum 
def createNexus(runNo, delay, T0start, T0end):
    runno="RUN"+str(runNo).zfill(7)

    prepath=sys.path[0]+'/'+runno
    prepath2=sys.path[0]
    if os.path.exists(prepath):
        pass
    else:
        os.mkdir(prepath)
    tmp=prepath+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    print 'mkdir ',tmp
    moduleList=[['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543','module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643'], ['module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343','module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443'],['module131', 'module132', 'module133','module231', 'module232', 'module233']]
    #moduleList=[['module131', 'module132', 'module133','module231', 'module232', 'module233']]
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/"+runno
    xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmlfile)==0:
        print "no data in ",runno, " for DAQ"
    else:
        for i in range(3):
            parseDaq(prepath, runno, len(moduleList[i]), moduleList[i], T0start, T0end)
            spid, stof, svalue = getDaq(prepath, moduleList[i], delay)
            LoadCSNSRaw(OutputWorkspace="sample", PixelID_bank=spid, TimeOfFlight_bank=stof, Counts_bank=svalue, PixelID_monitor=[0,1], TimeOfFlight_monitor=[0,16], Counts_monitor=[1,1])
            LoadInstrument(Workspace="sample_1", Filename=prepath2+'/paramData/bank'+str(i+1)+'.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace='sample_1', Filename=prepath+'/bank'+str(i+1)+'.nxs')
            DeleteWorkspace(Workspace='sample_1') 
            print 'finish save nexus for ',runno, ' bank',str(i+1),' ',time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')

    monitorList=['Monitor1','Monitor2','Monitor3']
    monitorPixel={}
    monitorPixel['monitor1']=1024
    monitorPixel['monitor2']=1024
    monitorPixel['monitor3']=1024
    for mname in monitorList:
        # is monitor file exist ?
        rawpath="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/"+mname+"/"+runno
        binfile=glob.glob(os.path.join(rawpath, '*.bin'))
        if len(binfile)==0:
            print "no data in ",runno, " for ",mname
            #sys.exit()
        else:
            #pass
            mname = mname.lower()
            pixels=int(monitorPixel[mname])
            parseMonitor(prepath, runno, mname, pixels)
            mpid=[]
            mtof=[]
            mvalue=[]
            mpid, mtof, mvalue = getMonitor(prepath, mname, pixels, delay)
            # mantid data processing
            LoadCSNSRaw(OutputWorkspace=mname, PixelID_bank=[0,1], TimeOfFlight_bank=[0,8], Counts_bank=[1,1], PixelID_monitor=mpid, TimeOfFlight_monitor=mtof, Counts_monitor=mvalue)
            LoadInstrument(Workspace=mname+"_2", Filename=prepath2+'/paramData/'+mname+'.xml', RewriteSpectraMap='True')
            SaveNexus(InputWorkspace=mname+'_2', Filename=prepath+'/'+mname+'.nxs')
            DeleteWorkspace(Workspace=mname+'_2') 
    
    _cmd="rm -rf "+prepath+"/tmpData"
    subprocess.check_call(_cmd, shell=True)
    

    f=open("./database/"+runno, "w")
    f.close()

    try:
        f=open("complete", "w")
        f.close()
    except:
        pass
    _cmd = 'scp -r '+runno+' transfer@10.1.26.156:/home/transfer/nexus/CSNSDATA/TS1/BL18/'
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'scp complete  transfer@10.1.26.156:/home/transfer/nexus/CSNSDATA/TS1/BL18/'+runno
    subprocess.check_call(_cmd, shell=True)

def getT0(runno, localStart, localEnd):
    # because T0 filename is not in xml, So it needs input the filepath
    filepath="/opt/CSNSDATA/TS1/BL18/DAQ/RUN0000"+runno+'/BL18_RUN0000383_MODULE99_FILE001_20180326020721.dat'
    T0Start, T0End=DAQParser.parseT0(filepath, localStart, localEnd)
    return T0Start, T0End

#!/usr/bin/python
import sys
import time
import os
import DAQParser
if __name__=="__main__":

    runNo = '383'
    delay = 0
    localStart='2018-03-25T16:20:00'
    localEnd='2018-03-25T16:36:02'
    T0Start, T0End=getT0(runNo, localStart, localEnd)


    _b=time.time()
    print "begin:", runNo
    createNexus(runNo, delay, T0Start, T0End)
    print "end:", runNo, (time.time()-_b)/60.0


