#!/usr/bin/python
from mantid.simpleapi import *
import sys
import json
import math

path_cur = "/home/dur/work/PDF"
path_data=path_cur+"/sqNxs"

def loadNxs(count, num):
    fname="/home/dur/work/PDF/sqNxs/sq_"+count+"_"+str(num)+".nxs"
    LoadNexus(Filename=fname, OutputWorkspace=count+"_"+str(num))

def loadData(count, num):
    fname="/home/dur/work/PDF/sqNxs/sq_"+count+"_"+str(num)+".dat"
    LoadAscii(Filename=fname, OutputWorkspace=count+"_"+str(num))

with open(path_cur+"/bankInfo.json", 'r') as f1:
    load_dict = json.load(f1)
countList=[1,4]
for count in countList:
    count=str(count)
    xstep=int(load_dict[count]['step_x'])#get angle(step)
    angleNos=111/xstep
    for i in range(angleNos):
        loadNxs(count, i)
        LoadInstrument(Workspace=count+"_"+str(i),RewriteSpectraMap=True,Filename="/home/dur/work/PDF/std.xml")
        #SaveAscii(InputWorkspace=count+"_"+str(i),Filename="/home/dur/work/PDF/sqNxs/sq_"+count+"_"+str(i)+".dat")

#count='3'
#xstep=int(load_dict[count]['step_x'])#get angle(step)
#angleNos=111/xstep
start=1.2
end=1.6
qStep=",-0.002,"
lhs = "9_5"
rhs = "7_1"
output="a1"
Stitch1D(LHSWorkspace=lhs, RHSWorkspace=rhs, OutputWorkspace=output, StartOverlap=start, EndOverlap=end, Params=qStep,ScaleRHSWorkspace=True, UseManualScaleFactor=False)

test = mtd["point"]
inst = test.getInstrument()
print (inst.getName())

#pdf


#angleNos=5
a=2.7
#count='6'
qStep=',-0.001,'
for i in range(angleNos-1,-1,-1):
    start=a
    end=start+0.1
    print i
    if i!=0:
        lhs = str(count)+"_"+str(i)
        rhs = str(count)+"_"+str(i-1)
        Stitch1D(LHSWorkspace=lhs, RHSWorkspace=rhs, OutputWorkspace=rhs, StartOverlap=start, EndOverlap=end, Params=qStep,ScaleRHSWorkspace=True, UseManualScaleFactor=False)
    else:
        RenameWorkspace(InputWorkspace=count+"_0", OutputWorkspace=count)
   
