import numpy, math
import matplotlib.pyplot as plt

def FTcore(r, q, sq, dq):
    qcut = q.max()
    print(qcut)
    mat = numpy.sin(numpy.outer(r,  q))
    qiq = (sq - 1.0) * q * dq

    if True:
        factor = numpy.sin(math.pi*q / qcut)/(math.pi * q / qcut)
        qiq = qiq * factor
    integral = numpy.inner(mat, qiq)
    return integral
	
r=[]
for i in range(320):
	r.append(1.5+i*0.15)

infile="simSi.dat"
rs, grs, gre=numpy.loadtxt(infile,delimiter=',',unpack=True)
  	
infile="Si_sq_0.06.dat"
q, sq, sqe=numpy.loadtxt(infile,delimiter=',',unpack=True)

for i in sq:
    if i<=0:print(i)
    
r=numpy.array(r)
q=numpy.array(q)
sq=numpy.array(sq)


#compare different scale factor
for k in range(2):
    
    qmax=40
    qnew=[]
    sqnew=[]
    for i in range(len(q)):
        if q[i]<=qmax:
            qnew.append(q[i])
            if k==0:
                a=1#scale factor
                sqnew.append(sq[i]*a)
            else:
                a=7
                sqnew.append(sq[i]*a)
        
    qnew=numpy.array(qnew)
    sqnew=numpy.array(sqnew)
    dq=qnew[1]-qnew[0]
    print(dq)

    Gr=FTcore(r, qnew, sqnew, dq)
    plt.plot(r, Gr, label="coff: "+str(a))

plt.plot(rs, grs,label='sim')
#plt.legend(loc=6)
plt.legend(loc='upper left')
plt.show()

#change qmax value and compare
for k in range(7):
    
    qmax=20+k*5
    qnew=[]
    sqnew=[]
    for i in range(len(q)):
        if q[i]<=qmax:
            qnew.append(q[i])
            sqnew.append(sq[i]*7)
        
    qnew=numpy.array(qnew)
    sqnew=numpy.array(sqnew)
    dq=qnew[1]-qnew[0]
    print(dq)

    Gr=FTcore(r, qnew, sqnew, dq)
    plt.plot(r, Gr, label="qmax: "+str(qmax))

infile="simSi.dat"
rs, grs, gre=numpy.loadtxt(infile,delimiter=',',unpack=True)
    
plt.plot(rs, grs,label='sim')
#plt.legend(loc=6)
plt.legend(loc='upper left')
plt.show()

filelist=["Si_sq_0.02.dat","Si_sq_0.04.dat","Si_sq_0.06.dat"]
qlist=[0.002, 0.004, 0.006]
for k in range(len(filelist)):
    q, sq, sqe=numpy.loadtxt(filelist[k],delimiter=',',unpack=True)
    qmax=40
    qnew=[]
    sqnew=[]
    for i in range(len(q)):
        if q[i]<=qmax:
            qnew.append(q[i])
            sqnew.append(sq[i]*7)
        
    qnew=numpy.array(qnew)
    sqnew=numpy.array(sqnew)
    dq=qnew[1]-qnew[0]
    Gr=FTcore(r, qnew, sqnew, dq)
    plt.plot(r, Gr, label="Qbin: "+str(qlist[k]))
    
plt.plot(rs, grs,label='sim')
#plt.legend(loc=6)
plt.legend(loc='upper left')
plt.show()

