from mantid.simpleapi import *
import os
import numpy as np
import sys
import json


def search(path, name):
    _tmp = ''
    #print path, name
    for item in os.listdir(path):
        
        item_path = os.path.join(path, item)
        if os.path.isdir(item_path):
            search(item_path, name)
            if name in item:
                _tmp=item_path
    return _tmp

def getExpInfo():
    with open("expInfo.json", 'r') as f:
        load_dict = json.load(f)
        return load_dict


def loadWS(filePath):
    print filePath
    LoadCSNSNexus(Filename=filePath, OutputWorkspace='m2', Bankname='module131',Loadmonitor=True, Monitorname='monitor2')
    LoadInstrument(Workspace='m2_2', Filename='./paramData/monitor2.xml', RewriteSpectraMap=True)
    LoadCSNSNexus(Filename=filePath, OutputWorkspace='m3', Bankname='module131',Loadmonitor=True, Monitorname='monitor3')
    LoadInstrument(Workspace='m3_2', Filename='./paramData/monitor3.xml', RewriteSpectraMap=True)

def normData(wave_rebin,output):
    ConvertUnits(InputWorkspace='m2_2', OutputWorkspace='mon2', Target = 'Wavelength', AlignBins = True)
    ConvertUnits(InputWorkspace='m3_2', OutputWorkspace='mon3', Target = 'Wavelength', AlignBins = True)
    Rebin(InputWorkspace = 'mon2', OutputWorkspace = 'mon2', Params = wave_rebin)
    Rebin(InputWorkspace = 'mon3', OutputWorkspace = 'mon3', Params = wave_rebin)
    SumSpectra(InputWorkspace='mon2',OutputWorkspace='mon2')
    name=mtd['mon2']
    value=sum(name.readY(0))
    mtd[output]=mtd['mon3']/value


def processData(samfile, bgfile, wave_rebin, step):
    loadWS(bgfile)
    normData(wave_rebin,'bg')
    loadWS(samfile)
    normData(wave_rebin,'sam')
    Divide(LHSWorkspace="sam", RHSWorkspace="bg", OutputWorkspace='ans', AllowDifferentNumberSpectra=True)
    ReplaceSpecialValues(InputWorkspace='ans',OutputWorkspace='ans',NaNValue=0,InfinityValue=0)
    SaveAscii(Filename='run'+samRun+'_'+step+'.dat', InputWorkspace='ans',Separator='Space')



infoList=getExpInfo()
samRun=str(infoList["samRun"])
samfile=str(infoList["nxsPath"])+samRun.zfill(7)+"/detector.nxs"
bgRun=str(infoList["emptyRun"])
bgfile=str(infoList["nxsPath"])+bgRun.zfill(7)+"/detector.nxs"
waveStart=str(infoList["waveStart"])
waveEnd=str(infoList["waveEnd"])
step=raw_input("input wave_steps (separate by comma):")
step=step.split(",")


#tmp=search(os.environ['HOME'], 'RUN'+samRun.zfill(7))
#print tmp
#+'/detector.nxs'


for i in range(len(step)):
    wave_rebin=waveStart+','+step[i]+','+waveEnd
    print wave_rebin
    processData(samfile, bgfile, wave_rebin, step[i])
   
