from mantid.simpleapi import *
import xml.etree.ElementTree as ET
import sys
import time

def readXml(file):
    tree = ET.parse(file)
    root = tree.getroot()
    configure={}

    _tmp = root.findall('Bank')[0].text
    configure['Bank']=_tmp
    _tmp = root.findall('Module')[0].text
    configure['Module']=_tmp

    _tmp = root.findall('Sample_det')[0].text
    configure['sam_run_det']=_tmp
    _tmp = root.findall('Sample_mon')[0].text
    configure['sam_run_mon']=_tmp
    _tmp = root.findall('Vanadium_det')[0].text
    configure['v_run_det']=_tmp
    _tmp = root.findall('Vanadium_mon')[0].text
    configure['v_run_mon']=_tmp
    _tmp = root.findall('Hold_det')[0].text
    configure['hold_run_det']=_tmp
    _tmp = root.findall('Hold_mon')[0].text
    configure['hold_run_mon']=_tmp
    _tmp = root.findall('Empty_det')[0].text
    configure['empty_run_det']=_tmp
    _tmp = root.findall('Empty_mon')[0].text
    configure['empty_run_mon']=_tmp
    _tmp = root.findall('TF')[0].text
    configure['timeFocus']=_tmp
    _tmp = root.findall('wmin')[0].text
    configure['wmin']=_tmp
    _tmp = root.findall('wmax')[0].text
    configure['wmax']=_tmp
    _tmp = root.findall('dmin')[0].text
    configure['dmin']=_tmp
    _tmp = root.findall('dmax')[0].text
    configure['dmax']=_tmp
    _tmp = root.findall('Absorption')[0].text
    configure['Absorption']=_tmp
    _tmp = root.findall('Multiple_scattering')[0].text
    configure['MS']=_tmp
    _tmp = root.findall('Volume')[0].text
    configure['Volume']=_tmp
    _tmp = root.findall('Mass')[0].text
    configure['Mass']=_tmp
    return configure

def mergeWS(wsList,output):
    for name in wsList:
        LoadNexus(Filename=name,OutputWorkspace=name)
    for i in range(len(wsList)):
        if len(wsList)== 1:
            CloneWorkspace(InputWorkspace=wsList[i], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
        elif wsList[i+1]!=wsList[-1]:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=wsList[i+1])
            DeleteWorkspace(Workspace=wsList[i])
        else:
            Plus(LHSWorkspace=wsList[i],RHSWorkspace=wsList[i+1], OutputWorkspace=output)
            DeleteWorkspace(Workspace=wsList[i])
            DeleteWorkspace(Workspace=wsList[i+1])
            break

def normData(detRun,monRun,wave_rebin,output, monSUM, prepath):
    mergeWS(detRun,'s')
    CloneWorkspace(InputWorkspace='s', OutputWorkspace='tmp')
    ConvertUnits(InputWorkspace='tmp', OutputWorkspace='tmp', Target = 'Wavelength', AlignBins = True)
    mergeWS(monRun,'m')
    #SumSpectra(InputWorkspace='m',OutputWorkspace='m')
    #LoadInstrument(Workspace='m', Filename=path+'/paramData/onePid_monitor.xml', RewriteSpectraMap=True) 
    ConvertUnits(InputWorkspace='m', OutputWorkspace='m', Target = 'Wavelength', AlignBins = True)
    Rebin(InputWorkspace = 'tmp', OutputWorkspace = 'tmp', Params = wave_rebin)
    Rebin(InputWorkspace = 'm', OutputWorkspace = 'm', Params = wave_rebin)
    SumSpectra(InputWorkspace='m',OutputWorkspace='m')
    if monSUM:
        name=mtd['m']
        value=sum(name.readY(0))
        CreateSingleValuedWorkspace(OutputWorkspace='m', DataValue=value)
    else:
        pass
    Divide(LHSWorkspace="tmp", RHSWorkspace="m", OutputWorkspace=output, AllowDifferentNumberSpectra=True)
    ConvertUnits(InputWorkspace=output, OutputWorkspace='ans', Target = 'dSpacing', AlignBins = True)
    SumSpectra(InputWorkspace='ans', OutputWorkspace='ans')
    SaveAscii(InputWorkspace='ans',Filename=prepath+'/'+output+'.dat')
    DeleteWorkspace(Workspace = 'tmp')
    DeleteWorkspace(Workspace = 'm')
    DeleteWorkspace(Workspace = 'ans')
    
def subHold(samWS,holdWS, output, prepath):
    Minus(LHSWorkspace = samWS,RHSWorkspace = holdWS, OutputWorkspace = output)
    ResetNegatives(InputWorkspace=output, OutputWorkspace=output, AddMinimum=False)
    ConvertUnits(InputWorkspace=output, OutputWorkspace='ans', Target = 'dSpacing', AlignBins = True)
    SumSpectra(InputWorkspace='ans', OutputWorkspace='ans')
    SaveAscii(InputWorkspace='ans',Filename=prepath+'/'+output+'.dat')
    DeleteWorkspace(Workspace = 'ans')
    

'''
hold_run_det=['/home/dur/work/nexusData/GPPD/RUN0000340/bank2.nxs']
hold_run_mon=['/home/dur/work/nexusData/GPPD/RUN0000340/monitor2.nxs']
sam_run_det=['/home/dur/work/nexusData/GPPD/RUN0000338/bank2.nxs']
sam_run_mon=['/home/dur/work/nexusData/GPPD/RUN0000338/monitor2.nxs']
v_run_det=['/home/dur/work/nexusData/GPPD/RUN0000336/bank2.nxs']
v_run_mon=['/home/dur/work/nexusData/GPPD/RUN0000336/monitor2.nxs']
wave_rebin='0.7,0.001,4.6'
d_rebin='0.45,0.002,4.0'
monSUM=False
prepath='/home/dur/work/nexusData/GPPD/dur'
Absorption=True
'''

def Reduction():
    _be=time.time()

    conf=readXml('configure.xml')

    if conf['Bank'] is not None:
        if int(conf['Bank']) == 0:
            bankName='bank1'
        elif int(conf['Bank']) == 1:
            bankName='bank2'
        elif int(conf['Bank']) == 2:
            bankName='bank3'
    
    if conf['Module'] is not None:
        moduleName=conf['Module']

    hold_run_det=[]
    if conf['hold_run_det'] is not None:
        hold_run_det.append(conf['hold_run_det'])
    hold_run_mon=[]
    if conf['hold_run_mon'] is not None:
        hold_run_mon.append(conf['hold_run_mon'])
    sam_run_det=[]
    if conf['sam_run_det'] is not None:
        sam_run_det.append(conf['sam_run_det'])
    sam_run_mon=[]
    if conf['sam_run_mon'] is not None:
        sam_run_mon.append(conf['sam_run_mon'])
    v_run_det=[]
    if conf['v_run_det'] is not None:
        v_run_det.append(conf['v_run_det'])
    v_run_mon=[]
    if conf['v_run_mon'] is not None:
        v_run_mon.append(conf['v_run_mon'])
    empty_run_det=[]
    if conf['empty_run_det'] is not None:
        empty_run_det.append(conf['empty_run_det'])
    empty_run_mon=[]
    if conf['empty_run_mon'] is not None:
        empty_run_mon.append(conf['empty_run_mon'])
    if conf['Volume'] is not None:
        volume=float(conf['Volume'])
    else:
        volume=1.0
    if conf['Mass'] is not None:
        mass=float(conf['Mass'])
    else:
        mass=1.0
    if conf['Absorption'] is not None:
        if int(conf['Absorption'])!= 0:
            Absorption=True
        else:
            Absorption=False
    else:
        Absorption=1
    if conf['Volume'] is not None:
        volume=float(conf['Volume'])
    else:
        volume=1.0
    if conf['Mass'] is not None:
        mass=float(conf['Mass'])
    else:
        mass=1.0

    if conf['wmin'] is not None:
        w1=float(conf['wmin'])
    else:
        w1=0.7
    if conf['wmax'] is not None:
        w2=float(conf['wmax'])
    else:
        w1=4.5
    wave_rebin=str(w1)+',0.001,'+str(w2)

    if conf['dmin'] is not None:
        d1=float(conf['dmin'])
    else:
        d1=0.7
    if conf['dmax'] is not None:
        d2=float(conf['dmax'])
    else:
        d2=2.8
    #d_rebin=str(d1)+',0.0004,'+str(d2)
    #d_rebin=str(d1)+',0.0002,'+str(d2)
    d_rebin=str(d1)+',-0.0008,'+str(d2)

    monSUM=True
    prepath=sys.path[0]
    
    CreateSingleValuedWorkspace(OutputWorkspace='volume', DataValue=volume)
    # hold
    if len(hold_run_det)>0:
        normData(hold_run_det,hold_run_mon,wave_rebin,'hold_raw', monSUM,prepath)
    else:
        pass

    # sample
    if len(sam_run_det)>0:
        normData(sam_run_det,sam_run_mon,wave_rebin,'sam_raw', monSUM, prepath)
        if len(hold_run_det)>0:
            subHold('sam_raw','hold_raw','sam_hold',prepath)
            ConvertUnits(InputWorkspace='sam_hold', OutputWorkspace='sam_d', Target = 'dSpacing', AlignBins = True)
            SumSpectra(InputWorkspace='sam_d', OutputWorkspace='sam_d')
        else:
            ConvertUnits(InputWorkspace='sam_raw', OutputWorkspace='sam_d', Target = 'dSpacing', AlignBins = True)
            SumSpectra(InputWorkspace='sam_d', OutputWorkspace='sam_d')
    else:
        pass

    # vanadium
    if len(v_run_det)>0:
        a = v_run_det[0]
        b = a.split('/')
        if 'RUN0000336' in b:
            vName='RUN0000336_'+bankName
            print 'load ', vName
            fname=prepath+'/paramData/'+vName+'.dat'
            LoadAscii(Filename = fname, OutputWorkspace='v_d', Separator='CSV',Unit='dSpacing')
            ConvertToHistogram(InputWorkspace='v_d', OutputWorkspace='v_d')
        else: 
            normData(v_run_det,v_run_mon,wave_rebin,'v_raw', monSUM,prepath)
            if len(hold_run_det)>0:
                subHold('v_raw','hold_raw','v_hold',prepath)
                if Absorption:
                    MultipleScatteringCylinderAbsorption(InputWorkspace='v_hold', OutputWorkspace='v_hold')
                else:
                    pass
                ConvertUnits(InputWorkspace='v_hold', OutputWorkspace='v_hold', Target = 'dSpacing', AlignBins = True)
                SumSpectra(InputWorkspace='v_hold', OutputWorkspace='v_d')
            else:
                if Absorption:
                    MultipleScatteringCylinderAbsorption(InputWorkspace='v_raw', OutputWorkspace='v_raw')
                else:
                    pass
                ConvertUnits(InputWorkspace='v_raw', OutputWorkspace='v_raw', Target = 'dSpacing', AlignBins = True)
                SumSpectra(InputWorkspace='v_raw', OutputWorkspace='v_d')
            StripVanadiumPeaks(InputWorkspace='v_d', OutputWorkspace='v_d')
    else:
        pass


    if len(v_run_det)>0:
    #substract v
        Rebin(InputWorkspace = 'sam_d', OutputWorkspace = 'sam_d', Params = d_rebin)
        Rebin(InputWorkspace = 'v_d', OutputWorkspace = 'v_d', Params = d_rebin)
        Divide(LHSWorkspace = 'sam_d', RHSWorkspace = 'v_d', OutputWorkspace = 'ans')
        Divide(LHSWorkspace = 'ans', RHSWorkspace = 'volume', OutputWorkspace = 'ans')
        SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Id.dat', Separator='Tab')
        ConvertUnits(InputWorkspace='ans', OutputWorkspace='ans', Target = 'TOF', AlignBins = True)
        #Rebin(InputWorkspace = 'ans', OutputWorkspace = 'ans', Params = '5000,16,40000')
        ReplaceSpecialValues(InputWorkspace='ans', OutputWorkspace='ans', NaNValue=0, InfinityValue=0)
        SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Itof.dat', Separator='CSV')
    else:
        Divide(LHSWorkspace = 'sam_d', RHSWorkspace = 'volume', OutputWorkspace = 'sam_d')
        SaveAscii(InputWorkspace='sam_d',Filename=prepath+'/sam_Id.dat', Separator='Tab')
        ConvertUnits(InputWorkspace='sam_d', OutputWorkspace='ans', Target = 'TOF', AlignBins = True)
        #Rebin(InputWorkspace = 'ans', OutputWorkspace = 'ans', Params = '5000,16,40000')
        ReplaceSpecialValues(InputWorkspace='ans', OutputWorkspace='ans', NaNValue=0, InfinityValue=0)
        SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Itof.dat', Separator='CSV')
    print "total time: ", time.time()-_be, " seconds!"
#Reduction()

