import re
import string
import sys
import numpy as np
import math
from scipy import floor
import os

prepath=os.environ['HOME']+'/GPPDoffline'

def ReadData(fname):
    TOF=[]
    YINT=[]
    YESD=[]
    fopen=open(fname, "r")
    lines=fopen.readlines()

    nline=len(lines)
    for line in lines:
        try:
            line=line.split(',')
            #line=line.split('   ')
            if float(line[2]):
                TOF.append(float(line[0]))
                YINT.append(float(line[1]))
                YESD.append(float(line[2]))
        except:
            pass
    s=0
    n=len(TOF)
    for i in range(n):
        s+=(YINT[i]*1.0/YESD[i])**2 
    rexp=100*math.sqrt(n*1.0/s)

    return TOF, YINT, YESD, rexp

def tof2d(tof, bank):
    d=[]

    if bank=='bank1':
        #a=2.84
        #b=15485.77
        #c=3.38
        a=4.46
        b=14723.34
        c=12.20

    if bank=='bank2':
        a=2.52
        b=11458.31
        c=4.0

    if bank=='bank3':
        #a=2.74
        #b=5032.97
        #c=10.77
        a=1.55
        b=1481.91
        c=10.08


    for i in range(len(tof)):
        output=(-b+(b**2.0-4*a*(c-tof[i]))**0.5)/2.0/a
        d.append(output)
        #print output, tof[i]    
    return d




def WriteGSA(runNo, bankName,sf):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=CR+LF
    fin=str(prepath+'/sam_Itof.dat')
    bname=bankName.upper()
    f_gsas=prepath+'/resultData/GPPD_'+bname+'_'+(runNo)+sf+'.gsa'
    file_gsas=open(f_gsas, 'w')
    
    num=bankName[-1]
    print num

    TOF, YINT, YESD, rexp = ReadData(fin)
    # write title
    if bankName=='bank2':
        strtmp='GPPD Diffraction Histogram for 90-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    elif bankName=='bank1':
        strtmp='GPPD Diffraction Histogram for 180-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    else:
        strtmp='GPPD Diffraction Histogram for 30-degree bank, '+str(runNo)+', Rexp is '+str(rexp)

    file_gsas.write('%-80s%s' % (strtmp,CRLF))

    # read data
    n=len(TOF)
    mul=1
    #print "factor: ",mul
    step = TOF[1]-TOF[0]

    istart = 1
    for i in range(n-1):
        if TOF[i+1]-TOF[i] != step:
            istart = i+1
            break
        
    res = (TOF[istart]-TOF[istart-1])/float(TOF[istart-1])

    # write keyword
    iformat = 2
    if iformat ==0:
        nrec = 1
        nch = n
        strtmp='%s%s %5d %5d %s %6d %6d %2d %2d %s' % ('BANK ',num, n, nch, 'CONST', int(TOF[0]), step, 0, 0, 'FXYE')

    if iformat ==1:
        nrec = 8
        nch=int((n-1)/nrec)
        n=nch*nrec
        strtmp='%s %6d %6d %s %6d %6d %6d %.6f %s' % ('BANK 2', n, nch, 'RALF', int(TOF[0])*32, step*32, int(TOF[istart])*32, res, 'ALT')

    if iformat ==2:
        nrec = 1
        nch = n-1
        n=nch
        strtmp='%s%s %6d %6d %s %6d %6d %6d %.6f %s' % ('BANK ',num, n, nch, 'RALF', int(TOF[0])*32, step*32, int(TOF[istart])*32, res, 'FXYE')

    if iformat ==3:
        nrec = 1
        nch = n
        strtmp='%s %6d %6d %s %6d %.6f %6d %d %s' % ('BANK 2', n, nch, 'SLOG', int(TOF[0]), res, int(TOF[n-1]), 0, 'FXYE')

    file_gsas.write('%-80s%s' % (strtmp,CRLF))

    # write data
    for i in range(nch):
        for j in range(nrec):
            if i*nrec+j==0:
                tof = TOF[0]
            else:
                tof = (TOF[i*nrec+j]+TOF[i*nrec+j-1])*0.5

            if iformat ==1:
                strtmp='%7d%8d%5d' % (tof*32, int(mul*YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])), int(mul*YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])))
            elif iformat ==2:
                strtmp='%15.6f %15.10f %15.10f' % (tof, YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j]), YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j]))
                #strtmp='%15.6f %d %d' % (tof, int(mul*YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])), int(mul*YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])))
            else:
                strtmp='%8d %15.5f %15.5f' % (tof, YINT[i*nrec+j], YESD[i*nrec+j])
            
            file_gsas.write('%s' % strtmp)

        file_gsas.write('%s' % CRLF) 


    print 'Histogram for GSAS:       '+f_gsas


def WriteFP(runNo, bankName,sf):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=LF

    fin=str(prepath+'/sam_Itof.dat')
    TOF, YINT, YESD, rexp=ReadData(fin)
    n=len(TOF)

    bname=bankName.upper()
    f_fp=prepath+'/resultData/GPPD_'+bname+'_'+runNo+sf+'.dat'
    file_fp=open(f_fp, 'w')

    # write title
    if bankName=='bank2':
        strtmp='GPPD Diffraction Histogram for 90-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    elif bankName=='bank1':
        strtmp='GPPD Diffraction Histogram for 180-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    else:
        strtmp='GPPD Diffraction Histogram for 30-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    file_fp.write('%s%s' % (strtmp,CRLF))

    strtmp='The original intensities and sigmas have been multiplied by 10000'
    file_fp.write('%s%s' % (strtmp,CRLF))


    #step = TOF[1]-TOF[0]
    strtmp='%s %s %s' % ('TOF', 'INT', 'ERR')
    file_fp.write('%s%s' % (strtmp,CRLF))
    # write data
    for i in range(n):
        strtmp='%.2f %.6f %.6f' % (TOF[i], YINT[i]*(10**(4)), YESD[i]*(10**(4)))
        file_fp.write('%s' % strtmp)
        file_fp.write('%s' % CRLF)

    print 'Histogram for FP:       '+f_fp


def WriteZR(runNo, bankName,sf):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=LF

    fin=str(prepath+'/sam_Itof.dat')
    TOF, YINT, YESD,rexp=ReadData(fin)
    bname=bankName.upper()
    f_fp=prepath+'/resultData/GPPD_'+bname+'_'+runNo+sf+'.histogramIgor'
    file_fp=open(f_fp, 'w')

    n=len(TOF)
    strtmp='IGOR'
    file_fp.write('%s%s' % (strtmp,CRLF))
    strtmp='%s %s %s %s' % ('WAVES/O', 'tof',  'yint',  'yerr')
    #strtmp='%s %s %s' % ('IGOR', 'INT', 'ERR')
    file_fp.write('%s%s' % (strtmp, CRLF))
    strtmp='BEGIN'
    file_fp.write('%s%s' % (strtmp,CRLF))

    # write data
    for i in range(n):
        strtmp='%.2f %.6f %.6f' % (TOF[i], YINT[i], YESD[i])
        file_fp.write('%s' % strtmp)
        #file_fp.write('\n') 
        file_fp.write('%s' % CRLF)

    strtmp='END'
    file_fp.write('%s' % (strtmp))

    print 'Histogram for ZR:       '+f_fp

def WriteFPd(runNo, bankName, sf):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=LF

    fin=str(prepath+'/sam_Itof.dat')
    TOF, YINT, YESD, rexp=ReadData(fin)
    n=len(TOF)
    d=tof2d(TOF,bankName)
    bname=bankName.upper()
    f_fp=prepath+'/resultData/GPPD_'+bname+'_'+runNo+sf+'_d.dat'
    #f_fp=prepath+'/GPPD_'+bname+'_V2.0_'+runNo+'_d.dat'
    file_fp=open(f_fp, 'w')
    #print 'rexp:',rexp
    # write title
    if bankName=='bank2':
        strtmp='GPPD Diffraction Histogram for 90-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
    elif bankName=='bank1':
        strtmp='GPPD Diffraction Histogram for 180-degree bank, '+str(runNo)+', Rexp is '+str(rexp)
        print strtmp
    else:
        strtmp='GPPD Diffraction Histogram for 30-degree bank, '+str(runNo)+', Rexp is '+str(rexp)

    file_fp.write('%s%s' % (strtmp,CRLF))

    strtmp='The original intensities and sigmas have been multiplied by 10000'
    file_fp.write('%s%s' % (strtmp,CRLF))

    # read data

    #step = TOF[1]-TOF[0]
    strtmp='%s %s %s' % ('d', 'INT', 'ERR')
    file_fp.write('%s%s' % (strtmp,CRLF))

    # write data
    for i in range(n):
        strtmp='%.6f %.6f %.6f' % (d[i], YINT[i]*(10**(4)), YESD[i]*(10**(4)))
        file_fp.write('%s' % strtmp)
        file_fp.write('%s' % CRLF)

    print 'Histogram for FP:       '+f_fp


