import sys
import os
#devnull = open(os.devnull, 'w')
#sys.stdout, sys.stderr = devnull, devnull
#import QtGui
import xml.etree.ElementTree as ET
from mantid.simpleapi import *
import time
import writeFormat
import logging
#from logging.handlers import RotatingFileHandler
import sendEmail
from PyQt4 import QtCore,QtGui

prepath=os.environ['HOME']+'/GPPDoffline'
prepath_read='/cvmfs/daas.csns.ihep.ac.cn/softwares/centos-7.2.1511/GPPDoffline'
#prepath_read='/home/dur/cloudBU/GPPDoffline'


class basicProcess():
    def __init__(self, filepathList, waveStart, waveEnd, output):
        #self.path_cur=prepath
        #self.path_data=prepath
        self.path_xml=prepath_read+'/paramData'
        self.waveStart=waveStart
        self.waveEnd=waveEnd
        self.fileList=filepathList
        #self.moduleList=moduleList
        self.output=output
        self.wsList=[]
        for ix in filepathList:
            num=ix.find("RUN")
            runNo=int(ix[num+3:num+10])
            name=str(runNo)
            self.wsList.append(name)

    def loadSingleDetWS(self, moduleNum, num):
        moduleName = "module"+str(moduleNum)
        filepath=self.fileList[num]
        LoadCSNSNexus(Filename=filepath, OutputWorkspace="tmp", Bankname=moduleName,Loadmonitor=False)
        LoadInstrument(Workspace="tmp", Filename=self.path_xml+'/module/'+moduleName+'.xml', RewriteSpectraMap=True)

    def loadSingleMonWS(self,num):
        filepath=self.fileList[num]
        LoadCSNSNexus(Filename=filepath, OutputWorkspace="mon", Loadbank=False, Loadmonitor=True, Monitorname="monitor2")
        LoadInstrument(Workspace="mon", Filename=self.path_xml+'/module/monitor2.xml', RewriteSpectraMap=True)

    def loadDetWS(self, moduleNum):
        moduleName = "module"+str(moduleNum)
        for i in range(len(self.fileList)):
            filepath=self.fileList[i]
            name=self.wsList[i]
            LoadCSNSNexus(Filename=filepath, OutputWorkspace=name, Bankname=moduleName,Loadmonitor=False)
            LoadInstrument(Workspace=name, Filename=self.path_xml+'/module/'+moduleName+'.xml', RewriteSpectraMap=True)

    def loadMonWS(self):
        for i in range(len(self.fileList)):
            filepath=self.fileList[i]
            name=self.wsList[i]
            LoadCSNSNexus(Filename=filepath, OutputWorkspace=name, Loadbank=False,Loadmonitor=True, Monitorname="monitor2")
            LoadInstrument(Workspace=name, Filename=self.path_xml+'/module/monitor2.xml', RewriteSpectraMap=True)

    def mergeWS(self, output):
        for i in range(len(self.wsList)):
            if len(self.wsList)== 1:
                CloneWorkspace(InputWorkspace=self.wsList[i], OutputWorkspace=output)
                DeleteWorkspace(Workspace=self.wsList[i])
            elif self.wsList[i+1]!=self.wsList[-1]:
                Plus(LHSWorkspace=self.wsList[i],RHSWorkspace=self.wsList[i+1], OutputWorkspace=self.wsList[i+1])
                DeleteWorkspace(Workspace=self.wsList[i])
            else:
                Plus(LHSWorkspace=self.wsList[i],RHSWorkspace=self.wsList[i+1], OutputWorkspace=output)
                DeleteWorkspace(Workspace=self.wsList[i])
                DeleteWorkspace(Workspace=self.wsList[i+1])
                break

    def sumMonitorCounts(self):
        ConvertUnits(InputWorkspace='mon',OutputWorkspace='tmp2' ,Target = 'Wavelength', AlignBins = True)
        CropWorkspace(InputWorkspace='tmp2',OutputWorkspace='tmp2', XMin=self.waveStart, XMax=self.waveEnd)
        SumSpectra(InputWorkspace='tmp2',OutputWorkspace='tmp2')
        value=sum(mtd['tmp2'].readY(0))
        DeleteWorkspace(Workspace="tmp2")
        return value

    def load2d(self, moduleNum,mode,num):
        if mode=="batch":
            self.loadSingleDetWS(moduleNum,num)
        else:
            self.loadDetWS(moduleNum)
            self.mergeWS("tmp")
        name=mtd['tmp']
        self.delayTime=name.readX(0)[0]
        self.convert2d()

    def convert2d(self):
        ConvertUnits(InputWorkspace='tmp',OutputWorkspace='tmp', Target = 'Wavelength', AlignBins = True)
        CropWorkspace(InputWorkspace='tmp',OutputWorkspace='tmp', xMin=self.waveStart,XMax=self.waveEnd) 
        ConvertUnits(InputWorkspace='tmp',OutputWorkspace='tmp', Target='dSpacing', AlignBins = True)
        SumSpectra(InputWorkspace='tmp',OutputWorkspace='tmp')

    def sumAllModules(self, moduleNumList, mode,number):
        num=0
        deltaD=[]
        maxD=[]
        minD=[]
        for mname in moduleNumList:
            print "========================="
            print  mname
            self.load2d(mname, mode, number)
            value=float(mtd['tmp'].readX(0)[1]-mtd['tmp'].readX(0)[0])
            maxD.append(float(mtd['tmp'].readX(0)[-1]))
            minD.append(float(mtd['tmp'].readX(0)[1]))
            deltaD.append(value)
            RenameWorkspace(InputWorkspace='tmp',OutputWorkspace=str(num))
            num+=1
        step_d=max(deltaD)
        dmin=min(minD)
        dmax=max(maxD)
        d_rebin=str(dmin)+','+str(step_d)+','+str(dmax)
        #print d_rebin
        for j in range(num):
            if j==0:
                Rebin(InputWorkspace=str(j),OutputWorkspace='ans', Params=d_rebin)
            else:
                Rebin(InputWorkspace=str(j),OutputWorkspace='tmp', Params=d_rebin)
                mtd['ans']+=mtd['tmp']
        self.normByMon(mode,number)

    def normByMon(self,mode,num):
        if mode =="batch":
            self.loadSingleMonWS(num)
        else:
            self.loadMonWS()
            self.mergeWS('mon')

        mc=self.sumMonitorCounts()
        DeleteWorkspace('mon')
        mtd['ans']= mtd['ans']/mc
        RenameWorkspace(InputWorkspace='ans',OutputWorkspace=self.output)


    def getCalFile(self, bankName, mergeMode, expMode):
        filename=""
        mode="_"+mergeMode
        rNo=self.wsList[0]
        l = os.listdir(self.path_xml)
        for name in l:
            if name[0]==expMode[0]:
                int1 = name.find(str(rNo))
                int2 = name.find(bankName)
                if(mode=="_old"):
                    int3=name.find(mode)
                    #print name , int1,int2,int3
                    if int1!=-1 and int2!=-1 and int3!=-1:
                        filename = name
                        break
                else:
                    #print "=================="
                    #print name
                    if int1!=-1 and int2!=-1:
                        filename = name
                        break
        return filename


    def loadCal(self,bankName, mergeMode,expMode, dRebin):
        runNo = self.wsList[0]
        if runNo>4050:
            if bankName=="bank2":
                tmp=self.getCalFile(bankName, mergeMode,expMode)
                if tmp == "":
                    fname = self.path_xml+"/nodata.nxs"
                else:
                    fname=self.path_xml+'/'+tmp
            else:
                fname=self.path_xml+'/'+expMode+'_'+bankName+'_'+str(runNo)+'.nxs'
        else:
            fname=self.path_xml+'/'+expMode+'_'+bankName+'_'+str(runNo)+'.nxs'
    
        print "=================="
        print fname
        if os.path.exists(fname):
            LoadNexus(Filename=fname, OutputWorkspace='raw')
            Rebin(InputWorkspace = 'raw', OutputWorkspace = expMode, Params = dRebin)
            #if expMode=="hold":
            #    mtd['ans']=mtd[expMode]*0.5
            #    SaveAscii(InputWorkspace='ans',Filename=prepath+'/'+expMode+'_raw.dat')
            #SaveAscii(InputWorkspace=expMode,Filename=prepath+'/'+expMode+'_raw.dat')
            return True
        else:
            return False

class expInfo():
    def __init__(self, filename):
        self.filename=filename
        self.conf=self.readXml()	
        self.bankDict={
                    "bank1":[521,531,532,533,541,542,543,623,631,632,633,641,642,643],
                    "bank2":[322,331,332,333,341,342,343,422,431,432,433,441,442,443],
                    "bank3":[123,131,132,133,141,142,143,221,231,232,233,241,242,243],
                    "bank2_sa":[131,141,233,243,322,331,332,333,341,342,343,422,431,432,433,441,442,443]
                    }

    def readXml(self):
        tree = ET.parse(self.filename)
        root = tree.getroot()
        configure={}

        _tmp = root.findall('Bank')[0].text
        configure['Bank']=_tmp
        _tmp = root.findall('Module')[0].text
        configure['Module']=_tmp
        _tmp = root.findall('Sample_det')[0].text
        configure['sam_run_det']=_tmp
        _tmp = root.findall('Vanadium_det')[0].text
        configure['v_run_det']=_tmp
        _tmp = root.findall('Hold_det')[0].text
        configure['hold_run_det']=_tmp
        _tmp = root.findall('Hold_check')[0].text
        configure['hold_check']=_tmp
        _tmp = root.findall('Empty_det')[0].text
        configure['empty_run_det']=_tmp
        _tmp = root.findall('Empty_check')[0].text
        configure['empty_check']=_tmp
        _tmp = root.findall('TF')[0].text
        configure['timeFocus']=_tmp
        _tmp = root.findall('wmin')[0].text
        configure['wmin']=_tmp
        _tmp = root.findall('wmax')[0].text
        configure['wmax']=_tmp
        _tmp = root.findall('wbin')[0].text
        configure['wbin']=_tmp
        _tmp = root.findall('dmin')[0].text
        configure['dmin']=_tmp
        _tmp = root.findall('dbin')[0].text
        configure['dbin']=_tmp
        _tmp = root.findall('dmax')[0].text
        configure['dmax']=_tmp
        _tmp = root.findall('Volume')[0].text
        configure['Volume']=_tmp
        _tmp = root.findall('Mass')[0].text
        configure['Mass']=_tmp
        _tmp = root.findall('Mode')[0].text
        configure['Mode']=_tmp
        _tmp = root.findall('Scale')[0].text
        configure['Scale']=_tmp
        _tmp = root.findall('email')[0].text
        configure['email']=_tmp
        return configure

    
    def getWaveInfo(self):
        if self.conf['wmin'] is not None:
            w1=float(self.conf['wmin'])
        else:
            w1=0.1
        if self.conf['wbin'] is not None:
            w2=float(self.conf['wbin'])
        else:
            w2=0.001
        if self.conf['wmax'] is not None:
            w3=float(self.conf['wmax'])
        else:
            w3=4.9
        return w1, w3

    def getdInfo(self):
        if self.conf['dmin'] is not None:
            d1=float(self.conf['dmin'])
        else:
            d1=0.7
        if self.conf['dbin'] is not None:
            d2=float(self.conf['dbin'])
        else:
            d2= -0.0008
        if self.conf['dmax'] is not None:
            d3=float(self.conf['dmax'])
        else:
            d3= 4.2
        dRebin=str(d1)+','+str(d2)+','+str(d3)
        return dRebin

    def getHoldRun(self):
        if self.conf['hold_run_det'] is not None:
            hold=[str(i) for i in self.conf['hold_run_det'].split(',')]
        else:
            hold=[]
        return hold

    def getVRun(self):
        if self.conf['v_run_det'] is not None:
            v=[str(i) for i in self.conf['v_run_det'].split(',')]
        else:
            v=[]
        return v

    def getEmptyRun(self):
        if self.conf['empty_run_det'] is not None:
            empty=[str(i) for i in self.conf['empty_run_det'].split(',')]
        else:
            empty=[]
        return empty

    def getSampleRun(self):
        if self.conf['sam_run_det'] is not None:
            sam=[str(i) for i in self.conf['sam_run_det'].split(',')]
        else:
            sam=[]
        return sam

    def getSampleInfo(self):
        if self.conf['Volume'] is not None:
            volume=float(self.conf['Volume'])
        else:
            volume=1.0
        if self.conf['Mass'] is not None:
            mass=float(self.conf['Mass'])
        else:
            mass=1.0
        return volume, mass

    def getMode(self):
        scale=""
        if self.conf['Mode'] is not None:
            tmp=int(self.conf['Mode'])
            if tmp==1:
                scale = "old"
            else:
                scale = "new"
        else:
            scale='new'
        return scale
    
    def getScale(self):
        scale=0.5
        if self.conf['Scale'] is not None:
            tmp=int(self.conf['Scale'])
            if tmp==1:
                scale = 1.0
        return 0.5


    def getBankName(self):
        if int(self.conf['Bank']) == 0:
            data='bank1'
        elif int(self.conf['Bank']) == 1:
            data='bank2'
        elif int(self.conf['Bank']) == 2:
            data='bank3'
        return data

    def getModuleNum(self):
        self.mode = self.getMode()
        tmp=""
        if self.mode == "new" and self.bankName=="bank2":
            tmp = "bank2_sa"
        else:
            tmp = self.bankName
        if self.conf['Module'] is not None:
            moduleName=self.conf['Module']
        else:
            moduleName='ALL'
        
        if moduleName == 'ALL':
            self.moduleList=self.bankDict[tmp]
        else:
            self.moduleList=moduleName.split(',')
             

    def getInfo(self):
        self.waveStart,self.waveEnd = self.getWaveInfo()
        self.email = self.conf['email']
        self.holdCheck=int(self.conf['hold_check'])
        self.emptyCheck=int(self.conf['empty_check'])
        self.bankName=self.getBankName()
        self.getModuleNum()
        self.dRebin=self.getdInfo()
        self.samRun=self.getSampleRun()
        self.holdRun=self.getHoldRun()
        self.bgRun=self.getEmptyRun()
        self.vRun=self.getVRun()
        self.scale=self.getScale()

def stripVpeaksAndSmooth(wsname, npoints):
    StripVanadiumPeaks(InputWorkspace=wsname,OutputWorkspace=wsname)
    SmoothData(InputWorkspace=wsname,OutputWorkspace=wsname,NPoints=npoints)
    SetUncertainties(InputWorkspace=wsname,OutputWorkspace=wsname,SetError='zero')


def subWS(lWS,rWS, output):
    Minus(LHSWorkspace = lWS,RHSWorkspace = rWS, OutputWorkspace = output, AllowDifferentNumberSpectra=True)
    SaveAscii(InputWorkspace=output,Filename=prepath+'/'+output+'.dat')

def convertTOF(wsName,bankName,delay):
    print "========convert TOF================"
    print bankName
    name=mtd[wsName]
    tmp=name.readX(0)
    y=name.readY(0)
    e=name.readE(0)
    d=[]
    for i in range(len(tmp)-1):
        d.append(tmp[i]+(tmp[i+1]-tmp[i])/2.0)

    tof=[]
    if bankName=='bank1':
        #constA=15482.00858 #5320001
        constA=14728.384562 #5330111
        #constA=15813.5438 #5310001

        constB= 0.0
    elif bankName=='bank3':
        #constA=5043.368242#1320001
        constB= 0.0
        constA=1488.94997#1330111

    elif bankName=='bank2':
        constA=11457.59304
        constB= -0.000203986

    f0=open(prepath+'/sam_Itof.dat', 'w')
    for i in range(len(d)):
        tof=d[i]*constA+constB
        #if tof<40000+delay and tof>delay:
        if tof>0:
            strtmp='%f%s%.20f%s%.20f'%(tof,',',y[i],',',e[i])
            f0.write('%s' % strtmp)
            f0.write('\n')
    f0.close()
    #print 'finish convert TOF'   

def raw2tof(wsName, bankName):
    name=mtd[wsName]
    tmp=name.readX(0)
    y=name.readY(0)
    e=name.readE(0)
    xList=[]
    yList=[]
    eList=[]
    d=[]
    for i in range(len(tmp)-1):
        d.append(tmp[i]+(tmp[i+1]-tmp[i])/2.0)

    tof=[]
    if bankName=='bank1':
        #constA=15482.00858 #5320001
        constA=14728.384562 #5330111
        #constA=15813.5438 #5310001
        constB= 0.0
    elif bankName=='bank3':
        #constA=5043.368242#1320001
        constB= 0.0
        constA=1488.94997#1330111

    elif bankName=='bank2':
        constA=11457.59304
        constB= -0.000203986

    for i in range(len(d)):
        tof=d[i]*constA+constB
        if tof>delay:
            xList.append(tof)
            yList.append(y[i])
            eList.append(e[i])
            
    return xList, yList, eList


def judgeNegtive(wsName):
    name=mtd[wsName]
    y=name.readY(0)
    judge=False
    num=0
    for iy in y:
        if iy<0:
            num+=1
            if num>2:
                judge=True
                break
    return judge

def sendE(runList,bName,email, vJudge, hJudge, bgJudge,bins):
    #send email
    if len(runList)>1:
    	message = "Dear User, \n- Please find the data files for GPPD "+runList[0]+"-"+runList[-1]+ " in the attachments. \n- Best."
        subject='GPPD '+runList[0]+'-'+runList[-1]+' '+bName
    else:
    	message = "Dear User, \n- Please find the data files for GPPD "+runList[0]+ " in the attachments. \n- Best."
        subject='GPPD '+runList[0]+' '+bName
    
    receiver=email
    files=[]
    suffix=[".histogramIgor", ".gsa", ".dat", "_d.dat"]
    path0=prepath+"/resultData/GPPD_"+bName.upper()+"_"

    for name in runList:
        fpath = path0+name+"_BIN"+bins
        if vJudge and bgJudge and hJudge:
            fpath=fpath+"_VCB"
        elif vJudge and hJudge:
            fpath = fpath+"_VC"
        elif vJudge and bgJudge:
            fpath = fpath+"_VB"
        elif vJudge:
            fpath=fpath+"_V"
        else:
            fpath = fpath+"_raw"

        for ix in suffix:
            filename = fpath+ix
            if os.path.exists(filename):
                files.append(filename)
                

    #'''
    if receiver  is None:
        pass
    else:
        sendEmail.sendEmail(receiver, subject, message, files)
        logging.info('finish reduction and send data by email!')
    #'''

def createPath():
    _home=os.environ["HOME"]
    _path=_home+"/GPPDoffline/resultData"
    isExists=os.path.exists(_path)
    if not isExists:
        os.makedirs(_path)


def processV(exp):
    v=basicProcess(exp.vRun, exp.waveStart,exp.waveEnd, 'v')
    judge = v.loadCal(exp.bankName, exp.mode, 'v', exp.dRebin)
    if judge:
        pass
    else:
        v.sumAllModules(exp.moduleList,"single",0)
        ConvertUnits(InputWorkspace='v',OutputWorkspace='v', Target='Wavelength', AlignBins=False)
        MultipleScatteringCylinderAbsorption(InputWorkspace='v',OutputWorkspace='v')
        ConvertUnits(InputWorkspace='v',OutputWorkspace='v', Target='dSpacing', AlignBins=False)
        stripVpeaksAndSmooth('v',21)
        Rebin(InputWorkspace='v',OutputWorkspace='v', Params=exp.dRebin)

    if len(exp.bgRun)>0 and exp.emptyCheck == 1:
        bg=basicProcess(exp.bgRun, exp.waveStart,exp.waveEnd, 'bg')
        judge = bg.loadCal(exp.bankName, exp.mode, 'bg', exp.dRebin)
        if judge:
            pass
        else:
            bg.sumAllModules(exp.moduleList,"single",0)
            Rebin(InputWorkspace='bg',OutputWorkspace='bg', Params=exp.dRebin)

        SaveAscii(InputWorkspace='bg',Filename=prepath+'/bg_raw.dat')
        subWS("v",'bg','v')
        logging.info('finish substracing bg for v')
        QtGui.QApplication.processEvents()
    else:
        logging.info('no bg')
        QtGui.QApplication.processEvents()
    
    SaveAscii(InputWorkspace='v',Filename=prepath+'/v_raw.dat')

def processHold(exp):
    hold = basicProcess(exp.holdRun, exp.waveStart,exp.waveEnd, 'hold')
    judge = hold.loadCal(exp.bankName, exp.mode, 'hold', exp.dRebin)
    if judge:
        pass
    else:
        hold.sumAllModules(exp.moduleList, "single",0)
        Rebin(InputWorkspace='hold',OutputWorkspace='hold', Params=exp.dRebin)
    mtd['hold']=mtd['hold']*exp.scale
    SaveAscii(InputWorkspace='hold',Filename=prepath+'/hold_raw.dat')

def outputTOF(bname,dTime, runName, vJudge, hJudge, bgJudge, bins):
    convertTOF('ans', bname, dTime)
    suffix = "_BIN"+bins
    if vJudge and bgJudge and hJudge:
        suffix=suffix+"_VCB"
    elif vJudge and hJudge:
        suffix=suffix+"_VC"
    elif vJudge and bgJudge:
        suffix=suffix+"_VB"
    elif vJudge:
        suffix=suffix+"_V"
    else:
        suffix=suffix+"_raw"
    writeFormat.WriteGSA(runName,bname,suffix)
    writeFormat.WriteFP(runName,bname,suffix)
    writeFormat.WriteZR(runName,bname,suffix)
    writeFormat.WriteFPd(runName,bname,suffix)


def Reduction():
    createPath()
    _be=time.time()
    expParam = expInfo(prepath+'/configure.xml')
    expParam.getInfo()
    #process V
    vJudge=False
    hJudge=False
    bgJudge=False
    if len(expParam.bgRun)>0 and expParam.emptyCheck == 1:
        bgJudge=True
    if len(expParam.vRun)>0:
        processV(expParam)
        vJudge=True

    if len(expParam.samRun)>0:
        sam=basicProcess(expParam.samRun, expParam.waveStart,expParam.waveEnd, 'sam')
        sam.sumAllModules(expParam.moduleList, "single",0)
        dTime = sam.delayTime
        Rebin(InputWorkspace='sam',OutputWorkspace='sam', Params=expParam.dRebin)
        tmp=expParam.dRebin.split(",")
        dBINS=str(abs(float(tmp[1]))*1000)
        SaveAscii(InputWorkspace='sam',Filename=prepath+'/sam_raw.dat')
        name = "RUN"+str(sam.wsList[0]).zfill(7)
        SaveAscii(InputWorkspace='sam',Filename=prepath+'/resultData/'+name+'_d_raw.dat')
        logging.info('finish raw sample data')
        QtGui.QApplication.processEvents()

        runList=[]
        runList.append(name)
        if len(expParam.holdRun)>0 and expParam.holdCheck == 1:
            processHold(expParam)
            subWS('sam','hold','sam_hold')
            logging.info('finish substracing holder for sample')
            negtive=judgeNegtive('sam_hold')
            if negtive:
                logging.warning('Error: can not substract holder. You should change d range and do reduction again!!!')
                QtGui.QApplication.processEvents()
                return 'Error: Can not substract holder!'
            else:
                hJudge = True
                if len(expParam.vRun) > 0:
                    Divide(LHSWorkspace = 'sam_hold', RHSWorkspace = 'v', OutputWorkspace = 'ans')
                    #runList.append(name)
                    ReplaceSpecialValues(InputWorkspace='ans', OutputWorkspace='ans', NaNValue=0, InfinityValue=0)
                    outputTOF(expParam.bankName, dTime, name, vJudge, hJudge, bgJudge, dBINS)
                    sendE(runList,expParam.bankName,expParam.email, vJudge, hJudge, bgJudge,dBINS)

                    logging.info('finish! '+str(time.time()-_be)+'seconds!')
                    SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Id.dat')
                    return 'Success!'
                else:
                    logging.warning('no v to reduction!!!')
                    QtGui.QApplication.processEvents()
                    return 'Warning: no Vanadium!'
        else:
            logging.warning('no hold data')
            if len(expParam.vRun)>0:
                Divide(LHSWorkspace = 'sam', RHSWorkspace = 'v', OutputWorkspace = 'ans')
                #runList.append(name)
                ReplaceSpecialValues(InputWorkspace='ans', OutputWorkspace='ans', NaNValue=0, InfinityValue=0)
                outputTOF(expParam.bankName, dTime, name, vJudge, hJudge, bgJudge, dBINS)
                sendE(runList,expParam.bankName,expParam.email, vJudge, hJudge, bgJudge,dBINS)
                logging.info('finish without hold! '+str(time.time()-_be)+'seconds!')
                SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Id.dat')
                return 'Success!'
            else:
                RenameWorkspace(InputWorkspace='sam', OutputWorkspace='ans') 
                outputTOF(expParam.bankName, dTime, name, vJudge, hJudge, bgJudge, dBINS)
                sendE(runList,expParam.bankName,expParam.email, vJudge, hJudge, bgJudge,dBINS)
                logging.warning('finish raw data!!!')
                QtGui.QApplication.processEvents()
                #logging.warning('finish with raw data!!! '+str(time.time()-_be)+'seconds!')
                #SaveAscii(InputWorkspace='sam_raw',Filename=prepath+'/sam_Id.dat')
                return 'Success'
    else:
        logging.warning('can not find sample run!!!')
        QtGui.QApplication.processEvents()
        return "Error: no sample run!"
    

def batchReduction():
    createPath()
    _be=time.time()
    expParam = expInfo(prepath+'/configure.xml')
    expParam.getInfo()
    hJudge = False
    vJudge = False
    bgJudge=False
    if len(expParam.bgRun)>0 and expParam.emptyCheck == 1:
        bgJudge=True
    if len(expParam.vRun)>0:
        processV(expParam)
        vJudge = True
    if len(expParam.holdRun)>0 and expParam.holdCheck == 1:
        processHold(expParam)
        hJudge=True
    else:
        logging.warning('no hold run input!!!')
    errorList=[]
    runList=[]
    sam=basicProcess(expParam.samRun, expParam.waveStart,expParam.waveEnd, 'sam')
    for i in range(len(expParam.samRun)):
        sam.sumAllModules(expParam.moduleList, "batch",i)
        dTime = sam.delayTime
        Rebin(InputWorkspace='sam',OutputWorkspace='sam', Params=expParam.dRebin)
        tmp=expParam.dRebin.split(",")
        dBINS=str(abs(float(tmp[1]))*1000)
        SaveAscii(InputWorkspace='sam',Filename=prepath+'/sam_raw.dat')
        name = "RUN"+str(sam.wsList[i]).zfill(7)
        SaveAscii(InputWorkspace='sam',Filename=prepath+'/resultData/'+name+'_d_raw.dat')

        redJudge = False
        if hJudge:
            subWS('sam','hold','sam_hold')
            negtive=judgeNegtive('sam_hold')
            if negtive:
                errorList.append(name)
                logging.warning('Error: can not substract holder. You should change d range and do reduction again!'+name)
                QtGui.QApplication.processEvents()
            else:
                if vJudge:
                    Divide(LHSWorkspace = 'sam_hold', RHSWorkspace = 'v', OutputWorkspace = 'ans')
                    redJudge = True
                else:
                    logging.warning('no v to reduction!!!')
                    redJudge = False
        else:
            if vJudge:
                Divide(LHSWorkspace = 'sam', RHSWorkspace = 'v', OutputWorkspace = 'ans')
            else:
                RenameWorkspace(InputWorkspace='sam', OutputWorkspace='ans') 
            redJudge = True

        if redJudge:
            runList.append(name)
            ReplaceSpecialValues(InputWorkspace='ans', OutputWorkspace='ans', NaNValue=0, InfinityValue=0)
            SaveAscii(InputWorkspace='ans',Filename=prepath+'/sam_Id.dat')
            outputTOF(expParam.bankName, dTime, name, vJudge, hJudge, bgJudge, dBINS)
            DeleteWorkspace(Workspace='ans')
            logging.info('finish! '+str(time.time()-_be)+'seconds!')
        else:
            pass

    #print "=================",runList,"=====================" 
    if len(runList)>0:
        sendE(runList,expParam.bankName,expParam.email, vJudge, hJudge, bgJudge,dBINS)
    if len(errorList)== 0:
        return 'Success!'
    else:
        strtmp=''
        for i in range(len(errorList)):
            strtmp+=errorList[i]+','
        strtmp=strtmp[:-1]
        return 'Can not subtract hold: '+strtmp

