#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2018.3.7
LILI YAN
'''
import os
import sys
from contextlib import contextmanager

@contextmanager
def stdout_redirected(to=os.devnull):
     fd = sys.stdout.fileno()

     def _redirect_stdout(to):
         sys.stdout.close()
         os.dup2(to.fileno(), fd)
         sys.stdout = os.fdopen(fd, 'w')

     with os.fdopen(os.dup(fd), 'w') as old_stdout:
         with open(to, 'w') as file:
             _redirect_stdout(to=file)
         try:
             yield
         finally:
             _redirect_stdout(to=old_stdout)

from multiprocessing import Pool
from conf.constants import *
import json
import atexit
import xml.etree.ElementTree as ET
from xml.dom import minidom
from canvas import *
import reduction
#import WriteGSA
#import WriteFP
#import WriteZR
import logWindow
from multiprocessing import Pool
import subprocess

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)

    def setupUi(self, MainWindow):
        _loadWidth=80
        _fileWidth=250

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([600, 500])

        self.logWindow = logWindow.LogWindow(self)

        self.splitter2 = QtGui.QSplitter(QtCore.Qt.Vertical, self)
        self.splitter2.addWidget(self.splitter)
        self.splitter2.addWidget(self.logWindow)
        self.splitter2.setSizes([900, 100])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

        self.historyButton = QtGui.QPushButton('History')
        self.historyButton.setMaximumHeight(30)
        self.historyButton.setMaximumWidth(_fileWidth)
        self.historyButton.clicked.connect(self.historyChanged)

        self.settingText = QtGui.QLabel('Settings: ',self.first)

        self.batchButton = QtGui.QPushButton('Batch Reduction')
        self.batchButton.setMaximumHeight(30)
        self.batchButton.setMaximumWidth(_fileWidth)
        self.batchButton.clicked.connect(self.batchReduction)

        self.singleButton = QtGui.QPushButton('Single Reduction')
        self.singleButton.setMaximumHeight(30)
        self.singleButton.setMaximumWidth(_fileWidth)
        self.singleButton.clicked.connect(self.singleReduction)

        self.defaultButton = QtGui.QPushButton('Default')
        self.defaultButton.setMaximumHeight(30)
        self.defaultButton.setMaximumWidth(_fileWidth)
        self.defaultButton.clicked.connect(self.setDefault)

        self.loadButton = QtGui.QPushButton('Load')
        self.loadButton.setMaximumHeight(30)
        self.loadButton.setMaximumWidth(_fileWidth)
        self.loadButton.clicked.connect(self.loadSetting)

        self.logo = QtGui.QLabel(self.first)
        self.logo.setPixmap(QtGui.QPixmap("img/csns.png").scaledToHeight(64))

        self.line1=QtGui.QFrame(self.first)
        self.line1.setGeometry(QtCore.QRect())
        self.line1.setFrameShape(QtGui.QFrame.HLine)
        self.line1.setFrameShadow(QtGui.QFrame.Sunken)

        self.line2=QtGui.QFrame(self.first)
        self.line2.setGeometry(QtCore.QRect())
        self.line2.setFrameShape(QtGui.QFrame.HLine)
        self.line2.setFrameShadow(QtGui.QFrame.Sunken)

        self.line3=QtGui.QFrame(self.first)
        self.line3.setGeometry(QtCore.QRect())
        self.line3.setFrameShape(QtGui.QFrame.HLine)
        self.line3.setFrameShadow(QtGui.QFrame.Sunken)

        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('Backward Bank')
        self.bankCombo.addItem('Middle Bank')
        self.bankCombo.addItem('Low Bank')
        self.bankCombo.setMaximumWidth(150)
        self.bankCombo.activated.connect(self.bankComboChange)

        self.addButton = QtGui.QPushButton('Add')
        self.addButton.setMaximumHeight(30)
        self.addButton.setMaximumWidth(_loadWidth)
        self.addButton.clicked.connect(self.addModule)

        self.module1Label = QtGui.QLabel('Module:')
        self.module1Text = QtGui.QTextEdit('')
        self.module1Text.setMaximumHeight(31)
        self.module2Label = QtGui.QLabel('Module:')
        self.module2Text = QtGui.QTextEdit('')
        self.module2Text.setMaximumHeight(31)
        self.module3Label = QtGui.QLabel('Module:')
        self.module3Text = QtGui.QTextEdit('')
        self.module3Text.setMaximumHeight(31)

        self.moduleCombo = QtGui.QComboBox()
        self.moduleCombo.addItem('ALL') 
        self.moduleCombo.addItem('322')
        self.moduleCombo.addItem('331')
        self.moduleCombo.addItem('332')
        self.moduleCombo.addItem('333')
        self.moduleCombo.addItem('341')
        self.moduleCombo.addItem('342')
        self.moduleCombo.addItem('343')
        self.moduleCombo.addItem('422')
        self.moduleCombo.addItem('431')
        self.moduleCombo.addItem('432')
        self.moduleCombo.addItem('433')
        self.moduleCombo.addItem('441')
        self.moduleCombo.addItem('442')
        self.moduleCombo.addItem('443')
        self.moduleCombo.setMaximumWidth(150)
        
        self.sample = QtGui.QLabel('Sample Run:',self.first)
        self.sample.setMaximumHeight(30)
        self.sampleText = QtGui.QTextEdit('') 
        self.sampleText.setMaximumHeight(31)
        #self.sampleLoad = QtGui.QPushButton('Load') 
        #self.sampleLoad.setMaximumHeight(30)
        #self.sampleLoad.setMaximumWidth(_loadWidth)
        #self.sampleLoad.clicked.connect(self.sampleLoadFile)
        #self.sampleTip = QtGui.QLabel('Please seperate run No with ,',self.first)

        self.vanadium = QtGui.QLabel('Vanadium Run:',self.first)
        self.vanadium.setMaximumHeight(30)
        self.vanadiumText = QtGui.QTextEdit('') 
        self.vanadiumText.setMaximumHeight(31)
        #self.vanadiumLoad = QtGui.QPushButton('Load') 
        #self.vanadiumLoad.setMaximumHeight(30)
        #self.vanadiumLoad.setMaximumWidth(_loadWidth)
        #self.vanadiumLoad.clicked.connect(self.vanadiumLoadFile)

        self.holdCheck = QtGui.QCheckBox('', self)
        self.holdCheck.stateChanged.connect(self.holdCheckChange)
        self.holdCheck.setChecked(True)
        self.hold = QtGui.QLabel('Holder Run:',self.first)
        self.hold.setMaximumHeight(30)
        self.holdText = QtGui.QTextEdit('') 
        self.holdText.setMaximumHeight(31)
        #self.holdLoad = QtGui.QPushButton('Load') 
        #self.holdLoad.setMaximumHeight(30)
        #self.holdLoad.setMaximumWidth(_loadWidth)
        #self.holdLoad.clicked.connect(self.holdLoadFile)

        self.volume = QtGui.QLabel('Volume:',self.first)
        self.volume.setMaximumHeight(30)
        self.volumeText = QtGui.QTextEdit('2.01') 
        self.volumeText.setMaximumHeight(31)
        self.volumeUnit = QtGui.QLabel('cm3',self.first)
        self.volumeUnit.setMaximumHeight(30)

        self.mass = QtGui.QLabel('Mass:',self.first)
        self.mass.setMaximumHeight(30)
        self.massText = QtGui.QTextEdit('10.69') 
        self.massText.setMaximumHeight(31)
        self.massUnit = QtGui.QLabel('g',self.first)
        self.massUnit.setMaximumHeight(30)

        self.mode = QtGui.QLabel('Mode:',self.first)
        self.modeCombo = QtGui.QComboBox()
        self.modeCombo.addItem('New')
        self.modeCombo.addItem('Old')
        self.modeCombo.setMaximumHeight(31)
        self.modeCombo.activated.connect(self.modeComboChange)
        #self.delayUnit = QtGui.QLabel('us',self.first)
        #self.delayUnit.setMaximumHeight(30)

        self.scale = QtGui.QLabel('Scale:',self.first)
        self.scaleCombo = QtGui.QComboBox()
        self.scaleCombo.addItem('0.5')
        self.scaleCombo.setMaximumHeight(31)

        self.emptyCheck = QtGui.QCheckBox('', self)
        self.emptyCheck.stateChanged.connect(self.emptyCheckChange)
        self.empty = QtGui.QLabel('Empty Run:',self.first)
        self.empty.setMaximumHeight(30)
        self.emptyText = QtGui.QTextEdit('') 
        self.emptyText.setMaximumHeight(31)
        #self.emptyLoad = QtGui.QPushButton('Load') 
        #self.emptyLoad.setMaximumHeight(30)
        #self.emptyLoad.setMaximumWidth(_loadWidth)
        #self.emptyLoad.clicked.connect(self.emptyLoadFile)

        self.timeF = QtGui.QLabel('TimeFocusing:',self.first)
        self.timeF.setMaximumHeight(30)
        self.timeFText = QtGui.QTextEdit('offset.cal') 
        self.timeFText.setMaximumHeight(31)
        self.timeFLoad = QtGui.QPushButton('Load') 
        self.timeFLoad.setMaximumHeight(30)
        self.timeFLoad.setMaximumWidth(_loadWidth)
        self.timeFLoad.clicked.connect(self.timeFLoadFile)

        #self.absorptionCheck = QtGui.QCheckBox('Absorption', self)
        #self.absorptionCheck.setChecked(True)
        #self.absorptionCheck.stateChanged.connect(self.absorptionCheckChange)
        #self.multipleSCheck = QtGui.QCheckBox('Multiple_scatterimg', self)
        #self.multipleSCheck.stateChanged.connect(self.multipleSCheckChange)
        #self.multipleSCheck.setChecked(True)

        self.maxWave = QtGui.QLabel('Max',self.first)
        self.maxWave.setMaximumHeight(30)
        self.binWave = QtGui.QLabel('Bin',self.first)
        self.binWave.setMaximumHeight(30)
        self.minWave = QtGui.QLabel('Min',self.first)
        self.minWave.setMaximumHeight(30)
        
        self.wavelength = QtGui.QLabel('Wavelength:',self.first)
        self.wavelengthMinText = QtGui.QTextEdit('0.1') 
        self.wavelengthMinText.setMaximumHeight(31)
        self.wavelengthBinText = QtGui.QTextEdit('0.001') 
        self.wavelengthBinText.setMaximumHeight(31)
        self.wavelengthMaxText = QtGui.QTextEdit('4.9') 
        self.wavelengthMaxText.setMaximumHeight(31)
        self.d = QtGui.QLabel('d-spacing:',self.first)
        self.dMinText = QtGui.QTextEdit('0.1') 
        self.dMinText.setMaximumHeight(31)
        self.dMinText.textChanged.connect(self.dMinTextChanged)
        self.dBinText = QtGui.QTextEdit('-0.001') 
        self.dBinText.setMaximumHeight(31)
        self.dBinText.textChanged.connect(self.dBinTextChanged)
        self.dMaxText = QtGui.QTextEdit('7.0') 
        self.dMaxText.setMaximumHeight(31)
        self.dMaxText.textChanged.connect(self.dMaxTextChanged)

        self.dateLabel = QtGui.QLabel('Output:',self.first)
        self.gsaCheck = QtGui.QCheckBox('gsas', self)
        self.fpCheck = QtGui.QCheckBox('fullprof', self)
        self.zCheck = QtGui.QCheckBox('Z-Rietveld', self)
        self.gsaCheck.setChecked(True)
        self.fpCheck.setChecked(True)
        self.zCheck.setChecked(True)

        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('sample_raw')
        self.comboBox.addItem('vanadium_raw')
        self.comboBox.addItem('hold_raw')
        self.comboBox.addItem('sample_substract_hold')
        self.comboBox.addItem('vanadium_substract_hold')
        self.comboBox.addItem('sample_final')
        self.comboBox.addItem('sample_final_id')
        self.comboBox.setMaximumWidth(150)
        self.comboBox.activated.connect(self.comboBoxChange)
        
        self.email = QtGui.QLabel('Email:',self.first)
        self.emailText = QtGui.QTextEdit('') 
        self.emailText.setMaximumHeight(31)

        self.canvas = zoomCanvas(
            self,
            16,
            8,
            150,
            '',
            '',
            '',
            '',
            )
        self.canvas.setMinimumHeight(100) 
        self.canvas.draw()

        _nline = 0
        self.firstGrid.addWidget(self.historyButton, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.logo,          _nline, 1, 1, 6, QtCore.Qt.AlignCenter)

        _nline+=1
        self.firstGrid.addWidget(self.settingText,   _nline, 1, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.defaultButton, _nline, 2, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.loadButton,    _nline, 3, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.singleButton,  _nline, 4, 1,2 , QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.batchButton,   _nline, 6, 1,2 , QtCore.Qt.AlignCenter)

        _nline+=1
        self.firstGrid.addWidget(self.line1,         _nline, 0, 1, 7)

        _nline+=1
        self.firstGrid.addWidget(self.bankCombo,     _nline, 0, 1, 2)
        self.firstGrid.addWidget(self.moduleCombo,   _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.addButton,     _nline, 3, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.module1Label,   _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.module1Text,    _nline, 2, 1, 3)
        _nline += 1
        self.firstGrid.addWidget(self.module2Label,   _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.module2Text,    _nline, 2, 1, 3)
        _nline += 1
        self.firstGrid.addWidget(self.module3Label,   _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.module3Text,    _nline, 2, 1, 3)
        _nline += 1
        self.firstGrid.addWidget(self.sample,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.sampleText,    _nline, 2, 1, 3)
        #self.firstGrid.addWidget(self.sampleLoad,    _nline, 4, 1, 1)
        #self.firstGrid.addWidget(self.sampleTip,    _nline, 3, 1, 1)
        
        _nline += 1
        self.firstGrid.addWidget(self.vanadium,      _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.vanadiumText,  _nline, 2, 1, 3)
        #self.firstGrid.addWidget(self.vanadiumLoad,  _nline, 4, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.holdCheck,     _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.hold,          _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.holdText,      _nline, 2, 1, 3)
        #self.firstGrid.addWidget(self.holdLoad,      _nline, 4, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.emptyCheck,    _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.empty,         _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.emptyText,     _nline, 2, 1, 3)
        #self.firstGrid.addWidget(self.emptyLoad,     _nline, 4, 1, 1)
       
        _nline+=1
        self.firstGrid.addWidget(self.line2,         _nline, 0, 1, 7)
        
        _nline += 1
        self.firstGrid.addWidget(self.timeF,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.timeFText,    _nline, 2, 1, 3)
        self.firstGrid.addWidget(self.timeFLoad,    _nline, 5, 1, 2)
         
        _nline += 1
        self.firstGrid.addWidget(self.volume,       _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.volumeText,   _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.volumeUnit,   _nline, 3, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.mass,         _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.massText,     _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.massUnit,     _nline, 3, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.mode,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.modeCombo,    _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.scale,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.scaleCombo,    _nline, 2, 1, 1)
        
        #_nline += 1
        #self.firstGrid.addWidget(self.absorptionCheck, _nline, 2, 1, 1)
        #self.firstGrid.addWidget(self.multipleSCheck,  _nline, 3, 1, 1)

        _nline+=1
        self.firstGrid.addWidget(self.line3, _nline, 0, 1, 7)
        
        _nline += 1
        self.firstGrid.addWidget(self.minWave, _nline, 2, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.binWave, _nline, 3, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.maxWave, _nline, 4, 1, 1, QtCore.Qt.AlignCenter)
        
        _nline += 1
        self.firstGrid.addWidget(self.wavelength,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.wavelengthBinText, _nline, 3, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMaxText, _nline, 4, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.d,        _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.dMinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.dBinText, _nline, 3, 1, 1)
        self.firstGrid.addWidget(self.dMaxText, _nline, 4, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.dateLabel, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.gsaCheck,  _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.fpCheck,   _nline, 3, 1, 1)
        self.firstGrid.addWidget(self.zCheck,    _nline, 4, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.email,     _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.emailText, _nline, 2, 1, 3)
         
        _nline = 0
        self.secondGrid.addWidget(self.comboBox, _nline, 0, 1, 1, QtCore.Qt.AlignCenter )
        _nline += 1
        self.secondGrid.addWidget(self.canvas,   _nline, 0, 1, 1, QtCore.Qt.AlignCenter)

        #self.comboBoxChange()
        self.dBank1Min = 0.1
        self.dBank1Bin = -0.0004
        self.dBank1Max = 2.6
        self.dBank2Min = 0.1
        self.dBank2Bin = -0.001
        self.dBank2Max = 7.0
        self.dBank3Min = 0.2
        self.dBank3Bin = -0.003
        self.dBank3Max = 20

        self.mainWidth = 0
        self.mainHeight = 0

        self.loadPath = ''
        self.runPath = ''

        self.samplePath = ''
        self.vanadiumPath = ''
        self.holdPath = ''
        self.hold2Path = ''
        self.emptyPath = ''
        self.empty2Path = ''
        self.timeFPath = ''
    
        self.setCentralWidget(self.splitter2)
        self.loadConfigure()

        self.bankCombo.setCurrentIndex(1)
        self.module1Label.hide()
        self.module1Text.hide()
        self.module2Label.show()
        self.module2Text.show()
        self.module3Label.hide()
        self.module3Text.hide()
        self.mode.show()
        self.modeCombo.show()

        logging.info("GPPD start!")

    def historyChanged(self):
        self.historyDialog = historyDialog()
        self.historyDialog.setHistory('GPPDoffline history:')
        self.historyDialog.setHistory('V2.0.1    2019-04-20   The original intensities and sigmas of fullprof data have been multiplied by 10000.')
        self.historyDialog.setHistory('V2.1.1    2019-10-31   Two mode for bank2: Old means only bank2, New means merging 4 modules in bank3')
        self.historyDialog.setHistory('V2.1.2    2019-11-01   Bugs in batch reduction. Add Rexp in Files')
        self.historyDialog.setHistory('V2.1.3    2019-11-06   Function optimization when merging several workspaces with memoryError.')
        self.historyDialog.setHistory('V2.2.1    2019-12-27   add tips for error in hold reduction.')
        self.historyDialog.setHistory('V2.3.1    2020-02-17   focus dSpacing by module, then merge to bank.')
        self.historyDialog.setHistory('V2.3.2    2020-03-11   new dSpacing range and rebin.')
        self.historyDialog.setHistory('V2.3.3    2020-03-20   two scale factor for room(0.5) and low temperature(1.0).')
        self.historyDialog.setHistory('V2.4.1    2020-04-15   change suffix with different data type and add raw data.')
        self.historyDialog.show()

    def setDefault(self):
        self.bankCombo.setCurrentIndex(1)
        self.volumeText.setText('2.01')
        self.massText.setText('10.69')
        self.modeCombo.setCurrentIndex(0)
        self.scaleCombo.setCurrentIndex(0)
        self.wavelengthMinText.setText('0.7')
        self.wavelengthBinText.setText('0.1')
        self.wavelengthMaxText.setText('4.6')
        index = self.bankCombo.currentIndex()
        if index == 0:
            self.dBank1Min = 0.1
            self.dBank1Bin = -0.0004
            self.dBank1Max = 2.6
            self.dMinText.setText(str(self.dBank1Min))
            self.dBinText.setText(str(self.dBank1Bin))
            self.dMaxText.setText(str(self.dBank1Max))
            self.mode.hide()
            self.modeCombo.hide()
        elif index == 1:
            self.dBank2Min = 0.2
            self.dBank2Bin = -0.0008
            self.dBank2Max = 3.9
            self.dMinText.setText(str(self.dBank2Min))
            self.dBinText.setText(str(self.dBank2Bin))
            self.dMaxText.setText(str(self.dBank2Max))
            self.mode.show()
            self.modeCombo.show()
        elif index == 2:
            self.dBank3Min = 0.5
            self.dBank3Bin = -0.0008
            self.dBank3Max = 20
            self.dMinText.setText(str(self.dBank3Min))
            self.dBinText.setText(str(self.dBank3Bin))
            self.dMaxText.setText(str(self.dBank3Max))
            self.mode.hide()
            self.modeCombo.hide()
        #self.absorptionCheck.setChecked(True)
        #self.multipleSCheck.setChecked(True)
        self.holdCheck.setChecked(True)
        self.emptyCheck.setChecked(False)        

    def loadSetting(self):
        #try:
        if not os.path.exists(os.environ['HOME']+'/GPPDoffline'):
            _cmd = 'mkdir '+os.environ['HOME']+'/GPPDoffline'
            subprocess.Popen(_cmd, shell=True)
        if not self.loadPath:
            _confFile = os.environ['HOME']+'/GPPDoffline'
            #_confFile = '/instrument_data'
            #_confFile = os.environ['HOME'] + '/instrument_data'
            if not os.path.exists(_confFile):
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
            self.loadPath = fileName[0]
        else:
            fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.loadPath)
        #except:
        #    pass
        #try:
        self.comboBox.setCurrentIndex(5)
        self.drawFinalCanvas()
        #self.canvas.ax.clear()
        #self.canvas.draw()
        configure = self.readXml(fileName[0])
        self.setSetting(configure)        
        #except:
        #    pass

    def setModuleIndex(self, bankIndex, module):
        self.bankComboChange()
        lowModule = ['ALL', '123','131','132','133','143','221','231','232','233','231']
        middleModule = ['ALL', '322','331','332','333','341','342','343','422','431','432','433','441','442','443']
        backwardModule = ['ALL', '521','522','523','531','532','533','541','542','543','621','622','623','631','632','633','641','642','643']
        if bankIndex == 0:
            _index = backwardModule.index(module)
        elif bankIndex == 1:
            _index = middleModule.index(module)
        elif bankIndex == 2:
            _index = lowModule.index(module)
        self.moduleCombo.setCurrentIndex(_index)

    def addModule(self):
        index = self.bankCombo.currentIndex()
        if index == 0:
            if str(self.moduleCombo.currentText()) not in str(self.module1Text.toPlainText()):
                if str(self.module1Text.toPlainText()):
                    self.module1Text.setText(str(self.module1Text.toPlainText())+','+str(self.moduleCombo.currentText()))
                else:
                    self.module1Text.setText(str(self.moduleCombo.currentText()))
        elif index == 1:
            if str(self.moduleCombo.currentText()) not in str(self.module2Text.toPlainText()):
                if str(self.module2Text.toPlainText()):
                    self.module2Text.setText(str(self.module2Text.toPlainText())+','+str(self.moduleCombo.currentText()))
                else:
                    self.module2Text.setText(str(self.moduleCombo.currentText()))
        elif index == 2:
            if str(self.moduleCombo.currentText()) not in str(self.module3Text.toPlainText()):
                if str(self.module3Text.toPlainText()):
                    self.module3Text.setText(str(self.module3Text.toPlainText())+','+str(self.moduleCombo.currentText()))
                else:
                    self.module3Text.setText(str(self.moduleCombo.currentText()))

    def dMinTextChanged(self):
        try:
            index = self.bankCombo.currentIndex()
            if index == 0:
                self.dBank1Min = float(self.dMinText.toPlainText())
            elif index == 1:
                self.dBank2Min = float(self.dMinText.toPlainText())
            elif index == 2:
                self.dBank3Min = float(self.dMinText.toPlainText())
        except:
            pass

    def dBinTextChanged(self):
        try:
            index = self.bankCombo.currentIndex()
            if index == 0:
                self.dBank1Bin = float(self.dBinText.toPlainText())
            elif index == 1:
                self.dBank2Bin = float(self.dBinText.toPlainText())
            elif index == 2:
                self.dBank3Bin = float(self.dBinText.toPlainText())
        except:
            pass

    def dMaxTextChanged(self):
        try:
            index = self.bankCombo.currentIndex()
            if index == 0:
                self.dBank1Max = float(self.dMaxText.toPlainText())
            elif index == 1:
                self.dBank2Max = float(self.dMaxText.toPlainText())
            elif index == 2:
                self.dBank3Max = float(self.dMaxText.toPlainText())
        except:
            pass

    def getRunNo(self, configure):
        runNo = ''
        _tmp = []
        _tmp1 = []
        _runNo1 = []
        _tmp2 = 0
        _tmp = [s.strip() for s in configure.split(',')]
        for i in range(len(_tmp)):
            _runNo = ''
            _runNo = _tmp[i].find('RUN')
            _runNo = int(_tmp[i][(int(_runNo)+3):(int(_runNo)+10)])
            _runNo1.append(_runNo)

        for i in range(len(_runNo1)):
            if i == len(_runNo1):
                break
            _tmp2 = int(_runNo1[i])
            for j in range(1,len(_runNo1)):
                if _tmp2+j in _runNo1:
                    _runNo1[i] = str(_tmp2)+'-'+str(_tmp2+j)
                    _runNo1.remove(int(_tmp2+j))

        for i in range(len(_runNo1)):
            if i == len(_runNo1) - 1:
                runNo += str(_runNo1[i])
            else:
                runNo += str(_runNo1[i]) + ','
        return runNo

    def setSetting(self, configure):

        bankIndex = int(configure['Bank'])
        self.bankCombo.setCurrentIndex(bankIndex)

        module = str(configure['Module'])
        if module == None:
            _module = module[-3:]
            self.setModuleIndex(bankIndex, _module)
            if bankIndex == 0:
                self.module1Text.setText(module)
            elif bankIndex == 1:
                self.module2Text.setText(module)
            elif bankIndex == 2:
                self.module3Text.setText(module)

        #loadIndex = int(configure['Load'])
        #self.loadCombo.setCurrentIndex(loadIndex)

        
        if configure['Sample_det']:
            _runNo = ''
            _runNo = self.getRunNo(configure['Sample_det'])
            self.sampleText.setText(_runNo)
            
        if configure['Vanadium_det']:
            _runNo = ''
            _runNo = self.getRunNo(configure['Vanadium_det'])
            self.vanadiumText.setText(_runNo)
        
        if configure['Hold_det']: 
            _runNo = ''
            _runNo = self.getRunNo(configure['Hold_det'])
            self.holdText.setText(_runNo)
        
        if configure['Empty_det']:
            _runNo = ''
            _runNo = self.getRunNo(configure['Empty_det'])
            self.emptyText.setText(_runNo)
        
        self.timeFText.setText(configure['TF'])
        self.volumeText.setText(configure['Volume'])
        self.massText.setText(configure['Mass'])
        modeIndex = int(configure['Mode'])
        self.modeCombo.setCurrentIndex(modeIndex)
        scaleIndex = int(configure['Scale'])
        self.scaleCombo.setCurrentIndex(scaleIndex)
        self.wavelengthMinText.setText(configure['wmin'])
        self.wavelengthBinText.setText(configure['wbin'])
        self.wavelengthMaxText.setText(configure['wmax'])
        self.dMinText.setText(configure['dmin'])
        self.dBinText.setText(configure['dbin'])
        self.dMaxText.setText(configure['dmax'])
        self.emailText.setText(configure['email'])
        #if configure['Absorption']=='0':
         #   self.absorptionCheck.setChecked(False)
        #else:
        #    self.absorptionCheck.setChecked(True)
        #if configure['Multiple_scattering']=='0':
        #    self.multipleSCheck.setChecked(False)
        #else:
        #    self.multipleSCheck.setChecked(True)

        if configure['Hold_check']=='1':
            self.holdCheck.setChecked(True)
        else:
            self.holdCheck.setChecked(False)

        if configure['Empty_check']=='1':
            self.emptyCheck.setChecked(True)
        else:
            self.emptyCheck.setChecked(False)

    def readXml(self, filename):
        tree = ET.parse(filename)
        root = tree.getroot()

        configure={}        

        _tmp = root.findall('Bank')[0].text
        configure['Bank']=_tmp

        _tmp = root.findall('Module')[0].text
        configure['Module']=_tmp

        #_tmp = root.findall('Load')[0].text
        #configure['Load']=_tmp

        _tmp = root.findall('Sample_det')[0].text
        configure['Sample_det']=_tmp
        #_tmp = root.findall('Sample_mon')[0].text
        #configure['Sample_mon']=_tmp
            
        _tmp = root.findall('Vanadium_det')[0].text
        configure['Vanadium_det']=_tmp
        #_tmp = root.findall('Vanadium_mon')[0].text
        #configure['Vanadium_mon']=_tmp

        _tmp = root.findall('Hold_det')[0].text
        configure['Hold_det']=_tmp
        #_tmp = root.findall('Hold_mon')[0].text
        #configure['Hold_mon']=_tmp
            
        _tmp = root.findall('Empty_det')[0].text
        configure['Empty_det']=_tmp
        #_tmp = root.findall('Empty_mon')[0].text
        #configure['Empty_mon']=_tmp
        
        _tmp = root.findall('Hold_check')[0].text
        configure['Hold_check']=_tmp
        
        _tmp = root.findall('Empty_check')[0].text
        configure['Empty_check']=_tmp
        
        _tmp = root.findall('TF')[0].text
        configure['TF']=_tmp
        
        _tmp = root.findall('Volume')[0].text
        configure['Volume']=_tmp
        
        _tmp = root.findall('Mass')[0].text
        configure['Mass']=_tmp
        
        _tmp = root.findall('Mode')[0].text
        configure['Mode']=_tmp
        
        _tmp = root.findall('Scale')[0].text
        configure['Scale']=_tmp
        
        _tmp = root.findall('wmin')[0].text
        configure['wmin']=_tmp
        
        _tmp = root.findall('wbin')[0].text
        configure['wbin']=_tmp
        
        _tmp = root.findall('wmax')[0].text
        configure['wmax']=_tmp
        
        _tmp = root.findall('dmin')[0].text
        configure['dmin']=_tmp
        
        _tmp = root.findall('dbin')[0].text
        configure['dbin']=_tmp
        
        _tmp = root.findall('dmax')[0].text
        configure['dmax']=_tmp
        
        _tmp = root.findall('email')[0].text
        configure['email']=_tmp
        
        #_tmp = root.findall('Absorption')[0].text
        #configure['Absorption']=_tmp
        
        #_tmp = root.findall('Multiple_scattering')[0].text
        #configure['Multiple_scattering']=_tmp

        return configure

    def getFilePath(self, _file):
        _path=""
        try:
            _path=os.path.dirname(_file)
        except:
            _path=""

        return _path

    def sampleLoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.samplePath:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])

                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.samplePath = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.samplePath)

            _path = self.sampleText.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]  #path,path
                #_name = str(fileName)[2:-1] #'path','path'
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.sampleText.setText(_name)
        except:
            pass

    def vanadiumLoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.vanadiumPath:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])

                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.vanadiumPath = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.vanadiumPath)

            _path = self.vanadiumText.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.vanadiumText.setText(_name)
        except:
            pass

    def holdLoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.holdPath:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])

                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.holdPath = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.holdPath)
            
            _path = self.holdText.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.holdText.setText(_name)
        except:
            pass

    def hold2LoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.hold2Path:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])

                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.hold2Path = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.hold2Path)

            _path = self.hold2Text.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.hold2Text.setText(_name)
        except:
            pass

    def emptyLoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.emptyPath:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])
                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.emptyPath = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.emptyPath)

            _path = self.emptyText.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.emptyText.setText(_name)
        except:
            pass

    def empty2LoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.empty2Path:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])
                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.empty2Path = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.empty2Path)

            _path = self.empty2Text.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.empty2Text.setText(_name)
        except:
            pass

    def timeFLoadFile(self):
        try:
            #fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
            if not self.timeFPath:
                #_confFile = '/instrument_data'
                _confFile = os.environ['HOME'] + '/instrument_data'
                if not os.path.exists(_confFile):
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', os.environ['HOME'])
                else:
                    fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', _confFile)
                self.timeFPath = fileName[0]
            else:
                fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load RUN Path', self.timeFPath)

            _path = self.timeFText.toPlainText()
            if _path == '':
                _name = str(fileName)[3:-2]
            else:
                _name = _path + ',' + str(fileName)[3:-2]
            self.timeFText.setText(_name)
        except:
            pass

    def holdCheckChange(self):
        if self.holdCheck.isChecked():
            self.hold = True
        else:
            self.hold = False

    def emptyCheckChange(self):
        if self.emptyCheck.isChecked():
            self.empty = True
        else:
            self.empty = False

    def absorptionCheckChange(self):
        if self.absorptionCheck.isChecked():
            self.absorption = '1'
        else:
            self.absorption = '0'

    def multipleSCheckChange(self):
        if self.multipleSCheck.isChecked():
            self.multipleS = '1'
        else:
            self.multipleS = '0'

    def drawFinalCanvas(self):
        _filename = os.environ['HOME']+'/GPPDoffline/sam_Itof.dat'

        #try:
        if os.path.exists(_filename):
            _x, _y = self.readData(_filename)
            self.updateCanvas(_x, _y)
        else:
            self.canvas.ax.clear()
        #except:
        #    pass

    def batchReduction(self):
        logging.info("batch reduction start!")
        self.comboBox.setCurrentIndex(5)
        index = self.bankCombo.currentIndex()
        if index == 0:
            bankName='bank1'
        elif index == 1:
            bankName='bank2'
        elif index == 2:
            bankName='bank3'
        configure = self.getSetting()
        self.writeXml(configure)
        _result = self.checkValue()
        print '================'
        print _result
        if _result:
            self.deleteData()
            self.canvas.ax.clear()
            self.canvas.draw()
            #with stdout_redirected(to="./log"):
            msg = reduction.batchReduction()
            #msg = reduction.Reduction()
            msgBox = QtGui.QMessageBox.information(self, "Warning", msg, QtGui.QMessageBox.Yes)
            logging.info("batch reduction end!")
            self.drawFinalCanvas()
        
    def singleReduction(self):
        logging.info("single reduction start!")
        self.comboBox.setCurrentIndex(5)
        index = self.bankCombo.currentIndex()
        if index == 0:
            bankName='bank1'
        elif index == 1:
            bankName='bank2'
        elif index == 2:
            bankName='bank3'
        configure = self.getSetting()
        self.writeXml(configure)
        _result = self.checkValue()
        print '================'
        print _result
        if _result:
            self.deleteData()
            self.canvas.ax.clear()
            self.canvas.draw()
            #with stdout_redirected(to="./log"):
            msg = reduction.Reduction()
            msgBox = QtGui.QMessageBox.information(self, "Warning", msg, QtGui.QMessageBox.Yes)
            #logging.info("single reduction end!")
            self.drawFinalCanvas()
        
        #for i in range(len(runNo)):
        #if self.gsaCheck.isChecked():
        #    WriteGSA.WriteGSA(runNo[0], bankName)

        #if self.fpCheck.isChecked():
        #    WriteFP.WriteFP(runNo[0],bankName)

        #if self.zCheck.isChecked():
        #    WriteZR.WriteZR(runNo[0], bankName)

    def deleteData(self):
        if not os.path.exists(os.environ['HOME']+'/GPPDoffline'):
            _cmd = 'mkdir '+os.environ['HOME']+'/GPPDoffline'
            subprocess.Popen(_cmd, shell=True)

        try:
            _tmp="rm -rf "+os.environ['HOME']+"/GPPDoffline/*.dat"
            subprocess.check_output(_tmp, shell=True)
        except:
            pass

    def checkValue(self):
        _result = False
        if self.sampleText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Sample Run can not be empty.", QtGui.QMessageBox.Yes)
        elif self.volumeText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Volume Run can not be empty.", QtGui.QMessageBox.Yes)
        elif self.massText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Mass can not be empty.", QtGui.QMessageBox.Yes)
        elif self.hold == True:
            if self.holdText.toPlainText() == '':
                msgBox = QtGui.QMessageBox.information(self,"Warning","Hold can not be empty.", QtGui.QMessageBox.Yes)
            else:
                _result = True
        else:
            _result = True
        return _result

    def setRunNo(self, tmp):
        _runNo = []
        _sample = ''
        if tmp !="":
            _runNo = tmp.split(',')

            for i in range(len(_runNo)):
                if '-' in _runNo[i]:
                    tmp = _runNo[i].split('-')
                    _runNo[i] = tmp[0]
                    for j in range(int(tmp[0]), int(tmp[1])):
                        _runNo.append(str(int(j)+1))

            for i in range(len(_runNo)):
                if str(_runNo[i]):
                    self.runPath = ''
                    self.search(os.environ['HOME'], 'RUN'+str(_runNo[i]).zfill(7))
                    if self.runPath:
                        if i == 0:
                            _sample += str(self.runPath) + '/detector.nxs'
                        else:
                            _sample += ',' + str(self.runPath) + '/detector.nxs'
        else:
            _sample = ''
        return _sample

    def getSetting(self):
        configure = {}

        index = self.bankCombo.currentIndex()
        #_text = self.moduleCombo.currentText()

        configure['Bank']=str(index)
        
        if index == 0:
            _text = str(self.module1Text.toPlainText())
        elif index == 1:
            _text = str(self.module2Text.toPlainText())
        elif index == 2:
            _text = str(self.module3Text.toPlainText())
        configure['Module']=str(_text)

        _runNo = ''
        _tmp = []
        _tmp=str(self.sampleText.toPlainText())
        _runNo = self.setRunNo(_tmp)
        configure['Sample_det'] = _runNo
           
        _runNo = ''
        _tmp = [] 
        _tmp=str(self.vanadiumText.toPlainText())
        _runNo = self.setRunNo(_tmp)    
        configure['Vanadium_det'] = _runNo

        _runNo = ''
        _tmp = []
        _tmp=str(self.holdText.toPlainText())
        _runNo = self.setRunNo(_tmp)    
        configure['Hold_det'] = _runNo

        configure['Volume'] = str(self.volumeText.toPlainText())
        configure['Mass'] = str(self.massText.toPlainText())
        
        index = self.modeCombo.currentIndex()
        configure['Mode']=str(index)
       
        index = self.scaleCombo.currentIndex()
        configure['Scale']=str(index)
       
        _runNo = ''
        _tmp = []
        _tmp=str(self.emptyText.toPlainText()) 
        _runNo = self.setRunNo(_tmp)
        configure['Empty_det'] = _runNo
        
        _tmp = str(self.timeFText.toPlainText())
        if _tmp!="":
            configure['TF'] =  _tmp
        else:
            configure['TF'] = ''
        #if self.absorptionCheck.isChecked():
        #    configure['Absorption'] = '1'
        #else:
        #    configure['Absorption'] = '0'

        #if self.multipleSCheck.isChecked():
        #    configure['Multiple_scattering'] = '1'
        #else:
        #    configure['Multiple_scattering'] = '0'
      
        if self.holdCheck.isChecked():
            configure['Hold_check'] = '1'
        else:
            configure['Hold_check'] = '0'
        if self.emptyCheck.isChecked():
            configure['Empty_check'] = '1'
        else:
            configure['Empty_check'] = '0'
 
        configure['wmin']=self.wavelengthMinText.toPlainText()
        configure['wbin']=self.wavelengthBinText.toPlainText()
        configure['wmax']=self.wavelengthMaxText.toPlainText()
        configure['dmin']=self.dMinText.toPlainText()
        configure['dbin']=self.dBinText.toPlainText()
        configure['dmax']=self.dMaxText.toPlainText()
        
        configure['email'] = str(self.emailText.toPlainText())

        return configure

    def writeXml(self, configure):
        top = ET.Element('root')

        child = ET.SubElement(top, 'Bank')
        child.text=configure['Bank']

        child = ET.SubElement(top, 'Module')
        child.text=configure['Module']

        #child = ET.SubElement(top, 'Load')
        #child.text=configure['Load']

        child = ET.SubElement(top, 'Sample_det')
        child.text=configure['Sample_det']
        #child = ET.SubElement(top, 'Sample_mon')
        #child.text=configure['Sample_mon']
        child = ET.SubElement(top, 'Vanadium_det')
        child.text=configure['Vanadium_det']
        #child = ET.SubElement(top, 'Vanadium_mon')
        #child.text=configure['Vanadium_mon']
        child = ET.SubElement(top, 'Hold_det')
        child.text=configure['Hold_det']
        #child = ET.SubElement(top, 'Hold_mon')
        #child.text=configure['Hold_mon']
        child = ET.SubElement(top, 'Volume')
        child.text=configure['Volume']
        child = ET.SubElement(top, 'Mass')
        child.text=configure['Mass']
        child = ET.SubElement(top, 'Mode')
        child.text=configure['Mode']
        child = ET.SubElement(top, 'Scale')
        child.text=configure['Scale']
        child = ET.SubElement(top, 'Empty_det')
        child.text=configure['Empty_det']
        #child = ET.SubElement(top, 'Empty_mon')
        #child.text=configure['Empty_mon']
        child = ET.SubElement(top, 'Hold_check')
        child.text=configure['Hold_check']
        child = ET.SubElement(top, 'Empty_check')
        child.text=configure['Empty_check']
        child = ET.SubElement(top, 'TF')
        child.text=configure['TF']

        child = ET.SubElement(top, 'wmin')
        child.text=configure['wmin']
        child = ET.SubElement(top, 'wbin')
        child.text=configure['wbin']
        child = ET.SubElement(top, 'wmax')
        child.text=configure['wmax']
        child = ET.SubElement(top, 'dmin')
        child.text=configure['dmin']
        child = ET.SubElement(top, 'dbin')
        child.text=configure['dbin']
        child = ET.SubElement(top, 'dmax')
        child.text=configure['dmax']
        #child = ET.SubElement(top, 'Absorption')
        #child.text=configure['Absorption']
        #child = ET.SubElement(top, 'Multiple_scattering')
        #child.text=configure['Multiple_scattering']
        child = ET.SubElement(top, 'email')
        child.text=configure['email']
     
        xmlstr = minidom.parseString(ET.tostring(top)).toprettyxml(indent="   ")
        
        if not os.path.exists(os.environ['HOME']+'/GPPDoffline'):
            _cmd = 'mkdir '+os.environ['HOME']+'/GPPDoffline'
            subprocess.Popen(_cmd, shell=True)

        with open(os.environ['HOME']+'/GPPDoffline/configure.xml', "w") as f:
            f.write(xmlstr)

    def bankComboChange(self):
        index = self.bankCombo.currentIndex()
        if index == 2:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('ALL') 
            self.moduleCombo.addItem('123') 
            self.moduleCombo.addItem('131') 
            self.moduleCombo.addItem('132') 
            self.moduleCombo.addItem('133') 
            self.moduleCombo.addItem('143') 
            self.moduleCombo.addItem('221') 
            self.moduleCombo.addItem('231') 
            self.moduleCombo.addItem('232') 
            self.moduleCombo.addItem('233') 
            self.moduleCombo.addItem('241') 
            self.dMinText.setText(str(self.dBank3Min))
            self.dBinText.setText(str(self.dBank3Bin))
            self.dMaxText.setText(str(self.dBank3Max))

            self.module1Label.hide()
            self.module1Text.hide()
            self.module2Label.hide()
            self.module2Text.hide()
            self.module3Label.show()
            self.module3Text.show()
            self.mode.hide()
            self.modeCombo.hide()

        elif index == 1:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('ALL') 
            self.moduleCombo.addItem('322')
            self.moduleCombo.addItem('331')
            self.moduleCombo.addItem('332')
            self.moduleCombo.addItem('333')
            self.moduleCombo.addItem('341')
            self.moduleCombo.addItem('342')
            self.moduleCombo.addItem('343')
            self.moduleCombo.addItem('422')
            self.moduleCombo.addItem('431')
            self.moduleCombo.addItem('432')
            self.moduleCombo.addItem('433')
            self.moduleCombo.addItem('441')
            self.moduleCombo.addItem('442')
            self.moduleCombo.addItem('443')
            self.dMinText.setText(str(self.dBank2Min))
            self.dBinText.setText(str(self.dBank2Bin))
            self.dMaxText.setText(str(self.dBank2Max))
            
            self.module1Label.hide()
            self.module1Text.hide()
            self.module2Label.show()
            self.module2Text.show()
            self.module3Label.hide()
            self.module3Text.hide()
            self.mode.show()
            self.modeCombo.show()
        
        elif index == 0:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('ALL') 
            self.moduleCombo.addItem('521')
            self.moduleCombo.addItem('522')
            self.moduleCombo.addItem('523')
            self.moduleCombo.addItem('531')
            self.moduleCombo.addItem('532')
            self.moduleCombo.addItem('533')
            self.moduleCombo.addItem('541')
            self.moduleCombo.addItem('542')
            self.moduleCombo.addItem('543')
            self.moduleCombo.addItem('621')
            self.moduleCombo.addItem('622')
            self.moduleCombo.addItem('623')
            self.moduleCombo.addItem('631')
            self.moduleCombo.addItem('632')
            self.moduleCombo.addItem('633')
            self.moduleCombo.addItem('641')
            self.moduleCombo.addItem('642')
            self.moduleCombo.addItem('643')
            self.dMinText.setText(str(self.dBank1Min))
            self.dBinText.setText(str(self.dBank1Bin))
            self.dMaxText.setText(str(self.dBank1Max))

            self.module1Label.show()
            self.module1Text.show()
            self.module2Label.hide()
            self.module2Text.hide()
            self.module3Label.hide()
            self.module3Text.hide()
            self.mode.hide()
            self.modeCombo.hide()
        else:
            pass

    def modeComboChange(self):
        index = self.modeCombo.currentIndex()
        if index == 0:
            self.dMinText.setText(str(0.1)) 
            self.dBinText.setText(str(-0.001)) 
            self.dMaxText.setText(str(7.0)) 
        elif index == 1:
            self.dMinText.setText(str(0.1)) 
            self.dBinText.setText(str(-0.0006)) 
            self.dMaxText.setText(str(4.0)) 

    def comboBoxChange(self):
        index = self.comboBox.currentIndex()
        if index == 2:
            _filename1 = os.environ['HOME']+'/GPPDoffline/sam_raw.dat'
            _filename2 = os.environ['HOME']+'/GPPDoffline/hold_raw.dat'
            if os.path.exists(_filename1) and os.path.exists(_filename2):
                _x1, _y1 = self.readData(_filename1)
                _x2, _y2 = self.readData(_filename2)
                self.updateCanvas1(_x1, _y1, _x2, _y2)
            else:
                self.canvas.ax.clear()
        else:
            if index == 0:
                _filename = os.environ['HOME']+'/GPPDoffline/sam_raw.dat'
            elif index == 1:
                _filename = os.environ['HOME']+'/GPPDoffline/v_raw.dat' 
            elif index == 3:
                _filename = os.environ['HOME']+'/GPPDoffline/sam_hold.dat'
            elif index == 4:
                _filename = os.environ['HOME']+'/GPPDoffline/v_hold.dat'
            elif index == 5:
                _filename = os.environ['HOME']+'/GPPDoffline/sam_Itof.dat'
            elif index == 6:
                _filename = os.environ['HOME']+'/GPPDoffline/sam_Id.dat'

            #try:
            if os.path.exists(_filename):
                _x, _y = self.readData(_filename)
                self.updateCanvas(_x, _y)
            else:
                self.canvas.ax.clear()
            #except:
            #    pass

    def readData(self, filename):
        _x=[]
        _y=[]
        f=open(filename, "rb")
        for line in f.readlines()[2:]:
            value=line.split(',')
            try:
                _x.append(float(value[0]))
                _y.append(float(value[1]))
            except:
                pass
        f.close()
        return _x, _y

    def updateCanvas(
        self,
        x,
        y,
        ):
        if len(y) == 0 or len(x) \
            != len(y):
            pass
        else:
            self.canvas.ax.clear()
            self.pix1 = \
                self.canvas.ax.plot(x, y)
            self.canvas.draw()
            self.canvas.ax.add_patch(self.canvas.rect)

            try:
                if self.canvas.zoomSelected \
                    and self.canvas.minX \
                    != self.canvas.maxX \
                    and self.canvas.minY \
                    != self.canvas.maxY:
                    self.canvas.ax.set_xlim(self.canvas.minX,
                        self.canvas.maxX)
                    self.canvas.ax.set_ylim(self.canvas.minY,
                        self.canvas.maxY)
                elif self.canvas.scale_factor != 1.0:
                    self.canvas.ax.set_xlim([self.canvas.xdata - self.canvas.new_width * \
                        (1-self.canvas.relx), self.canvas.xdata + \
                        self.canvas.new_width * (self.canvas.relx)])
                    self.canvas.ax.set_ylim([self.canvas.ydata - self.canvas.new_height * \
                        (1-self.canvas.rely), self.canvas.ydata + \
                        self.canvas.new_height * (self.canvas.rely)])
            except:
                pass
            self.canvas.ax.relim()
            self.canvas.ax.autoscale_view()           
 
            self.canvas.draw()

    def updateCanvas1(
        self,
        x1,
        y1,
        x2,
        y2
        ):
        if len(y1) == 0 or len(x1) \
            != len(y1):
            pass
        elif len(y2) == 0 or len(x2) \
            != len(y2):
            pass
        else:
            self.canvas.ax.clear()
            self.canvas.ax.plot(x1, y1)
            self.canvas.ax.plot(x2, y2)
            self.canvas.draw()
            self.canvas.ax.add_patch(self.canvas.rect)

            try:
                if self.canvas.zoomSelected \
                    and self.canvas.minX \
                    != self.canvas.maxX \
                    and self.canvas.minY \
                    != self.canvas.maxY:
                    self.canvas.ax.set_xlim(self.canvas.minX,
                        self.canvas.maxX)
                    self.canvas.ax.set_ylim(self.canvas.minY,
                        self.canvas.maxY)
                elif self.canvas.scale_factor != 1.0:
                    self.canvas.ax.set_xlim([self.canvas.xdata - self.canvas.new_width * \
                        (1-self.canvas.relx), self.canvas.xdata + \
                        self.canvas.new_width * (self.canvas.relx)])
                    self.canvas.ax.set_ylim([self.canvas.ydata - self.canvas.new_height * \
                        (1-self.canvas.rely), self.canvas.ydata + \
                        self.canvas.new_height * (self.canvas.rely)])
            except:
                pass
            self.canvas.ax.relim()
            self.canvas.ax.autoscale_view()

            self.canvas.draw()

    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        try:
            if not os.path.exists(os.environ['HOME']+'/GPPDoffline'):
                _cmd = 'mkdir '+os.environ['HOME']+'/GPPDoffline'
                subprocess.Popen(_cmd, shell=True)

            _confFile=os.environ['HOME']+'/GPPDoffline/configure.json'
            #_confFile='./conf/configure.json'
            _mainWidth, _mainHeight=self.getDisplay()

            if not os.path.exists(_confFile):
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight
            else:
                try:
                    layoutParameter = json.loads(open(_confFile, "r").read())
                    self.mainWidth=layoutParameter['mainWidth']
                    self.mainHeight=layoutParameter['mainHeight']*1.2
                except:
                    self.mainWidth=_mainWidth
                    self.mainHeight=_mainHeight

            self.resize(self.mainWidth, self.mainHeight)
        
            self.loadPath = layoutParameter['loadPath']
            self.samplePath = layoutParameter['samplePath']
            self.vanadiumPath = layoutParameter['vanadiumPath']
            self.holdPath = layoutParameter['holdPath']
            #self.hold2Path = layoutParameter['hold2Path']
            self.emptyPath = layoutParameter['emptyPath']
            #self.empty2Path = layoutParameter['empty2Path']
            self.timeFPath = layoutParameter['timeFPath']
        except:
            pass

    def saveConfigure(self):
        _mainWidth=self.splitter.geometry().width()
        _mainHeight=self.splitter.geometry().height()

        _data = {"mainWidth": _mainWidth, "mainHeight": _mainHeight, "loadPath":self.loadPath, "samplePath":self.samplePath, "vanadiumPath":self.vanadiumPath, "holdPath":self.holdPath, "emptyPath":self.emptyPath, "timeFPath":self.timeFPath}#,"hold2Path":self.hold2Path, "empty2Path":self.empty2Path}
        if not os.path.exists(os.environ['HOME']+'/GPPDoffline'):
                _cmd = 'mkdir '+os.environ['HOME']+'/GPPDoffline'
                subprocess.Popen(_cmd, shell=True)       
 
        _confFile=os.environ['HOME']+'/GPPDoffline/configure.json'
        #_confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
 
    def search(self, path, name):
        _tmp = ''
        for item in os.listdir(path):
            item_path = os.path.join(path, item)
            if os.path.isdir(item_path):
                self.search(item_path, name)
                if name in item:
                    self.runPath = item_path

class historyDialog(QtGui.QMainWindow):

    def __init__(self):
        super(historyDialog, self).__init__(parent=None)
        self.setupUi(self)
        self.setWindowTitle('History')
        self.setWindowModality(QtCore.Qt.ApplicationModal)
        #self.resize(560,460)

        self.history = ''

    def setupUi(self, QWidget):

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)
        self.first.setMinimumHeight(450)
        self.first.setMinimumWidth(750)
 
        self.firstGrid = QtGui.QGridLayout(self.first)

        self.historyText = QtGui.QTextEdit('', self.first)
        self.historyText.setMaximumHeight(430)
    
        _nline = 0    
        self.firstGrid.addWidget(self.historyText, _nline, 0, 1, 1)

        self.setCentralWidget(self.first)

    def setHistory(self, text):
        self.history += text + '\n' + '--------' + '\n'
        self.historyText.setText(self.history)

def exit_handler(top):
    top.saveConfigure()

if __name__ == '__main__':
    
    myapp = QtGui.QApplication(sys.argv)
    
    mytop = mywindow(myapp)
    mytop.setWindowTitle('GPPD Data Reduction V2.4.1')
    mytop.show()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
