#!/usr/bin/python
import subprocess
import sys
import os
import glob
import re
import time
import threading
from xml.etree import ElementTree as ET
import logging
from logging.handlers import RotatingFileHandler

class myLog():
    def __init__(self):
        logging.basicConfig(level=logging.DEBUG,
                format='%(asctime)s %(filename)s[line:%(lineno)d] %(levelname)s %(message)s',
                datefmt='%a, %d %b %Y %H:%M:%S',
                #filename='myMantid_'+name+'.log',
                filename=os.getcwd()+'/nxs.log',
                filemode='a')

        self.logger = logging.getLogger('BL18nxs')
        #hdlr = logging.FileHandler(os.getcwd()+'/RMmantid.log', maxBytes=100, backupCount=5)
        hdlr = RotatingFileHandler(os.getcwd()+'/nxs.log', maxBytes=100, backupCount=0)
        #hdlr = RotatingFileHandler(os.getcwd()+'/myMantid_'+name+'.log', maxBytes=10*1024*1024, backupCount=0)
        #formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
        #hdlr.setFormatter(formatter)
        #self.logger.addHandler(hdlr)
        #self.logger.setLevel(logging.DEBUG)

    def getLog(self):
        return self.logger


def parseDaq(prepath, runno, moduleList, logger):
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/"+runno+"/"
    xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmllist)== 0:
        logger.warning('no xml file in DAQ for '+runno)
        judge=False
    else:
        try:
            xmlfile=xmllist[0]
            root = ET.parse(xmlfile)
            judge=True
        except:
            logger.warning('error in parse xml for daq for '+runno)
            _cmd="cp "+xmlfile+" /home/mantid/workspace/nexusAPI/"+runno+'/'
            subprocess.check_call(_cmd, shell=True)
            judge=False

    if judge:
        for name in moduleList:
            _cmd="python binary_hist.py "+runno+" "+name+" "+prepath+" &"
            subprocess.check_call(_cmd, shell=True)
        for name in moduleList:
            while not os.path.exists(prepath+"/"+runno+"/tmpData/hist_"+name+'.dat'):
                #print "no hist_module data!"
                time.sleep(5)
            #logger.debug(name+" exists!")
    else:
        pass

def recAlg(runno,prepath, logger):
    tofstart, tofbin, tofstep = getTOFinfo()
    #_cmd="./main.exe "+runno+" "+prepath+" "+str(tofstart)+" "+str(tofbin)+" "+str(tofstep)
    _cmd="./main.exe "+runno+" "+str(tofstart)+" "+str(tofbin)+" "+str(tofstep)
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/"+runno+"/complete.dat"):
        #print "no data"
        time.sleep(5)
    #print "finish rec nexus! "


def getTOFinfo():
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    tofstart= int(tof.attrib['tofstart'])
    tofstep = int(tof.attrib['tofstep'])
    tofbin = int(tof.attrib['tofbin'])+1
    return tofstart, tofbin, tofstep

def checkNewRun():
    prepath=sys.path[0]
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/complete"
    daqList=os.listdir(rawpath)
    runList=os.listdir(prepath)
    newList=[]
    for name in daqList:
        if name[0]=='R':
            if name in runList:
                pass
            else:
                newList.append(name)
    return newList

def createNexus(runNo, delay, logger):
    be=time.time()
    runno="RUN"+str(runNo).zfill(7)
    prepath=sys.path[0]
    if os.path.exists(prepath+"/"+runno):
        pass
    else:
        os.mkdir(prepath+"/"+runno)
    
    tmp=prepath+'/'+runno+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    #moduleList=['module131']
    moduleList=['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543','module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643','module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343','module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443','module131', 'module132', 'module133','module231', 'module232', 'module233']
    
    parseDaq(prepath, runno, moduleList, logger)
    logger.debug("finish parse daq: "+str(time.time()-be)+" seconds!!!")
    be=time.time()
    recAlg(runno,prepath,logger)
    logger.debug("finish rec nexus: "+str(time.time()-be)+" seconds!!!")
    _cmd="rm -rf "+prepath+"/"+runno+"/complete.dat"
    subprocess.check_call(_cmd, shell=True)
    _cmd="rm -rf "+prepath+"/"+runno+"/tmpData"
    subprocess.check_call(_cmd, shell=True)
    
    f=open("./database/"+runno, "w")
    f.close()

    try:
        f=open("complete", "w")
        f.close()
    except:
        pass
    _cmd = 'scp -r '+runno+' transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL18/'
    subprocess.check_call(_cmd, shell=True)

    _cmd = 'scp complete  transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL18/'+runno
    subprocess.check_call(_cmd, shell=True)

class main(threading.Thread):
    def __init__(self, delay, logger):
        threading.Thread.__init__(self)
        self.delay=int(delay)
        self.logger = logger
    
    def getRunNoList(self):
        dir="/opt/CSNSDATA/TS1/BL18/Control/"
        pattern="^RUN[0-9]{7}"
        runNo=[]
        for dirpath, dirnames, files in os.walk(dir):
            for dirname in dirnames:
                if re.match(pattern, dirname):
                    runNo.append(int(dirname[3:]))
        runNo.sort()
        return runNo

    def getDaqCompleteList(self):
        dir="/opt/CSNSDATA/TS1/BL18/DAQ/complete/"
        pattern="^RUN[0-9]{7}"
        runNo=[]
        runStr=glob.glob(dir+'RUN*')
        for r in runStr:
            runNo.append(int(r[-7:]))
        runNo.sort()
        return runNo

    def getMonitorList(self,runNo):
        path='/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor2/RUN'+str(runNo).zfill(7)+'/'
        data=glob.glob(path+'*.bin')
        if len(data)==0:
            return False
        else:
            return True


    def getNexusRunList(self):
        dir=os.getcwd()+"/database/"
        pattern="^RUN[0-9]{7}"
        runNo=[]
        runStr=glob.glob(dir+'RUN*')
        for r in runStr:
            runNo.append(int(r[-7:]))
        runNo.sort()
        return runNo

    def process(self):
        ctrlRunList=self.getRunNoList()
        nexusRunList=self.getNexusRunList()
        completeRunList=self.getDaqCompleteList()
        newList=[]
        for cRun in ctrlRunList:
            if cRun not in nexusRunList and cRun in completeRunList:
                if cRun>534:
                    judge=self.getMonitorList(cRun)
                    if judge:
                        newList.append(cRun)
        #print "to be reconstructed: ",newList, time.strftime('%Y-%m-%d',time.localtime(time.time()))
        self.logger.debug("to be reconstructed: "+str(newList))
        for runNo in newList:
            _b=time.time()
            #print "begin:", runNo
            createNexus(runNo, self.delayi, self.logger)
            #print "end:", runNo, (time.time()-_b)/60.0
            self.logger.debug("end: "+str(runNo)+" "+str((time.time()-_b)/60.0)+" min")

    def run(self):
        while True:
            #try:
            self.process()
            #except:
                #pass
            time.sleep(300.0)

if __name__=="__main__":
    _log=myLog()
    logger= _log.getLog()

    threadDaemon = main(0, logger)
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()

