import re
import string
import sys
import numpy as np
import math
from scipy import floor
	
def ReadData(fname):
    TOF=[]
    YINT=[]
    YESD=[]
    fopen=open(fname, "r")
    lines=fopen.readlines()

    nline=len(lines)
    for line in lines:
        try:
            line=line.split(',')
            #line=line.split('   ')
            if float(line[2]) and float(line[0])<=40000:
                TOF.append(float(line[0]))
                YINT.append(float(line[1]))
                YESD.append(float(line[2]))
        except:
            pass
    return TOF, YINT, YESD

def WriteFP(runNo, bankName):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=CR+LF

    fin=str('./sam_Itof.dat')
    #print '<<'
    #print 'Histogram for Z-Rietveld: '+fin

    f_fp='RUN'+str(runNo).zfill(7)+'.dat'
    file_fp=open(f_fp, 'w')
    
    # write title
    if bankName=='bank2':
        strtmp='GPPD Diffraction Histogram for 90-degree bank, '+runNo
    elif bankName=='bank1':
        strtmp='GPPD Diffraction Histogram for 180-degree bank, '+runNo
    else:
        strtmp='GPPD Diffraction Histogram for 30-degree bank, '+runNo
    
    file_fp.write('%-80s%s' % (strtmp,CRLF))

    # read data
    #TOF, YINT, YESD, mul=ReadData(fin)
    TOF, YINT, YESD=ReadData(fin)
    n=len(TOF)

    #step = TOF[1]-TOF[0]
    strtmp='%s %s %s' % ('TOF', 'INT', 'ERR')
    file_fp.write('%-80s%s' % (strtmp,CRLF))
    
    # write data
    for i in range(n):
        strtmp='%.2f %.12f %.12f' % (TOF[i], YINT[i], YESD[i])
        file_fp.write('%s' % strtmp)
        file_fp.write('%s' % CRLF) 

    print 'Histogram for FP:       '+f_fp

#runNo='RUN0000319'
#WriteFP(runNo)
