import re
import string
import sys
import numpy as np
import math
from scipy import floor
	
def ReadData(fname):
    TOF=[]
    YINT=[]
    YESD=[]
    fopen=open(fname, "r")
    lines=fopen.readlines()

    nline=len(lines)
    for line in lines:
        try:
            line=line.split(',')
            #line=line.split('   ')
            if float(line[2]) and float(line[0])<=40000:
                TOF.append(float(line[0]))
                YINT.append(float(line[1]))
                YESD.append(float(line[2]))
        except:
            pass

    ymin=np.amin(YINT)
    ymax=np.amax(YINT)

    if ymin > 0:
        yemin = floor(math.log(ymin)/math.log(10))
    else:
        yemin =0
    yemax = floor(math.log(ymax)/math.log(10))

    if yemin < 0:
        mul = 10**(1-yemin)
    
    mul =10**(5-yemax)

    return TOF, YINT, YESD, mul

def WriteGSA(runNo):
    CR=unichr(13)
    LF=unichr(10)
    CRLF=CR+LF
    fin=str('./sam_Itof.dat')
    #print '<<'
    #print 'Histogram for Z-Rietveld: '+fin

    f_gsas=runNo+'.gsa'
    file_gsas=open(f_gsas, 'w')
    
    # write title
    strtmp='GPPD Diffraction Histogram for 90-degree bank'
    file_gsas.write('%-80s%s' % (strtmp,CRLF))
    strtmp='Instrument parameter: None'
    file_gsas.write('%-80s%s' % (strtmp,CRLF))

    # read data
    TOF, YINT, YESD, mul=ReadData(fin)
    n=len(TOF)
    #print "factor: ",mul
    step = TOF[1]-TOF[0]

    istart = 1
    for i in range(n-1):
        if TOF[i+1]-TOF[i] != step:
            istart = i+1
            break
        
    res = (TOF[istart]-TOF[istart-1])/float(TOF[istart-1])

    # write keyword
    iformat = 2
    if iformat ==0:
        nrec = 1
        nch = n
        strtmp='%s %5d %5d %s %6d %6d %2d %2d %s' % ('BANK 1', n, nch, 'CONST', int(TOF[0]), step, 0, 0, 'FXYE')

    if iformat ==1:
        nrec = 8
        nch=int((n-1)/nrec)
        n=nch*nrec
        strtmp='%s %6d %6d %s %6d %6d %6d %.6f %s' % ('BANK 1', n, nch, 'RALF', int(TOF[0])*32, step*32, int(TOF[istart])*32, res, 'ALT')

    if iformat ==2:
        nrec = 1
        nch = n-1
        n=nch
        strtmp='%s %6d %6d %s %6d %6d %6d %.6f %s' % ('BANK 1', n, nch, 'RALF', int(TOF[0])*32, step*32, int(TOF[istart])*32, res, 'FXYE')

    if iformat ==3:
        nrec = 1
        nch = n
        strtmp='%s %6d %6d %s %6d %.6f %6d %d %s' % ('BANK 1', n, nch, 'SLOG', int(TOF[0]), res, int(TOF[n-1]), 0, 'FXYE')

    file_gsas.write('%-80s%s' % (strtmp,CRLF))

    # write data
    for i in range(nch):
        for j in range(nrec):
            if i*nrec+j==0:
                tof = TOF[0]
            else:
                tof = (TOF[i*nrec+j]+TOF[i*nrec+j-1])*0.5

            if iformat ==1:
                strtmp='%7d%8d%5d' % (tof*32, int(mul*YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])), int(mul*YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])))
            elif iformat ==2:
                #strtmp='%15.6f %15.6f %15.6f' % (tof, YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j]), YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j]))
                strtmp='%15.6f %d %d' % (tof, int(mul*YINT[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])), int(mul*YESD[i*nrec+j]*(TOF[i*nrec+j+1]-TOF[i*nrec+j])))
            else:
                strtmp='%8d %15.5f %15.5f' % (tof, YINT[i*nrec+j], YESD[i*nrec+j])
            
            file_gsas.write('%s' % strtmp)

        file_gsas.write('%s' % CRLF) 


    print 'Histogram for GSAS:       '+f_gsas

#runNo='RUN0000319'
#WriteGSA(runNo)
