#!/usr/bin/python
# -*- coding: utf-8 -*-

'''
Created on 2018.3.7
LILI YAN
'''
from multiprocessing import Pool
from conf.constants import *
import json
import atexit
import xml.etree.ElementTree as ET
from xml.dom import minidom
from canvas import *
import reduction
import WriteGSA
import WriteFP
from multiprocessing import Pool
import subprocess

class mywindow(QtGui.QMainWindow):

    def __init__(self, parent):
        super(mywindow, self).__init__()
        self.parent = parent
        self.setupUi(self)
        print "1"

    def setupUi(self, MainWindow):
        _loadWidth=80
        _fileWidth=250

        self.first = QtGui.QFrame(self)
        self.first.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea = QtGui.QScrollArea()
        self.scrollArea.setWidgetResizable(True)
        self.scrollArea.setWidget(self.first)

        self.second = QtGui.QFrame(self)
        self.second.setFrameShape(QtGui.QFrame.StyledPanel)
        self.scrollArea2 = QtGui.QScrollArea()
        self.scrollArea2.setWidgetResizable(True)
        self.scrollArea2.setWidget(self.second)

        self.splitter = QtGui.QSplitter(QtCore.Qt.Horizontal, self)
        self.splitter.addWidget(self.scrollArea)
        self.splitter.addWidget(self.scrollArea2)
        self.splitter.setSizes([600, 500])

        self.firstGrid = QtGui.QGridLayout(self.first)
        self.secondGrid = QtGui.QGridLayout(self.second)

        self.settingText = QtGui.QLabel('Settings: ',self.first)

        self.okButton = QtGui.QPushButton('Do Reduction')
        self.okButton.setMaximumHeight(30)
        self.okButton.setMaximumWidth(_fileWidth)
        self.okButton.clicked.connect(self.startReduction)

        self.defaultButton = QtGui.QPushButton('Default')
        self.defaultButton.setMaximumHeight(30)
        self.defaultButton.setMaximumWidth(_fileWidth)
        self.defaultButton.clicked.connect(self.setDefault)

        self.loadButton = QtGui.QPushButton('Load')
        self.loadButton.setMaximumHeight(30)
        self.loadButton.setMaximumWidth(_fileWidth)
        self.loadButton.clicked.connect(self.loadSetting)

        self.logo = QtGui.QLabel(self.first)
        self.logo.setPixmap(QtGui.QPixmap("img/csns.png").scaledToHeight(64))

        self.line1=QtGui.QFrame(self.first)
        self.line1.setGeometry(QtCore.QRect())
        self.line1.setFrameShape(QtGui.QFrame.HLine)
        self.line1.setFrameShadow(QtGui.QFrame.Sunken)

        self.line2=QtGui.QFrame(self.first)
        self.line2.setGeometry(QtCore.QRect())
        self.line2.setFrameShape(QtGui.QFrame.HLine)
        self.line2.setFrameShadow(QtGui.QFrame.Sunken)

        self.line3=QtGui.QFrame(self.first)
        self.line3.setGeometry(QtCore.QRect())
        self.line3.setFrameShape(QtGui.QFrame.HLine)
        self.line3.setFrameShadow(QtGui.QFrame.Sunken)

        self.bankCombo = QtGui.QComboBox()
        self.bankCombo.addItem('Backward Bank')
        self.bankCombo.addItem('Middle Bank')
        self.bankCombo.addItem('Low Bank')
        self.bankCombo.setMaximumWidth(150)
        self.bankCombo.setCurrentIndex(1)
        self.bankCombo.activated.connect(self.bankComboChange)

        self.moduleCombo = QtGui.QComboBox()
        self.moduleCombo.addItem('322')
        self.moduleCombo.addItem('331')
        self.moduleCombo.addItem('332')
        self.moduleCombo.addItem('333')
        self.moduleCombo.addItem('341')
        self.moduleCombo.addItem('342')
        self.moduleCombo.addItem('343')
        self.moduleCombo.addItem('422')
        self.moduleCombo.addItem('431')
        self.moduleCombo.addItem('432')
        self.moduleCombo.addItem('433')
        self.moduleCombo.addItem('441')
        self.moduleCombo.addItem('442')
        self.moduleCombo.addItem('443')
        self.moduleCombo.addItem('ALL') 
        self.moduleCombo.setMaximumWidth(150)
        
        self.sample = QtGui.QLabel('Sample Run:',self.first)
        self.sample.setMaximumHeight(30)
        self.sampleText = QtGui.QTextEdit('') 
        self.sampleText.setMaximumHeight(31)
        self.sampleLoad = QtGui.QPushButton('Load') 
        self.sampleLoad.setMaximumHeight(30)
        self.sampleLoad.setMaximumWidth(_loadWidth)
        self.sampleLoad.clicked.connect(self.sampleLoadFile)

        self.vanadium = QtGui.QLabel('Vanadium Run:',self.first)
        self.vanadium.setMaximumHeight(30)
        self.vanadiumText = QtGui.QTextEdit('') 
        self.vanadiumText.setMaximumHeight(31)
        self.vanadiumLoad = QtGui.QPushButton('Load') 
        self.vanadiumLoad.setMaximumHeight(30)
        self.vanadiumLoad.setMaximumWidth(_loadWidth)
        self.vanadiumLoad.clicked.connect(self.vanadiumLoadFile)

        self.holdCheck = QtGui.QCheckBox('', self)
        self.holdCheck.stateChanged.connect(self.holdCheckChange)
        self.holdCheck.setChecked(True)
        self.hold = QtGui.QLabel('Holder Run:',self.first)
        self.hold.setMaximumHeight(30)
        self.holdText = QtGui.QTextEdit('') 
        self.holdText.setMaximumHeight(31)
        self.holdLoad = QtGui.QPushButton('Load') 
        self.holdLoad.setMaximumHeight(30)
        self.holdLoad.setMaximumWidth(_loadWidth)
        self.holdLoad.clicked.connect(self.holdLoadFile)

        self.volume = QtGui.QLabel('Volume:',self.first)
        self.volume.setMaximumHeight(30)
        self.volumeText = QtGui.QTextEdit('2.01') 
        self.volumeText.setMaximumHeight(31)

        self.mass = QtGui.QLabel('Mass:',self.first)
        self.mass.setMaximumHeight(30)
        self.massText = QtGui.QTextEdit('10.69') 
        self.massText.setMaximumHeight(31)

        self.emptyCheck = QtGui.QCheckBox('', self)
        self.emptyCheck.stateChanged.connect(self.emptyCheckChange)
        self.empty = QtGui.QLabel('Empty Run:',self.first)
        self.empty.setMaximumHeight(30)
        self.emptyText = QtGui.QTextEdit('') 
        self.emptyText.setMaximumHeight(31)
        self.emptyLoad = QtGui.QPushButton('Load') 
        self.emptyLoad.setMaximumHeight(30)
        self.emptyLoad.setMaximumWidth(_loadWidth)
        self.emptyLoad.clicked.connect(self.emptyLoadFile)

        self.timeF = QtGui.QLabel('TimeFocusing:',self.first)
        self.timeF.setMaximumHeight(30)
        self.timeFText = QtGui.QTextEdit('') 
        self.timeFText.setMaximumHeight(31)
        self.timeFLoad = QtGui.QPushButton('Load') 
        self.timeFLoad.setMaximumHeight(30)
        self.timeFLoad.setMaximumWidth(_loadWidth)
        self.timeFLoad.clicked.connect(self.timeFLoadFile)

        self.absorptionCheck = QtGui.QCheckBox('Absorption', self)
        self.absorptionCheck.setChecked(True)
        self.absorptionCheck.stateChanged.connect(self.absorptionCheckChange)
        self.multipleSCheck = QtGui.QCheckBox('Multiple_scatterimg', self)
        self.multipleSCheck.stateChanged.connect(self.multipleSCheckChange)
        self.multipleSCheck.setChecked(True)

        self.maxWave = QtGui.QLabel('Max',self.first)
        self.maxWave.setMaximumHeight(30)
        self.minWave = QtGui.QLabel('Min',self.first)
        self.minWave.setMaximumHeight(30)
        
        self.wavelength = QtGui.QLabel('Wavelength:',self.first)
        self.wavelengthMinText = QtGui.QTextEdit('0.7') 
        self.wavelengthMinText.setMaximumHeight(31)
        self.wavelengthMaxText = QtGui.QTextEdit('4.6') 
        self.wavelengthMaxText.setMaximumHeight(31)
        self.d = QtGui.QLabel('d-spacing:',self.first)
        self.dMinText = QtGui.QTextEdit('0.45') 
        self.dMinText.setMaximumHeight(31)
        self.dMaxText = QtGui.QTextEdit('4.2') 
        self.dMaxText.setMaximumHeight(31)

        self.dateLabel = QtGui.QLabel('Output:',self.first)
        self.gsaCheck = QtGui.QCheckBox('.gsa', self)
        self.fpCheck = QtGui.QCheckBox('.dat', self)
        self.gsaCheck.setChecked(True)

        self.comboBox = QtGui.QComboBox()
        self.comboBox.addItem('sample_raw')
        self.comboBox.addItem('vanadium_raw')
        self.comboBox.addItem('hold_raw')
        self.comboBox.addItem('sample_substract_hold')
        self.comboBox.addItem('vanadium_substract_hold')
        self.comboBox.addItem('sample_final')
        self.comboBox.setMaximumWidth(150)
        self.comboBox.activated.connect(self.comboBoxChange)

        self.canvas = figureCanvas(
            self,
            16,
            8,
            150,
            '',
            '',
            '',
            '',
            )

        _nline = 0
        self.firstGrid.addWidget(self.logo, _nline, 0, 1, 4, QtCore.Qt.AlignCenter)

        _nline+=1
        self.firstGrid.addWidget(self.settingText, _nline, 1, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.defaultButton, _nline, 2, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.loadButton, _nline, 3, 1,1 , QtCore.Qt.AlignLeft)
        self.firstGrid.addWidget(self.okButton, _nline, 4, 1,2 , QtCore.Qt.AlignCenter)

        _nline+=1
        self.firstGrid.addWidget(self.line1, _nline, 0, 1, 5)

        _nline+=1
        self.firstGrid.addWidget(self.bankCombo, _nline, 0, 1, 2)
        self.firstGrid.addWidget(self.moduleCombo, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.sample, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.sampleText, _nline, 2, 1, 1)
        #self.firstGrid.addWidget(self.sampleLoad, _nline, 3, 1, 1)
        
        _nline += 1
        self.firstGrid.addWidget(self.vanadium, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.vanadiumText, _nline, 2, 1, 1)
        #self.firstGrid.addWidget(self.vanadiumLoad, _nline, 3, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.holdCheck, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.hold, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.holdText, _nline, 2, 1, 1)
        #self.firstGrid.addWidget(self.holdLoad, _nline, 3, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.emptyCheck, _nline, 0, 1, 1)
        self.firstGrid.addWidget(self.empty, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.emptyText, _nline, 2, 1, 1)
        #self.firstGrid.addWidget(self.emptyLoad, _nline, 3, 1, 1)
       
        _nline+=1
        self.firstGrid.addWidget(self.line2, _nline, 0, 1, 5)
        
        _nline += 1
        self.firstGrid.addWidget(self.timeF, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.timeFText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.timeFLoad, _nline, 3, 1, 1)
         
        _nline += 1
        self.firstGrid.addWidget(self.volume, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.volumeText, _nline, 2, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.mass, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.massText, _nline, 2, 1, 1)
        
        _nline += 1
        self.firstGrid.addWidget(self.absorptionCheck, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.multipleSCheck, _nline, 3, 1, 1)

        _nline+=1
        self.firstGrid.addWidget(self.line3, _nline, 0, 1, 5)
        
        _nline += 1
        self.firstGrid.addWidget(self.minWave, _nline, 2, 1, 1, QtCore.Qt.AlignCenter)
        self.firstGrid.addWidget(self.maxWave, _nline, 3, 1, 1, QtCore.Qt.AlignCenter)
        
        _nline += 1
        self.firstGrid.addWidget(self.wavelength, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.wavelengthMaxText, _nline, 3, 1, 1)

        _nline += 1
        self.firstGrid.addWidget(self.d, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.dMinText, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.dMaxText, _nline, 3, 1, 1)
        _nline += 1
        self.firstGrid.addWidget(self.dateLabel, _nline, 1, 1, 1)
        self.firstGrid.addWidget(self.gsaCheck, _nline, 2, 1, 1)
        self.firstGrid.addWidget(self.fpCheck, _nline, 3, 1, 1)
         
        _nline = 0
        self.secondGrid.addWidget(self.comboBox, _nline, 0, 1, 1, QtCore.Qt.AlignCenter )
        _nline += 1
        self.secondGrid.addWidget(self.canvas, _nline, 0, 1, 1, QtCore.Qt.AlignCenter)

        self.setCentralWidget(self.splitter)
        self.loadConfigure()

        #self.comboBoxChange()

    def setDefault(self):
        self.bankCombo.setCurrentIndex(1)
        self.volumeText.setText('2.01')
        self.massText.setText('10.69')
        self.wavelengthMinText.setText('0.7')
        self.wavelengthMaxText.setText('4.6')
        self.dMinText.setText('0.45')
        self.dMaxText.setText('4.2')
        self.absorptionCheck.setChecked(True)
        self.multipleSCheck.setChecked(True)
        self.holdCheck.setChecked(True)
        self.emptyCheck.setChecked(False)        

    def loadSetting(self):
        fileName=QtGui.QFileDialog.getOpenFileNames(self, 'load Setting', './*.xml')
        configure = self.readXml(fileName[0])
        self.setSetting(configure)        

    def setModuleIndex(self, bankIndex, module):
        self.bankComboChange()
        lowModule = ['131','132','133','231','232','233','ALL']
        middleModule = ['322','331','332','333','341','342','343','422','431','432','433','441','442','443','ALL']
        backwardModule = ['521','522','523','531','532','533','541','542','543','621','622','623','631','632','633','641','642','643','ALL']
        if bankIndex == 0:
            _index = backwardModule.index(module)
        elif bankIndex == 1:
            _index = middleModule.index(module)
        elif bankIndex == 2:
            _index = lowModule.index(module)
        self.moduleCombo.setCurrentIndex(_index)

    def setSetting(self, configure):
        bankIndex = int(configure['Bank'])
        self.bankCombo.setCurrentIndex(bankIndex)

        module = str(configure['Module'])
        self.setModuleIndex(bankIndex, module)

        try:
            #self.sampleText.setText(self.getFilePath(configure['Sample_det']))
            self.sampleText.setText(self.getFilePath(configure['Sample_det'])[-3:])
        except:
            pass
        try:
            self.vanadiumText.setText(self.getFilePath(configure['Vanadium_det'])[-3:])
        except:
            pass
        try: 
            self.holdText.setText(self.getFilePath(configure['Hold_det'])[-3:])
        except:
            pass
        try:
            self.emptyText.setText(self.getFilePath(configure['Empty_det'])[-3:])
        except:
            pass
        self.timeFText.setText(configure['TF'])
        self.volumeText.setText(configure['Volume'])
        self.massText.setText(configure['Mass'])
        self.wavelengthMinText.setText(configure['wmin'])
        self.wavelengthMaxText.setText(configure['wmax'])
        self.dMinText.setText(configure['dmin'])
        self.dMaxText.setText(configure['dmax'])
        if configure['Absorption']=='0':
            self.absorptionCheck.setChecked(False)
        else:
            self.absorptionCheck.setChecked(True)
        if configure['Multiple_scattering']=='0':
            self.multipleSCheck.setChecked(False)
        else:
            self.multipleSCheck.setChecked(True)

        if configure['Hold_check']=='1':
            self.holdCheck.setChecked(True)
        else:
            self.holdCheck.setChecked(False)

        if configure['Empty_check']=='1':
            self.emptyCheck.setChecked(True)
        else:
            self.emptyCheck.setChecked(False)

    def readXml(self, filename):
        tree = ET.parse(filename)
        root = tree.getroot()

        configure={}        

        _tmp = root.findall('Bank')[0].text
        configure['Bank']=_tmp

        _tmp = root.findall('Module')[0].text
        configure['Module']=_tmp

        _tmp = root.findall('Sample_det')[0].text
        configure['Sample_det']=_tmp
        _tmp = root.findall('Sample_mon')[0].text
        configure['Sample_mon']=_tmp
            
        _tmp = root.findall('Vanadium_det')[0].text
        configure['Vanadium_det']=_tmp
        _tmp = root.findall('Vanadium_mon')[0].text
        configure['Vanadium_mon']=_tmp

        _tmp = root.findall('Hold_det')[0].text
        configure['Hold_det']=_tmp
        _tmp = root.findall('Hold_mon')[0].text
        configure['Hold_mon']=_tmp
            
        _tmp = root.findall('Empty_det')[0].text
        configure['Empty_det']=_tmp
        _tmp = root.findall('Empty_mon')[0].text
        configure['Empty_mon']=_tmp
        
        _tmp = root.findall('Hold_check')[0].text
        configure['Hold_check']=_tmp
        
        _tmp = root.findall('Empty_check')[0].text
        configure['Empty_check']=_tmp
        
        _tmp = root.findall('TF')[0].text
        configure['TF']=_tmp
        
        _tmp = root.findall('Volume')[0].text
        configure['Volume']=_tmp
        
        _tmp = root.findall('Mass')[0].text
        configure['Mass']=_tmp
        
        _tmp = root.findall('wmin')[0].text
        configure['wmin']=_tmp
        
        _tmp = root.findall('wmax')[0].text
        configure['wmax']=_tmp
        
        _tmp = root.findall('dmin')[0].text
        configure['dmin']=_tmp
        
        _tmp = root.findall('dmax')[0].text
        configure['dmax']=_tmp
        
        _tmp = root.findall('Absorption')[0].text
        configure['Absorption']=_tmp
        
        _tmp = root.findall('Multiple_scattering')[0].text
        configure['Multiple_scattering']=_tmp

        return configure

    def getFilePath(self, _file):
        _path=""
        try:
            _path=os.path.dirname(_file)
        except:
            _path=""

        return _path

    def sampleLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.sampleText.setText(fileName)

    def vanadiumLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.vanadiumText.setText(fileName)

    def holdLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.holdText.setText(fileName)

    def hold2LoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.hold2Text.setText(fileName)

    def emptyLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.emptyText.setText(fileName)

    def empty2LoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.empty2Text.setText(fileName)

    def timeFLoadFile(self):
        fileName = QtGui.QFileDialog.getExistingDirectory(self, 'path', './',  QtGui.QFileDialog.ShowDirsOnly | QtGui.QFileDialog.DontResolveSymlinks)
        self.timeFText.setText(fileName)

    def holdCheckChange(self):
        if self.holdCheck.isChecked():
            self.hold = True
        else:
            self.hold = False

    def emptyCheckChange(self):
        if self.emptyCheck.isChecked():
            self.empty = True
        else:
            self.empty = False

    def absorptionCheckChange(self):
        if self.absorptionCheck.isChecked():
            self.absorption = '1'
        else:
            self.absorption = '0'

    def multipleSCheckChange(self):
        if self.multipleSCheck.isChecked():
            self.multipleS = '1'
        else:
            self.multipleS = '0'

    def startReduction(self):
        _runNo = self.sampleText.toPlainText()
        runNo = 'RUN'+str(_runNo).zfill(7)
        _path = '/home/dur/work/nexusData/GPPD/'
        self.samplePath = _path + runNo
        
        if self.vanadiumText.toPlainText() == '':
            self.vanadiumPath = ''
        else: 
            self.vanadiumPath = _path + 'RUN' + str(self.vanadiumText.toPlainText()).zfill(7)
        if self.holdText.toPlainText() == '':
            self.holdPath = ''
        else: 
            self.holdPath = _path + 'RUN' + str(self.holdText.toPlainText()).zfill(7)
        if self.emptyText.toPlainText() == '':
            self.emptyPath = ''
        else: 
            self.emptyPath = _path + 'RUN' + str(self.emptyText.toPlainText()).zfill(7)

        configure = self.getSetting()
        self.writeXml(configure)
        self.comboBox.setCurrentIndex(-1)
        _result = self.checkValue()
        if _result:
            self.deleteData()
            self.canvas.ax.clear()
            self.canvas.draw()
            reduction.Reduction()
        
        if self.gsaCheck.isChecked():
            WriteGSA.WriteGSA(runNo)

        if self.fpCheck.isChecked():
            WriteFP.WriteFP(runNo)

    def deleteData(self):
        _tmp="rm -rf /home/dur/GPPDoffline/*.dat"
        try:
            subprocess.check_output(_tmp, shell=True)
        except:
            pass

    def checkValue(self):
        _result = False
        if self.sampleText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Sample Run can not be empty.", QtGui.QMessageBox.Yes)
        elif self.volumeText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Volume Run can not be empty.", QtGui.QMessageBox.Yes)
        elif self.massText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Mass can not be empty.", QtGui.QMessageBox.Yes)
        elif self.hold == True:
            if self.holdText.toPlainText() == '':
                msgBox = QtGui.QMessageBox.information(self,"Warning","Hold can not be empty.", QtGui.QMessageBox.Yes)
        elif self.wavelengthMinText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Wavelength Min can not be empty.", QtGui.QMessageBox.Yes)
        elif self.wavelengthMaxText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","Wavelength Max can not be empty.", QtGui.QMessageBox.Yes)
        elif self.dMinText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","d-spacing Min can not be empty.", QtGui.QMessageBox.Yes)
        elif self.dMaxText.toPlainText() == '':
            msgBox = QtGui.QMessageBox.information(self,"Warning","d-spacing Max can not be empty.", QtGui.QMessageBox.Yes)
        else:
            _result = True
        return _result

    def getSetting(self):
        configure = {}
        index = self.bankCombo.currentIndex()
        _text = self.moduleCombo.currentText()

        configure['Bank']=str(index)
        configure['Module']=str(_text)

        _tmp=str(self.samplePath)
        if _tmp!="":
            configure['Sample_det'] = _tmp + '/bank' + str(index +1) +'.nxs'
            configure['Sample_mon'] = _tmp + '/monitor2.nxs'
        else:
            configure['Sample_det'] = ''
            configure['Sample_mon'] = ''
            
        _tmp=str(self.vanadiumPath)
        if _tmp!="":
            configure['Vanadium_det'] = _tmp + '/bank' + str(index +1) +'.nxs'
            configure['Vanadium_mon'] = _tmp + '/monitor2.nxs'
        else:
            configure['Vanadium_det'] = ''
            configure['Vanadium_mon'] = ''

        _tmp=str(self.holdPath)
        if _tmp!="":
            configure['Hold_det'] = _tmp + '/bank' + str(index +1) +'.nxs'
            configure['Hold_mon'] = _tmp + '/monitor2.nxs'
        else:
            configure['Hold_det'] = ''
            configure['Hold_mon'] = ''

        configure['Volume'] = str(self.volumeText.toPlainText())
        configure['Mass'] = str(self.massText.toPlainText())
       
        _tmp=str(self.emptyPath) 
        if _tmp!="":
            configure['Empty_det'] = _tmp + '/bank' + str(index +1) +'.nxs'
            configure['Empty_mon'] = _tmp + '/monitor2.nxs'
        else:
            configure['Empty_det'] = ''
            configure['Empty_mon'] = ''
        
        configure['TF'] = str(self.timeFText.toPlainText())

        if self.absorptionCheck.isChecked():
            configure['Absorption'] = '1'
        else:
            configure['Absorption'] = '0'

        if self.multipleSCheck.isChecked():
            configure['Multiple_scattering'] = '1'
        else:
            configure['Multiple_scattering'] = '0'
      
        if self.holdCheck.isChecked():
            configure['Hold_check'] = '1'
        else:
            configure['Hold_check'] = '0'
        if self.emptyCheck.isChecked():
            configure['Empty_check'] = '1'
        else:
            configure['Empty_check'] = '0'
 
        configure['wmin']=self.wavelengthMinText.toPlainText()
        configure['wmax']=self.wavelengthMaxText.toPlainText()
        configure['dmin']=self.dMinText.toPlainText()
        configure['dmax']=self.dMaxText.toPlainText()

        return configure

    def writeXml(self, configure):
        top = ET.Element('root')

        child = ET.SubElement(top, 'Bank')
        child.text=configure['Bank']

        child = ET.SubElement(top, 'Module')
        child.text=configure['Module']

        child = ET.SubElement(top, 'Sample_det')
        child.text=configure['Sample_det']
        child = ET.SubElement(top, 'Sample_mon')
        child.text=configure['Sample_mon']
        child = ET.SubElement(top, 'Vanadium_det')
        child.text=configure['Vanadium_det']
        child = ET.SubElement(top, 'Vanadium_mon')
        child.text=configure['Vanadium_mon']
        child = ET.SubElement(top, 'Hold_det')
        child.text=configure['Hold_det']
        child = ET.SubElement(top, 'Hold_mon')
        child.text=configure['Hold_mon']
        child = ET.SubElement(top, 'Volume')
        child.text=configure['Volume']
        child = ET.SubElement(top, 'Mass')
        child.text=configure['Mass']
        child = ET.SubElement(top, 'Empty_det')
        child.text=configure['Empty_det']
        child = ET.SubElement(top, 'Empty_mon')
        child.text=configure['Empty_mon']
        child = ET.SubElement(top, 'Hold_check')
        child.text=configure['Hold_check']
        child = ET.SubElement(top, 'Empty_check')
        child.text=configure['Empty_check']
        child = ET.SubElement(top, 'TF')
        child.text=configure['TF']

        child = ET.SubElement(top, 'wmin')
        child.text=configure['wmin']
        child = ET.SubElement(top, 'wmax')
        child.text=configure['wmax']
        child = ET.SubElement(top, 'dmin')
        child.text=configure['dmin']
        child = ET.SubElement(top, 'dmax')
        child.text=configure['dmax']
        child = ET.SubElement(top, 'Absorption')
        child.text=configure['Absorption']
        child = ET.SubElement(top, 'Multiple_scattering')
        child.text=configure['Multiple_scattering']
     
        xmlstr = minidom.parseString(ET.tostring(top)).toprettyxml(indent="   ")
        with open("./configure.xml", "w") as f:
            f.write(xmlstr)

    def bankComboChange(self):
        index = self.bankCombo.currentIndex()
        if index == 2:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('131') 
            self.moduleCombo.addItem('132') 
            self.moduleCombo.addItem('133') 
            self.moduleCombo.addItem('231') 
            self.moduleCombo.addItem('232') 
            self.moduleCombo.addItem('233') 
            self.moduleCombo.addItem('ALL') 
        elif index == 1:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('322')
            self.moduleCombo.addItem('331')
            self.moduleCombo.addItem('332')
            self.moduleCombo.addItem('333')
            self.moduleCombo.addItem('341')
            self.moduleCombo.addItem('342')
            self.moduleCombo.addItem('343')
            self.moduleCombo.addItem('422')
            self.moduleCombo.addItem('431')
            self.moduleCombo.addItem('432')
            self.moduleCombo.addItem('433')
            self.moduleCombo.addItem('441')
            self.moduleCombo.addItem('442')
            self.moduleCombo.addItem('443')
            self.moduleCombo.addItem('ALL') 
        elif index == 0:
            numItem = self.moduleCombo.count()
            for i in range(numItem):
                self.moduleCombo.removeItem(numItem-i)
            self.moduleCombo.removeItem(0)
            self.moduleCombo.addItem('521')
            self.moduleCombo.addItem('522')
            self.moduleCombo.addItem('523')
            self.moduleCombo.addItem('531')
            self.moduleCombo.addItem('532')
            self.moduleCombo.addItem('533')
            self.moduleCombo.addItem('541')
            self.moduleCombo.addItem('542')
            self.moduleCombo.addItem('543')
            self.moduleCombo.addItem('621')
            self.moduleCombo.addItem('622')
            self.moduleCombo.addItem('623')
            self.moduleCombo.addItem('631')
            self.moduleCombo.addItem('632')
            self.moduleCombo.addItem('633')
            self.moduleCombo.addItem('641')
            self.moduleCombo.addItem('642')
            self.moduleCombo.addItem('643')
            self.moduleCombo.addItem('ALL') 
        else:
            pass

    def comboBoxChange(self):
        index = self.comboBox.currentIndex()
        if index == 0:
            _filename = './sam_raw.dat'
        elif index == 1:
            _filename = './v_raw.dat' 
        elif index == 2:
            _filename = './hold_raw.dat'
        elif index == 3:
            _filename = './sam_hold.dat'
        elif index == 4:
            _filename = './v_hold.dat'
        elif index == 5:
            _filename = './sam_Itof.dat'

        try:
            _x, _y = self.readData(_filename)
        except:
            pass
        try:
            self.updateCanvas(_x, _y)
        except:
            pass

    def readData(self, filename):
        _x=[]
        _y=[]
        f=open(filename, "rb")
        for line in f.readlines()[2:]:
            value=line.split(',')
            try:
                _x.append(float(value[0]))
                _y.append(float(value[1]))
            except:
                pass
        f.close()
        return _x, _y

    def updateCanvas(
        self,
        x,
        y,
        ):
        if len(y) == 0 or len(x) \
            != len(y):
            pass
        else:
            self.canvas.ax.clear()
            self.pix1 = \
                self.canvas.ax.plot(x, y)
            
            self.canvas.draw()

    def getDisplay(self):
        screen_resolution = self.parent.desktop().screenGeometry()
        return screen_resolution.width(), screen_resolution.height()

    def loadConfigure(self):
        _confFile='./conf/configure.json'
        _mainWidth, _mainHeight=self.getDisplay()

        if not os.path.exists(_confFile):
            self.mainWidth=_mainWidth
            self.mainHeight=_mainHeight
        else:
            try:
                layoutParameter = json.loads(open(_confFile, "r").read())
                self.mainWidth=layoutParameter['mainWidth']
                self.mainHeight=layoutParameter['mainHeight']
            except:
                self.mainWidth=_mainWidth
                self.mainHeight=_mainHeight

        self.resize(self.mainWidth, self.mainHeight)

    def saveConfigure(self):
        _mainWidth=self.splitter.geometry().width()
        _mainHeight=self.splitter.geometry().height()

        _data = {"mainWidth": _mainWidth, "mainHeight": _mainHeight}
        
        _confFile='./conf/configure.json'
        if not os.path.exists(_confFile):
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
        else:
            with open(_confFile, "w") as _f:
                json.dump(_data, _f)
  
def exit_handler(top):
    top.saveConfigure()

if __name__ == '__main__':
    
    myapp = QtGui.QApplication(sys.argv)
    
    mytop = mywindow(myapp)
    mytop.setWindowTitle('GPPD Data Reduction v0.2')
    mytop.show()

    atexit.register(exit_handler, mytop)
    sys.exit(myapp.exec_())
