#!/usr/bin/python
import subprocess
import sys
import os
import glob
import re
import time
import threading
from xml.etree import ElementTree as ET

def parseDaq(prepath, runno, moduleList):
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/"+runno+"/"
    #print rawpath
    try:
        xmllist=glob.glob(os.path.join(rawpath, '*.xml'))
        xmlfile=xmllist[0]
        root = ET.parse(xmlfile)
        judge=True
    except:
        judge=False

    if judge:
        for name in moduleList:
            _cmd="python binary_hist.py "+runno+" "+name+" "+prepath+" &"
            subprocess.check_call(_cmd, shell=True)
        for name in moduleList:
            while not os.path.exists(prepath+"/"+runno+"/tmpData/hist_"+name+'.dat'):
                print "no hist_module data!"
                time.sleep(5)
            print name, "exists!"
    else:
        print 'error in parse daq! ', runno

def recAlg(runno,prepath,delay):
    tofstart, tofbin, tofstep = getTOFinfo(delay)
    #_cmd="./main.exe "+runno+" "+prepath+" "+str(tofstart)+" "+str(tofbin)+" "+str(tofstep)
    _cmd="./main.exe "+runno+" "+str(tofstart)+" "+str(tofbin)+" "+str(tofstep)
    subprocess.check_call(_cmd, shell=True)
    while not os.path.exists(prepath+"/"+runno+"/complete.dat"):
        print "no data"
        time.sleep(5)
    print "finish rec nexus! "


def getTOFinfo(delay):
    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof  = root.find('tofInformation')
    tofstart= int(tof.attrib['tofstart'])+int(delay)
    tofstep = int(tof.attrib['tofstep'])
    tofbin = int(tof.attrib['tofbin'])+1
    return tofstart, tofbin, tofstep

def createNexus(runNo, delay):
    be=time.time()
    runno="RUN"+str(runNo).zfill(7)
    prepath=sys.path[0]
    if os.path.exists(prepath+"/"+runno):
        pass
    else:
        os.mkdir(prepath+"/"+runno)
    
    tmp=prepath+'/'+runno+'/tmpData'
    if os.path.exists(tmp):
        _cmd="rm -rf "+prepath+"/tmpData/*"
        #subprocess.check_call(_cmd, shell=True)
    else:
        os.mkdir(tmp)
    #moduleList=['module131']
    moduleList=['module521', 'module522', 'module523', 'module531', 'module532', 'module533', 'module541', 'module542', 'module543','module621', 'module622', 'module623', 'module631', 'module632', 'module633', 'module641', 'module642', 'module643','module322', 'module331', 'module332', 'module333', 'module341', 'module342', 'module343','module422', 'module431', 'module432', 'module433', 'module441', 'module442', 'module443','module131', 'module132', 'module133','module231', 'module232', 'module233']
    
    rawpath="/opt/CSNSDATA/TS1/BL18/DAQ/"+runno
    xmlfile=glob.glob(os.path.join(rawpath, '*.xml'))
    if len(xmlfile)==0:
        print "no data in ",runno, " for DAQ"
    else:
        parseDaq(prepath, runno, moduleList)
        print "finish parse daq: ",time.time()-be, "seconds!!!"
        be=time.time()
        #try:
        recAlg(runno,prepath,delay)
        print "finish rec nexus: ",time.time()-be, "seconds!!!"
        print 'finish save nexus for ',runno," ",time.strftime('%Y-%m-%dT%H:%M:%S.%03d+08:00')
        _cmd="rm -rf "+prepath+"/"+runno+"/complete.dat"
        subprocess.check_call(_cmd, shell=True)
        #except:
        #    print 'can not rec data'

        _cmd="rm -rf "+prepath+"/"+runno+"/tmpData"
        subprocess.check_call(_cmd, shell=True)
        
        f=open("./database/"+runno, "w")
        f.close()

        try:
            f=open("complete", "w")
            f.close()
        except:
            pass
        _cmd = 'scp -r '+runno+' transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL18/'
        subprocess.check_call(_cmd, shell=True)

        _cmd = 'scp complete  transfer@10.1.26.157:/home/transfer/nexus/CSNSDATA/TS1/BL18/'+runno
        subprocess.check_call(_cmd, shell=True)

if __name__=="__main__":
    runList=[]
    #for i in range(34):
    #    runList.append(str(466+i)) 
    runList=['544','545','546','547','548']
    for runNo in runList:
        #runNo = '454'
        delay = 8000
        #_b=time.time()
        print "begin:", runNo
        createNexus(runNo, delay)


