//#include "MantidAPI/FileProperty.h"
//#include "MantidAPI/MatrixWorkspace.h"
//#include "MantidAPI/RegisterFileLoader.h"
//#include "MantidDataHandling/LoadEventNexus.h"
//#include "MantidDataHandling/ReadCSNSNexus.h"
#include "../inc/MantidDataHandling/ReadCSNSNexus.h"
//#include "MantidKernel/ArrayProperty.h"
//#include "MantidKernel/BoundedValidator.h"
//#include "MantidKernel/cow_ptr.h"
//#include <nexus/NeXusFile.hpp>
//#include <boost/algorithm/string/detail/classification.hpp>
//#include <boost/algorithm/string/split.hpp>

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <vector>
#include <map>

using std::cout;
using std::endl;
using std::map;
using std::multimap;
using std::string;
using std::vector;

ReadCSNSNexus::ReadCSNSNexus(){}

//-------------------------------------------------------------------------------------------------
void ReadCSNSNexus::init() {}

void ReadCSNSNexus::loadBank(const std::string &nexusfilename,
                               const std::string &entry_name,
                               const std::string &bankName
                               ) {
}

//-------------------------------------------------------------------------------------------------
//mantid::std::string NexusDescriptor::pathOfType(const std::string &type)
/*
bool ReadCSNSNexus::pathOfTypeExists(const std::string &path,
                                       const std::string &type) const {
  auto it = m_pathsToTypes.find(path);
  if (it != m_pathsToTypes.end()) {
    return (it->second == type);
  } else
    return false;
}
*/
//-------------------------------------------------------------------------------------------------
/*
int LoadCSNSNexus::confidence() const {
  int confidence(0); 
  if (descriptor.pathOfTypeExists("/entry", "NXentry") ||
      descriptor.pathOfTypeExists("/entry-state0", "NXentry")) {
    const bool hasEventData = descriptor.classTypeExists("NXevent_data");
    const bool hasData = descriptor.classTypeExists("NXdata");
    if (hasData && hasEventData)
      // Event data = this is event NXS
      confidence = 20;
    else if (hasData && !hasEventData)
      // No event data = this is the one
      confidence = 80;
    else
      // No data ?
      confidence = 10;
  }
  return confidence;
}
*/
//-------------------------------------------------------------------------------------------------
std::string ReadCSNSNexus::getEntryName(const std::string &filename) {
  std::string entry_name = "entry";
  auto file = new ::NeXus::File(filename);
  std::map<std::string, std::string> entries = file->getEntries();
  file->close();
  delete file;

  if (entries.empty())
    throw std::runtime_error("No entries in the NXS file!");

  if (entries.find(entry_name) == entries.end())
    throw std::runtime_error("Not CSNS NXS file!");
    entry_name = entries.begin()->first;

  return entry_name;
}

//-------------------------------------------------------------------------------------------------
/**
* Return the CSNS NeXus definiton version
* @param[in] filename :: nxs file name
* @return version :: CSNS NeXus definition version 
*/
std::string ReadCSNSNexus::getVersion(const std::string &filename){
  std::string version;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("version") != entries.end()) {
          file->readData("version", version);
          return version;
    }else{
        throw std::runtime_error("No version in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the Org NeXus version
* @param[in] filename :: nxs file name
* @return nexusVersion :: org NeXus version 
*/
std::string ReadCSNSNexus::getNexusVersion(const std::string &filename){
  std::string nexusVersion;

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  if (file->hasAttr("NeXus_version")){
    file->getAttr("NeXus_version", nexusVersion);
    return nexusVersion;
  }else{
    throw std::runtime_error("No Nexus version in the NXS file!");
  }  
}

//-------------------------------------------------------------------------------------------------
/**
* Return the HDF5 version
* @param[in] filename :: nxs file name
* @return hdf5Version :: HDF5 version 
*/
std::string ReadCSNSNexus::getHdf5Version(const std::string &filename){
  std::string hdf5Version;

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  if (file->hasAttr("HDF5_Version")){
    file->getAttr("HDF5_Version", hdf5Version);
    return hdf5Version;
  }else{
    throw std::runtime_error("No HDF5 version in the NXS file!");
  }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument name
* @param[in] filename :: nxs file name
* @return instrument name 
*/
std::string ReadCSNSNexus::getInstrumentName(const std::string &filename){
  std::string instrumentName;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("instrument_name") != entries.end()) {
          file->readData("instrument_name", instrumentName);
          return instrumentName;
    }else{
        throw std::runtime_error("No Instrument Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument beamline
* @param[in] filename :: nxs file name
* @return beamline :: beamline name 
*/
std::string ReadCSNSNexus::getBeamline(const std::string &filename){
  std::string beamline;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("beamline") != entries.end()) {
          file->readData("beamline", beamline);
          return beamline;
    }else{
        throw std::runtime_error("No Beamline Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument No
* @param[in] filename :: nxs file name
* @return beamlineNo :: beamline No 
*/
size_t ReadCSNSNexus::getBeamlineNo(const std::string &filename){
  std::string beamline;
  size_t beamlineNo;

  std::string entry_name = "entry";
    
  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("beamline") != entries.end()) {
          file->readData("beamline", beamline);
          beamlineNo = atoi(beamline.substr(2, 2).c_str()); 
          return beamlineNo;
    }else{
        throw std::runtime_error("No Beamline Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the Run no
* @param[in] filename :: nxs file name
* @return run no 
*/
std::string ReadCSNSNexus::getRunNo(const std::string &filename){
    std::string runNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("run_no") != entries.end()) {
          file->readData("run_no", runNo);
          return runNo;
    }else{
        throw std::runtime_error("No Run No in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the Accelerator Run no
* @param[in] filename :: nxs file name
* @return accelerator run no 
*/
std::string ReadCSNSNexus::getAcceleratorRunNo(const std::string &filename){
    std::string acceleratorRunNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("accelerator_run_no") != entries.end()) {
          file->readData("accelerator_run_no", acceleratorRunNo);
          return acceleratorRunNo;
    }else{
        throw std::runtime_error("No Accelerator Run No in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
/**
* Return the description
* @param[in] filename :: nxs file name
* @return description 
*/
std::string ReadCSNSNexus::getDescription(const std::string &filename){
    std::string description;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("description") != entries.end()) {
          file->readData("description",description);
          return description;
    }else{
        throw std::runtime_error("No description in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
/**
* Return the proposal id
* @param[in] filename :: nxs file name
* @return proposalId 
*/
std::string ReadCSNSNexus::getProposalId(const std::string &filename){
    std::string proposalId;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("proposal_id") != entries.end()) {
          file->readData("proposal_id",proposalId);
          return proposalId;
    }else{
        throw std::runtime_error("No proposal Id in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return if filename changed (true: changed; flase: not changed)
* @param[in] filename :: nxs file name
* @param[out] oldfilename :: original file name
* @return true: changed, flase: not changed
*/
bool ReadCSNSNexus::isFilenameChanged(const std::string &newfilename, std::string &oldfilename){

  // Create the root Nexus class
  auto file = new ::NeXus::File(newfilename);
  if (file->hasAttr("file_name")){
    file->getAttr("file_name", oldfilename);
    if (oldfilename == newfilename){
      return false;
    }else{
      return true;
    }
  }else{
    throw std::runtime_error("No file name in the NXS file!");
  }
}


//-------------------------------------------------------------------------------------------------
/**
* Return the create time of file
* @param[in] filename :: nxs file name
* @return createTime :: create time
*/
std::string ReadCSNSNexus::getCreateTime(const std::string &filename){
  std::string createTime;

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  if (file->hasAttr("file_time")){
    file->getAttr("file_time", createTime);
    return createTime;
  }else{
    throw std::runtime_error("No file create time in the NXS file!");
  }    
}

//-------------------------------------------------------------------------------------------------
/**
* Return the start time of experiment
* @param[in] filename :: nxs file name
* @return startTime :: start time
*/
std::string ReadCSNSNexus::getStartTime(const std::string &filename){
    std::string startTime;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");

    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("start_time") != entries.end()) {
          file->readData("start_time", startTime);
          return startTime;
    }else{
        throw std::runtime_error("No start time in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the end time of experiment
* @param[in] filename :: nxs file name
* @return endTime :: end time
*/
std::string ReadCSNSNexus::getEndTime(const std::string &filename){
    std::string endTime;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    
    std::map<std::string, std::string> entries = file->getEntries();
    
    if (entries.find("end_time") != entries.end()) {
          file->readData("end_time", endTime);
          return endTime;
    }else{
        throw std::runtime_error("No end time in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the pixel number
* @param[in] filename :: nxs file name
* @param[in] entry_name :: nxs file entry name
* @return numPixels 
*/
size_t ReadCSNSNexus::getNumPixels(const std::string &filename, const std::string &entry_name){
    size_t numPixels=0;
    size_t newPixels;

    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    file->openGroup("instrument", "NXinstrument");
    // Look for all the banks
    std::map<std::string, std::string> entries = file->getEntries();
    std::map<std::string, std::string>::iterator it;
    for (it = entries.begin(); it != entries.end(); ++it) {
        std::string name = it->first;

        if (name.substr(0, 4) == "bank") {
         // cout<<"name is:"<<name<<endl; 
         // file->openGroup(name, "NXdetector");
          file->openGroup(name, it->second);
         
          std::map<std::string, std::string> entries = file->getEntries();

          if (entries.find("pixel_id") != entries.end()) {
            file->openData("pixel_id");
    	    std::vector<int64_t> dims = file->getInfo().dims;
            file->closeData();

            if (!dims.empty()) {
              size_t newPixels = 1;
              for (size_t i = 0; i < dims.size(); i++)
                newPixels *= dims[i];
              // cout<<"newPixels is: "<<newPixels<<endl;
              numPixels += newPixels;
            }
             // cout<<"numPixels is:"<<numPixels<<endl;
            } else{
              throw std::runtime_error("No pixels in the NXS file!");
            }
          file->closeGroup();
          }
    }
    return numPixels;
}

//-------------------------------------------------------------------------------------------------
/**
* Return the pixel number
* @param[in] filename :: nxs file name
* @param[in] entry_name :: nxs file entry name
* @return numBins :: bins of TOF 
*/
size_t ReadCSNSNexus::getNumBins(const std::string &filename, const std::string &entry_name){
    size_t numBins=0;

    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    file->openGroup("instrument", "NXinstrument");
    // Look for all the banks
    std::map<std::string, std::string> entries = file->getEntries();
    std::map<std::string, std::string>::iterator it;
    for (it = entries.begin(); it != entries.end(); ++it) {
        std::string name = it->first;
        if (name.substr(0, 4) == "bank") {
            file->openGroup(name, it->second);
            std::map<std::string, std::string> entries = file->getEntries();
            if (entries.find("time_of_flight") != entries.end()) {
                file->openData("time_of_flight");
                std::vector<int64_t> dims = file->getInfo().dims;
                file->closeData();
                numBins = dims[0];
                break;
            }
        }
    }
    return numBins;
}

//-------------------------------------------------------------------------------------------------
/**
* Return proton charge
* @param[in] filename :: nxs file name
* @return protonChargeLog :: [time, value]
*/
std::vector<std::vector<float> > ReadCSNSNexus::getProtonChargeLog(const std::string &filename) {
    std::vector<std::vector<float> > protonChargeLog;    

    auto file = new ::NeXus::File(filename);

    std::string entry_name = "entry";
    file->openGroup(entry_name, "NXentry");
    file->openGroup("logs", "NXcollection");
    file->openGroup("proton_charge", "NXlog");

    std::vector<float> _tmp;
    file->readData("time", _tmp);
    protonChargeLog.push_back(_tmp);

    file->readData("value", _tmp);
    protonChargeLog.push_back(_tmp);
   
    file->closeGroup(); 
    file->closeGroup(); 
    file->closeGroup();
    cout<<file->getPath()<<endl; 

    return protonChargeLog;

}

//-------------------------------------------------------------------------------------------------
/**
* Return sample Environment log
* @param[in] filename :: nxs file name
* @param[in] SEname :: sample Environment name
* @return sampleEnvironment :: [time, value]
*/
std::vector<std::vector<float> > ReadCSNSNexus::getSampleEnvironmentLog(const std::string &filename, const std::string &SEname) {
    std::vector<std::vector<float> > sampleEnvironment;

    auto file = new ::NeXus::File(filename);

    std::string entry_name = "entry";
    file->openGroup(entry_name, "NXentry");
    file->openGroup("logs", "NXcollection");
    file->openGroup("sample_environment", "NXcollection");

    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find(SEname) != entries.end()) {
        file->openGroup(SEname, "NXlog");

        std::vector<float> _tmp;
        file->readData("time", _tmp);
        sampleEnvironment.push_back(_tmp);

        file->readData("value", _tmp);
        sampleEnvironment.push_back(_tmp);
        file->closeGroup();
    }else{
        throw std::runtime_error("No "+SEname+" in the NXS file!");
    }

    file->closeGroup();
    file->closeGroup();
    file->closeGroup();
    //cout<<file->getPath()<<endl;

    return sampleEnvironment;
}

//-------------------------------------------------------------------------------------------------
/**
* Return Good Frame Log
* @param[in] filename :: nxs file name
* @return goodFrameLog :: [time, value]
*/
std::vector<std::vector<float> > ReadCSNSNexus::getGoodFrameLog(const std::string &filename) {
    std::vector<std::vector<float> > goodFrameLog;    

    auto file = new ::NeXus::File(filename);

    std::string entry_name = "entry";
    file->openGroup(entry_name, "NXentry");
    file->openGroup("logs", "NXcollection");
    file->openGroup("good_frame", "NXlog");

    std::vector<float> _tmp;
    file->readData("time", _tmp);
    goodFrameLog.push_back(_tmp);

    file->readData("value", _tmp);
    goodFrameLog.push_back(_tmp);
   
    file->closeGroup(); 
    file->closeGroup(); 
    file->closeGroup();
    cout<<file->getPath()<<endl; 

    return goodFrameLog;
}

//-------------------------------------------------------------------------------------------------
/**
* Return chopper phase Log
* @param[in] filename :: nxs file name
* @return chopperPhaseLog :: [time, value]
*/
std::vector<std::vector<float> > ReadCSNSNexus::getChopperPhaseLog(const std::string &filename) {
    std::vector<std::vector<float> > chopperPhaseLog;    

    auto file = new ::NeXus::File(filename);

    std::string entry_name = "entry";
    file->openGroup(entry_name, "NXentry");
    file->openGroup("logs", "NXcollection");
    file->openGroup("good_frame", "NXlog");

    std::vector<float> _tmp;
    file->readData("time", _tmp);
    chopperPhaseLog.push_back(_tmp);

    file->readData("value", _tmp);
    chopperPhaseLog.push_back(_tmp);
   
    file->closeGroup(); 
    file->closeGroup(); 
    file->closeGroup();
    cout<<file->getPath()<<endl; 

    return chopperPhaseLog;
}
//-------------------------------------------------------------------------------------------------
/**
* Return users
* @param[in] filename :: nxs file name
* @return users :: users
*/
std::vector<CSNSuser> ReadCSNSNexus::getUsers(const std::string &filename) {
    std::vector<CSNSuser> users;

    auto file = new ::NeXus::File(filename);

    std::string entry_name = "entry";
    file->openGroup(entry_name, "NXentry");
    file->openGroup("users", "NXcollection");
    // Look for all the banks
    std::map<std::string, std::string> entries = file->getEntries();
    std::map<std::string, std::string>::iterator it;
    CSNSuser _user;
    std::string _tmp;
    for (it = entries.begin(); it != entries.end(); ++it) {
        std::string type = it->second;
        if (type == "NXuser") {
            file->openGroup(it->first, "NXuser");
            
            file->readData("address", _tmp);
            _user.address=_tmp;
            
            file->readData("affiliation", _tmp);
            _user.affiliation=_tmp;
            
            file->readData("email", _tmp);
            _user.email=_tmp;
            
            file->readData("facility_user_id", _tmp);
            _user.facility_user_id=_tmp;
            
            file->readData("name", _tmp);
            _user.name=_tmp;
            
            file->readData("role", _tmp);
            _user.role=_tmp;

            users.push_back(_user);

            file->closeGroup();
        }
    }
    file->closeGroup();
    return users;
}

//-------------------------------------------------------------------------------------------------
std::vector<std::string> ReadCSNSNexus::getBankNames(const std::string &filename) {
  std::vector<std::string> bankNames;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");
  // Also pop into the instrument
  file->openGroup("instrument", "NXinstrument");

  // Look for all the banks
  std::map<std::string, std::string> entries = file->getEntries();
  std::map<std::string, std::string>::iterator it;
  for (it = entries.begin(); it != entries.end(); ++it) {
    std::string name = it->second;
    if (name=="NXdetector"){
    bankNames.push_back(it->first);
    }
  }
  return bankNames;
}

// exec
void ReadCSNSNexus::exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max){

std::string oldfilename;
if (isFilenameChanged(filename, oldfilename)){
    cout<<"Filename changed: from "<< oldfilename << " to "<<filename.substr(filename.find_last_of("/\\") + 1)<<endl;
}else{
    cout<<"Filename not changed"<<endl;
}

std::string entry_name = getEntryName(filename);
cout<<"entry is: "<<entry_name<<endl;

std::vector<std::string> bankNames = getBankNames(filename);
for (auto i = bankNames.begin(); i != bankNames.end(); ++i){std::cout<<"bank is: " << *i <<endl;}

std::string instrumentName = getInstrumentName(filename);
cout<<"instrument name is: "<<instrumentName<<endl;

std::string runNo = getRunNo(filename);
cout<<"run no is: "<<runNo<<endl;

std::string acceleratorRunNo = getAcceleratorRunNo(filename);
cout<<"accelerator run no is: "<<acceleratorRunNo<<endl;

std::string description = getDescription(filename);
cout<<"description is: "<<description<<endl;

std::string proposalId = getProposalId(filename);
cout<<"proposal id is: "<<proposalId<<endl;

size_t numPixels = getNumPixels(filename, entry_name);
cout<<"Total Pixel number is: "<<numPixels<<endl;

size_t numBins = getNumBins(filename, entry_name);
cout<<"The TOF number is: "<<numBins<<endl;

std::string version = getVersion(filename);
cout<<"CSNS NeXus version is: "<<version<<endl;

std::string nexusVersion = getNexusVersion(filename);
cout<<"ORG NeXus version is: "<<nexusVersion<<endl;

std::string hdf5Version = getHdf5Version(filename);
cout<<"HDF5 version is: "<<hdf5Version<<endl;

std::string createTime = getCreateTime(filename);
cout<<"File create time is: "<<createTime<<endl;

std::string startTime = getStartTime(filename);
cout<<"Start time is: "<<startTime<<endl;

std::string endTime = getEndTime(filename);
cout<<"End time is: "<<endTime<<endl;

std::string beamline = getBeamline(filename);
cout<<"The beamline is: "<<beamline<<endl;

size_t beamlineNo = getBeamlineNo(filename);
cout<<"The beamline No. is: "<<beamlineNo<<endl;

std::vector<CSNSuser> users = getUsers(filename);
for (auto i = users.begin(); i != users.end(); ++i){cout<<"User is: "<< (*i).name  <<endl;}

std::vector<std::vector<float> > protonChargeLog =getProtonChargeLog(filename);
if (protonChargeLog.size()==2){
    for (size_t j=0; j<protonChargeLog[0].size(); ++j){
        cout<<"time||value-protochargeLog : "<<protonChargeLog[0][j]<<"||"<<protonChargeLog[1][j]<<endl;
    }
}

std::vector<std::vector<float> > goodFrameLog =getGoodFrameLog(filename);
if (goodFrameLog.size()==2){
    for (size_t j=0; j<goodFrameLog[0].size(); ++j){
        cout<<"time||value-goodFrameLog : "<<goodFrameLog[0][j]<<"||"<<goodFrameLog[1][j]<<endl;
    }
}

std::vector<std::vector<float> > chopperPhaseLog =getChopperPhaseLog(filename);
if (chopperPhaseLog.size()==2){
    for (size_t j=0; j<chopperPhaseLog[0].size(); ++j){
        cout<<"time||value-chopperPhaseLog : "<<chopperPhaseLog[0][j]<<"||"<<chopperPhaseLog[1][j]<<endl;
    }
}

std::vector<std::vector<float> > sampleEnvironmentLog = getSampleEnvironmentLog(filename, "temperature");
if (sampleEnvironmentLog.size()==2){
    for (size_t j=0; j<sampleEnvironmentLog[0].size(); ++j){
        cout<<"time||temperature : "<<sampleEnvironmentLog[0][j]<<"||"<<sampleEnvironmentLog[1][j]<<endl;
    }
}

//mantid:: Create workspace
//MatrixWorkspace_sptr WS = WorkspaceFactory::Instance().create("Workspace2D", numPixels, numBins + 1, numBins);

//
}

int main(int argc, char** argv){
std::string filename="../../../Examples/BL18_GPPD_0000001.nxs";
size_t  m_signalNo = 1;
size_t  m_spec_min = 1;
size_t  m_spec_max = 1;


ReadCSNSNexus *readnxs = new ReadCSNSNexus();
readnxs->exec(filename, m_signalNo, m_spec_min, m_spec_max);

};
