#ifndef MANTID_DATAHANDLING_REACSNSNEXUS_H_
#define MANTID_DATAHANDLING_REACSNSNEXUS_H_

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <vector>
#include <map>
#include <nexus/napi.h>
#include <nexus/NeXusFile.hpp>
#include <unistd.h>
#include <boost/algorithm/string/detail/classification.hpp>
#include <boost/algorithm/string/split.hpp>

using std::cout;
using std::endl;
using std::map;
using std::multimap;
using std::string;
using std::vector;

//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------
//#include "MantidAPI/IFileLoader.h"
//#include "MantidAPI/Sample.h"
//#include "MantidAPI/SpectraDetectorTypes.h"
//#include "MantidDataObjects/Workspace2D.h"
//#include "MantidNexus/NexusClasses.h"
//#include "MantidKernel/DateAndTime.h"
//#include "MantidKernel/MultiThreaded.h"

/**
 Loads a NeXus file that conforms to the CSNS instrument definition format and
 stores it in a 2D workspace.

 Copyright &copy; 2007-8 ISIS Rutherford Appleton Laboratory, NScD Oak Ridge
 National Laboratory & European Spallation Source

 This file is part of Mantid.

 Mantid is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 Mantid is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 File change history is stored at: <https://github.com/mantidproject/mantid>
 */
class ReadCSNSNexus
     {
public:
  /// Default Constructor
  ReadCSNSNexus();

  // Destructor
  virtual ~ReadCSNSNexus() {}

  /// Algorithm's name for identification overriding a virtual method
  virtual const std::string name() const { return "ReadCSNSNexus"; }

  /// Summary of algorithms purpose
  virtual const std::string summary() const {
    return "Loads a NeXus file confirming to the CSNS format";
  }

  /// Algorithm's version for identification overriding a virtual method
  virtual int version() const { return 1; }

  /// Algorithm's category for identification overriding a virtual method
  virtual const std::string category() const { return "DataHandling\\Nexus"; }

  /// Get entry name
  static std::string getEntryName(const std::string &filename);

  /// Get instrument name
  static std::string getInstrumentName(const std::string &filename);
  
  /// Get Run No
  static std::string getRunNo(const std::string &filename);
  
  /// Get Accelerator Run No
  static std::string getAcceleratorRunNo(const std::string &filename);
 
  /// Get Description
  static std::string getDescription(const std::string &filename);

  /// Get Proposal Id
  static std::string getProposalId(const std::string &filename);
  
  /// List bank names 
  static std::vector<std::string> getBankNames(const std::string &filename);

  /// Returns a confidence value that this algorithm can load a file
  //virtual int confidence(Kernel::NexusDescriptor &descriptor) const;

  /// Number of pixels
  size_t m_numPixels;

  /// Signal # to load. Default 1
  int m_signalNo;

  void exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max);
protected:
  void init();
  //void exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max);

  /// Validate the optional input properties
  void checkOptionalProperties();

  /// Run LoadInstrument as a ChildAlgorithm
  //void runLoadInstrument(DataObjects::Workspace2D_sptr);
  void runLoadInstrument();

  /// Load in details about the sample
  //void loadSampleData(DataObjects::Workspace2D_sptr, Mantid::NeXus::NXEntry &entry);
  void loadSampleData(const std::string &entry_name);

  //void loadBank(const std::string &nexusfilename, const std::string &entry_name,
  //              const std::string &bankName, API::MatrixWorkspace_sptr WS,
  //              const detid2index_map &id_to_wi);

  void loadBank(const std::string &nexusfilename, const std::string &entry_name,
                const std::string &bankName);
  /// List of the absolute time of each pulse
  //std::vector<Kernel::DateAndTime> pulseTimes;

  /// Number of bins
  size_t m_numBins;

  /// Interval of chunk
  //specid_t m_spec_min, m_spec_max;
  size_t m_spec_min, m_spec_max;

  /// Name of the 'data' field to load (depending on Signal)
  std::string m_dataField;

  /// Name of the 'axis' field to load (depending on Signal)
  std::string m_axisField;

  /// Units of the X axis found
  std::string m_xUnits;

  /// Mutex to avoid simultaneous file access
 // Kernel::Mutex m_fileMutex;

};
#endif /* MANTID_DATAHANDLINGREACSNSNEXUS_H_ */
