#include "MantidDataHandling/LoadCSNSRaw.h"
#include "MantidDataHandling/EventWorkspaceCollection.h"

#include <boost/random/mersenne_twister.hpp>
#include <boost/random/uniform_real.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/shared_array.hpp>
#include <boost/scoped_array.hpp>
#include <boost/function.hpp>
#include <functional>

#include "MantidKernel/ArrayProperty.h"
#include "MantidKernel/ThreadPool.h"
#include "MantidKernel/UnitFactory.h"
#include "MantidKernel/ThreadSchedulerMutexes.h"
#include "MantidKernel/BoundedValidator.h"
#include "MantidKernel/VisibleWhenProperty.h"
#include "MantidKernel/TimeSeriesProperty.h"
#include "MantidGeometry/Instrument/RectangularDetector.h"
#include "MantidAPI/FileProperty.h"
#include "MantidAPI/MemoryManager.h"
#include "MantidAPI/RegisterFileLoader.h"
#include "MantidAPI/SpectrumDetectorMapping.h"
#include "MantidKernel/Timer.h"
//#include <iostream>
//#include <fstream>
//#include <cstdlib>
#include <algorithm>

using std::cout;
using std::endl;
using std::map;
using std::string;
using std::vector;
using std::ofstream;

namespace Mantid
{
namespace DataHandling
{

DECLARE_NEXUS_FILELOADER_ALGORITHM(LoadCSNSRaw)

using namespace Kernel;
using namespace Geometry;
using namespace API;
using namespace DataObjects;

LoadCSNSRaw::LoadCSNSRaw()
    : m_bTotalPixels(0),m_mTotalPixels(0), pulseTimes(0), m_numBins(0), m_spec_min(0),
      m_spec_max(0), m_fileMutex() {}

//-------------------------------------------------------------------------------------------------
/// Initialisation method.
void LoadCSNSRaw::init()
{
//    declareProperty(
//        new FileProperty("Filename", "", FileProperty::Load, {".nxs"}),
//        "The name of the NeXus file to load");
    declareProperty(new WorkspaceProperty<API::Workspace>("OutputWorkspace", "",
                    Direction::Output),
                    "The name of the Workspace2D to create.");
//    declareProperty(
//        new ArrayProperty<string>("PixelNum", Direction::Input),
//        "The total pixel number. ");
    declareProperty(
        new ArrayProperty<int64_t>("PixelID_bank", Direction::Input),
        "A comma-separated list of pixel id to read. ");
    declareProperty(
        new ArrayProperty<uint32_t>("TimeOfFlight_bank", Direction::Input),
        "A comma-separated list of time of flight to read. ");
    declareProperty(
        new ArrayProperty<uint32_t>("Counts_bank", Direction::Input),
        "A comma-separated list of counts to read. ");
    declareProperty(
        new ArrayProperty<int64_t>("PixelID_monitor", Direction::Input),
        "A comma-separated list of pixel id to read. ");
    declareProperty(
        new ArrayProperty<uint32_t>("TimeOfFlight_monitor", Direction::Input),
        "A comma-separated list of time of flight to read. ");
    declareProperty(
        new ArrayProperty<uint32_t>("Counts_monitor", Direction::Input),
        "A comma-separated list of counts to read. ");
//    declareProperty(
 //       new PropertyWithValue<string>("Entryname", "csns",Direction::Input), "Optional: Name of entry (default csns)");

 //   declareProperty(
  //      new ArrayProperty<string>("Bankname", Direction::Input),
  //      "Optional: A comma-separated list of bank to read. (default all banks)");
  //  declareProperty(
  //      new ArrayProperty<string>("Monitorname", Direction::Input),
  //      "Optional: A comma-separated list of monitor to read. (default all monitors)");
 //   declareProperty(
 //       new PropertyWithValue<bool>("Loadevent", true, Direction::Input),
 //       "Default true: load event data mode, false: Load histogram data.");

}

//-------------------------------------------------------------------------------------------------
/**
 * Return the confidence with with this algorithm can load the file
 * @param descriptor A descriptor for the file
 * @returns An integer specifying the confidence level. 0 indicates it will not
 * be used
 */
int LoadCSNSRaw::confidence(Kernel::NexusDescriptor &descriptor) const
{
    int confidence(0);
    if (descriptor.pathOfTypeExists("/csns", "NXentry"))
    {
        const bool hasEventData = descriptor.classTypeExists("NXevent_data");
        const bool hasHistogramData = descriptor.classTypeExists("NXdata");
        if (hasHistogramData && hasEventData)
            // Event data = this is event NXS
            confidence = 20;
        else if (hasHistogramData && !hasEventData)
            // No event data = this is the one
            confidence = 80;
        else if (!hasHistogramData && hasEventData)
            // Histogram Data only
            confidence = 40;
        else
            // No data ?
            confidence = 10;
    }
    return confidence;
}
//-----------------------------------------------------------------------------------------------
std::vector<int64_t> LoadCSNSRaw::getPixelId(bool bm)
{
std::vector<int64_t> pixelID;
    std::vector<int64_t>::iterator it;
    if(bm){
    pixelID=getProperty("PixelID_bank");
    }else{
    pixelID=getProperty("PixelID_monitor");
    }

    sort(pixelID.begin(),pixelID.end());
    it=unique(pixelID.begin(),pixelID.end());
    pixelID.erase(it,pixelID.end());
    return pixelID;
}
//-----------------------------------------------------------------------------------------------
std::vector<uint32_t> LoadCSNSRaw::getTimeOfFlight(bool bm)
{
    std::vector<uint32_t> timeOfFlight;
    std::vector<uint32_t>::iterator it;
    if(bm){
    timeOfFlight=getProperty("TimeOfFlight_bank");
    }else{
    timeOfFlight=getProperty("TimeOfFlight_monitor");
    }
    sort(timeOfFlight.begin(),timeOfFlight.end());
    it=unique(timeOfFlight.begin(),timeOfFlight.end());
    timeOfFlight.erase(it,timeOfFlight.end());
    return timeOfFlight;
}
//------------------------------------------------------------------------------------------------
std::map<int64_t, uint32_t> LoadCSNSRaw::getSpecNo(bool bm)
{
	std::vector<int64_t> pixelID=getPixelId(bm);
	std::vector<int64_t>::iterator it;
	std::map<int64_t, uint32_t> specNo;
	int p=0;
	for(it=pixelID.begin();it!=pixelID.end();it++)
	{
		specNo.insert(std::map<int64_t, uint32_t>::value_type(*it, p));
		p++;
	}
	return specNo;
}
//-------------------------------------------------------------------------------------------------
/**
 * Load histgram data into workspace
 * @param[in] filename :: nxs file name
 * @param[in] workspace :: workspace name
 * @param[in] totalPixels :: total pixel numbers
 * @param[in] timeBin :: time of flight
 */

   void LoadCSNSRaw::loadHistData(boost::shared_ptr<API::MatrixWorkspace> workspace, size_t totalPixels, bool bm)
{
   std::vector<uint32_t> counts;
    if(bm){
    counts=getProperty("Counts_bank");
    }else{
    counts=getProperty("Counts_monitor");
}
    std::vector<uint32_t> timeOfFlight=getTimeOfFlight(bm);
   std::map<int64_t, uint32_t> specNo=getSpecNo(bm);
    std::vector<uint32_t>::iterator it2;
std::map<int64_t, uint32_t>::iterator it3;

   size_t numBins = timeOfFlight.size();
   cout<<"the numBins= "<<numBins<<endl;
   cout<<"the total pixels= "<<totalPixels<<endl;
   MantidVecPtr x, e;
   MantidVec &xRef = x.access();
   MantidVec &eRef = e.access();
   xRef.resize(numBins);
   eRef.resize(numBins, 0); // Value of 0 in all error
//cout<<"how many tofs: "<<timeBin.size()<<endl;
// set X value
int st1 = 0;
for (it2 = timeOfFlight.begin(); it2 != timeOfFlight.end(); it2++)  
{
xRef[st1] = (*it2);
st1++;
}
// set Y value
size_t hist = 0;
std::vector<uint32_t>::iterator it_start = counts.begin();
std::vector<uint32_t>::iterator it_end = it_start + numBins ;
std::vector<uint32_t>::iterator it_tof = timeOfFlight.begin();
while(hist < totalPixels){
MantidVec &Y = workspace->dataY(hist);
Y.assign(it_start, it_end);
it_start += numBins;
it_end += numBins;
workspace->setX(hist, x);
++hist;
}
}


//-------------------------------------------------------------------------------------------------
void LoadCSNSRaw::exec()
{
	// The input properties
//	std::string filename = getPropertyValue("Filename");
//	std::string pixelnum = getPropertyValue("PixelNum");
//	m_entryName = getPropertyValue("Entryname");
	auto prog = new Progress(this, 0.0, 1.0, 10);
	prog->doReport("Start to load Raw Data");

	// Open nxs file
//	auto file = new ::NeXus::File(filename);

	prog->doReport("get histogram");

	//test get pixel id
	std::vector<int64_t> pixelid=getPixelId(true);
	std::vector<int64_t>::iterator it1;
        for(it1=pixelid.begin();it1!=pixelid.end();it1++){
		cout<<*it1<<endl;
	}
	size_t tot=pixelid.size();
	std::vector<int64_t> pixelid2=getPixelId(false);
	size_t tot2=pixelid2.size();
        
	//test get time of flight
	std::vector<uint32_t> timeOfFlight=getTimeOfFlight(true);
	std::vector<uint32_t>::iterator it2;
        for(it2=timeOfFlight.begin();it2!=timeOfFlight.end();it2++){
		cout<<*it2<<endl;
	}
	size_t nbin=timeOfFlight.size();
	// test getSpectraMapping
	   std::map<int64_t, uint32_t> specNo = getSpecNo(true);
	   std::cout<<"total number of spectrum in banks is: "<<specNo.size()<<std::endl;
	   std::map<int64_t, uint32_t>::iterator it3;
	it3=specNo.find(100);
	cout<<"pid=100 || "<<it3->second<<endl;

	   prog->doReport("Creating workspace");
	// Bank workspace
	MatrixWorkspace_sptr WS1 = boost::dynamic_pointer_cast<MatrixWorkspace>( WorkspaceFactory::Instance().create("Workspace2D", tot, nbin + 1, nbin));
	// Monitor workspace
	MatrixWorkspace_sptr WS2 = boost::dynamic_pointer_cast<MatrixWorkspace>( WorkspaceFactory::Instance().create("Workspace2D", tot2, nbin + 1, nbin));
	// make group
	WorkspaceGroup_sptr wksp_group(new WorkspaceGroup);
	wksp_group->addWorkspace(WS1);
	wksp_group->addWorkspace(WS2);
	// set outputworkspace
	setProperty("OutputWorkspace",boost::dynamic_pointer_cast<Workspace>(wksp_group));
	loadHistData(WS1, tot, true);
	loadHistData(WS2, tot2, false);
//	WS1->mutableRun().setStartAndEndTime(start_time, end_time);
//	WS1->setTitle(m_sampleInfo.name);
//	WS1->getAxis(0)->unit() = Kernel::UnitFactory::Instance().create("TOF");
//	WS1->setYUnit("Counts");
	
	// close nxs file
//	file->close();
//	delete file;
	}

} // namespace DataHandling
} // namespace Mantid
