#ifndef MANTID_DATAHANDLING_LOADCSNSNEXUS_H_
#define MANTID_DATAHANDLING_LOADCSNSNEXUS_H_

//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------
#include "MantidAPI/IFileLoader.h"
#include "MantidAPI/Sample.h"
#include "MantidAPI/SpectraDetectorTypes.h"
#include "MantidDataObjects/Workspace2D.h"
#include "MantidNexus/NexusClasses.h"
#include "MantidKernel/DateAndTime.h"
#include "MantidKernel/MultiThreaded.h"

namespace Mantid {

namespace DataHandling {
/**
 Loads a NeXus file that conforms to the CSNSNexus instrument definition format and
 stores it in a 2D workspace.

 Copyright &copy; 2007-8 ISIS Rutherford Appleton Laboratory, NScD Oak Ridge
 National Laboratory & European Spallation Source

 This file is part of Mantid.

 Mantid is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 Mantid is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 File change history is stored at: <https://github.com/mantidproject/mantid>
 */
class DLLExport LoadCSNSNexus
    : public API::IFileLoader<Kernel::NexusDescriptor> {
public:
  /// Default Constructor
  LoadCSNSNexus();

  // Destructor
  virtual ~LoadCSNSNexus() {}

  /// Algorithm's name for identification overriding a virtual method
  virtual const std::string name() const { return "LoadCSNSNexus"; }

  /// Summary of algorithms purpose
  virtual const std::string summary() const {
    return "Loads a NeXus file confirming to the CSNSNexus format";
  }

  /// Algorithm's version for identification overriding a virtual method
  virtual int version() const { return 1; }

  /// Algorithm's category for identification overriding a virtual method
  virtual const std::string category() const { return "DataHandling\\Nexus"; }
  /// get entry name
  static std::string getEntryName(const std::string &filename);
 
  ///entry name
  static std::string m_entryName;

  /// Returns a confidence value that this algorithm can load a file
  virtual int confidence(Kernel::NexusDescriptor &descriptor) const;

  /// Number of pixels
  size_t m_numPixels;

  /// Signal # to load. Default 1
  int m_signalNo;

protected:
  void init();
  void exec();

  /// Validate the optional input properties
  void checkOptionalProperties();

  /// List of the absolute time of each pulse
  std::vector<Kernel::DateAndTime> pulseTimes;

  /// Number of bins
  size_t m_numBins;

  /// Interval of chunk
  specid_t m_spec_min, m_spec_max;

  /// Name of the 'data' field to load (depending on Signal)
  std::string m_dataField;

  /// Name of the 'axis' field to load (depending on Signal)
  std::string m_axisField;

  /// Units of the X axis found
  std::string m_xUnits;

  /// Mutex to avoid simultaneous file access
  Kernel::Mutex m_fileMutex;

  /// Flag for whether or not to assume the data is old SNS raw files;
  bool m_assumeOldFile;
};

} // namespace DataHandling
} // namespace Mantid

#endif /* MANTID_DATAHANDLINGLOADCSNSNEXUS_H_ */
