//#include "MantidAPI/FileProperty.h"
//#include "MantidAPI/MatrixWorkspace.h"
//#include "MantidAPI/RegisterFileLoader.h"
//#include "MantidDataHandling/LoadEventNexus.h"
//#include "MantidDataHandling/ReadCSNSNexus.h"
#include "../inc/MantidDataHandling/ReadCSNSNexus.h"
//#include "MantidKernel/ArrayProperty.h"
//#include "MantidKernel/BoundedValidator.h"
//#include "MantidKernel/cow_ptr.h"
//#include <nexus/NeXusFile.hpp>
//#include <boost/algorithm/string/detail/classification.hpp>
//#include <boost/algorithm/string/split.hpp>

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <vector>
#include <map>

using std::cout;
using std::endl;
using std::map;
using std::multimap;
using std::string;
using std::vector;

ReadCSNSNexus::ReadCSNSNexus(){}

//-------------------------------------------------------------------------------------------------
void ReadCSNSNexus::init() {}

void ReadCSNSNexus::loadBank(const std::string &nexusfilename,
                               const std::string &entry_name,
                               const std::string &bankName
                               ) {
}

//-------------------------------------------------------------------------------------------------
//mantid::std::string NexusDescriptor::pathOfType(const std::string &type)
/*
bool ReadCSNSNexus::pathOfTypeExists(const std::string &path,
                                       const std::string &type) const {
  auto it = m_pathsToTypes.find(path);
  if (it != m_pathsToTypes.end()) {
    return (it->second == type);
  } else
    return false;
}
*/
//-------------------------------------------------------------------------------------------------
/*
int LoadCSNSNexus::confidence() const {
  int confidence(0); 
  if (descriptor.pathOfTypeExists("/entry", "NXentry") ||
      descriptor.pathOfTypeExists("/entry-state0", "NXentry")) {
    const bool hasEventData = descriptor.classTypeExists("NXevent_data");
    const bool hasData = descriptor.classTypeExists("NXdata");
    if (hasData && hasEventData)
      // Event data = this is event NXS
      confidence = 20;
    else if (hasData && !hasEventData)
      // No event data = this is the one
      confidence = 80;
    else
      // No data ?
      confidence = 10;
  }
  return confidence;
}
*/
//-------------------------------------------------------------------------------------------------
std::string ReadCSNSNexus::getEntryName(const std::string &filename) {
  std::string entry_name = "entry";
  auto file = new ::NeXus::File(filename);
  std::map<std::string, std::string> entries = file->getEntries();
  file->close();
  delete file;

  if (entries.empty())
    throw std::runtime_error("No entries in the NXS file!");

  if (entries.find(entry_name) == entries.end())
    throw std::runtime_error("Not CSNS NXS file!");
    entry_name = entries.begin()->first;

  return entry_name;
}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument name
* @param[in] filename :: nxs file name
* @return instrument name 
*/
std::string ReadCSNSNexus::getInstrumentName(const std::string &filename){
  std::string instrumentName;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("instrument_name") != entries.end()) {
          file->readData("instrument_name", instrumentName);
          return instrumentName;
    }else{
        throw std::runtime_error("No Instrument Name in the NXS file!");
    }

}


//-------------------------------------------------------------------------------------------------
/**
* Return the Run no
* @param[in] filename :: nxs file name
* @return run no 
*/
std::string ReadCSNSNexus::getRunNo(const std::string &filename){
    std::string runNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("run_no") != entries.end()) {
          file->readData("run_no", runNo);
          return runNo;
    }else{
        throw std::runtime_error("No Run No in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the Accelerator Run no
* @param[in] filename :: nxs file name
* @return accelerator run no 
*/
std::string ReadCSNSNexus::getAcceleratorRunNo(const std::string &filename){
    std::string acceleratorRunNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("accelerator_run_no") != entries.end()) {
          file->readData("accelerator_run_no", acceleratorRunNo);
          return acceleratorRunNo;
    }else{
        throw std::runtime_error("No Accelerator Run No in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
/**
* Return the description
* @param[in] filename :: nxs file name
* @return description 
*/
std::string ReadCSNSNexus::getDescription(const std::string &filename){
    std::string description;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("description") != entries.end()) {
          file->readData("description",description);
          return description;
    }else{
        throw std::runtime_error("No description in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
std::vector<std::string> ReadCSNSNexus::getBankNames(const std::string &filename) {
  std::vector<std::string> bankNames;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");
  // Also pop into the instrument
  file->openGroup("instrument", "NXinstrument");

  // Look for all the banks
  std::map<std::string, std::string> entries = file->getEntries();
  std::map<std::string, std::string>::iterator it;
  for (it = entries.begin(); it != entries.end(); ++it) {
    std::string name = it->second;
    if (name=="NXdetector"){
    bankNames.push_back(it->first);
    }
  }
  return bankNames;
}

void ReadCSNSNexus::exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max){
std::string entry_name = getEntryName(filename);
cout<<"entry is: "<<entry_name<<endl;

std::vector<std::string> bankNames = getBankNames(filename);

for (auto i = bankNames.begin(); i != bankNames.end(); ++i){std::cout<<"bank is: " << *i <<endl;}

std::string instrumentName = getInstrumentName(filename);
cout<<"instrument name is: "<<instrumentName<<endl;

std::string runNo = getRunNo(filename);
cout<<"run no is: "<<runNo<<endl;

std::string acceleratorRunNo = getAcceleratorRunNo(filename);
cout<<"accelerator run no is: "<<acceleratorRunNo<<endl;

std::string description = getDescription(filename);
cout<<"description is: "<<description<<endl;
/*
auto file = new ::NeXus::File(filename);
std::map<std::string, std::string> entries = file->getEntries();
std::map<std::string, std::string>::iterator it;
for (it = entries.begin(); it != entries.end(); ++it) {
cout<<it->first<<" : " <<it->second<<endl;  
}

file->close();
  delete file;
*/
}


int main(int argc, char** argv){
std::string filename="../../../Examples/BL18_GPPD_0000001.nxs";
size_t  m_signalNo = 1;
size_t  m_spec_min = 1;
size_t  m_spec_max = 1;


ReadCSNSNexus *readnxs = new ReadCSNSNexus();
readnxs->exec(filename, m_signalNo, m_spec_min, m_spec_max);



};
