//#include "MantidAPI/FileProperty.h"
//#include "MantidAPI/MatrixWorkspace.h"
//#include "MantidAPI/RegisterFileLoader.h"
//#include "MantidDataHandling/LoadEventNexus.h"
//#include "MantidDataHandling/ReadCSNSNexus.h"
#include "../inc/MantidDataHandling/ReadCSNSNexus.h"
//#include "MantidKernel/ArrayProperty.h"
//#include "MantidKernel/BoundedValidator.h"
//#include "MantidKernel/cow_ptr.h"
//#include <nexus/NeXusFile.hpp>
//#include <boost/algorithm/string/detail/classification.hpp>
//#include <boost/algorithm/string/split.hpp>

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <vector>
#include <map>

using std::cout;
using std::endl;
using std::map;
using std::multimap;
using std::string;
using std::vector;

ReadCSNSNexus::ReadCSNSNexus(){}

//-------------------------------------------------------------------------------------------------
void ReadCSNSNexus::init() {}

void ReadCSNSNexus::loadBank(const std::string &nexusfilename,
                               const std::string &entry_name,
                               const std::string &bankName
                               ) {
}

//-------------------------------------------------------------------------------------------------
//mantid::std::string NexusDescriptor::pathOfType(const std::string &type)
/*
bool ReadCSNSNexus::pathOfTypeExists(const std::string &path,
                                       const std::string &type) const {
  auto it = m_pathsToTypes.find(path);
  if (it != m_pathsToTypes.end()) {
    return (it->second == type);
  } else
    return false;
}
*/
//-------------------------------------------------------------------------------------------------
/*
int LoadCSNSNexus::confidence() const {
  int confidence(0); 
  if (descriptor.pathOfTypeExists("/entry", "NXentry") ||
      descriptor.pathOfTypeExists("/entry-state0", "NXentry")) {
    const bool hasEventData = descriptor.classTypeExists("NXevent_data");
    const bool hasData = descriptor.classTypeExists("NXdata");
    if (hasData && hasEventData)
      // Event data = this is event NXS
      confidence = 20;
    else if (hasData && !hasEventData)
      // No event data = this is the one
      confidence = 80;
    else
      // No data ?
      confidence = 10;
  }
  return confidence;
}
*/
//-------------------------------------------------------------------------------------------------
std::string ReadCSNSNexus::getEntryName(const std::string &filename) {
  std::string entry_name = "entry";
  auto file = new ::NeXus::File(filename);
  std::map<std::string, std::string> entries = file->getEntries();
  file->close();
  delete file;

  if (entries.empty())
    throw std::runtime_error("No entries in the NXS file!");

  if (entries.find(entry_name) == entries.end())
    throw std::runtime_error("Not CSNS NXS file!");
    entry_name = entries.begin()->first;

  return entry_name;
}

//-------------------------------------------------------------------------------------------------
/**
* Return the CSNS NeXus definiton version
* @param[in] filename :: nxs file name
* @return version :: CSNS NeXus definition version 
*/
std::string ReadCSNSNexus::getVersion(const std::string &filename){
  std::string version;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("version") != entries.end()) {
          file->readData("version", version);
          return version;
    }else{
        throw std::runtime_error("No version in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the Org NeXus version
* @param[in] filename :: nxs file name
* @return nexusVersion :: org NeXus version 
*/
std::string ReadCSNSNexus::getNexusVersion(const std::string &filename){
  std::string nexusVersion;

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  if (file->hasAttr("NeXus_version")){
    file->getAttr("NeXus_version", nexusVersion);
    return nexusVersion;
  }else{
    throw std::runtime_error("No Nexus version in the NXS file!");
  }  
}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument name
* @param[in] filename :: nxs file name
* @return instrument name 
*/
std::string ReadCSNSNexus::getInstrumentName(const std::string &filename){
  std::string instrumentName;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("instrument_name") != entries.end()) {
          file->readData("instrument_name", instrumentName);
          return instrumentName;
    }else{
        throw std::runtime_error("No Instrument Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument beamline
* @param[in] filename :: nxs file name
* @return beamline :: beamline name 
*/
std::string ReadCSNSNexus::getBeamline(const std::string &filename){
  std::string beamline;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("beamline") != entries.end()) {
          file->readData("beamline", beamline);
          return beamline;
    }else{
        throw std::runtime_error("No Beamline Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the instrument No
* @param[in] filename :: nxs file name
* @return beamlineNo :: beamline No 
*/
size_t ReadCSNSNexus::getBeamlineNo(const std::string &filename){
  std::string beamline;
  size_t beamlineNo;

  std::string entry_name = "entry";
    
  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");

   std::map<std::string, std::string> entries = file->getEntries();

   if (entries.find("beamline") != entries.end()) {
          file->readData("beamline", beamline);
          beamlineNo = atoi(beamline.substr(2, 2).c_str()); 
          return beamlineNo;
    }else{
        throw std::runtime_error("No Beamline Name in the NXS file!");
    }

}

//-------------------------------------------------------------------------------------------------
/**
* Return the Run no
* @param[in] filename :: nxs file name
* @return run no 
*/
std::string ReadCSNSNexus::getRunNo(const std::string &filename){
    std::string runNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("run_no") != entries.end()) {
          file->readData("run_no", runNo);
          return runNo;
    }else{
        throw std::runtime_error("No Run No in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the Accelerator Run no
* @param[in] filename :: nxs file name
* @return accelerator run no 
*/
std::string ReadCSNSNexus::getAcceleratorRunNo(const std::string &filename){
    std::string acceleratorRunNo;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("accelerator_run_no") != entries.end()) {
          file->readData("accelerator_run_no", acceleratorRunNo);
          return acceleratorRunNo;
    }else{
        throw std::runtime_error("No Accelerator Run No in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
/**
* Return the description
* @param[in] filename :: nxs file name
* @return description 
*/
std::string ReadCSNSNexus::getDescription(const std::string &filename){
    std::string description;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("description") != entries.end()) {
          file->readData("description",description);
          return description;
    }else{
        throw std::runtime_error("No description in the NXS file!");
    }
}
//-------------------------------------------------------------------------------------------------
/**
* Return the proposal id
* @param[in] filename :: nxs file name
* @return proposalId 
*/
std::string ReadCSNSNexus::getProposalId(const std::string &filename){
    std::string proposalId;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
  
    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("proposal_id") != entries.end()) {
          file->readData("proposal_id",proposalId);
          return proposalId;
    }else{
        throw std::runtime_error("No proposal Id in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the start time of experiment
* @param[in] filename :: nxs file name
* @return startTime :: start time
*/
std::string ReadCSNSNexus::getStartTime(const std::string &filename){
    std::string startTime;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");

    std::map<std::string, std::string> entries = file->getEntries();

    if (entries.find("start_time") != entries.end()) {
          file->readData("start_time", startTime);
          return startTime;
    }else{
        throw std::runtime_error("No start time in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the end time of experiment
* @param[in] filename :: nxs file name
* @return endTime :: end time
*/
std::string ReadCSNSNexus::getEndTime(const std::string &filename){
    std::string endTime;
    std::string entry_name = "entry";
    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    
    std::map<std::string, std::string> entries = file->getEntries();
    
    if (entries.find("end_time") != entries.end()) {
          file->readData("end_time", endTime);
          return endTime;
    }else{
        throw std::runtime_error("No end time in the NXS file!");
    }
}

//-------------------------------------------------------------------------------------------------
/**
* Return the pixel number
* @param[in] filename :: nxs file name
* @param[in] entry_name :: nxs file entry name
* @return numPixels 
*/
size_t ReadCSNSNexus::getNumPixels(const std::string &filename, const std::string &entry_name){
    size_t numPixels=0;
    size_t newPixels;

    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    file->openGroup("instrument", "NXinstrument");
    // Look for all the banks
    std::map<std::string, std::string> entries = file->getEntries();
    std::map<std::string, std::string>::iterator it;
    for (it = entries.begin(); it != entries.end(); ++it) {
        std::string name = it->first;

        if (name.substr(0, 4) == "bank") {
         // cout<<"name is:"<<name<<endl; 
         // file->openGroup(name, "NXdetector");
          file->openGroup(name, it->second);
         
          std::map<std::string, std::string> entries = file->getEntries();

          if (entries.find("pixel_id") != entries.end()) {
            file->openData("pixel_id");
    	    std::vector<int64_t> dims = file->getInfo().dims;
            file->closeData();

            if (!dims.empty()) {
              size_t newPixels = 1;
              for (size_t i = 0; i < dims.size(); i++)
                newPixels *= dims[i];
              // cout<<"newPixels is: "<<newPixels<<endl;
              numPixels += newPixels;
            }
             // cout<<"numPixels is:"<<numPixels<<endl;
            } else{
              throw std::runtime_error("No pixels in the NXS file!");
            }
          file->closeGroup();
          }
    }
    return numPixels;
}

//-------------------------------------------------------------------------------------------------
/**
* Return the pixel number
* @param[in] filename :: nxs file name
* @param[in] entry_name :: nxs file entry name
* @return numBins :: bins of TOF 
*/
size_t ReadCSNSNexus::getNumBins(const std::string &filename, const std::string &entry_name){
    size_t numBins=0;

    auto file = new ::NeXus::File(filename);
    file->openGroup(entry_name, "NXentry");
    file->openGroup("instrument", "NXinstrument");
    // Look for all the banks
    std::map<std::string, std::string> entries = file->getEntries();
    std::map<std::string, std::string>::iterator it;
    for (it = entries.begin(); it != entries.end(); ++it) {
        std::string name = it->first;
        if (name.substr(0, 4) == "bank") {
            file->openGroup(name, it->second);
            std::map<std::string, std::string> entries = file->getEntries();
            if (entries.find("time_of_flight") != entries.end()) {
                file->openData("time_of_flight");
                std::vector<int64_t> dims = file->getInfo().dims;
                file->closeData();
                numBins = dims[0];
                break;
            }
        }
    }
    return numBins;
}

//-------------------------------------------------------------------------------------------------
std::vector<std::string> ReadCSNSNexus::getBankNames(const std::string &filename) {
  std::vector<std::string> bankNames;

  std::string entry_name = "entry";

  // Create the root Nexus class
  auto file = new ::NeXus::File(filename);
  // Open the default data group 'entry'
  file->openGroup(entry_name, "NXentry");
  // Also pop into the instrument
  file->openGroup("instrument", "NXinstrument");

  // Look for all the banks
  std::map<std::string, std::string> entries = file->getEntries();
  std::map<std::string, std::string>::iterator it;
  for (it = entries.begin(); it != entries.end(); ++it) {
    std::string name = it->second;
    if (name=="NXdetector"){
    bankNames.push_back(it->first);
    }
  }
  return bankNames;
}

void ReadCSNSNexus::exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max){
std::string entry_name = getEntryName(filename);
cout<<"entry is: "<<entry_name<<endl;

std::vector<std::string> bankNames = getBankNames(filename);

for (auto i = bankNames.begin(); i != bankNames.end(); ++i){std::cout<<"bank is: " << *i <<endl;}

std::string instrumentName = getInstrumentName(filename);
cout<<"instrument name is: "<<instrumentName<<endl;

std::string runNo = getRunNo(filename);
cout<<"run no is: "<<runNo<<endl;

std::string acceleratorRunNo = getAcceleratorRunNo(filename);
cout<<"accelerator run no is: "<<acceleratorRunNo<<endl;

std::string description = getDescription(filename);
cout<<"description is: "<<description<<endl;

std::string proposalId = getProposalId(filename);
cout<<"proposal id is: "<<proposalId<<endl;

size_t numPixels = getNumPixels(filename, entry_name);
cout<<"Total Pixel number is: "<<numPixels<<endl;

size_t numBins = getNumBins(filename, entry_name);
cout<<"The TOF number is: "<<numBins<<endl;

std::string version = getVersion(filename);
cout<<"CSNS NeXus version is: "<<version<<endl;

std::string nexusVersion = getNexusVersion(filename);
cout<<"ORG NeXus version is: "<<nexusVersion<<endl;

std::string startTime = getStartTime(filename);
cout<<"Start time is: "<<startTime<<endl;

std::string endTime = getEndTime(filename);
cout<<"End time is: "<<endTime<<endl;

std::string beamline = getBeamline(filename);
cout<<"The beamline is: "<<beamline<<endl;

size_t beamlineNo = getBeamlineNo(filename);
cout<<"The beamline No. is: "<<beamlineNo<<endl;
//mantid:: Create workspace
//MatrixWorkspace_sptr WS = WorkspaceFactory::Instance().create("Workspace2D", numPixels, numBins + 1, numBins);

//
}

int main(int argc, char** argv){
std::string filename="../../../Examples/BL18_GPPD_0000001.nxs";
size_t  m_signalNo = 1;
size_t  m_spec_min = 1;
size_t  m_spec_max = 1;


ReadCSNSNexus *readnxs = new ReadCSNSNexus();
readnxs->exec(filename, m_signalNo, m_spec_min, m_spec_max);

};
