#ifndef MANTID_DATAHANDLING_REACSNSNEXUS_H_
#define MANTID_DATAHANDLING_REACSNSNEXUS_H_

#include <iostream>
#include <string>
#include <sstream>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <vector>
#include <map>
#include <nexus/napi.h>
#include <nexus/NeXusFile.hpp>
#include <unistd.h>
#include <boost/algorithm/string/detail/classification.hpp>
#include <boost/algorithm/string/split.hpp>

using std::cout;
using std::endl;
using std::map;
using std::multimap;
using std::string;
using std::vector;

struct CSNSuser
{
    std::string user="";
    std::string facility_user_id="";
    std::string name="";
    std::string role="";
    std::string affiliation="";
    std::string address="";
    std::string email="";
};
struct CSNSsample
{
    std::string name="";
    std::string type="";
    std::string chemical_formula="";
    float density=0.0;
    float mass=0.0;
    std::string situation="";
    float distance=0.0;
    std::string shape="";
    std::vector<float> size {0.0, 0.0, 0.0, 0.0, 0.0};
};
struct CSNSEventDataFormat
{
    int pixelId;
    float timeOfFlight;
    float pulseTime;
};
struct CSNSbank
{
    size_t spectrumIndex;
    float xPixelOffset;
    float yPixelOffset;
    float xLower;
    float xUpper;
    float yLower;
    float yUpper;
};
//----------------------------------------------------------------------
// Includes
//----------------------------------------------------------------------
//#include "MantidAPI/IFileLoader.h"
//#include "MantidAPI/Sample.h"
//#include "MantidAPI/SpectraDetectorTypes.h"
//#include "MantidDataObjects/Workspace2D.h"
//#include "MantidNexus/NexusClasses.h"
//#include "MantidKernel/DateAndTime.h"
//#include "MantidKernel/MultiThreaded.h"

/**
 Loads a NeXus file that conforms to the CSNS instrument definition format and
 stores it in a 2D workspace.

 Copyright &copy; 2007-8 ISIS Rutherford Appleton Laboratory, NScD Oak Ridge
 National Laboratory & European Spallation Source

 This file is part of Mantid.

 Mantid is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 Mantid is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 File change history is stored at: <https://github.com/mantidproject/mantid>
 */
class ReadCSNSNexus
{
public:
    /// Default Constructor
    ReadCSNSNexus();

    // Destructor
    virtual ~ReadCSNSNexus() {}

    /// Algorithm's name for identification overriding a virtual method
    virtual const std::string name() const
    {
        return "ReadCSNSNexus";
    }

    /// Summary of algorithms purpose
    virtual const std::string summary() const
    {
        return "Loads a NeXus file confirming to the CSNS format";
    }

    /// Algorithm's version for identification overriding a virtual method
    virtual int version() const
    {
        return 1;
    }

    /// Algorithm's category for identification overriding a virtual method
    virtual const std::string category() const
    {
        return "DataHandling\\Nexus";
    }

    /// Get entry name
    static std::string getEntryName(const std::string &filename);

    /// Get instrument name
    static std::string getInstrumentName(const std::string &filename);

    /// Get Run No
    static std::string getRunNo(const std::string &filename);

    /// Get Accelerator Run No
    static std::string getAcceleratorRunNo(const std::string &filename);

    /// Get Description
    static std::string getDescription(const std::string &filename);

    /// Get Proposal Id
    static std::string getProposalId(const std::string &filename);

    /// Get Beamline and Beamline number
    static std::string getBeamline(const std::string &filename);
    static size_t getBeamlineNo(const std::string &filename);

    /// Get Version
    static std::string getVersion(const std::string &filename);

    /// Get Nexus Version
    static std::string getNexusVersion(const std::string &filename);

    /// Get HDF5 Version
    static std::string getHdf5Version(const std::string &filename);

    /// Return if the filename changed
    static bool isFilenameChanged(const std::string &newfilename, std::string &oldfilename);

    /// Get file create time
    static std::string getCreateTime(const std::string &filename);

    /// Get start time
    static std::string getStartTime(const std::string &filename);

    /// Get end time
    static std::string getEndTime(const std::string &filename);

    /// Get sample name
    static std::string getSampleName(const std::string &filename);

    /// Get sample chemical formula
    static std::string getSampleChemicalFormula(const std::string &filename);

    /// Get sample type
    static std::string getSampleType(const std::string &filename);

    /// Get sample situation
    static std::string getSampleSituation(const std::string &filename);

    /// Get sample density
    static float getSampleDensity(const std::string &filename);

    /// Get sample distance
    static float getSampleDistance(const std::string &filename);

    /// Get sample mass
    static float getSampleMass(const std::string &filename);

    /// Get sample shape
    static std::string getSampleShape(const std::string &filename);

    /// Get sample size
    static std::vector<float> getSampleSize(const std::string &filename);

    /// Get Number bins
    static size_t getNumBins(const std::string &filename, const std::string &entry_name);

    /// Get numbers Pixels
    static size_t getNumPixels(const std::string &filename, const std::string &entry_name);

    /// List bank names
    static std::vector<std::string> getBankNames(const std::string &filename);

    /// List monitor names
    static std::vector<std::string> getMonitorNames(const std::string &filename);

    /// List Users name
    static std::vector<CSNSuser> getUsers(const std::string &filename);

    /// return  Sample
    static CSNSsample getSample(const std::string &filename);
    
    /// List Sample Environment Names
    static std::vector<std::string> getSampleEnvironment(const std::string &filename);

    /// List Sample Environment Log
    static std::vector<std::vector<float> > getSampleEnvironmentLog(const std::string &filename, const std::string &SEname);

    /// List Disk Chopper1 Names
    static std::vector<std::string> getDiskChopper1(const std::string &filename);

    /// List Disk Chopper1 Log
    static float getDiskChopper1Log(const std::string &filename, const std::string &DCname);

    /// List proton charge log
    static std::vector<std::vector<float> > getProtonChargeLog(const std::string &filename);

    /// List good frame log
    static std::vector<std::vector<float> > getGoodFrameLog(const std::string &filename);

    /// List chopper names
    static std::vector<std::string> getChopperNames(const std::string &filename);

    /// List chopper logs
    static std::vector<std::string> getChopperLogs(const std::string &filename, const std::string &chopperName);

    /// List chopper phase log
    static std::vector<std::vector<float> > getChopperPhaseLog(const std::string &filename, const std::string &chopperName);

    /// List chopper speed log
    static std::vector<std::vector<float> > getChopperSpeedLog(const std::string &filename, const std::string &chopperName);
    
    ///get event data of specilized banks
    static std::vector<CSNSEventDataFormat> getEventData(const std::string &filename,const std::string &bankName);
    /// Returns a confidence value that this algorithm can load a file
    //virtual int confidence(Kernel::NexusDescriptor &descriptor) const;

    /// Number of pixels
    size_t m_numPixels;

    /// Signal # to load. Default 1
    int m_signalNo;

    void exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max);
protected:
    void init();
    //void exec(const std::string &filename, size_t m_signalNo, size_t m_spec_min, size_t m_spec_max);

    /// Validate the optional input properties
    void checkOptionalProperties();

    /// Run LoadInstrument as a ChildAlgorithm
    //void runLoadInstrument(DataObjects::Workspace2D_sptr);
    void runLoadInstrument();

    /// Load in details about the sample
    //void loadSampleData(DataObjects::Workspace2D_sptr, Mantid::NeXus::NXEntry &entry);
    void loadSampleData(const std::string &entry_name);

    //void loadBank(const std::string &nexusfilename, const std::string &entry_name,
    //              const std::string &bankName, API::MatrixWorkspace_sptr WS,
    //              const detid2index_map &id_to_wi);

    void loadBank(const std::string &nexusfilename, const std::string &entry_name,
                  const std::string &bankName);
    /// List of the absolute time of each pulse
    //std::vector<Kernel::DateAndTime> pulseTimes;

    /// Number of bins
    size_t m_numBins;

    /// Interval of chunk
    //specid_t m_spec_min, m_spec_max;
    size_t m_spec_min, m_spec_max;

    /// Name of the 'data' field to load (depending on Signal)
    std::string m_dataField;

    /// Name of the 'axis' field to load (depending on Signal)
    std::string m_axisField;

    /// Units of the X axis found
    std::string m_xUnits;

    /// Mutex to avoid simultaneous file access
// Kernel::Mutex m_fileMutex;

};
#endif /* MANTID_DATAHANDLINGREACSNSNEXUS_H_ */
