/*
 * Decompiled with CFR 0.152.
 */
package org.nexusformat;

import java.io.File;
import java.util.Hashtable;
import ncsa.hdf.hdflib.HDFArray;
import ncsa.hdf.hdflib.HDFException;
import org.nexusformat.AttributeEntry;
import org.nexusformat.NXlink;
import org.nexusformat.NeXusFileInterface;
import org.nexusformat.NexusException;

public class NexusFile
implements NeXusFileInterface {
    public static final int NXACC_READ = 1;
    public static final int NXACC_RDWR = 2;
    public static final int NXACC_CREATE = 3;
    public static final int NXACC_CREATE4 = 4;
    public static final int NXACC_CREATE5 = 5;
    public static final int NXACC_CREATEXML = 6;
    public static final int NXACC_NOSTRIP = 128;
    public static final int NX_UNLIMITED = -1;
    public static final int NX_FLOAT32 = 5;
    public static final int NX_FLOAT64 = 6;
    public static final int NX_INT8 = 20;
    public static final int NX_BINARY = 20;
    public static final int NX_UINT8 = 21;
    public static final int NX_BOOLEAN = 21;
    public static final int NX_INT16 = 22;
    public static final int NX_UINT16 = 23;
    public static final int NX_INT32 = 24;
    public static final int NX_UINT32 = 25;
    public static final int NX_INT64 = 26;
    public static final int NX_UINT64 = 27;
    public static final int NX_CHAR = 4;
    public static final int NX_COMP_NONE = 100;
    public static final int NX_COMP_LZW = 200;
    public static final int NX_COMP_RLE = 300;
    public static final int NX_COMP_HUF = 400;
    public static final int NX_COMP_LZW_LVL0 = 20000;
    public static final int NX_COMP_LZW_LVL1 = 20001;
    public static final int NX_COMP_LZW_LVL2 = 20002;
    public static final int NX_COMP_LZW_LVL3 = 20003;
    public static final int NX_COMP_LZW_LVL4 = 20004;
    public static final int NX_COMP_LZW_LVL5 = 20005;
    public static final int NX_COMP_LZW_LVL6 = 20006;
    public static final int NX_COMP_LZW_LVL7 = 20007;
    public static final int NX_COMP_LZW_LVL8 = 20008;
    public static final int NX_COMP_LZW_LVL9 = 20009;
    protected static final int MAXNAMELEN = 64;
    protected int handle;

    protected native int init(String var1, int var2);

    protected native void close(int var1);

    protected native int nxflush(int var1);

    public NexusFile(String filename, int access) throws NexusException {
        this.checkForNull(filename);
        this.handle = this.init(filename, access);
        if (this.handle < 0) {
            throw new NexusException("Failed to open " + filename);
        }
    }

    @Override
    public void flush() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.handle = this.nxflush(this.handle);
    }

    @Override
    public void close() throws NexusException {
        if (this.handle >= 0) {
            this.close(this.handle);
            this.handle = -1;
        }
    }

    @Override
    public void finalize() throws Throwable {
        this.close();
    }

    protected native void nxmakegroup(int var1, String var2, String var3);

    protected native void nxopengroup(int var1, String var2, String var3);

    protected native void nxopenpath(int var1, String var2);

    protected native void nxopengrouppath(int var1, String var2);

    protected native void nxclosegroup(int var1);

    protected native String nxgetpath(int var1);

    @Override
    public void makegroup(String name, String nxclass) throws NexusException {
        this.checkForNull(name, nxclass);
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxmakegroup(this.handle, name, nxclass);
    }

    @Override
    public void opengroup(String name, String nxclass) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name, nxclass);
        this.nxopengroup(this.handle, name, nxclass);
    }

    @Override
    public void openpath(String path) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(path);
        this.nxopenpath(this.handle, path);
    }

    @Override
    public void opengrouppath(String path) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(path);
        this.nxopengrouppath(this.handle, path);
    }

    @Override
    public String getpath() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        return this.nxgetpath(this.handle);
    }

    @Override
    public void closegroup() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxclosegroup(this.handle);
    }

    protected native void nxmakedata(int var1, String var2, int var3, int var4, int[] var5);

    protected native void nxmakedata64(int var1, String var2, int var3, int var4, long[] var5);

    protected native void nxmakecompdata(int var1, String var2, int var3, int var4, int[] var5, int var6, int[] var7);

    protected native void nxmakecompdata64(int var1, String var2, int var3, int var4, long[] var5, int var6, long[] var7);

    protected native void nxopendata(int var1, String var2);

    protected native void nxclosedata(int var1);

    protected native void nxcompress(int var1, int var2);

    @Override
    public void compmakedata(String name, int type, int rank, int[] dim, int compression_type, int[] iChunk) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(type);
        this.checkForNull(name, rank, iChunk);
        this.checkForNegInArray(true, dim, iChunk);
        this.checkCompression(compression_type);
        this.nxmakecompdata(this.handle, name, type, rank, dim, compression_type, iChunk);
    }

    @Override
    public void compmakedata(String name, int type, int rank, long[] dim, int compression_type, long[] iChunk) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(type);
        this.checkForNull(name, rank, iChunk);
        this.checkForNegInArray(true, dim, iChunk);
        this.checkCompression(compression_type);
        this.nxmakecompdata64(this.handle, name, type, rank, dim, compression_type, iChunk);
    }

    @Override
    public void makedata(String name, int type, int rank, int[] dim) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(type);
        this.checkForNull(name, dim);
        this.checkForNegInArray(true, new int[][]{dim});
        this.nxmakedata(this.handle, name, type, rank, dim);
    }

    @Override
    public void makedata(String name, int type, int rank, long[] dim) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(type);
        this.checkForNull(name, dim);
        this.checkForNegInArray(true, new long[][]{dim});
        this.nxmakedata64(this.handle, name, type, rank, dim);
    }

    @Override
    public void opendata(String name) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name);
        this.nxopendata(this.handle, name);
    }

    @Override
    public void closedata() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxclosedata(this.handle);
    }

    @Override
    public void compress(int compression_type) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkCompression(compression_type);
        this.nxcompress(this.handle, compression_type);
    }

    protected native void nxgetdata(int var1, byte[] var2);

    protected native void nxgetslab(int var1, int[] var2, int[] var3, byte[] var4);

    protected native void nxgetslab64(int var1, long[] var2, long[] var3, byte[] var4);

    protected native void nxgetattr(int var1, String var2, byte[] var3, int[] var4);

    @Override
    public void getdata(Object array) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(array);
        try {
            HDFArray ha = new HDFArray(array);
            byte[] bdata = ha.emptyBytes();
            this.nxgetdata(this.handle, bdata);
            array = ha.arrayify(bdata);
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
    }

    @Override
    public void getslab(int[] start, int[] size, Object array) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(start, size, array);
        this.checkForNegInArray(false, start, size);
        try {
            HDFArray ha = new HDFArray(array);
            byte[] bdata = ha.emptyBytes();
            this.nxgetslab(this.handle, start, size, bdata);
            array = ha.arrayify(bdata);
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
    }

    @Override
    public void getslab(long[] start, long[] size, Object array) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(start, size, array);
        this.checkForNegInArray(false, start, size);
        try {
            HDFArray ha = new HDFArray(array);
            byte[] bdata = ha.emptyBytes();
            this.nxgetslab64(this.handle, start, size, bdata);
            array = ha.arrayify(bdata);
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
    }

    @Override
    public void getattr(String name, Object array, int[] args) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(args[1]);
        this.checkForNull(name, array);
        try {
            HDFArray ha = new HDFArray(array);
            byte[] bdata = ha.emptyBytes();
            this.nxgetattr(this.handle, name, bdata, args);
            array = ha.arrayify(bdata);
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
    }

    protected native void nxputdata(int var1, byte[] var2);

    protected native void nxputslab(int var1, byte[] var2, int[] var3, int[] var4);

    protected native void nxputslab64(int var1, byte[] var2, long[] var3, long[] var4);

    protected native void nxputattr(int var1, String var2, byte[] var3, int var4);

    @Override
    public void putdata(Object array) throws NexusException {
        byte[] data;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(array);
        try {
            HDFArray ha = new HDFArray(array);
            data = ha.byteify();
            ha = null;
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
        this.nxputdata(this.handle, data);
        data = null;
    }

    @Override
    public void putslab(Object array, int[] start, int[] size) throws NexusException {
        byte[] data;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(array, start, size);
        this.checkForNegInArray(false, start, size);
        try {
            HDFArray ha = new HDFArray(array);
            data = ha.byteify();
            ha = null;
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
        this.nxputslab(this.handle, data, start, size);
        data = null;
    }

    @Override
    public void putslab(Object array, long[] start, long[] size) throws NexusException {
        byte[] data;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(array, start, size);
        this.checkForNegInArray(false, start, size);
        try {
            HDFArray ha = new HDFArray(array);
            data = ha.byteify();
            ha = null;
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
        this.nxputslab64(this.handle, data, start, size);
        data = null;
    }

    @Override
    public void putattr(String name, Object array, int iType) throws NexusException {
        byte[] data;
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(iType);
        this.checkForNull(name, array);
        try {
            HDFArray ha = new HDFArray(array);
            data = ha.byteify();
            ha = null;
        }
        catch (HDFException he) {
            throw new NexusException(he.getMessage());
        }
        this.nxputattr(this.handle, name, data, iType);
        data = null;
    }

    protected native void nxgetinfo(int var1, int[] var2, int[] var3);

    protected native void nxgetinfo64(int var1, long[] var2, int[] var3);

    protected native void nxsetnumberformat(int var1, int var2, String var3);

    protected native int nextentry(int var1, String[] var2);

    protected native int nextattr(int var1, String[] var2, int[] var3);

    protected native void initattrdir(int var1);

    protected native void initgroupdir(int var1);

    @Override
    public void setnumberformat(int type, String format) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkType(type);
        this.checkForNull(format);
        this.nxsetnumberformat(this.handle, type, format);
    }

    @Override
    public void getinfo(int[] iDim, int[] args) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxgetinfo(this.handle, iDim, args);
    }

    @Override
    public void getinfo(long[] iDim, int[] args) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxgetinfo64(this.handle, iDim, args);
    }

    @Override
    public Hashtable groupdir() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        String[] names = new String[2];
        this.initgroupdir(this.handle);
        while (this.nextentry(this.handle, names) != -1) {
            h.put(names[0], names[1]);
        }
        return h;
    }

    @Override
    public Hashtable attrdir() throws NexusException {
        int[] args = new int[2];
        String[] names = new String[1];
        Hashtable<String, AttributeEntry> h = new Hashtable<String, AttributeEntry>();
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.initattrdir(this.handle);
        while (this.nextattr(this.handle, names, args) != -1) {
            AttributeEntry at = new AttributeEntry();
            at.length = args[0];
            at.type = args[1];
            h.put(names[0], at);
        }
        return h;
    }

    protected native void nxgetgroupid(int var1, NXlink var2);

    protected native void nxgetdataid(int var1, NXlink var2);

    protected native void nxmakelink(int var1, NXlink var2);

    protected native void nxmakenamedlink(int var1, String var2, NXlink var3);

    protected native void nxopensourcepath(int var1);

    @Override
    public NXlink getgroupID() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        NXlink l = new NXlink();
        this.nxgetgroupid(this.handle, l);
        return l;
    }

    @Override
    public NXlink getdataID() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        NXlink l = new NXlink();
        this.nxgetdataid(this.handle, l);
        return l;
    }

    @Override
    public void makelink(NXlink target) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(target);
        this.nxmakelink(this.handle, target);
    }

    @Override
    public void makenamedlink(String name, NXlink target) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name, target);
        this.nxmakenamedlink(this.handle, name, target);
    }

    @Override
    public void opensourcepath() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.nxopensourcepath(this.handle);
    }

    private void checkForNull(Object ... args) {
        for (Object o : args) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    private void checkForNegInArray(boolean allowUnlimited, int[] ... args) {
        int[][] nArray = args;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] array;
            for (int value : array = nArray[i]) {
                if (value >= 0) continue;
                if (value == -1 && allowUnlimited) continue;
                throw new IllegalArgumentException("negative dimension received");
            }
        }
    }

    private void checkForNegInArray(boolean allowUnlimited, long[] ... args) {
        long[][] lArray = args;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] array;
            for (long value : array = lArray[i]) {
                if (value >= 0L) continue;
                if (value == -1L && allowUnlimited) continue;
                throw new IllegalArgumentException("negative dimension received");
            }
        }
    }

    private void checkType(int type) throws NexusException {
        switch (type) {
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            default: {
                throw new NexusException("Illegal number type requested");
            }
        }
    }

    private void checkCompression(int compression_type) throws NexusException {
        switch (compression_type) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 20000: 
            case 20001: 
            case 20002: 
            case 20003: 
            case 20004: 
            case 20005: 
            case 20006: 
            case 20007: 
            case 20008: 
            case 20009: {
                break;
            }
            default: {
                throw new NexusException("Invalid compression code requested");
            }
        }
    }

    protected native void nxinquirefile(int var1, String[] var2);

    protected native void nxlinkexternal(int var1, String var2, String var3, String var4);

    protected native void nxlinkexternaldataset(int var1, String var2, String var3);

    protected native int nxisexternalgroup(int var1, String var2, String var3, String[] var4);

    protected native int nxisexternaldataset(int var1, String var2, String[] var3);

    @Override
    public String inquirefile() throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        String[] names = new String[1];
        this.nxinquirefile(this.handle, names);
        return names[0];
    }

    @Override
    public void linkexternal(String name, String nxclass, String nxurl) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name, nxclass, nxurl);
        this.nxlinkexternal(this.handle, name, nxclass, nxurl);
    }

    @Override
    public void linkexternaldataset(String name, String nxurl) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name, nxurl);
        this.nxlinkexternaldataset(this.handle, name, nxurl);
    }

    @Override
    public String isexternalgroup(String name, String nxclass) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name, nxclass);
        String[] nxurl = new String[1];
        int status = this.nxisexternalgroup(this.handle, name, nxclass, nxurl);
        if (status == 1) {
            return nxurl[0];
        }
        return null;
    }

    @Override
    public String isexternaldataset(String name) throws NexusException {
        if (this.handle < 0) {
            throw new NexusException("NAPI-ERROR: File not open");
        }
        this.checkForNull(name);
        String[] nxurl = new String[1];
        int status = this.nxisexternaldataset(this.handle, name, nxurl);
        if (status == 1) {
            return nxurl[0];
        }
        return null;
    }

    public native void debugstop();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        String filename = null;
        filename = System.getProperty("org.nexusformat.JNEXUSLIB", null);
        if (filename != null && filename.length() > 0) {
            File hdfdll = new File(filename);
            if (!hdfdll.exists() || !hdfdll.canRead() || !hdfdll.isFile()) throw new UnsatisfiedLinkError("Invalid JNEXUS library");
            System.load(filename);
            return;
        } else {
            System.loadLibrary("jnexus");
        }
    }
}

