/*
 * Decompiled with CFR 0.152.
 */
package cn.ac.csns.nexus.csnsnexustemplate;

import cn.ac.csns.nexus.csnsnexustemplate.CSNSuser;
import cn.ac.csns.nexus.csnsnexustemplate.CalendarTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.nexusformat.NXlink;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;

public class CsnsNexusTemplateGenerator {
    public static final String TOOL_NAME = CsnsNexusTemplateGenerator.class.getCanonicalName();
    public static final String VERSION = "1.0-Alpha";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genNexusTemplate(String file, String instrumentName, String fileFormat) {
        NexusFile nexusFile = null;
        try {
            if (fileFormat != null) {
                switch (fileFormat = fileFormat.toLowerCase()) {
                    case "hdf5": {
                        nexusFile = new NexusFile(file, 5);
                        break;
                    }
                    case "hdf4": {
                        nexusFile = new NexusFile(file, 4);
                        break;
                    }
                    case "xml": {
                        nexusFile = new NexusFile(file, 6);
                        break;
                    }
                    default: {
                        throw new NexusException("File format not supported: " + fileFormat + ".");
                    }
                }
            } else {
                nexusFile = new NexusFile(file, 5);
            }
        }
        catch (NexusException ex) {
            Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            System.exit(0);
        }
        try {
            CsnsNexusTemplateGenerator.genGlobalAttributes(nexusFile);
            nexusFile.makegroup("entry", "NXentry");
            nexusFile.opengroup("entry", "NXentry");
            CsnsNexusTemplateGenerator.genPublicFields(nexusFile, instrumentName);
            CsnsNexusTemplateGenerator.genUserInfo(nexusFile);
            CsnsNexusTemplateGenerator.genProcess(nexusFile);
            CsnsNexusTemplateGenerator.genInstrument(nexusFile, instrumentName);
            CsnsNexusTemplateGenerator.genPresentData(nexusFile, instrumentName);
            CsnsNexusTemplateGenerator.genHistogramData(nexusFile, instrumentName);
            CsnsNexusTemplateGenerator.genEventData(nexusFile, instrumentName);
            CsnsNexusTemplateGenerator.genLogs(nexusFile);
            nexusFile.closegroup();
            nexusFile.closegroup();
        }
        catch (NexusException ex) {
            Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                nexusFile.close();
            }
            catch (NexusException ex) {
                Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private static void genGlobalAttributes(NexusFile nexusFile) throws NexusException {
        String creator = TOOL_NAME + ", version: " + VERSION;
        nexusFile.putattr("creator", (Object)creator.getBytes(), 4);
    }

    private static void genUserInfo(NexusFile nexusFile) throws NexusException {
        String groupName = "users";
        CSNSuser user1 = new CSNSuser("user1", "tangm", "M Tang", "principal_investigator", "IHEP", "Zhongziyuan Road No.1, Dongguan, Guangdong, China", "tangm@ihep.ac.cn");
        CSNSuser user2 = new CSNSuser("user2", "dur", "R Du", "investigator", "IHEP", "Zhongziyuan Road No.1, Dongguan, Guangdong, China", "durong@ihep.ac.cn");
        ArrayList<CSNSuser> userGroup = new ArrayList<CSNSuser>();
        userGroup.add(user1);
        userGroup.add(user2);
        nexusFile.makegroup(groupName, "NXcollection");
        nexusFile.opengroup(groupName, "NXcollection");
        for (int i = 0; i < userGroup.size(); ++i) {
            nexusFile.makegroup(((CSNSuser)userGroup.get(i)).getUser(), "NXuser");
            nexusFile.opengroup(((CSNSuser)userGroup.get(i)).getUser(), "NXuser");
            String _tmp = ((CSNSuser)userGroup.get(i)).getFacilityUserId();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "facility_user_id", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            _tmp = ((CSNSuser)userGroup.get(i)).getName();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "name", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            _tmp = ((CSNSuser)userGroup.get(i)).getRole();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "role", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            _tmp = ((CSNSuser)userGroup.get(i)).getAffiliation();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "affiliation", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            _tmp = ((CSNSuser)userGroup.get(i)).getAddress();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "address", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            _tmp = ((CSNSuser)userGroup.get(i)).getEmail();
            CsnsNexusTemplateGenerator.writeData(nexusFile, "email", 4, 1, new int[]{_tmp.length()}, _tmp.getBytes());
            nexusFile.closegroup();
        }
        nexusFile.closegroup();
    }

    private static void genProcess(NexusFile nexusFile) throws NexusException {
        int[] dim = new int[1];
        String author = "Li Si";
        String algorithm = "GPPD_builder_1.0.py";
        String parameters = "-l 1 -c \"6Li.dat\" -i \"BLxx_xxxx_0000001_001.raw\"";
        String description = "This is event data builder.";
        String data = "GPPD_builder_1.0.py -l 1 -c \"6Li.dat\" -i \"BLxx_xxxx_0000001_001.raw\"";
        String date = "2015-05-21T16:49:36+08:00";
        nexusFile.makegroup("process", "NXprocess");
        nexusFile.opengroup("process", "NXprocess");
        nexusFile.makegroup("process1", "NXnote");
        nexusFile.opengroup("process1", "NXnote");
        dim[0] = "Li Si".length();
        nexusFile.makedata("author", 4, 1, dim);
        nexusFile.opendata("author");
        nexusFile.putdata((Object)"Li Si".getBytes());
        nexusFile.closedata();
        dim[0] = "GPPD_builder_1.0.py -l 1 -c \"6Li.dat\" -i \"BLxx_xxxx_0000001_001.raw\"".length();
        nexusFile.makedata("data", 4, 1, dim);
        nexusFile.opendata("data");
        nexusFile.putdata((Object)"GPPD_builder_1.0.py -l 1 -c \"6Li.dat\" -i \"BLxx_xxxx_0000001_001.raw\"".getBytes());
        nexusFile.closedata();
        dim[0] = "This is event data builder.".length();
        nexusFile.makedata("description", 4, 1, dim);
        nexusFile.opendata("description");
        nexusFile.putdata((Object)"This is event data builder.".getBytes());
        nexusFile.closedata();
        dim[0] = "2015-05-21T16:49:36+08:00".length();
        nexusFile.makedata("date", 4, 1, dim);
        nexusFile.opendata("date");
        nexusFile.putdata((Object)"2015-05-21T16:49:36+08:00".getBytes());
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.closegroup();
    }

    private static void genLogs(NexusFile nexusFile) throws NexusException {
        int rank = 1;
        int size = 90;
        nexusFile.makegroup("logs", "NXcollection");
        nexusFile.opengroup("logs", "NXcollection");
        float[][] protonCharge = CsnsNexusTemplateGenerator.genProtonCharge(size, 0.04f);
        nexusFile.makegroup("proton_charge", "NXlog");
        nexusFile.opengroup("proton_charge", "NXlog");
        nexusFile.makedata("time", 5, rank, new int[]{size});
        nexusFile.opendata("time");
        nexusFile.putdata((Object)protonCharge[0]);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, new int[]{size});
        nexusFile.opendata("value");
        nexusFile.putdata((Object)protonCharge[1]);
        nexusFile.putattr("units", (Object)"pC".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        float[][] goodFrame = CsnsNexusTemplateGenerator.genGoodFrame(size, 0.04f);
        nexusFile.makegroup("good_frame", "NXlog");
        nexusFile.opengroup("good_frame", "NXlog");
        nexusFile.makedata("time", 5, rank, new int[]{size});
        nexusFile.opendata("time");
        nexusFile.putdata((Object)goodFrame[0]);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, new int[]{size});
        nexusFile.opendata("value");
        nexusFile.putdata((Object)goodFrame[1]);
        nexusFile.closedata();
        nexusFile.closegroup();
        float[][] chopperPhase = CsnsNexusTemplateGenerator.genChopperPhase(size, 0.04f);
        nexusFile.makegroup("disk_chopper_phase1", "NXlog");
        nexusFile.opengroup("disk_chopper_phase1", "NXlog");
        nexusFile.makedata("time", 5, rank, new int[]{size});
        nexusFile.opendata("time");
        nexusFile.putdata((Object)chopperPhase[0]);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, new int[]{size});
        nexusFile.opendata("value");
        nexusFile.putdata((Object)chopperPhase[1]);
        nexusFile.closedata();
        nexusFile.closegroup();
        CsnsNexusTemplateGenerator.genSampleEnvLogs(nexusFile);
        nexusFile.closegroup();
    }

    private static void genSampleEnvLogs(NexusFile nexusFile) throws NexusException {
        int rank = 1;
        float[] value = new float[]{0.0f, 15.0f};
        float[] time = new float[]{0.0f, 25.0f};
        int[] dim = new int[]{2};
        nexusFile.makegroup("sample_environment", "NXcollection");
        nexusFile.opengroup("sample_environment", "NXcollection");
        nexusFile.makegroup("temperature", "NXlog");
        nexusFile.opengroup("temperature", "NXlog");
        nexusFile.makedata("time", 5, rank, dim);
        nexusFile.opendata("time");
        nexusFile.putdata((Object)time);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, dim);
        nexusFile.opendata("value");
        nexusFile.putdata((Object)value);
        nexusFile.putattr("units", (Object)"K".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.makegroup("magnetic_field", "NXlog");
        nexusFile.opengroup("magnetic_field", "NXlog");
        nexusFile.makedata("time", 5, rank, dim);
        nexusFile.opendata("time");
        nexusFile.putdata((Object)time);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, dim);
        nexusFile.opendata("value");
        nexusFile.putdata((Object)value);
        nexusFile.putattr("units", (Object)"T".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.makegroup("electric_field", "NXlog");
        nexusFile.opengroup("electric_field", "NXlog");
        nexusFile.makedata("time", 5, rank, dim);
        nexusFile.opendata("time");
        nexusFile.putdata((Object)time);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, dim);
        nexusFile.opendata("value");
        nexusFile.putdata((Object)value);
        nexusFile.putattr("units", (Object)"V m-1".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.makegroup("pressure", "NXlog");
        nexusFile.opengroup("pressure", "NXlog");
        nexusFile.makedata("time", 5, rank, dim);
        nexusFile.opendata("time");
        nexusFile.putdata((Object)time);
        nexusFile.putattr("units", (Object)"s".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("value", 5, rank, dim);
        nexusFile.opendata("value");
        nexusFile.putdata((Object)value);
        nexusFile.putattr("units", (Object)"Pa".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.closegroup();
    }

    private static void genInstrument(NexusFile nexusFile, String instrumentName) throws NexusException {
        nexusFile.makegroup("instrument", "NXinstrument");
        nexusFile.opengroup("instrument", "NXinstrument");
        CsnsNexusTemplateGenerator.genSource(nexusFile);
        CsnsNexusTemplateGenerator.genModerator(nexusFile);
        CsnsNexusTemplateGenerator.genAperture(nexusFile, instrumentName);
        CsnsNexusTemplateGenerator.genBeamStop(nexusFile, instrumentName);
        CsnsNexusTemplateGenerator.genDiskChopper(nexusFile);
        CsnsNexusTemplateGenerator.genFlipper(nexusFile);
        CsnsNexusTemplateGenerator.genPolarizer(nexusFile);
        CsnsNexusTemplateGenerator.genEnvironment(nexusFile);
        CsnsNexusTemplateGenerator.genSample(nexusFile, instrumentName);
        CsnsNexusTemplateGenerator.genDetector(nexusFile, instrumentName);
        CsnsNexusTemplateGenerator.genMonitor(nexusFile);
        nexusFile.closegroup();
    }

    private static void genSource(NexusFile nexusFile) throws NexusException {
        int[] dim = new int[1];
        nexusFile.makegroup("source", "NXsource");
        nexusFile.opengroup("source", "NXsource");
        dim[0] = "CSNS".length();
        nexusFile.makedata("name", 4, 1, dim);
        nexusFile.opendata("name");
        nexusFile.putdata((Object)"CSNS".getBytes());
        nexusFile.closedata();
        dim[0] = "Spallation Neutron Source".length();
        nexusFile.makedata("type", 4, 1, dim);
        nexusFile.opendata("type");
        nexusFile.putdata((Object)"Spallation Neutron Source".getBytes());
        nexusFile.closedata();
        dim[0] = "neutron".length();
        nexusFile.makedata("probe", 4, 1, dim);
        nexusFile.opendata("probe");
        nexusFile.putdata((Object)"neutron".getBytes());
        nexusFile.closedata();
        nexusFile.makedata("frequency", 5, 1, new int[]{1});
        nexusFile.opendata("frequency");
        nexusFile.putdata((Object)new float[]{25.0f});
        nexusFile.putattr("units", (Object)"Hz".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("power", 5, 1, new int[]{1});
        nexusFile.opendata("power");
        nexusFile.putdata((Object)new float[]{-1.0f});
        nexusFile.putattr("units", (Object)"W".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genModerator(NexusFile nexusFile) throws NexusException {
        int[] dim = new int[1];
        nexusFile.makegroup("moderator", "NXmoderator");
        nexusFile.opengroup("moderator", "NXmoderator");
        String type = "Liquid H2";
        dim[0] = type.length();
        nexusFile.makedata("type", 4, 1, dim);
        nexusFile.opendata("type");
        nexusFile.putdata((Object)type.getBytes());
        nexusFile.closedata();
        nexusFile.makedata("distance", 5, 1, new int[]{1});
        nexusFile.opendata("distance");
        nexusFile.putdata((Object)new float[]{30.0f});
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("coupled", 21, 1, new int[]{1});
        nexusFile.opendata("coupled");
        nexusFile.putdata((Object)new short[]{0});
        nexusFile.closedata();
        dim[0] = "Gd".length();
        nexusFile.makedata("poison_material", 4, 1, dim);
        nexusFile.opendata("poison_material");
        nexusFile.putdata((Object)"NONE".getBytes());
        nexusFile.closedata();
        nexusFile.makedata("temperature", 5, 1, new int[]{1});
        nexusFile.opendata("temperature");
        nexusFile.putdata((Object)new float[]{20.0f});
        nexusFile.putattr("units", (Object)"K".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genAperture(NexusFile nexusFile, String instrumentName) throws NexusException {
        float[] size;
        int[] dim = new int[1];
        nexusFile.makegroup("aperture1", "NXaperture");
        nexusFile.opengroup("aperture1", "NXaperture");
        nexusFile.makegroup("geometry", "NXgeometry");
        nexusFile.opengroup("geometry", "NXgeometry");
        nexusFile.makegroup("shape", "NXshape");
        nexusFile.opengroup("shape", "NXshape");
        if (instrumentName.equalsIgnoreCase("GPPD") || instrumentName.equalsIgnoreCase("MR")) {
            dim[0] = "nxbox".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxbox".getBytes());
            nexusFile.closedata();
            dim[0] = 3;
            size = new float[]{0.04f, -1.0f, 0.1f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
        }
        if (instrumentName.equalsIgnoreCase("SANS")) {
            dim[0] = "nxelliptical".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxelliptical".getBytes());
            nexusFile.closedata();
            dim[0] = 3;
            size = new float[]{0.01f, 0.01f, 90.0f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m,m,degree".getBytes(), 4);
            nexusFile.closedata();
        }
        nexusFile.closegroup();
        nexusFile.makegroup("translation", "NXtranslation");
        nexusFile.opengroup("translation", "NXtranslation");
        dim[0] = 3;
        float[] distances = new float[]{0.0f, 0.0f, 10.0f};
        nexusFile.makedata("distances", 5, 1, dim);
        nexusFile.opendata("distances");
        nexusFile.putdata((Object)distances);
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.makegroup("orientation", "NXorientation");
        nexusFile.opengroup("orientation", "NXorientation");
        dim[0] = 6;
        float[] value = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        nexusFile.makedata("value", 5, 1, dim);
        nexusFile.opendata("value");
        nexusFile.putdata((Object)value);
        nexusFile.closedata();
        nexusFile.closegroup();
        nexusFile.closegroup();
        nexusFile.makedata("offset", 5, 1, new int[]{2});
        nexusFile.opendata("offset");
        nexusFile.putdata((Object)new float[]{0.01f, 0.01f});
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genBeamStop(NexusFile nexusFile, String instrumentName) throws NexusException {
        int[] dim = new int[1];
        if (instrumentName.equalsIgnoreCase("SANS")) {
            nexusFile.makegroup("beam_stop", "NXbeam_stop");
            nexusFile.opengroup("beam_stop", "NXbeam_stop");
            nexusFile.makegroup("geometry", "NXgeometry");
            nexusFile.opengroup("geometry", "NXgeometry");
            nexusFile.makegroup("shape", "NXshape");
            nexusFile.opengroup("shape", "NXshape");
            dim[0] = "nxelliptical".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxelliptical".getBytes());
            nexusFile.closedata();
            dim[0] = 3;
            float[] size = new float[]{0.01f, 0.01f, 90.0f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m,m,degree".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
            nexusFile.makegroup("translation", "NXtranslation");
            nexusFile.opengroup("translation", "NXtranslation");
            dim[0] = 3;
            float[] distances = new float[]{0.0f, 0.0f, 15.0f};
            nexusFile.makedata("distances", 5, 1, dim);
            nexusFile.opendata("distances");
            nexusFile.putdata((Object)distances);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
            nexusFile.makegroup("orientation", "NXorientation");
            nexusFile.opengroup("orientation", "NXorientation");
            dim[0] = 6;
            float[] value = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
            nexusFile.makedata("value", 5, 1, dim);
            nexusFile.opendata("value");
            nexusFile.putdata((Object)value);
            nexusFile.closedata();
            nexusFile.closegroup();
            nexusFile.closegroup();
            nexusFile.makedata("offset", 5, 1, new int[]{2});
            nexusFile.opendata("offset");
            nexusFile.putdata((Object)new float[]{0.0f, 0.0f});
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
        }
    }

    private static void genDiskChopper(NexusFile nexusFile) throws NexusException {
        int i;
        ArrayList<String> chopperGroup = new ArrayList<String>();
        ArrayList<Float> distanceGroup = new ArrayList<Float>();
        ArrayList<Float> speedGroup = new ArrayList<Float>();
        for (i = 0; i < 2; ++i) {
            chopperGroup.add("disk_chopper" + i);
            distanceGroup.add(Float.valueOf((float)(i + 1) * 10.0f - 1.0f));
            speedGroup.add(Float.valueOf(25.0f / (float)(i + 1)));
        }
        for (i = 0; i < 2; ++i) {
            nexusFile.makegroup((String)chopperGroup.get(i), "NXdisk_chopper");
            nexusFile.opengroup((String)chopperGroup.get(i), "NXdisk_chopper");
            nexusFile.makedata("rotation_speed", 5, 1, new int[]{1});
            nexusFile.opendata("rotation_speed");
            nexusFile.putdata((Object)new float[]{((Float)speedGroup.get(i)).floatValue()});
            nexusFile.putattr("units", (Object)"Hz".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.makedata("slit_angle", 5, 1, new int[]{1});
            nexusFile.opendata("slit_angle");
            nexusFile.putdata((Object)new float[]{30.0f});
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.makedata("phase", 5, 1, new int[]{1});
            nexusFile.opendata("phase");
            nexusFile.putdata((Object)new float[]{10.0f});
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.makedata("distance", 5, 1, new int[]{1});
            nexusFile.opendata("distance");
            nexusFile.putdata((Object)new float[]{((Float)distanceGroup.get(i)).floatValue()});
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
        }
    }

    private static void genFlipper(NexusFile nexusFile) throws NexusException {
        int[] dim = new int[1];
        nexusFile.makegroup("flipper1", "NXflipper");
        nexusFile.opengroup("flipper1", "NXflipper");
        dim[0] = "coil".length();
        nexusFile.makedata("type", 4, 1, dim);
        nexusFile.opendata("type");
        nexusFile.putdata((Object)"coil".getBytes());
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genPolarizer(NexusFile nexusFile) throws NexusException {
        int[] dim = new int[1];
        nexusFile.makegroup("polarizer1", "NXpolarizer");
        nexusFile.opengroup("polarizer1", "NXpolarizer");
        dim[0] = "crystal".length();
        nexusFile.makedata("type", 4, 1, dim);
        nexusFile.opendata("type");
        nexusFile.putdata((Object)"crystal".getBytes());
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genEnvironment(NexusFile nexusFile) throws NexusException {
        nexusFile.makegroup("sample_environment", "NXenvironment");
        nexusFile.opengroup("sample_environment", "NXenvironment");
        nexusFile.makedata("name", 4, 1, new int[]{"OC100 011".length()});
        nexusFile.opendata("name");
        nexusFile.putdata((Object)"OC100 011".getBytes());
        nexusFile.closedata();
        nexusFile.makedata("type", 4, 1, new int[]{"OC100".length()});
        nexusFile.opendata("type");
        nexusFile.putdata((Object)"OC/100".getBytes());
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genSample(NexusFile nexusFile, String instrumentName) throws NexusException {
        float[] size;
        int[] dim = new int[1];
        nexusFile.makegroup("sample", "NXsample");
        nexusFile.opengroup("sample", "NXsample");
        dim[0] = "Silicon".length();
        nexusFile.makedata("name", 4, 1, dim);
        nexusFile.opendata("name");
        nexusFile.putdata((Object)"Silicon".getBytes());
        nexusFile.closedata();
        dim[0] = "Si".length();
        nexusFile.makedata("chemical_formula", 4, 1, dim);
        nexusFile.opendata("chemical_formula");
        nexusFile.putdata((Object)"Si".getBytes());
        nexusFile.closedata();
        nexusFile.makedata("mass", 5, 1, new int[]{1});
        nexusFile.opendata("mass");
        nexusFile.putdata((Object)new float[]{5.0f});
        nexusFile.putattr("units", (Object)"g".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("density", 5, 1, new int[]{1});
        nexusFile.opendata("density");
        nexusFile.putdata((Object)new float[]{1.8f});
        nexusFile.putattr("units", (Object)"g cm-3".getBytes(), 4);
        nexusFile.closedata();
        dim[0] = "sample".length();
        nexusFile.makedata("type", 4, 1, dim);
        nexusFile.opendata("type");
        nexusFile.putdata((Object)"sample".getBytes());
        nexusFile.closedata();
        dim[0] = "vacuum".length();
        nexusFile.makedata("situation", 4, 1, dim);
        nexusFile.opendata("situation");
        nexusFile.putdata((Object)"vacuum".getBytes());
        nexusFile.closedata();
        nexusFile.makedata("distance", 5, 1, new int[]{1});
        nexusFile.opendata("distance");
        nexusFile.putdata((Object)new float[]{30.0f});
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makegroup("geometry", "NXgeometry");
        nexusFile.opengroup("geometry", "NXgeometry");
        nexusFile.makegroup("shape", "NXshape");
        nexusFile.opengroup("shape", "NXshape");
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            dim[0] = "nxcylinder".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxcylinder".getBytes());
            nexusFile.closedata();
            dim[0] = 5;
            size = new float[]{0.01f, 0.1f, 0.0f, 1.0f, 0.0f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
        }
        if (instrumentName.equalsIgnoreCase("MR")) {
            dim[0] = "nxbox".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxbox".getBytes());
            nexusFile.closedata();
            dim[0] = 3;
            size = new float[]{0.01f, 0.001f, 0.01f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
        }
        if (instrumentName.equalsIgnoreCase("SANS")) {
            dim[0] = "nxbox".length();
            nexusFile.makedata("shape", 4, 1, dim);
            nexusFile.opendata("shape");
            nexusFile.putdata((Object)"nxbox".getBytes());
            nexusFile.closedata();
            dim[0] = 3;
            size = new float[]{0.02f, 0.001f, -1.0f};
            nexusFile.makedata("size", 5, 1, dim);
            nexusFile.opendata("size");
            nexusFile.putdata((Object)size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
        }
        nexusFile.closegroup();
        nexusFile.closegroup();
        nexusFile.closegroup();
    }

    private static void genDetector(NexusFile nexusFile, String instrumentName) throws NexusException {
        int i;
        int x_pixel = 4;
        int y_pixel = 128;
        int z_pixel = 5000;
        int eventsNumber = 1485;
        int clockPulses = 25;
        int[] dim = new int[1];
        ArrayList<String> bankGroup = new ArrayList<String>();
        ArrayList<String> bankGroupName = new ArrayList<String>();
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            for (i = 0; i < 3; ++i) {
                bankGroup.add("bank" + i);
                bankGroupName.add("backward" + i);
            }
        } else if (instrumentName.equalsIgnoreCase("SANS")) {
            bankGroup.add("bank");
            bankGroupName.add("main");
        } else if (instrumentName.equalsIgnoreCase("MR")) {
            bankGroup.add("bank");
            bankGroupName.add("main");
        }
        for (i = 0; i < bankGroup.size(); ++i) {
            nexusFile.makegroup((String)bankGroup.get(i), "NXdetector");
            nexusFile.opengroup((String)bankGroup.get(i), "NXdetector");
            CsnsNexusTemplateGenerator.writeData(nexusFile, "local_name", 4, 1, new int[]{((String)bankGroupName.get(i)).length()}, ((String)bankGroupName.get(i)).getBytes());
            nexusFile.makedata("distance", 5, 1, new int[]{1});
            nexusFile.opendata("distance");
            nexusFile.putdata((Object)new float[]{40 + i});
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            int[][] ids = CsnsNexusTemplateGenerator.genIntData2D(x_pixel, y_pixel, 0, 1);
            nexusFile.makedata("pixel_id", 24, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("pixel_id");
            nexusFile.putdata((Object)ids);
            nexusFile.closedata();
            int[] spectrumIndex = CsnsNexusTemplateGenerator.genIntData1D(x_pixel * y_pixel, 0, 1);
            nexusFile.makedata("spectrum_index", 24, 1, new int[]{x_pixel * y_pixel});
            nexusFile.opendata("spectrum_index");
            nexusFile.putdata((Object)spectrumIndex);
            nexusFile.closedata();
            dim = new int[]{x_pixel, y_pixel};
            float[][] polar_angle = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 100);
            nexusFile.makedata("polar_angle", 5, 2, dim);
            nexusFile.opendata("polar_angle");
            nexusFile.putdata((Object)polar_angle);
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            float[][] azimuthal_angle = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 100);
            nexusFile.makedata("azimuthal_angle", 5, 2, dim);
            nexusFile.opendata("azimuthal_angle");
            nexusFile.putdata((Object)azimuthal_angle);
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            float[] x_pixel_offset = CsnsNexusTemplateGenerator.genPixelOffset1D(x_pixel, 0.0f, 5.0f);
            nexusFile.makedata("x_pixel_offset", 5, 1, new int[]{x_pixel});
            nexusFile.opendata("x_pixel_offset");
            nexusFile.putdata((Object)x_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{1}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"x pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[] y_pixel_offset = CsnsNexusTemplateGenerator.genPixelOffset1D(y_pixel, 0.0f, 10.0f);
            nexusFile.makedata("y_pixel_offset", 5, 1, new int[]{y_pixel});
            nexusFile.opendata("y_pixel_offset");
            nexusFile.putdata((Object)y_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{2}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"y pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            dim[0] = 1;
            float[] z_pixel_offset = new float[]{0.0f};
            nexusFile.makedata("z_pixel_offset", 5, 1, dim);
            nexusFile.opendata("z_pixel_offset");
            nexusFile.putdata((Object)z_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{3}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"z pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            dim = new int[]{x_pixel, y_pixel};
            float[][] x_pixel_size = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 1);
            nexusFile.makedata("x_pixel_size", 5, 2, dim);
            nexusFile.opendata("x_pixel_size");
            nexusFile.putdata((Object)x_pixel_size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[][] y_pixel_size = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 1);
            nexusFile.makedata("y_pixel_size", 5, 2, dim);
            nexusFile.opendata("y_pixel_size");
            nexusFile.putdata((Object)y_pixel_size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            int[] timeOfFlight = CsnsNexusTemplateGenerator.genTimeOfFlight(z_pixel, 8);
            nexusFile.makedata("time_of_flight", 24, 1, new int[]{z_pixel});
            nexusFile.opendata("time_of_flight");
            nexusFile.putdata((Object)timeOfFlight);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.putattr("axis", (Object)new int[]{3}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"Time Of Flight (s)".getBytes(), 4);
            nexusFile.closedata();
            int[] eventPixelId = CsnsNexusTemplateGenerator.genIntRandom1D(eventsNumber, 0, x_pixel * y_pixel);
            nexusFile.makedata("event_pixel_id", 24, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_pixel_id");
            nexusFile.putdata((Object)eventPixelId);
            nexusFile.closedata();
            float[] eventTimeOfFlight = CsnsNexusTemplateGenerator.genFloatRandom1D(eventsNumber, 0, clockPulses);
            nexusFile.makedata("event_time_of_flight", 5, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_time_of_flight");
            nexusFile.putdata((Object)eventTimeOfFlight);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.closedata();
            float[] eventPulseTime = CsnsNexusTemplateGenerator.genFloatPulseTime(eventsNumber, 0.04f);
            nexusFile.makedata("event_pulse_time", 5, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_pulse_time");
            nexusFile.putdata((Object)eventPulseTime);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
        }
    }

    private static void genMonitor(NexusFile nexusFile) throws NexusException {
        int i;
        int x_pixel = 16;
        int y_pixel = 16;
        int z_pixel = 5000;
        int eventsNumber = 785;
        int clockPulses = 25;
        ArrayList<String> monitorGroup = new ArrayList<String>();
        ArrayList<Float> distanceGroup = new ArrayList<Float>();
        for (i = 0; i < 2; ++i) {
            monitorGroup.add("monitor" + i);
            distanceGroup.add(Float.valueOf((float)(i + 1) * 10.0f));
        }
        for (i = 0; i < 2; ++i) {
            nexusFile.makegroup((String)monitorGroup.get(i), "NXdetector");
            nexusFile.opengroup((String)monitorGroup.get(i), "NXdetector");
            nexusFile.makedata("local_name", 4, 1, new int[]{((String)monitorGroup.get(i)).length()});
            nexusFile.opendata("local_name");
            nexusFile.putdata((Object)((String)monitorGroup.get(i)).getBytes());
            nexusFile.closedata();
            nexusFile.makedata("distance", 5, 1, new int[]{1});
            nexusFile.opendata("distance");
            nexusFile.putdata((Object)new float[]{((Float)distanceGroup.get(i)).floatValue()});
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            int[][] ids = CsnsNexusTemplateGenerator.genIntData2D(x_pixel, y_pixel, 0, 1);
            nexusFile.makedata("pixel_id", 24, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("pixel_id");
            nexusFile.putdata((Object)ids);
            nexusFile.closedata();
            int[] spectrumIndex = CsnsNexusTemplateGenerator.genIntData1D(x_pixel * y_pixel, 0, 1);
            nexusFile.makedata("spectrum_index", 24, 1, new int[]{x_pixel * y_pixel});
            nexusFile.opendata("spectrum_index");
            nexusFile.putdata((Object)spectrumIndex);
            nexusFile.closedata();
            float[][] polar_angle = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 100);
            nexusFile.makedata("polar_angle", 5, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("polar_angle");
            nexusFile.putdata((Object)polar_angle);
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            float[][] azimuthal_angle = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 100);
            nexusFile.makedata("azimuthal_angle", 5, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("azimuthal_angle");
            nexusFile.putdata((Object)azimuthal_angle);
            nexusFile.putattr("units", (Object)"degree".getBytes(), 4);
            nexusFile.closedata();
            float[] x_pixel_offset = CsnsNexusTemplateGenerator.genPixelOffset1D(x_pixel, 1.0f, 2.0f);
            nexusFile.makedata("x_pixel_offset", 5, 1, new int[]{x_pixel});
            nexusFile.opendata("x_pixel_offset");
            nexusFile.putdata((Object)x_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{1}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"x pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[] y_pixel_offset = CsnsNexusTemplateGenerator.genPixelOffset1D(y_pixel, 1.0f, 2.0f);
            nexusFile.makedata("y_pixel_offset", 5, 1, new int[]{y_pixel});
            nexusFile.opendata("y_pixel_offset");
            nexusFile.putdata((Object)y_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{2}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"y pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[] z_pixel_offset = new float[]{0.0f};
            nexusFile.makedata("z_pixel_offset", 5, 1, new int[]{1});
            nexusFile.opendata("z_pixel_offset");
            nexusFile.putdata((Object)z_pixel_offset);
            nexusFile.putattr("axis", (Object)new int[]{3}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"z pixel offset".getBytes(), 4);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[][] x_pixel_size = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 1);
            nexusFile.makedata("x_pixel_size", 5, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("x_pixel_size");
            nexusFile.putdata((Object)x_pixel_size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            float[][] y_pixel_size = CsnsNexusTemplateGenerator.genFloatData2D(x_pixel, y_pixel, 1);
            nexusFile.makedata("y_pixel_size", 5, 2, new int[]{x_pixel, y_pixel});
            nexusFile.opendata("y_pixel_size");
            nexusFile.putdata((Object)y_pixel_size);
            nexusFile.putattr("units", (Object)"m".getBytes(), 4);
            nexusFile.closedata();
            int[] timeOfFlight = CsnsNexusTemplateGenerator.genTimeOfFlight(z_pixel, 8);
            nexusFile.makedata("time_of_flight", 24, 1, new int[]{z_pixel});
            nexusFile.opendata("time_of_flight");
            nexusFile.putdata((Object)timeOfFlight);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.putattr("axis", (Object)new int[]{3}, 24);
            nexusFile.putattr("primary", (Object)new int[]{1}, 24);
            nexusFile.putattr("long_name", (Object)"Time Of Flight (s)".getBytes(), 4);
            nexusFile.closedata();
            int[] eventPixelId = CsnsNexusTemplateGenerator.genIntRandom1D(eventsNumber, 0, x_pixel * y_pixel);
            nexusFile.makedata("event_pixel_id", 24, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_pixel_id");
            nexusFile.putdata((Object)eventPixelId);
            nexusFile.closedata();
            float[] eventTimeOfFlight = CsnsNexusTemplateGenerator.genFloatRandom1D(eventsNumber, 0, clockPulses);
            nexusFile.makedata("event_time_of_flight", 5, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_time_of_flight");
            nexusFile.putdata((Object)eventTimeOfFlight);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.closedata();
            float[] eventPulseTime = CsnsNexusTemplateGenerator.genFloatPulseTime(eventsNumber, 0.04f);
            nexusFile.makedata("event_pulse_time", 5, 1, new int[]{eventsNumber});
            nexusFile.opendata("event_pulse_time");
            nexusFile.putdata((Object)eventPulseTime);
            nexusFile.putattr("units", (Object)"microsecond".getBytes(), 4);
            nexusFile.closedata();
            nexusFile.closegroup();
        }
    }

    private static void genHistogramData(NexusFile nexusFile, String instrumentName) throws NexusException {
        int i;
        String groupName = "histogram_data";
        int x_pixel = 4;
        int y_pixel = 128;
        int z_pixel = 5000;
        int x_pixel_monitor = 16;
        int y_pixel_monitor = 16;
        int z_pixel_monitor = 5000;
        ArrayList<String> bankGroup = new ArrayList<String>();
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            for (i = 0; i < 3; ++i) {
                bankGroup.add("bank" + i);
            }
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else if (instrumentName.equalsIgnoreCase("SANS")) {
            bankGroup.add("bank");
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else if (instrumentName.equalsIgnoreCase("MR")) {
            bankGroup.add("bank");
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else {
            Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, "ERROR: The insturment not exist!", "instrument name");
            System.exit(0);
        }
        int[][][] idsBank = CsnsNexusTemplateGenerator.genIntData3D(x_pixel, y_pixel, z_pixel);
        int[][][] idsMonitor = CsnsNexusTemplateGenerator.genIntData3D(x_pixel_monitor, y_pixel_monitor, z_pixel_monitor);
        nexusFile.makegroup(groupName, "NXcollection");
        nexusFile.opengroup(groupName, "NXcollection");
        nexusFile.closegroup();
        for (int i2 = 0; i2 < bankGroup.size(); ++i2) {
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i2) + "/x_pixel_offset");
            NXlink XPixelOffsetLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i2) + "/y_pixel_offset");
            NXlink YPixelOffsetLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i2) + "/time_of_flight");
            NXlink TimeOfFlightLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/" + groupName);
            nexusFile.makegroup((String)bankGroup.get(i2), "NXdata");
            nexusFile.opengroup((String)bankGroup.get(i2), "NXdata");
            if (((String)bankGroup.get(i2)).substring(0, 4).equals("bank")) {
                nexusFile.makedata("value", 24, 3, new int[]{x_pixel, y_pixel, z_pixel});
                nexusFile.opendata("value");
                nexusFile.putdata((Object)idsBank);
            } else {
                nexusFile.makedata("value", 24, 3, new int[]{x_pixel_monitor, y_pixel_monitor, z_pixel_monitor});
                nexusFile.opendata("value");
                nexusFile.putdata((Object)idsMonitor);
            }
            nexusFile.closedata();
            nexusFile.makelink(XPixelOffsetLink);
            nexusFile.makelink(YPixelOffsetLink);
            nexusFile.makelink(TimeOfFlightLink);
            nexusFile.closegroup();
            nexusFile.closegroup();
        }
    }

    private static void genEventData(NexusFile nexusFile, String instrumentName) throws NexusException {
        int i;
        String groupName = "event_data";
        ArrayList<String> bankGroup = new ArrayList<String>();
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            for (i = 0; i < 3; ++i) {
                bankGroup.add("bank" + i);
            }
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else if (instrumentName.equalsIgnoreCase("SANS")) {
            bankGroup.add("bank");
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else if (instrumentName.equalsIgnoreCase("MR")) {
            bankGroup.add("bank");
            for (i = 0; i < 2; ++i) {
                bankGroup.add("monitor" + i);
            }
        } else {
            Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, "ERROR: The insturment not exist!", "instrument name");
            System.exit(0);
        }
        nexusFile.makegroup(groupName, "NXcollection");
        nexusFile.opengroup(groupName, "NXcollection");
        nexusFile.closegroup();
        for (i = 0; i < bankGroup.size(); ++i) {
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i) + "/event_pixel_id");
            NXlink eventPixelIdLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i) + "/event_time_of_flight");
            NXlink eventTimeOfFlightLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/instrument/" + (String)bankGroup.get(i) + "/event_pulse_time");
            NXlink eventPulseTimeLink = nexusFile.getdataID();
            nexusFile.openpath("/entry/" + groupName);
            nexusFile.makegroup((String)bankGroup.get(i), "NXevent_data");
            nexusFile.opengroup((String)bankGroup.get(i), "NXevent_data");
            nexusFile.makelink(eventPixelIdLink);
            nexusFile.makelink(eventTimeOfFlightLink);
            nexusFile.makelink(eventPulseTimeLink);
            nexusFile.closegroup();
            nexusFile.closegroup();
        }
    }

    private static void genPresentData(NexusFile nexusFile, String instrumentName) throws NexusException {
        String groupName = "present_data";
        int data1_size = 124;
        int data2_size = 56;
        nexusFile.makegroup(groupName, "NXdata");
        nexusFile.opengroup(groupName, "NXdata");
        String plot = "data1,data2,data3:data3_error";
        nexusFile.makedata("plot", 4, 1, new int[]{plot.length()});
        nexusFile.opendata("plot");
        nexusFile.putdata((Object)plot.getBytes());
        nexusFile.closedata();
        String type = "line";
        nexusFile.makedata("type", 4, 1, new int[]{type.length()});
        nexusFile.opendata("type");
        nexusFile.putdata((Object)type.getBytes());
        nexusFile.closedata();
        String title = "Events Distribution";
        nexusFile.makedata("title", 4, 1, new int[]{title.length()});
        nexusFile.opendata("title");
        nexusFile.putdata((Object)title.getBytes());
        nexusFile.closedata();
        float[] data1 = CsnsNexusTemplateGenerator.genFloatData1D(data1_size, 100);
        float[] data2 = CsnsNexusTemplateGenerator.genFloatData1D(data2_size, 50);
        float[] data3 = CsnsNexusTemplateGenerator.genFloatData1D(data1_size * data2_size, 30);
        float[] data3_error = CsnsNexusTemplateGenerator.genFloatData1D(data1_size * data2_size, 1);
        nexusFile.makedata("data1", 5, 1, new int[]{data1_size});
        nexusFile.opendata("data1");
        nexusFile.putdata((Object)data1);
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.putattr("long_name", (Object)"x".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("data2", 5, 1, new int[]{data2_size});
        nexusFile.opendata("data2");
        nexusFile.putdata((Object)data2);
        nexusFile.putattr("units", (Object)"m".getBytes(), 4);
        nexusFile.putattr("long_name", (Object)"y".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("data3", 5, 1, new int[]{data1_size * data2_size});
        nexusFile.opendata("data3");
        nexusFile.putdata((Object)data3);
        nexusFile.putattr("units", (Object)"counts".getBytes(), 4);
        nexusFile.putattr("long_name", (Object)"Counts".getBytes(), 4);
        nexusFile.closedata();
        nexusFile.makedata("data3_error", 5, 1, new int[]{data1_size * data2_size});
        nexusFile.opendata("data3_error");
        nexusFile.putdata((Object)data3_error);
        nexusFile.closedata();
        nexusFile.closegroup();
    }

    private static void genPublicFields(NexusFile nexusFile, String instrumentName) throws NexusException {
        String version = "1";
        String proposalId = "CSNS-00001";
        String acceleratorRunNo = "23";
        String runNo = "0000001";
        String description = "This is the first beam from CSNS.";
        String beamline = null;
        String startTime = CalendarTool.getFormatedCurrentDate("yyyy-MM-dd'T'HH:mm:ss", true);
        String endTime = CalendarTool.getFormatedCurrentDate("yyyy-MM-dd'T'HH:mm:ss", true);
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            beamline = "BL18";
        } else if (instrumentName.equalsIgnoreCase("MR")) {
            beamline = "BL03";
        } else if (instrumentName.equalsIgnoreCase("SANS")) {
            beamline = "BL02";
        } else {
            Logger.getLogger(CsnsNexusTemplateGenerator.class.getName()).log(Level.SEVERE, "ERROR: The insturment not exist!", "instrument name");
            System.exit(0);
        }
        String instrumentFile = "CSNS_BL01_Definition_2016_05_18.xml";
        String instrumentDefinition = null;
        String _IDF = new File("./" + instrumentFile).exists() ? "./" + instrumentFile : "/opt/shared/home/zhangjr/git/CSNSNeXusFormat/src/instrument/" + instrumentFile;
        try (FileInputStream inputStream = new FileInputStream(_IDF);){
            instrumentDefinition = IOUtils.toString((InputStream)inputStream);
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        CsnsNexusTemplateGenerator.writeData(nexusFile, "version", 4, 1, new int[]{version.length()}, version.toUpperCase().getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "instrument_name", 4, 1, new int[]{instrumentName.length()}, instrumentName.toUpperCase().getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "beamline", 4, 1, new int[]{beamline.length()}, beamline.toUpperCase().getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "instrument_file", 4, 1, new int[]{instrumentFile.length()}, instrumentFile.toUpperCase().getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "instrument_definition", 4, 1, new int[]{instrumentDefinition.length()}, instrumentDefinition.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "proposal_id", 4, 1, new int[]{proposalId.length()}, proposalId.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "accelerator_run_no", 4, 1, new int[]{acceleratorRunNo.length()}, acceleratorRunNo.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "run_no", 4, 1, new int[]{runNo.length()}, runNo.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "description", 4, 1, new int[]{description.length()}, description.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "start_time", 4, 1, new int[]{startTime.length()}, startTime.getBytes());
        CsnsNexusTemplateGenerator.writeData(nexusFile, "end_time", 4, 1, new int[]{endTime.length()}, endTime.getBytes());
    }

    private static void genFermiChopper(NexusFile nexusFile) throws NexusException {
        nexusFile.makegroup("fermi_chopper1", "NXfermi_chopper");
        nexusFile.opengroup("fermi_chopper1", "NXfermi_chopper");
        nexusFile.closegroup();
    }

    private static float[] genFloatData1D(int size, int scale) {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new Random().nextFloat() * (float)scale;
        }
        return data;
    }

    private static float[] genPixelOffset1D(int size, float begin, float bin) {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = begin + (float)i * bin;
        }
        return data;
    }

    private static float[][] genFloatData2D(int x, int y, int scale) {
        float[][] data = new float[x][y];
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                data[i][j] = new Random().nextFloat() * (float)scale;
            }
        }
        return data;
    }

    private static int[] genIntData1D(int size, int start, int inc) {
        int current = start;
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = current;
            current += inc;
        }
        return data;
    }

    private static int[] genTimeOfFlight(int size, int bin) {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (1 + i) * bin;
        }
        return data;
    }

    private static int[][] genIntData2D(int x, int y, int start, int inc) {
        int current = start;
        int[][] data = new int[x][y];
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                data[i][j] = current;
                current += inc;
            }
        }
        return data;
    }

    private static int[][][] genIntData3D(int x, int y, int z) {
        int[][][] data = new int[x][y][z];
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                for (int k = 0; k < y; ++k) {
                    data[i][j][k] = new Random().nextInt(1000);
                }
            }
        }
        return data;
    }

    private static int[] genIntRandom1D(int size, int min, int max) {
        int[] data = new int[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new Random().nextInt(max) % Math.abs(max - min + 1) + min;
        }
        return data;
    }

    private static float[] genFloatRandom1D(int size, int min, int max) {
        float[] data = new float[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new Random().nextFloat() * (float)Math.abs(max - min) + (float)min;
        }
        return data;
    }

    private static float[] genFloatPulseTime(int size, float period) {
        float[] data = new float[size];
        float t0 = 0.0f;
        for (int i = 0; i < size; ++i) {
            Random random = new Random();
            if (random.nextFloat() < 0.1f) {
                t0 += period;
            }
            data[i] = t0;
        }
        return data;
    }

    private static float[][] genProtonCharge(int size, float period) {
        float[][] data = new float[2][size];
        for (int i = 0; i < size; ++i) {
            data[0][i] = 0.0f + (float)i * period;
            data[1][i] = new Random().nextFloat() * 0.2f + 0.9f;
        }
        return data;
    }

    private static float[][] genGoodFrame(int size, float period) {
        float[][] data = new float[2][size];
        for (int i = 0; i < size; ++i) {
            data[0][i] = 0.0f + (float)i * period;
            data[1][i] = new Random().nextFloat() < 0.05f ? 0.0f : 1.0f;
        }
        return data;
    }

    private static float[][] genChopperPhase(int size, float period) {
        float[][] data = new float[2][size];
        for (int i = 0; i < size; ++i) {
            data[0][i] = 0.0f + (float)i * period;
            data[1][i] = new Random().nextFloat() < 0.1f ? 0.0f : 1.0f;
        }
        return data;
    }

    private static void writeData(NexusFile nexusFile, String dataName, int dataType, int rank, int[] dim, Object data) throws NexusException {
        nexusFile.makedata(dataName, dataType, rank, dim);
        nexusFile.opendata(dataName);
        nexusFile.putdata(data);
        nexusFile.closedata();
    }

    private static void help(String[] supportedInstruments, String[] supportedFileFormats) {
        System.out.println("Usage:  java " + CsnsNexusTemplateGenerator.class.getCanonicalName() + " instrument_name [file_format]");
        System.out.println("\ninstrument_name can be one of these:");
        for (String supportedInstrument : supportedInstruments) {
            System.out.println(supportedInstrument);
        }
        System.out.println("\nfile_format can be one of these:");
        for (String supportedFileFormat : supportedFileFormats) {
            System.out.println(supportedFileFormat);
        }
        System.out.println("");
    }

    public static void main(String[] args) {
        String file = "csns-nexus-template.nxs";
        String fileSuffix = ".nxs";
        String instrumentName = "GPPD";
        String fileFormat = null;
        String[] supportedInstruments = new String[]{"GPPD", "SANS", "MR"};
        String[] supportedFileFormats = new String[]{"HDF5", "HDF4", "XML"};
        Boolean isSupported = false;
        if (args.length < 1) {
            CsnsNexusTemplateGenerator.help(supportedInstruments, supportedFileFormats);
            System.exit(0);
        }
        instrumentName = args[0].trim();
        for (String supportedInstrument : supportedInstruments) {
            if (!instrumentName.equalsIgnoreCase(supportedInstrument)) continue;
            isSupported = true;
            break;
        }
        if (!isSupported.booleanValue()) {
            CsnsNexusTemplateGenerator.help(supportedInstruments, supportedFileFormats);
            System.exit(0);
        }
        if (args.length >= 2) {
            fileFormat = args[1].trim();
            isSupported = false;
            for (String supportedFileFormat : supportedFileFormats) {
                if (!fileFormat.equalsIgnoreCase(supportedFileFormat)) continue;
                isSupported = true;
                break;
            }
            if (!isSupported.booleanValue()) {
                CsnsNexusTemplateGenerator.help(supportedInstruments, supportedFileFormats);
                System.exit(0);
            }
            if (fileFormat.equalsIgnoreCase("XML")) {
                fileSuffix = ".xml";
            }
        }
        if (instrumentName.equalsIgnoreCase("GPPD")) {
            file = "CSNS_GPPD_NeXus_Template" + fileSuffix;
        }
        if (instrumentName.equalsIgnoreCase("SANS")) {
            file = "CSNS_SANS_NeXus_Template" + fileSuffix;
        }
        if (instrumentName.equalsIgnoreCase("MR")) {
            file = "CSNS_MR_NeXus_Template" + fileSuffix;
        }
        CsnsNexusTemplateGenerator.genNexusTemplate(file, instrumentName, fileFormat);
    }
}

