/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.nexus.csnsnexustemplate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;
import org.threeten.extra.scale.TaiInstant;

/**
 * Unit test class for CalendarTool.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public class CalendarToolTest {

    public CalendarToolTest() {
    }

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of getFormatedCurrentDate method, of class CalendarTool.
     */
    @Test
    public void testGetFormatedCurrentDate() {
        System.out.println("getFormatedCurrentDate");
        String format = "yyyy-MM-dd'T'HH:mm:ss";
        String result = CalendarTool.getFormatedCurrentDate(format, false);
        assertTrue(result.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}$"));

        result = CalendarTool.getFormatedCurrentDate(format, true);
        assertTrue(result.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]{1}\\d{2}:\\d{2}$"));
    }

    @Test
    public void testNumberRoud() {
        System.out.println("numberRound");
        double d = 3.14314;
        BigDecimal bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("3", bd.toString());

        d = 3.54314;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("4", bd.toString());

        d = 3.5;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("4", bd.toString());

        d = 3.000;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("3", bd.toString());

        d = -3.54314;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("-4", bd.toString());

        d = -3.24314;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("-3", bd.toString());

        d = -3.000;
        bd = new BigDecimal(Double.toString(d)).setScale(0, RoundingMode.HALF_UP);
        assertEquals("-3", bd.toString());

        d = 3.523;
        bd = new BigDecimal(Double.toString(d)).setScale(1, RoundingMode.HALF_UP);
        assertEquals("3.5", bd.toString());

        d = 3.57;
        bd = new BigDecimal(Double.toString(d)).setScale(1, RoundingMode.HALF_UP);
        assertEquals("3.6", bd.toString());

        d = 3.55;
        bd = new BigDecimal(Double.toString(d)).setScale(1, RoundingMode.HALF_UP);
        assertEquals("3.6", bd.toString());

        d = 3.50;
        bd = new BigDecimal(Double.toString(d)).setScale(1, RoundingMode.HALF_UP);
        assertEquals("3.5", bd.toString());
    }

    @Test
    public void testDatetimeConvert(){
        System.out.println("datetimeConvert");
        String utcString = "5000-12-31T23:59:59.999999900Z";
        BigInteger total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        TaiInstant tai=CalendarTool.getTaiInstantFromUtc(utcString);
        BigInteger expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        long reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        String convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5000-12-31T23:59:59.999999900Z".equals(convertedBack));

        utcString = "5000-12-31T23:59:59.999999902Z";
        total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        tai=CalendarTool.getTaiInstantFromUtc(utcString);
        expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5000-12-31T23:59:59.999999900Z".equals(convertedBack));
        
        utcString = "5000-12-31T23:59:59.999999949Z";
        total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        tai=CalendarTool.getTaiInstantFromUtc(utcString);
        expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5000-12-31T23:59:59.999999900Z".equals(convertedBack));

        utcString = "5000-12-31T23:59:59.999999950Z";
        total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        tai=CalendarTool.getTaiInstantFromUtc(utcString);
        expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5001-01-01T00:00:00Z".equals(convertedBack));

        utcString = "5000-12-31T23:59:59.999999987Z";
        total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        tai=CalendarTool.getTaiInstantFromUtc(utcString);
        expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5001-01-01T00:00:00Z".equals(convertedBack));

        utcString = "5000-12-31T23:59:59.999999999Z";
        total = CalendarTool.getTotalNanoSecondsFromUtcString(utcString);
        tai=CalendarTool.getTaiInstantFromUtc(utcString);
        expected=CalendarTool.getTotalNanoSecondsFromTaiSeconds(tai.getTaiSeconds(), tai.getNano());
        assertTrue(total.equals(expected));
        reduced = CalendarTool.getReducedNanoSeconds(total, 100);
        convertedBack=CalendarTool.getTaiInstantFromReducedNanoSeconds(reduced, 100).toUtcInstant().toString();
        assertTrue("5001-01-01T00:00:00Z".equals(convertedBack));
    }

}
