/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.nexus.csnsnexustemplate;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

/**
 *
 * @author lanjian
 */
public class CalendarTool {

    /**
     * Get current date and time as a formated string.
     * 
     * @param format a string limit how date and time are returned. eg. "yyyy-MM-dd'T'HH:mm:ss"
     * @param isTimeDiff a boolean limit if time zone offset is returned. Such as +08:00 for China.
     *       <ul>
     *         <li><code>true</code>    return the time zone offset</li>
     *         <li><code>false</code>   don't return the time zone offset</li>
     *       </ul>
     * @return 
     */
    public static String getFormatedCurrentDate(String format, Boolean isTimeDiff) {
        String result;
        int hour;
        int minute;
        int diff;
        String offset="";
        TimeZone tz;

        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        result = sdf.format(calendar.getTime());
        
        if (isTimeDiff) 
        {
            tz = calendar.getTimeZone();
            diff = tz.getRawOffset();
            diff = Math.abs(diff / 1000);
            hour = diff / 3600;
            minute = (diff - hour * 3600) / 60;
            offset = String.format("%02d:%02d", hour, minute);
            if (tz.getRawOffset() >= 0) {
                offset = "+" + offset;
            } else {
                offset = "-" + offset;
            }
        }
        return result + offset;
    }
}
