#include <tinyxml.h>
#include <iostream>
#include <iomanip>
#include <locale>
#include <sstream>
#include <fstream>
#include <string>
#include <ctime>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "nexus/NeXusFile.hpp"
#include <vector>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include "log.h"
#include "config.h"
#include "parseXML.h"
#include "r2n.h"

using namespace std;

const uint32_t PULSE_NUM = 10000;
const uint32_t xpid_M = 16;
const uint32_t ypid_M = 16;
const uint32_t PIXEL_NUM_M = xpid_M*ypid_M;
const uint32_t EVENT_NUM_M = 25000;
const uint64_t EVENT_NUM = 10000;

//const uint32_t xpid = 128;
//const uint32_t ypid = 64;
//const uint32_t PIXEL_NUM = xpid*ypid;
const uint32_t TIME_BIN = 20000;
int dim[1]={0}; // one dimension data , dim[0] is line number. 
int dim2D_M [2] = {xpid_M, ypid_M};
//get method
//-----------------------------------------------------------------------------
void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
	dim[0] = dataValue.size();
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
	status=NXopendata(fileID,p);
	status=NXputdata(fileID,dataValue.c_str());
	status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
// if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
//text is the unit.
void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
	status=NXopendata(fileID, p);
	status=NXputdata(fileID, dataValue);
	while(text != "0")
	{
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		break;
	}
	status=NXclosedata(fileID);
}
void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
	status=NXopendata(fileID, p);
	status=NXputdata(fileID, dataValue);
	while(text != "0")
	{
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		break;
	}
	status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
//chopper used it
void getFloatOrder1D(float floatOrder1D[], uint32_t size, float init, float step)
{
	for (uint32_t i = 0; i < size; i++)
		floatOrder1D[i] = init+i*step;
}
//--------------------------------------------------------------------------------------
//chopper, present_data used it
void getFloatRandom1D(float floatRandom1D[], uint32_t size, float min, float max)
{
	for(uint32_t i = 0 ; i < size; i++)
		floatRandom1D[i] = min + ((float)rand()/(float)RAND_MAX)*(max-min);
}
//--------------------------------------------------------------------------------------
//chopper used it
void getPulseInfo(float pulseValue[], uint32_t size)
{
	for(uint32_t i = 0; i < size; i++)
		pulseValue[i] = rand()%2;
}

TiXmlDocument *loadFile(string filename){
    TiXmlDocument *doc=new TiXmlDocument(filename.c_str());
    doc->LoadFile();
    TiXmlElement *root=doc->RootElement();
    cout<<root->Value()<<endl;
    if (doc==NULL)
        cout<<"error: no such xml file!"<<endl;
    return doc;
}
//------------------------------------------------------------------------------------
void SaveNexusFile(std::string nexusfilename, string summaryfilename, string idfbankfilename){
	std::cout << "SavenexusFile" << std::endl;
	NXaccess mode(NXACC_CREATE5);
	NXstatus status;
	NXhandle fileID;
	uint32_t compression(NX_COMP_LZW);
	status=NXopen(nexusfilename.c_str(), mode, &fileID);

    TiXmlDocument *doc_sum=loadFile(summaryfilename);
    TiXmlDocument *doc_idf_bank=loadFile(idfbankfilename);

    ParseXML xmlInfo;

    std::map<string, string> publicFromSummary=xmlInfo.getPublic(doc_sum);
    map<string, string>::iterator it22;
	//-----------------------------------open-csns-------------------------------------------
	//enter group: csns
	status=NXmakegroup(fileID,"csns","NXentry");
	status=NXopengroup(fileID,"csns","NXentry");
	cout<<"open csns group"<<endl;
    
	writeCharData(status, fileID, "run_no", publicFromSummary["run_no"]);
	writeCharData(status, fileID, "beamline", publicFromSummary["beamline"]);
	writeCharData(status, fileID, "description", publicFromSummary["description"]);
	writeCharData(status, fileID, "start_time_tai", publicFromSummary["start_time_tai"]);
	writeCharData(status, fileID, "start_time_utc", publicFromSummary["start_time_utc"]);
	writeCharData(status, fileID, "end_time_tai", publicFromSummary["end_time_tai"]);
	writeCharData(status, fileID, "end_time_utc", publicFromSummary["end_time_utc"]);
	writeCharData(status, fileID, "proposal_id", publicFromSummary["proposal_id"]);
	writeCharData(status, fileID, "instrument_name", publicFromSummary["instrument_name"]);
	writeCharData(status, fileID, "facility", publicFromSummary["facility"]);

		const std::string version = "1";
		writeCharData(status, fileID, "version", version);
		const std::string definition = "TOF";
		writeCharData(status, fileID, "definition", definition);
//		std::string instrument_definition = ""; 
//		fstream fileidf;
	//	fileidf.open("/home/dur/work/gen_nexus/data/GPPD_IDF_template.xml", std::ios::in);
	//	std::stringstream tmp;
	//	tmp<<fileidf.rdbuf();
	//	instrument_definition = tmp.str();
	//	fileidf.close();

	string text;
	//----------------------------open-csns/instrument-----------------------------------------
	status=NXmakegroup(fileID,"instrument","NXinstrument");
	status=NXopengroup(fileID,"instrument","NXinstrument");
	//----------------------------------open-csns/instrument/sample--------------------------
	//enter group: csns/instrument/sample
	status=NXmakegroup(fileID,"sample","NXsample");
	status=NXopengroup(fileID,"sample","NXsample");
    std::map<string, string> sampleFromSummary=xmlInfo.getSample(doc_sum);
    //for(it22=sampleFromSummary.begin();it22!=sampleFromSummary.end();it22++)
      //  cout<<it22->first<<" || "<<it22->second<<endl;

	writeCharData(status, fileID, "chemical_formula", sampleFromSummary["chemical_formula"]);
	writeCharData(status, fileID, "name", sampleFromSummary["name"]);
	writeCharData(status, fileID, "situation", sampleFromSummary["situation"]);
	writeCharData(status, fileID, "type", sampleFromSummary["type"]);
    text=sampleFromSummary["density"];
	const float density = atof(text.c_str()); 
    text=sampleFromSummary["mass"];
	const float mass = atof(text.c_str()); 
	dim[0] = 1;
	writeNumData(status, fileID, "density", &density, 1, dim, "g cm-3");
	writeNumData(status, fileID, "mass", &mass, 1, dim, "g");
	dim[0]=3;
    std::vector<string> distance_tmp=xmlInfo.getDistance(doc_sum, "sample");
    float distance[3]={};
    for(int i=0; i!=3;i++){
        distance[i]=atof(distance_tmp[i].c_str());
    }
    distance_tmp.clear();
	writeNumData(status, fileID, "distance", distance, 1, dim, "m");
	//-----------------------------open-csns/instrument/sample/geometry----------------------
	//enter group: csns/instrument/sample/geometry
	status=NXmakegroup(fileID,"geometry","NXgeometry");
	status=NXopengroup(fileID,"geometry","NXgeometry");
    CSNSgeometry samGeometry=xmlInfo.getGeometry(doc_sum, "sample");    
	//-----------------------------open-csns/instrument/sample/geometry/shape-------------------
	//enter group: csns/instrument/sample/geometry/shape
	status=NXmakegroup(fileID,"shape","NXshape");
	status=NXopengroup(fileID,"shape","NXshape");
	writeCharData(status, fileID, "shape", samGeometry.shape);
    float size[3]={};
    for(int i=0; i!=3;i++){
        size[i]=atof(samGeometry.size[i].c_str());
    }
	dim[0] = 3;
	writeNumData(status, fileID, "size", size, 1, dim, "m");
	NXclosegroup(fileID);
	NXclosegroup(fileID);
	//--------------------------close-csns/instrument/sample/geometry----------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/sample----------------------
	//--------------------------------open-csns/instrument/sample_environment---------------------------------
	status=NXmakegroup(fileID,"sample_environment","NXenvironment");
	status=NXopengroup(fileID,"sample_environment","NXenvironment");

	status=NXmakegroup(fileID,"sample_environment1","NXnote");
	status=NXopengroup(fileID,"sample_environment1","NXnote");
    
    std::vector<CSNSse> se=xmlInfo.getSE(doc_sum);
    std::vector<CSNSse>::iterator it_se;
    it_se=se.begin();
	writeCharData(status,fileID,"name",(*it_se).name);
	writeCharData(status,fileID,"type",(*it_se).type);
	NXclosegroup(fileID);
	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/sample_environment---------------------------------
	//--------------------------------open-csns/instrument/source---------------------------------
	status=NXmakegroup(fileID,"source","NXsource");
	status=NXopengroup(fileID,"source","NXsource");
    
    std::map<string, string> sourceFromSummary=xmlInfo.getInstrumentComponent(doc_sum, "source");
	writeCharData(status,fileID,"name",sourceFromSummary["name"]);
	writeCharData(status,fileID,"type",sourceFromSummary["type"]);
	writeCharData(status,fileID,"probe",sourceFromSummary["probe"]);
	const float frequency_source = atof(sourceFromSummary["frequency"].c_str());  
	const float power_source =atof(sourceFromSummary["frequency"].c_str());
	dim[0]=1;
	writeNumData(status, fileID, "frequency", &frequency_source, 1, dim, "Hz");
	writeNumData(status, fileID, "power", &power_source, 1, dim, "W");
	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/source---------------------------------
    std::vector<string> chopperGroup;
    chopperGroup.push_back("disk_chopper0"); 
    chopperGroup.push_back("disk_chopper1"); 
	//------------------------------open-csns/instrument/disk_chopper-------------------------
	std::vector<string>::iterator it_chopper;
	int ii_disk = 0;
    std::vector<CSNSdc> diskChopper=xmlInfo.getDC(doc_sum, "disk_chopper0", "disk_chopper1");
	for (it_chopper = chopperGroup.begin(); it_chopper != chopperGroup.end(); it_chopper++)
	{
		const char *str_disk = (*it_chopper).c_str(); 
		status = NXmakegroup(fileID, str_disk,"NXdisk_chopper");
		status = NXopengroup(fileID, str_disk,"NXdisk_chopper");
		float phase = atof(diskChopper[ii_disk].phase.c_str());
		float slitAngle = atof(diskChopper[ii_disk].slitAngle.c_str());
		float rotationSpeed = atof(diskChopper[ii_disk].rotationSpeed.c_str());

		dim[0]=1; 
		writeNumData(status, fileID, "phase", &phase, 1, dim, "degree");
		writeNumData(status, fileID, "slit_angle", &slitAngle, 1, dim, "degree");
		writeNumData(status, fileID, "rotation_speed", &rotationSpeed, 1, dim, "Hz");
		float distance[3] = {};
        for(int i=0; i!=3;i++)
            distance[i]=atof(diskChopper[ii_disk].distance[i].c_str());
		dim[0]=3;
		writeNumData(status, fileID, "distance", distance, 1, dim, "m");
		NXclosegroup(fileID);
		ii_disk++;
	}
	//--------------------------------close-csns/instrument/disk_chopper---------------------------------
    std::vector<string> apertureGroup;
	apertureGroup.push_back("aperture0");
	apertureGroup.push_back("aperture1");
    std::vector<string>::iterator it_ape;

	//--------------------------------open-csns/instrument/aperture1---------------------------------
    for(it_ape=apertureGroup.begin();it_ape!=apertureGroup.end();it_ape++)
    {
    const char* pm=(*it_ape).c_str(); 
	status=NXmakegroup(fileID, pm,"NXaperture");
	status=NXopengroup(fileID, pm,"NXaperture");
	//--------------------------------open-csns/instrument/aperture1/geometry---------------------------
	status=NXmakegroup(fileID,"geometry","NXgeometry");
	status=NXopengroup(fileID,"geometry","NXgeometry");
	//--------------------------------open-csns/instrument/aperture1/geometry/orientation-----------------
    CSNSgeometry aperGeometry=xmlInfo.getGeometry(doc_sum, pm);

	status=NXmakegroup(fileID,"orientation","NXorientation");
	status=NXopengroup(fileID,"orientation","NXorientation");

	float value_ori[6]={};
    for(int i=0; i!=6;i++)
        value_ori[i]=atof(aperGeometry.ori[i].c_str());
	dim[0]=6; 
	writeNumData(status, fileID, "value", value_ori, 1, dim, "0");
	NXclosegroup(fileID);
	//------------------------close-csns/instrument/aperture1/geometry/orientation-----------------------
	//------------------------open-csns/instrument/aperture1/geometry/shape-----------------------
	status=NXmakegroup(fileID,"shape","NXshape");
	status=NXopengroup(fileID,"shape","NXshape");

	float size_shape[3]={};
    for(int i=0; i!=3;i++)
        size_shape[i]=atof(aperGeometry.size[i].c_str());
	dim[0]=3;
	writeNumData(status, fileID, "size", size_shape, 1, dim, "m");

	const std::string shape_shape = "nxelliptical";
	writeCharData(status, fileID, "shape", aperGeometry.shape);

	NXclosegroup(fileID); 
	NXclosegroup(fileID);
	//------------------------close-csns/instrument/aperture1/geometry/-----------------------
    distance_tmp=xmlInfo.getDistance(doc_sum, pm);
	float distance_trans[3]={};
    for(int i=0; i!=3;i++)
        distance_trans[i]=atof(distance_tmp[i].c_str());
    distance_tmp.clear(); 
	dim[0]=3;
	writeNumData(status, fileID, "distance", distance_trans, 1, dim, "m");
	NXclosegroup(fileID);
	//-------------------------close-csns/instrument/aperture1---------------------------------
    }
    //---------------------------open-csns/instrument/beam_stop---------------------------------
    CSNSbs beamstop=xmlInfo.getBS(doc_sum, "beam_stop");
    status=NXmakegroup(fileID,"beam_stop","NXbeam_stop");
    status=NXopengroup(fileID,"beam_stop","NXbeam_stop");

    float distance_bs[3]={};
    for(int i=0; i!=3;i++)
        distance_bs[i]=atof(beamstop.distance[i].c_str());
	dim[0]=3;
	writeNumData(status, fileID, "distance", distance_bs, 1, dim, "m");

    writeCharData(status, fileID, "status", beamstop.status); 
    //--------------------------------open-csns/instrument/beam_stop/geometry---------------------------------
    status=NXmakegroup(fileID,"geometry","NXgeometry");
    status=NXopengroup(fileID,"geometry","NXgeometry");

    status=NXmakegroup(fileID,"orientation","NXorientation");
    status=NXopengroup(fileID,"orientation","NXorientation");
    
    float ori_bs[6]={};
    for(int i=0; i!=6;i++)
        ori_bs[i]=atof(beamstop.geometry.ori[i].c_str());
    dim[0]=6;
    writeNumData(status, fileID, "value", ori_bs, 1, dim, text);
    NXclosegroup(fileID);

    status=NXmakegroup(fileID,"shape","NXshape");
    status=NXopengroup(fileID,"shape","NXshape");
    writeCharData(status, fileID, "shape", beamstop.geometry.shape);
    
    float size_bs[3]={};
    for(int i=0; i!=3;i++){
        size_bs[i]=atof(beamstop.geometry.size[i].c_str());
    }
    dim[0] = 3;
    writeNumData(status, fileID, "size", size_bs, 1, dim, "m");
    NXclosegroup(fileID);
    //-------------------------------close-csns/instrument/beam_stop/shape---------------------------
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/beam_stop/geometry---------------------------------
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/beam_stop/---------------------------------
	//--------------------------------open-csns/instrument/moderator---------------------------------
	status=NXmakegroup(fileID,"moderator","NXmoderator");
	status=NXopengroup(fileID,"moderator","NXmoderator");
    
    std::map<string, string> moderatorFromSummary=xmlInfo.getInstrumentComponent(doc_sum,"moderator");
	//const std::string type_mod="Liquid H2";
	//const std::string poison_material="Gd";
	writeCharData(status, fileID, "type", moderatorFromSummary["type"]);
    distance_tmp=xmlInfo.getDistance(doc_sum, "moderator"); 

	float distance_mod[3]={};
    for(int i=0; i!=3;i++)
        distance_mod[i]=atof(distance_tmp[i].c_str());
    distance_tmp.clear(); 
	dim[0]=3;
	writeNumData(status, fileID, "distance", distance_mod, 1, dim, "m");
	dim[0]=1;
	const float temperature_mod = atof(moderatorFromSummary["temperature"].c_str());
	writeNumData(status, fileID, "temperature", &temperature_mod, 1, dim, "K");

	cout<<"set bool coupled!"<<endl;
	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/moderator---------------------------------
    
    std::vector<CSNSdet> detGroup=xmlInfo.getDetector(doc_idf_bank);
    int bankNum=detGroup.size();

	//-----------------------------open-csns/instrument/bank----------------------
    for(int ii = 0; ii!=bankNum; ii++)
    {
         
        int xpid=atoi(detGroup[ii].pid["xpixels"].c_str()); 
        int ypid=atoi(detGroup[ii].pid["ypixels"].c_str());
        int idstart=atoi(detGroup[ii].pid["idstart"].c_str());     
        int idstep=atoi(detGroup[ii].pid["idstepbyrow"].c_str());     
		const char *str_bank = detGroup[ii].bankName.c_str(); 

        int dim2D [2] = {xpid, ypid};
		uint64_t evt_num = EVENT_NUM;
		status = NXmakegroup(fileID, str_bank,"NXdetector");
		status = NXopengroup(fileID, str_bank,"NXdetector");
		//       add distance 
		float bank_distance = 1.5;
		dim[0] = 1;
		writeNumData(status, fileID, "distance", &bank_distance, 1, dim, "m");

		//add azimuthal_angle
		float azimuthalAngle [xpid][ypid];
		for(int i = 0 ; i<xpid; i++){
			for(int j = 0; j<ypid; j++){
				azimuthalAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
			}
		}
		writeNumData(status, fileID, "azimuthal_angle", *azimuthalAngle, 2, dim2D, "degree");
		//add radial_distance 
		float radial_distance [xpid][ypid];
		for(int i = 0 ; i<xpid; i++){
			for(int j = 0; j<ypid; j++){
				radial_distance[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(16.0-0.0);
			}
		}
		writeNumData(status, fileID, "radial_distance", *radial_distance, 2, dim2D, "m");
		//add polar_angle
		float polarAngle [xpid][ypid];
		for(uint32_t i = 0 ; i<xpid; i++){
			for(uint32_t j = 0; j<ypid; j++){
				polarAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
			}
		}
		writeNumData(status, fileID, "polar_angle", *polarAngle, 2, dim2D, "degree");
		//add event_pixel_id
		int64_t eventPixelId [evt_num];
		for (int64_t i = 0; i<evt_num; i++)
		{
			eventPixelId[i]=ii*10000+rand()%(xpid*ypid);
		}
		dim[0] = evt_num;
        writeNumData(status, fileID, "event_pixel_id", eventPixelId, 1, dim, "0");
		//add event_time_of_flight
		float eventTimeOfFlight [evt_num];
		getFloatRandom1D(eventTimeOfFlight, evt_num, 5000.0, 40000.0);
		writeNumData(status, fileID, "event_time_of_flight", eventTimeOfFlight, 1, dim, "microsecond");
		//add event_index
		int64_t eventIndex [evt_num];
		for(int64_t i =0; i<evt_num; i++)
		{
			eventIndex[i] = i;
		}
		dim[0] = evt_num;
        writeNumData(status, fileID, "event_index", eventIndex, 1, dim, "0");
		//add event_pulse_time
		uint64_t eventPulseTime[evt_num];
		for (uint32_t i = 0; i<evt_num; i++){
			eventPulseTime[i] = 14897125513178+i*40000;
		}
		status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
		status=NXopendata(fileID,"event_pulse_time");
		status=NXputdata(fileID,(void*)eventPulseTime);
		text = "nanosecond";
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		status=NXclosedata(fileID);
		//add x_pixel_size
		float xPixelSize[xpid][ypid];
		for(uint32_t i = 0 ; i<xpid; i++){
			for(uint32_t j = 0; j<ypid; j++){
				xPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
			}
		}
		writeNumData(status, fileID, "x_pixle_size", *xPixelSize, 2, dim2D, "m");
		//add y_pixel_size
		float yPixelSize[xpid][ypid];
		for(uint32_t i = 0 ; i<xpid; i++){
			for(uint32_t j = 0; j<ypid; j++){
				yPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
			}
		}
		writeNumData(status, fileID, "y_pixle_size", *yPixelSize, 2, dim2D, "m");
		// add z_pixel_size
		float zPixelSize = 0.001;
		dim[0] = 1;
		writeNumData(status, fileID, "z_pixel_size", &zPixelSize, 1, dim, "m");

		//add local_name  
		string local_name = "backward0";
		writeCharData(status, fileID, "local_name", local_name);
		//add pixel_id 
		int64_t pixelId [xpid][ypid];
		for (int i=0; i<xpid; i++){
		    int64_t _nm = 0; 
			for(int j=0; j<ypid; j++) {
				pixelId[i][j] = idstart+idstep*i+_nm;
				_nm++;
			}
		}
        writeNumData(status, fileID, "pixel_id", *pixelId, 2, dim2D, "0");
		//add time_of_flight
		uint32_t timeBin[TIME_BIN];
		for (uint32_t i = 0; i<TIME_BIN; i++)
		{
			timeBin [i]= i*2;
		}
		dim[0] = TIME_BIN;
		status=NXmakedata(fileID,"time_of_flight",NX_UINT32,1,dim);
		status=NXopendata(fileID,"time_of_flight");
		status=NXputdata(fileID,(void*)timeBin);
		text = "microsecond";
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "3";
		NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "Time Of Flight(s)";
		NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "1";
		NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		status=NXclosedata(fileID);

		//add geometry
		//--------------------------------open-csns/instrument/bank/geometry/-----------------
		status=NXmakegroup(fileID,"geometry","NXgeometry");
		status=NXopengroup(fileID,"geometry","NXgeometry");
		//--------------------------------open-csns/instrument/bank/geometry/orientation-----------------
		status=NXmakegroup(fileID,"orientation","NXorientation");
		status=NXopengroup(fileID,"orientation","NXorientation");

		float value_ori[6]={1.0,0.0,0.0,1.0,1.0,0.0};
		dim[0]=6; 
		writeNumData(status, fileID, "value", value_ori, 1, dim, "0");
		NXclosegroup(fileID);
		//------------------------close-csns/instrument/bank/geometry/orientation-----------------------
		//------------------------open-csns/instrument/bank/geometry/shape-----------------------
		status=NXmakegroup(fileID,"shape","NXshape");
		status=NXopengroup(fileID,"shape","NXshape");
		float size_shape[3]={0.04,-1.0,0.1};
		dim[0]=3;
		writeNumData(status, fileID, "size", size_shape, 1, dim, "m");
		const std::string shape_shape = "nxbox";
		writeCharData(status, fileID, "shape", shape_shape);
		NXclosegroup(fileID); 
		//------------------------close-csns/instrument/bank/geometry/shape-----------------------
		//------------------------open-csns/instrument/bank/geometry/translation--------------------
		status=NXmakegroup(fileID,"translation","NXtranslation");
		status=NXopengroup(fileID,"translation","NXtranslation");
		float distance_trans[3]={0.0,0.0,10.0};
		dim[0]=3;
		writeNumData(status, fileID, "distance", distance_trans, 1, dim, "m");
		NXclosegroup(fileID);
		//------------------------close-csns/instrument/bank/geometry/translation--------------------
		NXclosegroup(fileID);
		//--------------------------------close-csns/instrument/bank/geometry---------------------------
//		ii++;
		NXclosegroup(fileID);
	}
	//-------------------------------close-csns/instrument/bank----------------------------------------
	//-----------------------------open-csns/instrument/monitor----------------------
	std::vector<string> monitorGroup;
	int monitorNum = 3;
	for(int i = 0; i< monitorNum; i++){
		string str1 = static_cast<ostringstream*>(&(ostringstream()<<i))->str();
		monitorGroup.push_back("monitor"+str1);
	}
	std::vector<string>::iterator it_mon;

	int ii_mon = 0;
	for (it_mon = monitorGroup.begin(); it_mon != monitorGroup.end(); it_mon++)
	{
		const char *str_mon = (*it_mon).c_str(); 
		uint64_t evt_num = EVENT_NUM_M;
		status = NXmakegroup(fileID, str_mon,"NXdetector");
		status = NXopengroup(fileID, str_mon,"NXdetector");
		//add distance 
		float mon_distance = 10.0;
		dim[0] = 1;
		text = "m";
		writeNumData(status, fileID, "distance", &mon_distance, 1, dim, text);
		//add azimuthal_angle
		float azimuthalAngle [xpid_M][ypid_M];
		for(int i = 0 ; i<xpid_M; i++){
			for(int j = 0; j<ypid_M; j++){
				azimuthalAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
			}
		}
		text = "degree";
		writeNumData(status, fileID, "azimuthal_angle", *azimuthalAngle, 2, dim2D_M, text);
		//add radial_distance 
		float radial_distance [xpid_M][ypid_M];
		for(int i = 0 ; i<xpid_M; i++){
			for(int j = 0; j<ypid_M; j++){
				radial_distance[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(16.0-0.0);
			}
		}
		text = "m";
		writeNumData(status, fileID, "radial_distance", *radial_distance, 2, dim2D_M, text);
		//add polar_angle
		float polarAngle [xpid_M][ypid_M];
		for(uint32_t i = 0 ; i<xpid_M; i++){
			for(uint32_t j = 0; j<ypid_M; j++){
				polarAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
			}
		}
		text = "degree";
		writeNumData(status, fileID, "polar_angle", *polarAngle, 2, dim2D_M, text);

		//add event_pixel_id
		int64_t eventPixelId [evt_num];
		for (int64_t i = 0; i<evt_num; i++)
		{
			eventPixelId[i]=ii_mon*10000+rand()%(PIXEL_NUM_M);
		}
		dim[0] = evt_num;
        writeNumData(status, fileID, "event_pixel_id", eventPixelId, 1, dim, "0");
		//add event_time_of_flight
		float eventTimeOfFlight [evt_num];
		getFloatRandom1D(eventTimeOfFlight, evt_num, 5000.0, 40000.0);
		writeNumData(status, fileID, "event_time_of_flight", eventTimeOfFlight, 1, dim, "microsecond");
		//add event_index
		int64_t eventIndex [evt_num];
		for(int64_t i =0; i<evt_num; i++)
		{
			eventIndex[i] = i;
		}
		dim[0] = evt_num;
        writeNumData(status, fileID, "event_index", eventIndex, 1, dim, "0");
		//add event_pulse_time
		uint64_t eventPulseTime[evt_num];
		for (uint32_t i = 0; i<evt_num; i++){
			eventPulseTime[i] = 14897125513178+i*40000;
		}
		status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
		status=NXopendata(fileID,"event_pulse_time");
		status=NXputdata(fileID,(void*)eventPulseTime);
		text = "nanosecond";
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		status=NXclosedata(fileID);

		//add x_pixel_size
		float xPixelSize[xpid_M][ypid_M];
		for(uint32_t i = 0 ; i<xpid_M; i++){
			for(uint32_t j = 0; j<ypid_M; j++){
				xPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
			}
		}
		text = "m";
		writeNumData(status, fileID, "x_pixle_size", *xPixelSize, 2, dim2D_M, text);
		//add y_pixel_size
		float yPixelSize[xpid_M][ypid_M];
		for(uint32_t i = 0 ; i<xpid_M; i++){
			for(uint32_t j = 0; j<ypid_M; j++){
				yPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
			}
		}
		text = "m";
		writeNumData(status, fileID, "y_pixle_size", *yPixelSize, 2, dim2D_M, text);
		//add z_pixel_size
		float zPixelSize = 0.01;
		dim[0] = 1;
		text = "m";
		writeNumData(status, fileID, "z_pixle_size", &zPixelSize, 1, dim, text);

		//add local_name  
		string local_name = "monitor";
		writeCharData(status, fileID, "local_name", local_name);
		//add pixel_id 
		int64_t pixelId [xpid_M][ypid_M];
		int64_t _nm = 0; 
		for (int64_t i=0; i<xpid_M; i++){
			for(int64_t j=0; j<ypid_M; j++) {
				pixelId[i][j] = _nm;
				_nm++;
			}
		}
        writeNumData(status, fileID, "pixel_id", *pixelId, 2, dim2D_M, "0");
		//add time_of_flight
		uint32_t timeBin[TIME_BIN];
		for (uint32_t i = 0; i<TIME_BIN; i++)
		{
			timeBin [i]= i*2;
		}
		dim[0] = TIME_BIN;
		status=NXmakedata(fileID,"time_of_flight",NX_UINT32,1,dim);
		status=NXopendata(fileID,"time_of_flight");
		status=NXputdata(fileID,(void*)timeBin);
		text = "microsecond";
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "3";
		NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "Time Of Flight(s)";
		NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		text = "1";
		NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		status=NXclosedata(fileID);

		//add geometry
		//--------------------------------open-csns/instrument/monitor/geometry/-----------------
		status=NXmakegroup(fileID,"geometry","NXgeometry");
		status=NXopengroup(fileID,"geometry","NXgeometry");
		//--------------------------------open-csns/instrument/monitor/geometry/orientation-----------------
		status=NXmakegroup(fileID,"orientation","NXorientation");
		status=NXopengroup(fileID,"orientation","NXorientation");

		float value_ori[6]={1.0,0.0,0.0,1.0,1.0,0.0};
		dim[0]=6; 
		text = "0";
		writeNumData(status, fileID, "value", value_ori, 1, dim, text);
		NXclosegroup(fileID);
		//------------------------close-csns/instrument/monitor/geometry/orientation-----------------------
		//------------------------open-csns/instrument/monitor/geometry/shape-----------------------
		status=NXmakegroup(fileID,"shape","NXshape");
		status=NXopengroup(fileID,"shape","NXshape");
		float size_shape[3]={0.04,-1.0,0.1};
		dim[0]=3;
		text = "m";
		writeNumData(status, fileID, "size", size_shape, 1, dim, text);
		const std::string shape_shape = "nxbox";
		writeCharData(status, fileID, "shape", shape_shape);
		NXclosegroup(fileID); 
		//------------------------close-csns/instrument/monitor/geometry/shape-----------------------
		//------------------------open-csns/instrument/monitor/geometry/translation--------------------
		status=NXmakegroup(fileID,"translation","NXtranslation");
		status=NXopengroup(fileID,"translation","NXtranslation");
		float distance_trans[3]={0.0,0.0,10.0};
		dim[0]=3;
		text = "m";
		writeNumData(status, fileID, "distance", distance_trans, 1, dim, text);
		NXclosegroup(fileID);
		//------------------------close-csns/instrument/monitor/geometry/translation--------------------
		NXclosegroup(fileID);
		//--------------------------------close-csns/instrument/monitor/geometry---------------------------
		ii_mon++;
		NXclosegroup(fileID);
	}
	//-------------------------------close-csns/instrument/monitor----------------------------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument----------------------
	//----------------------------open-csns/logs-----------------------------------
	//open group: csns/logs
	status=NXmakegroup(fileID,"logs","NXcollection");
	status=NXopengroup(fileID,"logs","NXcollection");

    CSNSlogs logs=xmlInfo.getLogs(doc_sum);
    cout<<"proton_charge: "<<logs.proton_charge.size()<<endl;

	//get chopperPhase and chopperSpeed 
	float pulseTime[PULSE_NUM];  
	float pulseValue[PULSE_NUM];
	float chopperSpeedValue[PULSE_NUM];
	getFloatOrder1D(pulseTime, PULSE_NUM, 0.0, 0.04);
	getPulseInfo(pulseValue, PULSE_NUM);
	getFloatRandom1D(chopperSpeedValue, PULSE_NUM, 25.0, 26.0);
	//--------------------------open-csns/logs/disk_chopper0-----------------------------
	//create chopper group
    std::vector<string>::iterator it_disk;
	for(it_disk = chopperGroup.begin(); it_disk!= chopperGroup.end();it_disk++)
	{
		char* pm = (char*)(*it_disk).data();
		status=NXmakegroup(fileID, pm,"NXcollection");
		status=NXopengroup(fileID, pm,"NXcollection");
		//--------------------------open-csns/logs/disk_chopper0/phase-----------------------------
		//open group: csns/logs/disk_chopper0/phase
		status=NXmakegroup(fileID,"phase","NXlog");
		status=NXopengroup(fileID,"phase","NXlog");

		dim[0] = 89;
		text = "s";
		writeNumData(status, fileID, "time", pulseTime, 1, dim, text);
		text = "0";
		writeNumData(status, fileID, "value", pulseValue, 1, dim, text);

		NXclosegroup(fileID);
		//---------------------------------close-csns/logs/disk_chopper/phase--------------------
		//--------------------------open-csns/logs/disk_chopper/speed-----------------------------
		//open group: csns/logs/disk_chopper/speed
		status=NXmakegroup(fileID,"speed","NXlog");
		status=NXopengroup(fileID,"speed","NXlog");

		writeNumData(status, fileID, "time", pulseTime, 1, dim, "s");
		writeNumData(status, fileID, "value", chopperSpeedValue, 1, dim, "Hz");

		NXclosegroup(fileID);
		//--------------------------------close-csns/logs/disk_chopper/speed--------------------
		NXclosegroup(fileID);
		//--------------------------------close-csns/logs/disk_chopper--------------------
	}
	//--------------------------open-csns/logs/proton_charge-----------------------------
	//open group: csns/logs/proton_charge
	status=NXmakegroup(fileID,"proton_charge","NXlog");
	status=NXopengroup(fileID,"proton_charge","NXlog");

	text = "s";
	writeNumData(status, fileID, "time", pulseTime, 1, dim, text);
	text = "pC";
	writeNumData(status, fileID, "value", pulseValue, 1, dim, text);
	//need to generate proton charge value!!! it is not pulse value!!!

	NXclosegroup(fileID);
	//-------------------------------close-csns/logs/proton_charge---------------------------------------
	//--------------------------open-csns/logs/moderator-----------------------------
	status=NXmakegroup(fileID,"moderator","NXlog");
	status=NXopengroup(fileID,"moderator","NXlog");

	status=NXmakegroup(fileID,"temperature","NXlog");
	status=NXopengroup(fileID,"temperature","NXlog");

	text = "s";
	writeNumData(status, fileID, "time", pulseTime, 1, dim, text);
	text = "K";
	writeNumData(status, fileID, "value", pulseValue, 1, dim, text);

	NXclosegroup(fileID);
	NXclosegroup(fileID);
	//--------------------------close-csns/logs/moderator-----------------------------
	//--------------------------open-csns/logs/sample_environment-----------------------------
	//open group: csns/logs/sample_environment
	status=NXmakegroup(fileID,"sample_environment","NXcollection");
	status=NXopengroup(fileID,"sample_environment","NXcollection");

	float time[2] = {0.0, 25.0};
	float value[2] = {0.0, 15.0};

	//-----------------------open-csns/logs/sample_environment/electric_field-----------------------------
	//open group: csns/logs/sample_environment/electric_field
	status=NXmakegroup(fileID,"electric_field","NXlog");
	status=NXopengroup(fileID,"electric_field","NXlog");

	dim[0] = 2;
	text = "s";
	writeNumData(status, fileID, "time", time, 1, dim, text);
	text = "V m-1";
	writeNumData(status, fileID, "value", value, 1, dim, text);

	NXclosegroup(fileID);
	//--------------------------close-csns/logs/sample_environment/electrin_field---------------------------------------
	//-----------------------open-csns/logs/sample_environment/magnetic_field-----------------------------
	status=NXmakegroup(fileID,"magnetic_field","NXlog");
	status=NXopengroup(fileID,"magnetic_field","NXlog");

	text = "s";
	writeNumData(status, fileID, "time", time, 1, dim, text);
	text = "T";
	writeNumData(status, fileID, "value", value, 1, dim, text);

	NXclosegroup(fileID);
	//--------------------------close-csns/logs/sample_environment/magnetic_field---------------------------------------
	//-----------------------open-csns/logs/sample_environment/pressure-----------------------------
	status=NXmakegroup(fileID,"pressure","NXlog");
	status=NXopengroup(fileID,"pressure","NXlog");

	text = "s";
	writeNumData(status, fileID, "time", time, 1, dim, text);
	text = "Pa";
	writeNumData(status, fileID, "value", value, 1, dim, text);

	NXclosegroup(fileID);
	//-------------------------------close-csns/logs/sample_environment/pressure---------------------------------------
	//-----------------------open-csns/logs/sample_environment/temperature-----------------------------
	status=NXmakegroup(fileID,"temperature","NXlog");
	status=NXopengroup(fileID,"temperature","NXlog");

	text = "s";
	writeNumData(status, fileID, "time", time, 1, dim, text);
	text = "K";
	writeNumData(status, fileID, "value", value, 1, dim, text);

	NXclosegroup(fileID);
	//---------------close-csns/logs/sample_environment/temperature---------------------------------------
	NXclosegroup(fileID);
	//-------------------------close-csns/logs/sample_environment---------------------------------------
	NXclosegroup(fileID);
	//--------------------------------------close-csns/logs/---------------------------------------


	//-------------------------------------open-csns/process/-------------------------------
	status=NXmakegroup(fileID,"process","NXprocess");
	status=NXopengroup(fileID,"process","NXprocess");
	//-------------------------------------open-csns/process/process1-------------------------------
	CSNSprocess process1;
	status=NXmakegroup(fileID,"process1","NXnote");
	status=NXopengroup(fileID,"process1","NXnote");

	process1.author="csns";
	process1.algorithm="DroNE_V1, gen_nexus_v1.cpp, calfile.cal";
	process1.date="2015-05-21T16:49:36+08:00";
	process1.description="This is data reconstruction.";

	writeCharData(status,fileID,"author",process1.author);
	writeCharData(status,fileID,"algorithm",process1.algorithm);
	writeCharData(status,fileID,"date",process1.date);
	writeCharData(status,fileID,"description",process1.description);

	NXclosegroup(fileID);
	//--------------------------close-csns/process/process1-------------------------------
	NXclosegroup(fileID);
	//-------------------------------------close-csns/process/-------------------------------
	//-------------------------------open-csns/present_data------------------------------------
	status=NXmakegroup(fileID,"present_data","NXdata");
	status=NXopengroup(fileID,"present_data","NXdata");

	const std::string plot_pres="TOF,intensity:intensity_error";
	const std::string title_pres="Events Distribution";
	const std::string type_pres="line";
	writeCharData(status,fileID,"plot",plot_pres);
	writeCharData(status,fileID,"title",title_pres);
	writeCharData(status,fileID,"type",type_pres);

	uint32_t data1_size=124;
	//  uint32_t data2_size=56;

	float data1[data1_size];
	//  float data2[data2_size];
	float data3[data1_size];
	float data3_error[data1_size];
	getFloatRandom1D(data1, data1_size, 0.0, 100.0);
	//getFloatRandom1D(data2, data2_size, 0.0, 50.0);
	getFloatRandom1D(data3, data1_size, 0.0, 30.0);
	getFloatRandom1D(data3_error, data1_size, 0.0, 1.0);

	dim[0] = data1_size;
	text = "microsecond";
	writeNumData(status, fileID, "TOF", data1, 1, dim, text);
	//  dim[0] = data2_size;
	//  text = "m";
	//  writeNumData(status, fileID, "data2", data2, 1, dim, text);
	dim[0] = data1_size;
	text = "counts";
	writeNumData(status, fileID, "intensity", data3, 1, dim, text);
	dim[0] = data1_size;
	text = "0";
	writeNumData(status, fileID, "intensity_error", data3_error, 1, dim, text);

	NXclosegroup(fileID);
	//-------------------------------------close-csns/present_date/-------------------------------
	//-------------------------------------------open-csns/users------------------------------------
	status=NXmakegroup(fileID,"users","NXcollection");
	status=NXopengroup(fileID,"users","NXcollection");
	//-----------------------------------------open-csns/users/user--------------------------------------
	CSNSusers user1;
	CSNSusers user2;

	status=NXmakegroup(fileID,"user1","NXuser");
	status=NXopengroup(fileID,"user1","NXuser");
	user1.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
	user1.affiliation="IHEP";
	user1.email="tangm@ihep.ac.cn";
	user1.facility_user_id="tangm";
	user1.name="M Tang";
	user1.role="principal_investigator";
	writeCharData(status, fileID, "address", user1.address);
	writeCharData(status, fileID, "affiliation",user1.affiliation);
	writeCharData(status, fileID, "email", user1.email);
	writeCharData(status, fileID, "facility_user_id", user1.facility_user_id);
	writeCharData(status, fileID, "name", user1.name);
	writeCharData(status, fileID, "role", user1.role);
	NXclosegroup(fileID);

	status=NXmakegroup(fileID,"user2","NXuser");
	status=NXopengroup(fileID,"user2","NXuser");
	user2.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
	user2.affiliation="IHEP";
	user2.email="durong@ihep.ac.cn";
	user2.facility_user_id="dur";
	user2.name="R Du";
	user2.role="investigator";
	writeCharData(status, fileID, "address", user2.address);
	writeCharData(status, fileID, "affiliation",user2.affiliation);
	writeCharData(status, fileID, "email", user2.email);
	writeCharData(status, fileID, "facility_user_id", user2.facility_user_id);
	writeCharData(status, fileID, "name", user2.name);
	writeCharData(status, fileID, "role", user2.role);
	NXclosegroup(fileID);
	//-------------------------------------------close-csns/users/user---------------------------------
	NXclosegroup(fileID);
	//-------------------------------------------close-csns/users-----------------------------------------
/*
	//-------------------------------open-csns/event_data------------------------------------
	status=NXmakegroup(fileID,"event_data","NXcollection");
	status=NXopengroup(fileID,"event_data","NXcollection");
	NXclosegroup(fileID);
	for (it_bank = bankGroup.begin(); it_bank != bankGroup.end(); it_bank++)
	{
		std::string bank_name = *it_bank;

		//---------------------------------open-csns/event_data/bank----------------------------
		//create link
		NXlink eventIndexLink;
		NXlink eventPixelIdLink;
		NXlink eventPulseTimeLink;
		NXlink eventTimeOfFlightLink;
		string path = "/csns/instrument/"+bank_name;
		// string path = "/csns/instrument/bank0";
		string pathEventIndex = path+"/event_index";
		string pathEventPixelId = path+"/event_pixel_id";
		string pathEventPulseTime = path+"/event_pulse_time";
		string pathEventTimeOfFlight = path+"/event_time_of_flight";
		string pathEventData="/csns/event_data";

		status=NXopenpath(fileID, pathEventIndex.c_str());
		status=NXgetdataID(fileID, &eventIndexLink);
		status=NXopenpath(fileID, pathEventPixelId.c_str());
		status=NXgetdataID(fileID, &eventPixelIdLink);
		status=NXopenpath(fileID, pathEventPulseTime.c_str());
		status=NXgetdataID(fileID, &eventPulseTimeLink);
		status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
		status=NXgetdataID(fileID, &eventTimeOfFlightLink);

		status=NXopenpath(fileID, pathEventData.c_str());

		const char *str_bank = (*it_bank).c_str();
		status = NXmakegroup(fileID, str_bank,"NXevent_data");
		status = NXopengroup(fileID, str_bank,"NXevent_data");

		//  status=NXmakegroup(fileID, "bank0", "NXevent_data");    
		//  status=NXopengroup(fileID, "bank0", "NXevent_data");    

		status=NXmakelink(fileID, &eventIndexLink);
		status=NXmakelink(fileID, &eventPixelIdLink);
		status=NXmakelink(fileID, &eventPulseTimeLink);
		status=NXmakelink(fileID, &eventTimeOfFlightLink);

		NXclosegroup(fileID);
	}
	//------------------------------close-csns/event_data/bank------------------------------  
	NXclosegroup(fileID);
	//-------------------------------close-csns/event_data----------------------------- 
	//---------------------------open-csns-event_data/monitor-----------------------  
	for (it_mon = monitorGroup.begin(); it_mon != monitorGroup.end(); it_mon++)
	{
		std::string mon_name = *it_mon;

		//---------------------------------open-csns/event_data/monitor----------------------------
		//create link
		NXlink eventIndexLink;
		NXlink eventPixelIdLink;
		NXlink eventPulseTimeLink;
		NXlink eventTimeOfFlightLink;
		string path = "/csns/instrument/"+mon_name;
		string pathEventIndex = path+"/event_index";
		string pathEventPixelId = path+"/event_pixel_id";
		string pathEventPulseTime = path+"/event_pulse_time";
		string pathEventTimeOfFlight = path+"/event_time_of_flight";
		string pathEventData="/csns/event_data";

		status=NXopenpath(fileID, pathEventIndex.c_str());
		status=NXgetdataID(fileID, &eventIndexLink);
		status=NXopenpath(fileID, pathEventPixelId.c_str());
		status=NXgetdataID(fileID, &eventPixelIdLink);
		status=NXopenpath(fileID, pathEventPulseTime.c_str());
		status=NXgetdataID(fileID, &eventPulseTimeLink);
		status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
		status=NXgetdataID(fileID, &eventTimeOfFlightLink);

		status=NXopenpath(fileID, pathEventData.c_str());

		const char *str_mon = (*it_mon).c_str();
		status = NXmakegroup(fileID, str_mon,"NXevent_data");
		status = NXopengroup(fileID, str_mon,"NXevent_data");

		//  status=NXmakegroup(fileID, "bank0", "NXevent_data");    
		//  status=NXopengroup(fileID, "bank0", "NXevent_data");    

		status=NXmakelink(fileID, &eventIndexLink);
		status=NXmakelink(fileID, &eventPixelIdLink);
		status=NXmakelink(fileID, &eventPulseTimeLink);
		status=NXmakelink(fileID, &eventTimeOfFlightLink);

		NXclosegroup(fileID);
	}
	//------------------------------close-csns/event_data/monitor------------------------------  
	NXclosegroup(fileID);
	//-----------------------------close-csns/event_data-----------------------------------
	//-----------------------------open-csns/histogram_data----------------------------------
	status=NXmakegroup(fileID,"histogram_data","NXcollection");
	status=NXopengroup(fileID,"histogram_data","NXcollection");
	NXclosegroup(fileID);
*/
	//------------------------------open_csns/histogram_data/monitor-----------------------
	/*
	   NXlink TimeOfFlightLink;
	   NXlink MonitorDataLink;
	   string pathTimeOfFlight = "/csns/instrument/monitor0/time_of_flight";
	   string pathMonitorData = "/csns/instrument/monitor0/data";
	   string pathHistogramData="/csns/histogram_data";

	   status=NXopenpath(fileID, pathTimeOfFlight.c_str());
	   status=NXgetdataID(fileID, &TimeOfFlightLink);
	   status=NXopenpath(fileID, pathMonitorData.c_str());
	   status=NXgetdataID(fileID, &MonitorDataLink);

	   status=NXopenpath(fileID, pathHistogramData.c_str());
	   status=NXmakegroup(fileID, "monitor0", "NXdata");
	   status=NXopengroup(fileID, "monitor0", "NXdata");

	   status=NXmakelink(fileID, &TimeOfFlightLink);
	   status=NXmakelink(fileID, &MonitorDataLink);

	   NXclosegroup(fileID);
	//-----------------------------close-csns/histogram_data/monitor------------------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/histogram_data----------------------------------
	*/
	NXclosegroup(fileID);
	//-------------------------------close-csns---------------------------------------
	/*-----------------------------------------------*/
	// close file
	NXclose(&fileID);
}
//------------------------------------------------------------------------------
int main()
{
	//std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.xml"; 
	std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.nxs"; 
	std::string summaryfile     = "/home/dur/work/gen_nexus/data/SUMMARY629.xml"; 
	std::string idfbankfile     = "/home/dur/work/gen_nexus/data/idf_bank.xml"; 
	SaveNexusFile(nexusfile, summaryfile, idfbankfile);

	return 0;
}
