#include "parseXML.h"
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
using namespace std;


void  ParseXML::getNodePointerByName(TiXmlElement *root, const char* nodeName, TiXmlElement * &destNode)
{
    if(0==strcmp(nodeName, root->Value()))
        destNode=root;
    TiXmlElement *pNode=root;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        if(0!=strcmp(nodeName,pNode->Value())){
            getNodePointerByName(pNode, nodeName, destNode);
        }else{
            destNode=pNode;
            break;
        }
    }
}

void ParseXML::getNodePointerByAttr(TiXmlElement *root, const char* attrName, const char* attrValue, TiXmlElement * &destNode)
{
    TiXmlAttribute *attr;
    for(attr=root->FirstAttribute();attr!=NULL; attr=attr->Next())
    {
        if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
            destNode=root;
            break;
        }
    }
    TiXmlElement *pNode=root;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        for(attr=pNode->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
                destNode=pNode;
                break;
            }else{
                getNodePointerByAttr(pNode, attrName, attrValue, destNode);
            }
        }
    }
}

vector<string> ParseXML::getDistance(TiXmlDocument *doc, const char* name)
{
    std::vector<string> data;
    TiXmlElement *root, *search, *node;
    TiXmlText *text;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByAttr(root, "name",  name, node);
    getNodePointerByName(node, "distance", search);
    text=search->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data,str2,boost::is_any_of(" "), boost::token_compress_on);
    return data;
}

CSNSgeometry ParseXML::getGeometry(TiXmlDocument *doc, const char* name)
{
    CSNSgeometry data;
    TiXmlElement *root, *search, *node, *group, *son;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByAttr(root, "name",  name, node);
    getNodePointerByName(node, "NXgeometry", search);
    for(group=search->FirstChildElement();group!=NULL; group=group->NextSiblingElement())
    {
        if(0==strcmp(group->Value(),"NXshape")){
            for(son=group->FirstChildElement();son!=NULL;son=son->NextSiblingElement()){
                text=son->FirstChild()->ToText();
                if(0==strcmp(son->Value(), "shape")){
                    data.shape=text->Value();
                }else{
                    str2=text->Value();
                    boost::split(data.size,str2,boost::is_any_of(" "), boost::token_compress_on);
                }
            }
        }else{
            son=group->FirstChildElement();
            text=son->FirstChild()->ToText();
            str2=text->Value();
            boost::split(data.ori,str2,boost::is_any_of(" "), boost::token_compress_on);
        }
    }
    return data;
}

map<string, string> ParseXML::getPublic(TiXmlDocument *doc)
{
    std::map<string, string> data;
    TiXmlElement *root, *search, *node;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    node=root->FirstChildElement();
    for(search=node->FirstChildElement();search!=NULL; search=search->NextSiblingElement()){
        TiXmlNode *tmp=search->FirstChild();
        if(tmp->Type()==TiXmlNode::TINYXML_TEXT){
            text=search->FirstChild()->ToText();
            str=search->Value();
            str2=text->Value();
            data.insert(make_pair(str, str2));
        }else{
            continue;
        }
    }
    return data;
}

map<string, string> ParseXML::getInstrumentComponent(TiXmlDocument *doc, const char* name)
{
    std::map<string, string> data;
    TiXmlElement *root, *search, *node, *group;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByAttr(root, "name", name, search);
    cout<<"search: "<<search->Value()<<endl;
    for(node=search->FirstChildElement();node!=NULL; node=node->NextSiblingElement()){
        str=node->Value();
        if(0!=strcmp(str,"distance")){
            text=node->FirstChild()->ToText();
            str2=text->Value();
            data.insert(make_pair(str, str2));
        }else{
            continue;
        }
    }
    return data;
}
       
map<string, string> ParseXML::getSample(TiXmlDocument *doc)
{
    std::map<string, string> data;
    TiXmlElement *root, *search, *node;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByName(root, "NXsample", search);
    for(node=search->FirstChildElement();node!=NULL;node=node->NextSiblingElement()){
        str=node->Value();
        if(0==strcmp(str,"distance") || 0==strcmp(str,"NXgeometry")){
            continue;
        }else{
            text=node->FirstChild()->ToText();
            str2=text->Value();
            data.insert(make_pair(str, str2));
        }
    }
    return data;
}

vector<CSNSse> ParseXML::getSE(TiXmlDocument *doc)
{
    std::vector<CSNSse> data;
    CSNSse tmp;
    TiXmlElement *root, *search, *node, *group;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByName(root, "NXenvironment", search);
    for(node=search->FirstChildElement(); node!=NULL; node=node->NextSiblingElement()){
        for(group=node->FirstChildElement();group!=NULL; group=group->NextSiblingElement()){
            text=group->FirstChild()->ToText();
            if(0==strcmp(group->Value(),"name")){
                tmp.name=text->Value();
            }else{
                tmp.type=text->Value();
            }
        }
        data.push_back(tmp);
    }
    return data;
}
        
vector<CSNSdc> ParseXML::getDC(TiXmlDocument *doc, const char* name1, const char* name2)
{
    std::vector<CSNSdc> data;
    CSNSdc tmp;
    TiXmlElement *root, *search, *node, *group;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByAttr(root, "name",name1, search);
    getNodePointerByName(search, "phase", node);
    text=node->FirstChild()->ToText();
    tmp.phase=text->Value();
    getNodePointerByName(search, "slit_angle", node);
    text=node->FirstChild()->ToText();
    tmp.slitAngle=text->Value();
    getNodePointerByName(search, "rotation_speed", node);
    text=node->FirstChild()->ToText();
    tmp.rotationSpeed=text->Value();
    tmp.distance=getDistance(doc, name1);
    data.push_back(tmp);

    getNodePointerByAttr(root, "name",name2, search);
    getNodePointerByName(search, "phase", node);
    text=node->FirstChild()->ToText();
    tmp.phase=text->Value();
    getNodePointerByName(search, "slit_angle", node);
    text=node->FirstChild()->ToText();
    tmp.slitAngle=text->Value();
    getNodePointerByName(search, "rotation_speed", node);
    text=node->FirstChild()->ToText();
    tmp.rotationSpeed=text->Value();
    tmp.distance=getDistance(doc, name2);
    data.push_back(tmp);
    tmp.distance.clear();    

    return data;
}

vector<CSNSapeture> ParseXML::getApeture(TiXmlDocument *doc, const char* name1, const char* name2)
{
    std::vector<CSNSapeture> data;
    CSNSapeture tmp;
    tmp.geometry=getGeometry(doc,name1);
    tmp.distance=getDistance(doc,name1);
    data.push_back(tmp);
    
    tmp.geometry=getGeometry(doc,name2);
    tmp.distance=getDistance(doc,name2);
    data.push_back(tmp);
    tmp.distance.clear();
    tmp.geometry.ori.clear();
    tmp.geometry.size.clear();
}

CSNSbs ParseXML::getBS(TiXmlDocument *doc, const char* name)
{
    CSNSbs data;
    data.geometry=getGeometry(doc,name);
    data.distance=getDistance(doc,name);
    TiXmlElement *root, *search, *node;
    TiXmlText *text;
    root=doc->RootElement();
    getNodePointerByName(root, "status", search);
    text=search->FirstChild()->ToText();
    data.status=text->Value();
    return data;
}

CSNSlogs ParseXML::getLogs(TiXmlDocument *doc)
{
    CSNSlogs data;
    TiXmlElement *root, *search, *node, *group;
    TiXmlText *text;
    const char* str;
    const char* str2;
    root=doc->RootElement();
    getNodePointerByName(root, "NXcollection", search);

    getNodePointerByName(search, "proton_charge", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.proton_charge,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNodePointerByName(search, "disk_chopper_phase1", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.disk_chopper_phase1,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNodePointerByName(search, "sample_electric_field", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_electric_field,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNodePointerByName(search, "sample_magnetic_field", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_magnetic_field,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNodePointerByName(search, "sample_pressure", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_pressure,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNodePointerByName(search, "sample_environment_temperature", node);
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_environment_temperature,str2,boost::is_any_of(":"), boost::token_compress_on);

    return data;
}

std::vector<CSNSdet> ParseXML::getDetector(TiXmlDocument *doc)
{
    std::vector<CSNSdet> data;
    CSNSdet tmp;
    TiXmlElement *root, *search, *node, *group;
    TiXmlAttribute *attr;
    TiXmlText *text;
    const char* str;
    const char* str2;
    string xpixels, ypixels, xstep, ystep, xstart, ystart;
    root=doc->RootElement();
    getNodePointerByAttr(root, "is", "rectangularDetector", search);
    for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        if(0==strcmp("xpixels",attr->Name()))
            xpixels=attr->Value();
        if(0==strcmp("ypixels",attr->Name()))
            ypixels=attr->Value();
        if(0==strcmp("xstep",attr->Name()))
            xstep=attr->Value();
        if(0==strcmp("ystep",attr->Name()))
            ystep=attr->Value();
        if(0==strcmp("xstart",attr->Name()))
            xstart=attr->Value();
        if(0==strcmp("ystart",attr->Name()))
            ystart=attr->Value();
        continue;
    }
    getNodePointerByAttr(root, "name", "detector", search);
    int nu=0;
    for(node=search->FirstChildElement();node!=NULL;node=node->NextSiblingElement())
    {
        cout<<"nu= "<<nu<<endl;
        getNodePointerByName(node, "component", group);
        for(attr=group->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("idstart",attr->Name()))
            {
                tmp.pid.insert(make_pair("idstart",attr->Value()));
                cout<<"idstart= "<<attr->Value()<<endl;
            }
            if(0==strcmp("idstepbyrow",attr->Name()))
                tmp.pid.insert(make_pair("idstepbyrow",attr->Value()));
            continue;
        }
        tmp.pid.insert(make_pair("xpixels",xpixels.c_str()));
        tmp.pid.insert(make_pair("ypixels",ypixels.c_str()));
        
        getNodePointerByName(node, "location", group);
        for(attr=group->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("name",attr->Name()))
                tmp.bankName=attr->Value();
            if(0==strcmp("x",attr->Name()))
                tmp.pos.insert(make_pair("x",attr->Value()));
            if(0==strcmp("y",attr->Name()))
                tmp.pos.insert(make_pair("y",attr->Value()));
            if(0==strcmp("z",attr->Name()))
                tmp.pos.insert(make_pair("z",attr->Value()));
        }
        getNodePointerByName(node, "rot", group);
        for(attr=group->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("val",attr->Name()))
                tmp.pos.insert(make_pair("val",attr->Value()));
            if(0==strcmp("axis-x",attr->Name()))
                tmp.pos.insert(make_pair("axis-x",attr->Value()));
            if(0==strcmp("axis-y",attr->Name()))
                tmp.pos.insert(make_pair("axis-y",attr->Value()));
            if(0==strcmp("axis-z",attr->Name()))
                tmp.pos.insert(make_pair("axis-z",attr->Value()));
        }
        tmp.pos.insert(make_pair("xstart",xstart.c_str()));
        tmp.pos.insert(make_pair("ystart",ystart.c_str()));
        tmp.pos.insert(make_pair("xstep",xstep.c_str()));
        tmp.pos.insert(make_pair("ystep",ystep.c_str()));
        
        data.push_back(tmp);
        nu++;
        tmp.pid.clear();
        tmp.pos.clear();
    }
    return data;
}
