#include <iostream>
#include <iomanip>
#include <locale>
#include <sstream>
#include <fstream>
#include <string>
#include <ctime>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "nexus/NeXusFile.hpp"
#include <vector>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include "log.h"
#include "config.h"
#include "r2n.h"

using namespace std;

int dim[1]={0}; // one dimension data , dim[0] is line number. 
//get method
//-----------------------------------------------------------------------------
void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
	dim[0] = dataValue.size();
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
	status=NXopendata(fileID,p);
	status=NXputdata(fileID,dataValue.c_str());
	status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
// if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
//text is the unit.
void writeFloatData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
	status=NXopendata(fileID, p);
	status=NXputdata(fileID, dataValue);
	while(text != "0")
	{
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		break;
	}
	status=NXclosedata(fileID);
}
//------------------------------------------------------------------------------------
void SaveNexusFile(std::string nexusfilename){
	std::cout << "SavenexusFile" << std::endl;
//	NXaccess mode(NXACC_CREATE5);
	NXaccess mode(NXACC_CREATEXML);
	NXstatus status;
	NXhandle fileID;
	uint32_t compression(NX_COMP_LZW);
	status=NXopen(nexusfilename.c_str(), mode, &fileID);
	//-----------------------------------open-csns-------------------------------------------
	//enter group: csns
	status=NXmakegroup(fileID,"csns","NXentry");
	status=NXopengroup(fileID,"csns","NXentry");

	const std::string description = "This is the first beam from CSNS";
	writeCharData(status, fileID, "description", description);

	const std::string user_id = "zhangsan";
	writeCharData(status, fileID, "user_id", user_id);

	const std::string beamline = "BL18";
	writeCharData(status, fileID, "beamline", beamline);

	const std::string start_time_utc = "2016-06-21T16:58:34.123+08:00";
	writeCharData(status, fileID, "start_time_utc", start_time_utc);

	const std::string end_time_utc = "2016-06-22T16:58:34.321+08:00";
	writeCharData(status, fileID, "end_time_utc", end_time_utc);

	const std::string proposal_id = "CSNS-0000001";
	writeCharData(status, fileID, "proposal_id",proposal_id);

	const std::string facility = "CSNS";
	writeCharData(status, fileID, "facility", facility);

	const std::string instrument_name = "GPPD";
	writeCharData(status, fileID, "instrument_name", instrument_name);

	int64_t start_time_tai = 14913726990000000;
	dim[0]=1;
	status=NXmakedata(fileID, "start_time_tai", NX_INT64, 1, dim);
	status=NXopendata(fileID, "start_time_tai");
	status=NXputdata(fileID, &start_time_tai);
	status=NXclosedata(fileID); 

	int64_t end_time_tai = 14914026990000000;
	status=NXmakedata(fileID, "end_time_tai", NX_INT64, 1, dim);
	status=NXopendata(fileID, "end_time_tai");
	status=NXputdata(fileID, &end_time_tai);
	status=NXclosedata(fileID); 

	const std::string run_no = "0040956";
	writeCharData(status, fileID, "run_no", run_no);

	const std::string measurement_type = "scattering";
	writeCharData(status, fileID, "measurement_type", measurement_type);


	string text;
	//----------------------------open-csns/instrument-----------------------------------------
	status=NXmakegroup(fileID,"instrument","NXinstrument");
	status=NXopengroup(fileID,"instrument","NXinstrument");
	//----------------------------------open-csns/instrument/sample--------------------------
	//enter group: csns/instrument/sample
	status=NXmakegroup(fileID,"sample","NXsample");
	status=NXopengroup(fileID,"sample","NXsample");

	const std::string chemical_formula = "Si";
	const std::string name = "Sillicon";
	const std::string situation = "vacuum";
	const std::string type = "sample+can";

	writeCharData(status, fileID, "chemical_formula", chemical_formula);
	writeCharData(status, fileID, "name", name);
	writeCharData(status, fileID, "situation", situation);
	writeCharData(status, fileID, "type", type);

	const float density = 2.0; 
	float distance[3] = {0.0, 0.0, 0.0};
	const float mass = 5.0;

	dim[0] = 1;
	text = "g cm-3";
	writeFloatData(status, fileID, "density", &density, 1, dim, text);
	text = "g";
	writeFloatData(status, fileID, "mass", &mass, 1, dim, text);
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "distance", distance, 1, dim, text);
	//-----------------------------open-csns/instrument/sample/geometry----------------------
	//enter group: csns/instrument/sample/geometry
	status=NXmakegroup(fileID,"geometry","NXgeometry");
	status=NXopengroup(fileID,"geometry","NXgeometry");
	//-----------------------------open-csns/instrument/sample/geometry/shape-------------------
	//enter group: csns/instrument/sample/geometry/shape
	status=NXmakegroup(fileID,"shape","NXshape");
	status=NXopengroup(fileID,"shape","NXshape");

	const std::string shape = "nxbox";
	writeCharData(status, fileID, "shape", shape);

	float size[3] = {0.1,0.1,0.0};
	dim[0] = 3;
	text = "m";
	writeFloatData(status, fileID, "size", size, 1, dim, text);

	NXclosegroup(fileID);
	//------------------------close-csns/instrument/sample/geometry/shape----------------------
	NXclosegroup(fileID);
	//--------------------------close-csns/instrument/sample/geometry----------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/sample----------------------
	//--------------------------------open-csns/instrument/sample_environment---------------------------------
	status=NXmakegroup(fileID,"sample_environment","NXenvironment");
	status=NXopengroup(fileID,"sample_environment","NXenvironment");

	status=NXmakegroup(fileID,"sample_environment1","NXnote");
	status=NXopengroup(fileID,"sample_environment1","NXnote");

	const std::string name_se="hypothermia";
	const std::string type_se="CSNS_Cryto_05";

	writeCharData(status,fileID,"name",name_se);
	writeCharData(status,fileID,"type",type_se);

	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/sample_environment1---------------------------------
	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/sample_environment---------------------------------
	//--------------------------------open-csns/instrument/source---------------------------------
	status=NXmakegroup(fileID,"source","NXsource");
	status=NXopengroup(fileID,"source","NXsource");

	const std::string name_source="csns";
	const std::string type_source="spallation neutron source";
	const std::string probe_source="neutron";
	writeCharData(status,fileID,"name",name_source);
	writeCharData(status,fileID,"type",type_source);
	writeCharData(status,fileID,"probe",probe_source);

	const int32_t frequency_source = 25;  
	const float power_source =2.0;

	dim[0]=1;
	status=NXmakedata(fileID, "frequency", NX_INT32, 1, dim);
	status=NXopendata(fileID, "frequency");
	status=NXputdata(fileID, &frequency_source);
	text = "Hz";
	NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
	status=NXclosedata(fileID);
	
	text = "W";
	writeFloatData(status, fileID, "power", &power_source, 1, dim, text);

	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/source---------------------------------
	//------------------------------open-csns/instrument/disk_chopper-------------------------
    std::vector<string> chopperGroup;
    chopperGroup.push_back("disk_chopper0");
    chopperGroup.push_back("disk_chopper1");
    std::vector<string>::iterator it_disk;
    for(it_disk=chopperGroup.begin();it_disk!=chopperGroup.end();it_disk++)
	{
        char* pm=(char*)(*it_disk).data();
		status = NXmakegroup(fileID, pm,"NXdisk_chopper");
		status = NXopengroup(fileID, pm,"NXdisk_chopper");
		float phase = 10.0;
		float slitAngle = 30.0;
		float distance[3] = {0.0, 0.0, -5.0};
		float rotationSpeed = 25.0;

		dim[0]=1; 
		text = "degree";
		writeFloatData(status, fileID, "phase", &phase, 1, dim, text);
		text = "degree";
		writeFloatData(status, fileID, "slit_angle", &slitAngle, 1, dim, text);
		text = "Hz";
		writeFloatData(status, fileID, "rotation_speed", &rotationSpeed, 1, dim, text);
		dim[0]=3;
		text = "m";
		writeFloatData(status, fileID, "distance", distance, 1, dim, text);
		NXclosegroup(fileID);
	}

	//--------------------------------close-csns/instrument/disk_chopper---------------------------------
	//-------------------------open-csns/instrument/beam_stop--------------------------------------
	status=NXmakegroup(fileID,"beam_stop","NXbeam_stop");
        status=NXopengroup(fileID,"beam_stop","NXbeam_stop");
	//--------------------------------open-csns/instrument/beam_stop/geometry---------------------------
	status=NXmakegroup(fileID,"geometry","NXgeometry");
	status=NXopengroup(fileID,"geometry","NXgeometry");
	//--------------------------------open-csns/instrument/beam_stop/geometry/orientation-----------------
	status=NXmakegroup(fileID,"orientation","NXorientation");
	status=NXopengroup(fileID,"orientation","NXorientation");

	float value_ori_bs[6]={1.0,0.0,0.0,0.0,1.0,0.0};
	dim[0]=6; 
	text = "0";
	writeFloatData(status, fileID, "value", value_ori_bs, 1, dim, text);
	NXclosegroup(fileID);
	//------------------------close-csns/instrument/beam_stop/geometry/orientation-----------------------
	//------------------------open-csns/instrument/beam_stop/geometry/shape-----------------------
	status=NXmakegroup(fileID,"shape","NXshape");
	status=NXopengroup(fileID,"shape","NXshape");

	float size_shape_bs[3]={0.04,-1.0,0.1};
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "size", size_shape_bs, 1, dim, text);

	const std::string shape_shape_bs = "nxelliptical";
	writeCharData(status, fileID, "shape", shape_shape_bs);

	NXclosegroup(fileID); 
	//------------------------close-csns/instrument/beam_stop/geometry/shape-----------------------
	NXclosegroup(fileID);
	//------------------------close-csns/instrument/beam_stop/geometry/--------------------

	float distance_trans_bs[3]={0.0,0.0,10.0};
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "distance", distance_trans_bs, 1, dim, text);
	const string status_bs="in";
	writeCharData(status, fileID, "status", status_bs);
	NXclosegroup(fileID);
	//-------------------------close-csns/instrument/beam_stop--------------------------------------
	//--------------------------------open-csns/instrument/aperture1---------------------------------
    std::vector<string> apertureGroup;
    apertureGroup.push_back("aperture0");
    apertureGroup.push_back("aperture1");
    std::vector<string>::iterator it_ape;

    for(it_ape=apertureGroup.begin();it_ape!=apertureGroup.end();it_ape++)
    {
        char* pm=(char*)(*it_ape).data();
	status=NXmakegroup(fileID,pm,"NXaperture");
	status=NXopengroup(fileID,pm,"NXaperture");

	//--------------------------------open-csns/instrument/aperture1/geometry---------------------------
	status=NXmakegroup(fileID,"geometry","NXgeometry");
	status=NXopengroup(fileID,"geometry","NXgeometry");
	//--------------------------------open-csns/instrument/aperture1/geometry/orientation-----------------
	status=NXmakegroup(fileID,"orientation","NXorientation");
	status=NXopengroup(fileID,"orientation","NXorientation");

	float value_ori[6]={1.0,0.0,0.0,0.0,1.0,0.0};
	dim[0]=6; 
	text = "0";
	writeFloatData(status, fileID, "value", value_ori, 1, dim, text);
	NXclosegroup(fileID);
	//------------------------close-csns/instrument/aperture1/geometry/orientation-----------------------
	//------------------------open-csns/instrument/aperture1/geometry/shape-----------------------
	status=NXmakegroup(fileID,"shape","NXshape");
	status=NXopengroup(fileID,"shape","NXshape");

	float size_shape[3]={0.04,-1.0,0.1};
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "size", size_shape, 1, dim, text);

	const std::string shape_shape = "nxelliptical";
	writeCharData(status, fileID, "shape", shape_shape);

	NXclosegroup(fileID); 
	//------------------------close-csns/instrument/aperture1/geometry/shape-----------------------
	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/aperture1/geometry---------------------------

	float distance_trans[3]={0.0,0.0,10.0};
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "distance", distance_trans, 1, dim, text);
	NXclosegroup(fileID);
    }
	//--------------------------------close-csns/instrument/aperture1---------------------------------
	//-----------------------------open-csns/instrument/flipper-------------------------
	status=NXmakegroup(fileID,"flipper","NXflipper");
	status=NXopengroup(fileID,"flipper","NXflipper");
	const std::string type_flipper="coil";
	writeCharData(status, fileID, "type", type_flipper);
	int32_t spin_flipper=1;
	dim[0]=1;
	status=NXmakedata(fileID, "spin", NX_INT32, 1, dim);
	status=NXopendata(fileID, "spin");
	status=NXputdata(fileID, &spin_flipper);
	status=NXclosedata(fileID);
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/flipper-------------------------
	//-----------------------------open-csns/instrument/polarizer-------------------------
	status=NXmakegroup(fileID,"polarizer","Npolarizer");
	status=NXopengroup(fileID,"polarizer","Npolarizer");
	const std::string type_polarizer="crystal";
	writeCharData(status, fileID, "type", type_polarizer);
	float efficiency = 0.90;
	dim[0]=1;
	text = "0";
	writeFloatData(status, fileID, "efficiency", &efficiency, 1, dim, text);
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/polarizer-------------------------	
	//-----------------------------open-csns/instrument/flipper-------------------------
	status=NXmakegroup(fileID,"analyzer","NXcrystal");
	status=NXopengroup(fileID,"analyzer","NXcrystal");
	const std::string type_analyzer="coil";
	writeCharData(status, fileID, "type", type_analyzer);
	int32_t spin_analyzer=1;
	dim[0]=1;
	status=NXmakedata(fileID, "spin", NX_INT32, 1, dim);
	status=NXopendata(fileID, "spin");
	status=NXputdata(fileID, &spin_analyzer);
	status=NXclosedata(fileID);
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/flipper-------------------------
	//--------------------------------open-csns/instrument/moderator---------------------------------
	status=NXmakegroup(fileID,"moderator","NXmoderator");
	status=NXopengroup(fileID,"moderator","NXmoderator");

	const std::string type_mod="Liquid H2/coupled";
	writeCharData(status, fileID, "type", type_mod);

	float distance_mod[3]={0.0, 0.0,-30.0};
	dim[0]=3;
	text = "m";
	writeFloatData(status, fileID, "distance", distance_mod, 1, dim, text);
	dim[0]=1;
	const float temperature_mod = 20.0;
	text = "K";
	writeFloatData(status, fileID, "temperature", &temperature_mod, 1, dim, text);

	NXclosegroup(fileID);
	//--------------------------------close-csns/instrument/moderator---------------------------------
	//-----------------------------open-csns/instrument/bank----------------------
	{
		status = NXmakegroup(fileID, "detector","NXdetector");
		status = NXopengroup(fileID, "detector","NXdetector");

		//add local_name  
		string local_name = "backward0";
		writeCharData(status, fileID, "local_name", local_name);
		string ddf="./detector_definition.xml";
		writeCharData(status, fileID, "detector_definition_file", ddf);
		//--------------------------------close-csns/instrument/bank/geometry---------------------------
		NXclosegroup(fileID);
	}
	//-------------------------------close-csns/instrument/bank----------------------------------------
	//-----------------------------open-csns/instrument/monitor----------------------
	{
		status = NXmakegroup(fileID, "monitor","NXmonitor");
		status = NXopengroup(fileID, "monitor","NXmonitor");

		string local_name = "monitor";
		writeCharData(status, fileID, "local_name", local_name);
		string mdf="./monitor_definition.xml";
                writeCharData(status, fileID, "monitor_definition_file", mdf);
		NXclosegroup(fileID);
	}
	//-------------------------------close-csns/instrument/monitor----------------------------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument----------------------
	//----------------------------open-csns/logs-----------------------------------
	//open group: csns/logs
	status=NXmakegroup(fileID,"logs","NXcollection");
	status=NXopengroup(fileID,"logs","NXcollection");

	const string proton_charge="/path/to/file1:/path/to/file2";
	writeCharData(status, fileID, "proton_charge", proton_charge);
	const string disk_chopper_phase="/path/to/file:/path/to/file2";
	writeCharData(status, fileID, "disk_chopper_phase1", disk_chopper_phase);
	const string sample_electric_field="/path/to/file:/path/to/file2";
	writeCharData(status, fileID, "sample_electric_field", sample_electric_field);
	const string sample_magnetic_field="/path/to/file:/path/to/file2";
	writeCharData(status, fileID, "sample_magnetic_field", sample_magnetic_field);
	const string sample_pressure="/path/to/file:/path/to/file2";
	writeCharData(status, fileID, "sample_pressure", sample_pressure);
	const string sample_environment_temperature="/path/to/file:/path/to/file2";
	writeCharData(status, fileID, "sample_environment_temperature", sample_environment_temperature);
	NXclosegroup(fileID);
	//--------------------------------------close-csns/logs/---------------------------------------

	NXclosegroup(fileID);
	//-------------------------------close-csns---------------------------------------
	/*-----------------------------------------------*/
	// close file
	NXclose(&fileID);
}
//------------------------------------------------------------------------------
int main()
{
	std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.xml"; 
	//std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.nxs"; 
	SaveNexusFile(nexusfile);

	return 0;
}
