#include <tinyxml.h>
#include <iostream>
#include <iomanip>
#include <locale>
#include <sstream>
#include <fstream>
#include <string>
#include <ctime>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "nexus/NeXusFile.hpp"
#include <vector>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include "log.h"
#include "config.h"
#include "parseXML.h"
#include "r2n.h"

using namespace std;

const uint32_t PULSE_NUM = 10000;
const uint32_t xpid_M = 16;
const uint32_t ypid_M = 16;
const uint32_t PIXEL_NUM_M = xpid_M*ypid_M;
const uint32_t EVENT_NUM_M = 25000;
const uint64_t EVENT_NUM = 10000;
const uint32_t TIME_BIN = 20000;
int dim[1]={0}; // one dimension data , dim[0] is line number. 
int dim2D_M [2] = {xpid_M, ypid_M};
//get method
//-----------------------------------------------------------------------------
inline void writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType)
{
    status=NXmakegroup(fileID,groupName,groupType);
    status=NXopengroup(fileID,groupName,groupType);
}

inline void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
	dim[0] = dataValue.size();
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
	status=NXopendata(fileID,p);
	status=NXputdata(fileID,dataValue.c_str());
	status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
// if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
inline void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
	status=NXopendata(fileID, p);
	status=NXputdata(fileID, dataValue);
	while(text != "")
	{
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		break;
	}
	status=NXclosedata(fileID);
}
inline void writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
	char* p = (char*)dataName.data();
	status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
	status=NXopendata(fileID, p);
	status=NXputdata(fileID, dataValue);
	while(text != "")
	{
		NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
		break;
	}
	status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
//chopper used it
void getFloatOrder1D(float floatOrder1D[], uint32_t size, float init, float step)
{
	for (uint32_t i = 0; i < size; i++)
		floatOrder1D[i] = init+i*step;
}
//--------------------------------------------------------------------------------------
//chopper, present_data used it
void getFloatRandom1D(float floatRandom1D[], uint32_t size, float min, float max)
{
	for(uint32_t i = 0 ; i < size; i++)
		floatRandom1D[i] = min + ((float)rand()/(float)RAND_MAX)*(max-min);
}
//--------------------------------------------------------------------------------------
//chopper used it
void getPulseInfo(float pulseValue[], uint32_t size)
{
	for(uint32_t i = 0; i < size; i++)
		pulseValue[i] = rand()%2;
}
//------------------------------------------------------------------------------------
void SaveNexusFile(std::string nexusfilename, string summaryfilename, string idfbankfilename){
	std::cout << "SavenexusFile" << std::endl;
	NXaccess mode(NXACC_CREATE5);
	NXstatus status;
	NXhandle fileID;
	uint32_t compression(NX_COMP_LZW);
	status=NXopen(nexusfilename.c_str(), mode, &fileID);
    ParseXML sumXML(summaryfilename);
    ParseXML idfXML(idfbankfilename);
    std::map<string, string> publicFromSummary=sumXML.getPublic();
	//-----------------------------------open-csns-------------------------------------------
    writeGroup(status, fileID, "csns", "NXentry");
	cout<<"open csns group"<<endl;
	cout<<publicFromSummary["facility"]<<endl;
	writeCharData(status, fileID, "run_no", publicFromSummary["run_no"]);
	writeCharData(status, fileID, "beamline", publicFromSummary["beamline"]);
	writeCharData(status, fileID, "description", publicFromSummary["description"]);
	writeCharData(status, fileID, "start_time_tai", publicFromSummary["start_time_tai"]);
	writeCharData(status, fileID, "start_time_utc", publicFromSummary["start_time_utc"]);
	writeCharData(status, fileID, "end_time_tai", publicFromSummary["end_time_tai"]);
	writeCharData(status, fileID, "end_time_utc", publicFromSummary["end_time_utc"]);
	writeCharData(status, fileID, "proposal_id", publicFromSummary["proposal_id"]);
	writeCharData(status, fileID, "instrument_name", publicFromSummary["instrument_name"]);
	writeCharData(status, fileID, "facility", publicFromSummary["facility"]);

		const std::string version = "1";
		writeCharData(status, fileID, "version", version);
		const std::string definition = "TOF";
		writeCharData(status, fileID, "definition", definition);
//		std::string instrument_definition = ""; 
//		fstream fileidf;
	//	fileidf.open("/home/dur/work/gen_nexus/data/GPPD_IDF_template.xml", std::ios::in);
	//	std::stringstream tmp;
	//	tmp<<fileidf.rdbuf();
	//	instrument_definition = tmp.str();
	//	fileidf.close();

	string text;
	//----------------------------open-csns/instrument-----------------------------------------
    writeGroup(status, fileID, "instrument", "NXinstrument");
	//----------------------------------open-csns/instrument/sample--------------------------
	//enter group: csns/instrument/sample
    writeGroup(status, fileID, "sample", "NXsample");
	cout<<"open sample group"<<endl;
    CSNSsam sampleFromSummary=sumXML.getSample();

	writeCharData(status, fileID, "chemical_formula", sampleFromSummary.chemical_formula);
	writeCharData(status, fileID, "name", sampleFromSummary.name);
	writeCharData(status, fileID, "situation", sampleFromSummary.situation);
	writeCharData(status, fileID, "type", sampleFromSummary.type);
	dim[0] = 1;
	writeNumData(status, fileID, "density", &sampleFromSummary.density, 1, dim, "g cm-3");
	writeNumData(status, fileID, "mass", &sampleFromSummary.mass, 1, dim, "g");
	dim[0]=3;
	writeNumData(status, fileID, "distance", sampleFromSummary.distance, 1, dim, "m");
	//-----------------------------open-csns/instrument/sample/geometry----------------------
    writeGroup(status, fileID, "geometry", "NXgeometry");
	//-----------------------------open-csns/instrument/sample/geometry/shape-------------------
    writeGroup(status, fileID, "shape", "NXshape");
	writeCharData(status, fileID, "shape", sampleFromSummary.geometry.shape);
	dim[0] = 3;
	writeNumData(status, fileID, "size", sampleFromSummary.geometry.size, 1, dim, "m");
	NXclosegroup(fileID);
	NXclosegroup(fileID);
	//--------------------------close-csns/instrument/sample/geometry----------------------
	NXclosegroup(fileID);
	//-----------------------------close-csns/instrument/sample----------------------
	//----------------open-csns/instrument/sample_environment---------------------------------
    writeGroup(status, fileID, "sample_environment", "NXsample_environment");
    vector<CSNSse> se=sumXML.getSE();
    vector<CSNSse>::iterator it_se;
    for(it_se=se.begin();it_se!=se.end();it_se++)
    {
        const char* gName=(*it_se).seName.c_str();
        writeGroup(status, fileID, gName, "NXnote");
        writeCharData(status,fileID,"name",(*it_se).name);
        writeCharData(status,fileID,"type",(*it_se).type);
        NXclosegroup(fileID);
        NXclosegroup(fileID);
    }
    //------------------close-csns/instrument/sample_environment---------------------------------
    //------------------------------open-csns/instrument/disk_chopper-------------------------
    vector<CSNSdc> diskChopper=sumXML.getDC();
    vector<CSNSdc>::iterator it_dc;
    for(it_dc=diskChopper.begin();it_dc!=diskChopper.end();it_dc++)
    {
        const char* gName=((*it_dc).dcName).c_str();
        writeGroup(status, fileID, gName, "NXdisk_chopper");
        dim[0]=1; 
        writeNumData(status, fileID, "phase", &(*it_dc).phase, 1, dim, "degree");
        writeNumData(status, fileID, "slit_angle", &(*it_dc).slitAngle, 1, dim, "degree");
        writeNumData(status, fileID, "rotation_speed", &(*it_dc).rotationSpeed, 1, dim, "Hz");
        dim[0]=3;
        writeNumData(status, fileID, "distance", (*it_dc).distance, 1, dim, "m");
        NXclosegroup(fileID);
    }
    //--------------------------------close-csns/instrument/disk_chopper---------------------------------
    
    //--------------------------------open-csns/instrument/source---------------------------------
    writeGroup(status, fileID, "source", "NXsource");

    CSNSsource sourceFromSummary=sumXML.getSource();
    writeCharData(status,fileID,"name",sourceFromSummary.name);
    writeCharData(status,fileID,"type",sourceFromSummary.type);
    writeCharData(status,fileID,"probe",sourceFromSummary.probe);
    dim[0]=1;
    writeNumData(status, fileID, "frequency", &sourceFromSummary.frequency, 1, dim, "Hz");
    writeNumData(status, fileID, "power", &sourceFromSummary.power, 1, dim, "W");
    NXclosegroup(fileID);
    //----------------------------close-csns/instrument/source---------------------------------
    //--------------------------------open-csns/instrument/moderator---------------------------------
    writeGroup(status, fileID, "moderator", "NXmoderator");

    CSNSmoderator moderatorFromSummary=sumXML.getModerator();
    writeCharData(status, fileID, "type", moderatorFromSummary.type);
    dim[0]=3;
    writeNumData(status, fileID, "distance", moderatorFromSummary.distance, 1, dim, "m");
    dim[0]=1;
    writeNumData(status, fileID, "temperature", &moderatorFromSummary.temperature, 1, dim, "K");

    cout<<"set bool coupled!"<<endl;
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/moderator---------------------------------
    //--------------------------------open-csns/instrument/aperture1---------------------------------
    vector<CSNSaperture> aperture=sumXML.getAperture();
    vector<CSNSaperture>::iterator it_ap;

    for(it_ap=aperture.begin();it_ap!=aperture.end();it_ap++)
    {
        const char* gName=(*it_ap).apertureName.c_str(); 
        writeGroup(status, fileID, gName, "NXaperture");
        //--------------------------------open-csns/instrument/aperture1/geometry---------------------------
        writeGroup(status, fileID, "geometry", "NXgeometry");
        writeGroup(status, fileID, "orientation", "NXorientation");
        dim[0]=6; 
        writeNumData(status, fileID, "value", (*it_ap).geometry.ori, 1, dim, "");
        NXclosegroup(fileID);
        
        writeGroup(status, fileID, "shape", "NXshape");
        dim[0]=3;
        writeNumData(status, fileID, "size", (*it_ap).geometry.size, 1, dim, "m");

        const std::string shape_shape = "nxelliptical";
        writeCharData(status, fileID, "shape", (*it_ap).geometry.shape);

        NXclosegroup(fileID); 
        NXclosegroup(fileID);
        writeNumData(status, fileID, "distance", (*it_ap).distance, 1, dim, "m");
        NXclosegroup(fileID);
        //-------------------------close-csns/instrument/aperture1---------------------------------
    }
    cout<<"0"<<endl;
    //---------------------------open-csns/instrument/beam_stop---------------------------------
    CSNSbs beamstop=sumXML.getBS();
    writeGroup(status, fileID, "beam_stop", "NXbeam_stop");
    dim[0]=3;
    writeNumData(status, fileID, "distance", beamstop.distance, 1, dim, "m");
    writeCharData(status, fileID, "status", beamstop.status); 
    //--------------------------------open-csns/instrument/beam_stop/geometry---------------------------------
        writeGroup(status, fileID, "geometry", "NXgeometry");
        writeGroup(status, fileID, "orientation", "NXorientation");
    dim[0]=6;
    writeNumData(status, fileID, "value", beamstop.geometry.ori, 1, dim, text);
    NXclosegroup(fileID);

        writeGroup(status, fileID, "shape", "NXshape");
    writeCharData(status, fileID, "shape", beamstop.geometry.shape);

    dim[0] = 3;
    writeNumData(status, fileID, "size", beamstop.geometry.size, 1, dim, "m");
    NXclosegroup(fileID);
    //-------------------------------close-csns/instrument/beam_stop/shape---------------------------
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/beam_stop/geometry---------------------------------
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/beam_stop/---------------------------------
    cout<<"1"<<endl;
    vector<string> bankGroup=idfXML.getBankName();
    cout<<"bank begin"<<endl;
    int bankNum=bankGroup.size();
    //-----------------------------open-csns/instrument/bank----------------------
    for(int ii = 0; ii!=bankNum; ii++)
    {
    /*
        int xpid=int(detGroup[ii].pid["xpixels"]);
        int ypid=int(detGroup[ii].pid["ypixels"]);
        int idstart=int(detGroup[ii].pid["idstart"]);
        int idstep=int(detGroup[ii].pid["idstepbyrow"]);
        float xstep=detGroup[ii].pos["xstep"]; 
        float ystep=detGroup[ii].pos["ystep"]; 
    if (xstep<0)
    xstep=0-xstep;
    if (ystep<0)
    ystep=0-ystep;
    cout<<"xstep= "<<xstep<<endl;
    cout<<"ystep= "<<ystep<<endl;
    */
    int xpid=3;
    int ypid=3;
    int dim2D [2] = {xpid, ypid};
    uint64_t evt_num = EVENT_NUM;
        const char *str_bank = bankGroup[ii].c_str(); 
    writeGroup(status, fileID, str_bank, "NXdetector");
    //       add distance 
    float bank_distance[3]={};
    idfXML.getBankDistance(str_bank,bank_distance);
    dim[0] = 3;
    writeNumData(status, fileID, "distance", bank_distance, 1, dim, "m");

    //add azimuthal_angle
    float azimuthalAngle [xpid][ypid];
    for(int i = 0 ; i<xpid; i++){
    for(int j = 0; j<ypid; j++){
    azimuthalAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
    }
}
writeNumData(status, fileID, "azimuthal_angle", *azimuthalAngle, 2, dim2D, "degree");
//add radial_distance 
float radial_distance [xpid][ypid];
for(int i = 0 ; i<xpid; i++){
    for(int j = 0; j<ypid; j++){
        radial_distance[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(16.0-0.0);
    }
}
writeNumData(status, fileID, "radial_distance", *radial_distance, 2, dim2D, "m");
//add polar_angle
float polarAngle [xpid][ypid];
for(uint32_t i = 0 ; i<xpid; i++){
    for(uint32_t j = 0; j<ypid; j++){
        polarAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
    }
}
writeNumData(status, fileID, "polar_angle", *polarAngle, 2, dim2D, "degree");
//add event_pixel_id
int64_t eventPixelId [evt_num];
for (int64_t i = 0; i<evt_num; i++)
{
    eventPixelId[i]=ii*10000+rand()%(xpid*ypid);
}
dim[0] = evt_num;
writeNumData(status, fileID, "event_pixel_id", eventPixelId, 1, dim, "");
//add event_time_of_flight
float eventTimeOfFlight [evt_num];
getFloatRandom1D(eventTimeOfFlight, evt_num, 5000.0, 40000.0);
writeNumData(status, fileID, "event_time_of_flight", eventTimeOfFlight, 1, dim, "microsecond");
//add event_index
int64_t eventIndex [evt_num];
for(int64_t i =0; i<evt_num; i++)
{
    eventIndex[i] = i;
}
dim[0] = evt_num;
writeNumData(status, fileID, "event_index", eventIndex, 1, dim, "");
//add event_pulse_time
uint64_t eventPulseTime[evt_num];
for (uint32_t i = 0; i<evt_num; i++){
    eventPulseTime[i] = 14897125513178+i*40000;
}
status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
status=NXopendata(fileID,"event_pulse_time");
status=NXputdata(fileID,(void*)eventPulseTime);
text = "nanosecond";
NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
status=NXclosedata(fileID);

//add pixel_id, x_pixel_size, y_pixel_size
int64_t pixelId [xpid][ypid];
float xPixelSize [xpid][ypid];
float yPixelSize [xpid][ypid];

for (int i=0; i<xpid; i++){
    int64_t _nm = 0; 
    for(int j=0; j<ypid; j++) {
        pixelId[i][j] = 10000+10*i+_nm;
        xPixelSize[i][j] = 0.05;
        yPixelSize[i][j] = 0.1;
        _nm++;
    }
}
writeNumData(status, fileID, "pixel_id", *pixelId, 2, dim2D, "");
writeNumData(status, fileID, "x_pixel_size", *xPixelSize, 2, dim2D, "m");
writeNumData(status, fileID, "y_pixel_size", *yPixelSize, 2, dim2D, "m");
// add z_pixel_size
float zPixelSize = 0.0001;
dim[0] = 1;
writeNumData(status, fileID, "z_pixel_size", &zPixelSize, 1, dim, "m");

//add local_name  
string local_name = "backward0";
writeCharData(status, fileID, "local_name", local_name);
//add time_of_flight
uint32_t timeBin[TIME_BIN];
for (uint32_t i = 0; i<TIME_BIN; i++)
    timeBin [i]= i*2;
dim[0] = TIME_BIN;
status=NXmakedata(fileID,"time_of_flight",NX_UINT32,1,dim);
status=NXopendata(fileID,"time_of_flight");
status=NXputdata(fileID,(void*)timeBin);
text = "microsecond";
NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
text = "3";
NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
text = "Time Of Flight(s)";
NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
text = "1";
NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
status=NXclosedata(fileID);

//add geometry
//--------------------------------open-csns/instrument/bank/geometry/-----------------
writeGroup(status, fileID, "geometry", "NXgeometry");
writeGroup(status, fileID, "orientation", "NXorientation");

float value_ori[6]={1.0,0.0,0.0,1.0,1.0,0.0};
dim[0]=6; 
writeNumData(status, fileID, "value", value_ori, 1, dim, "");
NXclosegroup(fileID);

writeGroup(status, fileID, "shape", "NXshape");
float size_shape[3]={0.04,-1.0,0.1};
dim[0]=3;
writeNumData(status, fileID, "size", size_shape, 1, dim, "m");
const std::string shape_shape = "nxbox";
writeCharData(status, fileID, "shape", shape_shape);
NXclosegroup(fileID); 

writeGroup(status, fileID, "translation", "NXtranslation");
float distance_trans[3]={0.0,0.0,10.0};
dim[0]=3;
writeNumData(status, fileID, "distance", distance_trans, 1, dim, "m");
NXclosegroup(fileID);
NXclosegroup(fileID);
NXclosegroup(fileID);
}
//-------------------------------close-csns/instrument/bank----------------------------------------
/*
//-----------------------------open-csns/instrument/monitor----------------------
std::vector<string> monitorGroup;
int monitorNum = 3;
for(int i = 0; i< monitorNum; i++){
    string str1 = static_cast<ostringstream*>(&(ostringstream()<<i))->str();
    monitorGroup.push_back("monitor"+str1);
}
std::vector<string>::iterator it_mon;

int ii_mon = 0;
for (it_mon = monitorGroup.begin(); it_mon != monitorGroup.end(); it_mon++)
{
    const char *str_mon = (*it_mon).c_str(); 
    uint64_t evt_num = EVENT_NUM_M;
    status = NXmakegroup(fileID, str_mon,"NXdetector");
    status = NXopengroup(fileID, str_mon,"NXdetector");
    //add distance 
    float mon_distance = 10.0;
    dim[0] = 1;
    text = "m";
    writeNumData(status, fileID, "distance", &mon_distance, 1, dim, text);
    //add azimuthal_angle
    float azimuthalAngle [xpid_M][ypid_M];
    for(int i = 0 ; i<xpid_M; i++){
        for(int j = 0; j<ypid_M; j++){
            azimuthalAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
        }
    }
    text = "degree";
    writeNumData(status, fileID, "azimuthal_angle", *azimuthalAngle, 2, dim2D_M, text);
    //add radial_distance 
    float radial_distance [xpid_M][ypid_M];
    for(int i = 0 ; i<xpid_M; i++){
        for(int j = 0; j<ypid_M; j++){
            radial_distance[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(16.0-0.0);
        }
    }
    text = "m";
    writeNumData(status, fileID, "radial_distance", *radial_distance, 2, dim2D_M, text);
    //add polar_angle
    float polarAngle [xpid_M][ypid_M];
    for(uint32_t i = 0 ; i<xpid_M; i++){
        for(uint32_t j = 0; j<ypid_M; j++){
            polarAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
        }
    }
    text = "degree";
    writeNumData(status, fileID, "polar_angle", *polarAngle, 2, dim2D_M, text);

    //add event_pixel_id
    int64_t eventPixelId [evt_num];
    for (int64_t i = 0; i<evt_num; i++)
    {
        eventPixelId[i]=ii_mon*10000+rand()%(PIXEL_NUM_M);
    }
    dim[0] = evt_num;
    writeNumData(status, fileID, "event_pixel_id", eventPixelId, 1, dim, "");
    //add event_time_of_flight
    float eventTimeOfFlight [evt_num];
    getFloatRandom1D(eventTimeOfFlight, evt_num, 5000.0, 40000.0);
    writeNumData(status, fileID, "event_time_of_flight", eventTimeOfFlight, 1, dim, "microsecond");
    //add event_index
    int64_t eventIndex [evt_num];
    for(int64_t i =0; i<evt_num; i++)
    {
        eventIndex[i] = i;
    }
    dim[0] = evt_num;
    writeNumData(status, fileID, "event_index", eventIndex, 1, dim, "");
    //add event_pulse_time
    uint64_t eventPulseTime[evt_num];
    for (uint32_t i = 0; i<evt_num; i++){
        eventPulseTime[i] = 14897125513178+i*40000;
    }
    status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
    status=NXopendata(fileID,"event_pulse_time");
    status=NXputdata(fileID,(void*)eventPulseTime);
    text = "nanosecond";
    NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    status=NXclosedata(fileID);

    //add x_pixel_size
    float xPixelSize[xpid_M][ypid_M];
    for(uint32_t i = 0 ; i<xpid_M; i++){
        for(uint32_t j = 0; j<ypid_M; j++){
            xPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
        }
    }
    text = "m";
    writeNumData(status, fileID, "x_pixle_size", *xPixelSize, 2, dim2D_M, text);
    //add y_pixel_size
    float yPixelSize[xpid_M][ypid_M];
    for(uint32_t i = 0 ; i<xpid_M; i++){
        for(uint32_t j = 0; j<ypid_M; j++){
            yPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
        }
    }
    text = "m";
    writeNumData(status, fileID, "y_pixle_size", *yPixelSize, 2, dim2D_M, text);
    //add z_pixel_size
    float zPixelSize = 0.01;
    dim[0] = 1;
    text = "m";
    writeNumData(status, fileID, "z_pixle_size", &zPixelSize, 1, dim, text);

    //add local_name  
    string local_name = "monitor";
    writeCharData(status, fileID, "local_name", local_name);
    //add pixel_id 
    int64_t pixelId [xpid_M][ypid_M];
    int64_t _nm = 0; 
    for (int64_t i=0; i<xpid_M; i++){
        for(int64_t j=0; j<ypid_M; j++) {
            pixelId[i][j] = _nm;
            _nm++;
        }
    }
    writeNumData(status, fileID, "pixel_id", *pixelId, 2, dim2D_M, "");
    //add time_of_flight
    uint32_t timeBin[TIME_BIN];
    for (uint32_t i = 0; i<TIME_BIN; i++)
    {
        timeBin [i]= i*2;
    }
    dim[0] = TIME_BIN;
    status=NXmakedata(fileID,"time_of_flight",NX_UINT32,1,dim);
    status=NXopendata(fileID,"time_of_flight");
    status=NXputdata(fileID,(void*)timeBin);
    text = "microsecond";
    NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    text = "3";
    NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    text = "Time Of Flight(s)";
    NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    text = "1";
    NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    status=NXclosedata(fileID);

    //add geometry
    //--------------------------------open-csns/instrument/monitor/geometry/-----------------
    status=NXmakegroup(fileID,"geometry","NXgeometry");
    status=NXopengroup(fileID,"geometry","NXgeometry");
    //--------------------------------open-csns/instrument/monitor/geometry/orientation-----------------
    status=NXmakegroup(fileID,"orientation","NXorientation");
    status=NXopengroup(fileID,"orientation","NXorientation");

    float value_ori[6]={1.0,0.0,0.0,1.0,1.0,0.0};
    dim[0]=6; 
    writeNumData(status, fileID, "value", value_ori, 1, dim, "");
    NXclosegroup(fileID);
    //------------------------close-csns/instrument/monitor/geometry/orientation-----------------------
    //------------------------open-csns/instrument/monitor/geometry/shape-----------------------
    status=NXmakegroup(fileID,"shape","NXshape");
    status=NXopengroup(fileID,"shape","NXshape");
    float size_shape[3]={0.04,-1.0,0.1};
    dim[0]=3;
    text = "m";
    writeNumData(status, fileID, "size", size_shape, 1, dim, text);
    const std::string shape_shape = "nxbox";
    writeCharData(status, fileID, "shape", shape_shape);
    NXclosegroup(fileID); 
    //------------------------close-csns/instrument/monitor/geometry/shape-----------------------
    //------------------------open-csns/instrument/monitor/geometry/translation--------------------
    status=NXmakegroup(fileID,"translation","NXtranslation");
    status=NXopengroup(fileID,"translation","NXtranslation");
    float distance_trans[3]={0.0,0.0,10.0};
    dim[0]=3;
    text = "m";
    writeNumData(status, fileID, "distance", distance_trans, 1, dim, text);
    NXclosegroup(fileID);
    //------------------------close-csns/instrument/monitor/geometry/translation--------------------
    NXclosegroup(fileID);
    //--------------------------------close-csns/instrument/monitor/geometry---------------------------
    ii_mon++;
    NXclosegroup(fileID);
}
//-------------------------------close-csns/instrument/monitor----------------------------------------
NXclosegroup(fileID);
//-----------------------------close-csns/instrument----------------------
*/



//----------------------------open-csns/logs-----------------------------------
//open group: csns/logs
writeGroup(status, fileID, "logs", "NXcollection");

CSNSlogs logs=sumXML.getLogs();
cout<<"proton_charge: "<<logs.proton_charge[0]<<endl;

/*
//get chopperPhase and chopperSpeed 
float pulseTime[PULSE_NUM];  
float pulseValue[PULSE_NUM];
float chopperSpeedValue[PULSE_NUM];
getFloatOrder1D(pulseTime, PULSE_NUM, 0.0, 0.04);
getPulseInfo(pulseValue, PULSE_NUM);
getFloatRandom1D(chopperSpeedValue, PULSE_NUM, 25.0, 26.0);
//--------------------------open-csns/logs/disk_chopper0-----------------------------
//create chopper group
std::vector<string>::iterator it_disk;
for(it_disk = chopperGroup.begin(); it_disk!= chopperGroup.end();it_disk++)
{
char* pm = (char*)(*it_disk).data();
status=NXmakegroup(fileID, pm,"NXcollection");
status=NXopengroup(fileID, pm,"NXcollection");
//--------------------------open-csns/logs/disk_chopper0/phase-----------------------------
//open group: csns/logs/disk_chopper0/phase
status=NXmakegroup(fileID,"phase","NXlog");
status=NXopengroup(fileID,"phase","NXlog");

dim[0] = 89;
writeNumData(status, fileID, "time", pulseTime, 1, dim, "s");
writeNumData(status, fileID, "value", pulseValue, 1, dim, "");

NXclosegroup(fileID);
//---------------------------------close-csns/logs/disk_chopper/phase--------------------
//--------------------------open-csns/logs/disk_chopper/speed-----------------------------
//open group: csns/logs/disk_chopper/speed
status=NXmakegroup(fileID,"speed","NXlog");
status=NXopengroup(fileID,"speed","NXlog");

writeNumData(status, fileID, "time", pulseTime, 1, dim, "s");
writeNumData(status, fileID, "value", chopperSpeedValue, 1, dim, "Hz");

NXclosegroup(fileID);
//--------------------------------close-csns/logs/disk_chopper/speed--------------------
NXclosegroup(fileID);
//--------------------------------close-csns/logs/disk_chopper--------------------
}
//--------------------------open-csns/logs/proton_charge-----------------------------
//open group: csns/logs/proton_charge
status=NXmakegroup(fileID,"proton_charge","NXlog");
status=NXopengroup(fileID,"proton_charge","NXlog");

writeNumData(status, fileID, "time", pulseTime, 1, dim, "s");
writeNumData(status, fileID, "value", pulseValue, 1, dim, "pC");
//need to generate proton charge value!!! it is not pulse value!!!

NXclosegroup(fileID);
//-------------------------------close-csns/logs/proton_charge---------------------------------------
//--------------------------open-csns/logs/moderator-----------------------------
status=NXmakegroup(fileID,"moderator","NXlog");
status=NXopengroup(fileID,"moderator","NXlog");

status=NXmakegroup(fileID,"temperature","NXlog");
status=NXopengroup(fileID,"temperature","NXlog");

writeNumData(status, fileID, "time", pulseTime, 1, dim, "s");
writeNumData(status, fileID, "value", pulseValue, 1, dim, "K");

NXclosegroup(fileID);
NXclosegroup(fileID);
//--------------------------close-csns/logs/moderator-----------------------------
//--------------------------open-csns/logs/sample_environment-----------------------------
//open group: csns/logs/sample_environment
status=NXmakegroup(fileID,"sample_environment","NXcollection");
status=NXopengroup(fileID,"sample_environment","NXcollection");

float time[2] = {0.0, 25.0};
float value[2] = {0.0, 15.0};

//-----------------------open-csns/logs/sample_environment/electric_field-----------------------------
//open group: csns/logs/sample_environment/electric_field
status=NXmakegroup(fileID,"electric_field","NXlog");
status=NXopengroup(fileID,"electric_field","NXlog");

dim[0] = 2;
text = "s";
writeNumData(status, fileID, "time", time, 1, dim, text);
text = "V m-1";
writeNumData(status, fileID, "value", value, 1, dim, text);

NXclosegroup(fileID);
//--------------------------close-csns/logs/sample_environment/electrin_field---------------------------------------
//-----------------------open-csns/logs/sample_environment/magnetic_field-----------------------------
status=NXmakegroup(fileID,"magnetic_field","NXlog");
status=NXopengroup(fileID,"magnetic_field","NXlog");

text = "s";
writeNumData(status, fileID, "time", time, 1, dim, text);
text = "T";
writeNumData(status, fileID, "value", value, 1, dim, text);

NXclosegroup(fileID);
//--------------------------close-csns/logs/sample_environment/magnetic_field---------------------------------------
//-----------------------open-csns/logs/sample_environment/pressure-----------------------------
status=NXmakegroup(fileID,"pressure","NXlog");
status=NXopengroup(fileID,"pressure","NXlog");

text = "s";
writeNumData(status, fileID, "time", time, 1, dim, text);
text = "Pa";
writeNumData(status, fileID, "value", value, 1, dim, text);

NXclosegroup(fileID);
//-------------------------------close-csns/logs/sample_environment/pressure---------------------------------------
//-----------------------open-csns/logs/sample_environment/temperature-----------------------------
status=NXmakegroup(fileID,"temperature","NXlog");
status=NXopengroup(fileID,"temperature","NXlog");

text = "s";
writeNumData(status, fileID, "time", time, 1, dim, text);
text = "K";
writeNumData(status, fileID, "value", value, 1, dim, text);

NXclosegroup(fileID);
//---------------close-csns/logs/sample_environment/temperature---------------------------------------
NXclosegroup(fileID);
//-------------------------close-csns/logs/sample_environment---------------------------------------
NXclosegroup(fileID);
//--------------------------------------close-csns/logs/---------------------------------------

//-------------------------------------open-csns/process/-------------------------------
status=NXmakegroup(fileID,"process","NXprocess");
status=NXopengroup(fileID,"process","NXprocess");
//-------------------------------------open-csns/process/process1-------------------------------
CSNSprocess process1;
status=NXmakegroup(fileID,"process1","NXnote");
status=NXopengroup(fileID,"process1","NXnote");

process1.author="csns";
process1.algorithm="DroNE_V1, gen_nexus_v1.cpp, calfile.cal";
process1.date="2015-05-21T16:49:36+08:00";
process1.description="This is data reconstruction.";

writeCharData(status,fileID,"author",process1.author);
writeCharData(status,fileID,"algorithm",process1.algorithm);
writeCharData(status,fileID,"date",process1.date);
writeCharData(status,fileID,"description",process1.description);

NXclosegroup(fileID);
//--------------------------close-csns/process/process1-------------------------------
NXclosegroup(fileID);
//-------------------------------------close-csns/process/-------------------------------
//-------------------------------open-csns/present_data------------------------------------
status=NXmakegroup(fileID,"present_data","NXdata");
status=NXopengroup(fileID,"present_data","NXdata");

const std::string plot_pres="TOF,intensity:intensity_error";
const std::string title_pres="Events Distribution";
const std::string type_pres="line";
writeCharData(status,fileID,"plot",plot_pres);
writeCharData(status,fileID,"title",title_pres);
writeCharData(status,fileID,"type",type_pres);

uint32_t data1_size=124;
//  uint32_t data2_size=56;

float data1[data1_size];
//  float data2[data2_size];
float data3[data1_size];
float data3_error[data1_size];
getFloatRandom1D(data1, data1_size, 0.0, 100.0);
//getFloatRandom1D(data2, data2_size, 0.0, 50.0);
getFloatRandom1D(data3, data1_size, 0.0, 30.0);
getFloatRandom1D(data3_error, data1_size, 0.0, 1.0);

dim[0] = data1_size;
text = "microsecond";
writeNumData(status, fileID, "TOF", data1, 1, dim, text);
//  dim[0] = data2_size;
//  text = "m";
//  writeNumData(status, fileID, "data2", data2, 1, dim, text);
dim[0] = data1_size;
text = "counts";
writeNumData(status, fileID, "intensity", data3, 1, dim, text);
dim[0] = data1_size;
writeNumData(status, fileID, "intensity_error", data3_error, 1, dim, "");

NXclosegroup(fileID);
//-------------------------------------close-csns/present_date/-------------------------------
//-------------------------------------------open-csns/users------------------------------------
status=NXmakegroup(fileID,"users","NXcollection");
status=NXopengroup(fileID,"users","NXcollection");
//-----------------------------------------open-csns/users/user--------------------------------------
CSNSusers user1;
CSNSusers user2;

status=NXmakegroup(fileID,"user1","NXuser");
status=NXopengroup(fileID,"user1","NXuser");
user1.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
user1.affiliation="IHEP";
user1.email="tangm@ihep.ac.cn";
user1.facility_user_id="tangm";
user1.name="M Tang";
user1.role="principal_investigator";
writeCharData(status, fileID, "address", user1.address);
writeCharData(status, fileID, "affiliation",user1.affiliation);
writeCharData(status, fileID, "email", user1.email);
writeCharData(status, fileID, "facility_user_id", user1.facility_user_id);
writeCharData(status, fileID, "name", user1.name);
writeCharData(status, fileID, "role", user1.role);
NXclosegroup(fileID);

status=NXmakegroup(fileID,"user2","NXuser");
status=NXopengroup(fileID,"user2","NXuser");
user2.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
user2.affiliation="IHEP";
user2.email="durong@ihep.ac.cn";
user2.facility_user_id="dur";
user2.name="R Du";
user2.role="investigator";
writeCharData(status, fileID, "address", user2.address);
writeCharData(status, fileID, "affiliation",user2.affiliation);
writeCharData(status, fileID, "email", user2.email);
writeCharData(status, fileID, "facility_user_id", user2.facility_user_id);
writeCharData(status, fileID, "name", user2.name);
writeCharData(status, fileID, "role", user2.role);
NXclosegroup(fileID);
//-------------------------------------------close-csns/users/user---------------------------------
NXclosegroup(fileID);
//-------------------------------------------close-csns/users-----------------------------------------
*/
/*
//-------------------------------open-csns/event_data------------------------------------
status=NXmakegroup(fileID,"event_data","NXcollection");
status=NXopengroup(fileID,"event_data","NXcollection");
NXclosegroup(fileID);
for (it_bank = bankGroup.begin(); it_bank != bankGroup.end(); it_bank++)
{
std::string bank_name = *it_bank;

//---------------------------------open-csns/event_data/bank----------------------------
//create link
NXlink eventIndexLink;
NXlink eventPixelIdLink;
NXlink eventPulseTimeLink;
NXlink eventTimeOfFlightLink;
string path = "/csns/instrument/"+bank_name;
// string path = "/csns/instrument/bank0";
string pathEventIndex = path+"/event_index";
string pathEventPixelId = path+"/event_pixel_id";
string pathEventPulseTime = path+"/event_pulse_time";
string pathEventTimeOfFlight = path+"/event_time_of_flight";
string pathEventData="/csns/event_data";

status=NXopenpath(fileID, pathEventIndex.c_str());
status=NXgetdataID(fileID, &eventIndexLink);
status=NXopenpath(fileID, pathEventPixelId.c_str());
status=NXgetdataID(fileID, &eventPixelIdLink);
status=NXopenpath(fileID, pathEventPulseTime.c_str());
status=NXgetdataID(fileID, &eventPulseTimeLink);
status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
status=NXgetdataID(fileID, &eventTimeOfFlightLink);

status=NXopenpath(fileID, pathEventData.c_str());

const char *str_bank = (*it_bank).c_str();
status = NXmakegroup(fileID, str_bank,"NXevent_data");
status = NXopengroup(fileID, str_bank,"NXevent_data");

//  status=NXmakegroup(fileID, "bank0", "NXevent_data");    
//  status=NXopengroup(fileID, "bank0", "NXevent_data");    

status=NXmakelink(fileID, &eventIndexLink);
status=NXmakelink(fileID, &eventPixelIdLink);
status=NXmakelink(fileID, &eventPulseTimeLink);
status=NXmakelink(fileID, &eventTimeOfFlightLink);

NXclosegroup(fileID);
}
//------------------------------close-csns/event_data/bank------------------------------  
NXclosegroup(fileID);
//-------------------------------close-csns/event_data----------------------------- 
//---------------------------open-csns-event_data/monitor-----------------------  
for (it_mon = monitorGroup.begin(); it_mon != monitorGroup.end(); it_mon++)
{
std::string mon_name = *it_mon;

//---------------------------------open-csns/event_data/monitor----------------------------
//create link
NXlink eventIndexLink;
NXlink eventPixelIdLink;
NXlink eventPulseTimeLink;
NXlink eventTimeOfFlightLink;
string path = "/csns/instrument/"+mon_name;
string pathEventIndex = path+"/event_index";
string pathEventPixelId = path+"/event_pixel_id";
string pathEventPulseTime = path+"/event_pulse_time";
string pathEventTimeOfFlight = path+"/event_time_of_flight";
string pathEventData="/csns/event_data";

status=NXopenpath(fileID, pathEventIndex.c_str());
status=NXgetdataID(fileID, &eventIndexLink);
status=NXopenpath(fileID, pathEventPixelId.c_str());
status=NXgetdataID(fileID, &eventPixelIdLink);
status=NXopenpath(fileID, pathEventPulseTime.c_str());
status=NXgetdataID(fileID, &eventPulseTimeLink);
status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
status=NXgetdataID(fileID, &eventTimeOfFlightLink);

status=NXopenpath(fileID, pathEventData.c_str());

const char *str_mon = (*it_mon).c_str();
status = NXmakegroup(fileID, str_mon,"NXevent_data");
status = NXopengroup(fileID, str_mon,"NXevent_data");

//  status=NXmakegroup(fileID, "bank0", "NXevent_data");    
//  status=NXopengroup(fileID, "bank0", "NXevent_data");    

status=NXmakelink(fileID, &eventIndexLink);
status=NXmakelink(fileID, &eventPixelIdLink);
status=NXmakelink(fileID, &eventPulseTimeLink);
status=NXmakelink(fileID, &eventTimeOfFlightLink);

NXclosegroup(fileID);
}
//------------------------------close-csns/event_data/monitor------------------------------  
NXclosegroup(fileID);
//-----------------------------close-csns/event_data-----------------------------------
//-----------------------------open-csns/histogram_data----------------------------------
status=NXmakegroup(fileID,"histogram_data","NXcollection");
status=NXopengroup(fileID,"histogram_data","NXcollection");
NXclosegroup(fileID);
*/
//------------------------------open_csns/histogram_data/monitor-----------------------
/*
   NXlink TimeOfFlightLink;
   NXlink MonitorDataLink;
   string pathTimeOfFlight = "/csns/instrument/monitor0/time_of_flight";
   string pathMonitorData = "/csns/instrument/monitor0/data";
   string pathHistogramData="/csns/histogram_data";

   status=NXopenpath(fileID, pathTimeOfFlight.c_str());
   status=NXgetdataID(fileID, &TimeOfFlightLink);
   status=NXopenpath(fileID, pathMonitorData.c_str());
   status=NXgetdataID(fileID, &MonitorDataLink);

   status=NXopenpath(fileID, pathHistogramData.c_str());
   status=NXmakegroup(fileID, "monitor0", "NXdata");
   status=NXopengroup(fileID, "monitor0", "NXdata");

   status=NXmakelink(fileID, &TimeOfFlightLink);
   status=NXmakelink(fileID, &MonitorDataLink);

   NXclosegroup(fileID);
//-----------------------------close-csns/histogram_data/monitor------------------------------
NXclosegroup(fileID);
//-----------------------------close-csns/histogram_data----------------------------------
*/
NXclosegroup(fileID);
//-------------------------------close-csns---------------------------------------
/*-----------------------------------------------*/
// close file
NXclose(&fileID);
}
//------------------------------------------------------------------------------
int main()
{
    //std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.xml"; 
    std::string nexusfile     = "/home/dur/work/gen_nexus/gppd_template.nxs"; 
    std::string summaryfile     = "/home/dur/work/gen_nexus/data/SUMMARY629.xml"; 
    std::string idfbankfile     = "/home/dur/work/gen_nexus/data/idf_bank.xml"; 
    SaveNexusFile(nexusfile, summaryfile, idfbankfile);

    return 0;
}
